#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4312"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1


function check_main()
{
    os_type_judg_1=`cat /etc/*-release | grep -i suse`
    os_type_judg_2=`cat /etc/*-release | grep 11`
    originalInfo="${originalInfo}""operate:check OS version\n"
    if [[ -z "${os_type_judg_1}" || -z "${os_type_judg_2}" ]]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:OS is not SuSE 11, no need to check."
        log INFO "Comm_${checkItemId}:OS is not SuSE 11, no need to check."
        log INFO "Comm_${checkItemId}:ok"
        return 0
    fi

    iptables_order_judg=`which iptables`
    if [[ -z "${iptables_order_judg}" ]]
    then
        resultCode=0
        originalInfo="${originalInfo}""command:which iptables\n"
        originalInfo="${originalInfo}""review:Null\n"
        originalInfo="${originalInfo}""result:there is no iptables order."
        log INFO "Comm_${checkItemId}:there is no iptables order."
        log INFO "Comm_${checkItemId}:ok"
        return 0
    fi

    target_rule_num=`iptables -S | grep -i 'A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT' | wc -l`
    originalInfo="${originalInfo}""command:iptables -S | grep -i 'A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT' | wc -l\n"
    originalInfo="${originalInfo}""review:${target_rule_num}\n"
    if [ ${target_rule_num} -gt 2 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 系统存在 iptables 规则重复添加
        originalInfo="${originalInfo}""result:there is problem that iptables has rule repeat."
        log ERROR "Comm_${checkItemId}:there is problem that iptables has rule repeat."
        log ERROR "Comm_${checkItemId}:unok"
        return 1
    else
        resultCode=0
        originalInfo="${originalInfo}""result:rule is not repeated."
        log INFO "Comm_${checkItemId}:rule is not repeated."
        log INFO "Comm_${checkItemId}:ok"
        return 0
    fi
}

function main()
{
    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_main
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            check_main
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
