#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4341"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1



function check_backup_file()
{
    if [[ -d "/opt/dsware/update/backup" && -d "/opt/dsware/update/work" ]]
    then
        local bkFileNum="$(ls /opt/dsware/update/backup | wc -l)"
        originalInfo="command:ls /opt/dsware/update/backup\n"
        originalInfo="${originalInfo}""review:$(ls /opt/dsware/update/backup)\n"

        local wkFileNum="$(ls /opt/dsware/update/work |grep -v Inspect | wc -l)"
        originalInfo="${originalInfo}""command:ls /opt/dsware/update/work \n"
        originalInfo="${originalInfo}""review:$(ls /opt/dsware/update/work |grep -v Inspect)\n"

        if [ ${bkFileNum} -eq 0 -a ${wkFileNum} -eq 0 ]
        then
            originalInfo="${originalInfo}""result:Comm_check_backup_dir:ok"
            log INFO "${checkItemId}:Comm_check_backup_dir:ok"
            return 0
        else
            if [ ${bkFileNum} -ne 0 -a ${wkFileNum} -eq 0 ]
            then
                resultCode=1
                errorKey="${checkItemId}0002"    #  0002 /opt/dsware/update/backup 目录下有残留
                originalInfo="${originalInfo}""result:/opt/dsware/update/backup is not empty\n"
                log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/backup is not empty"
                return 1
            fi

            if [ ${bkFileNum} -eq 0 -a ${wkFileNum} -ne 0 ]
            then
                resultCode=1
                errorKey="${checkItemId}0003"    #  0003 /opt/dsware/update/work 目录下有残留
                originalInfo="${originalInfo}""result:/opt/dsware/update/work is not empty\n"
                log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/work is not empty"
                return 1
            fi

            resultCode=1
            errorKey="${checkItemId}0004"    #  0004 /opt/dsware/update/backup 和 /opt/dsware/update/work 目录下都有残留
            originalInfo="${originalInfo}""result:/opt/dsware/update/backup and /opt/dsware/update/work are not empty\n"
            log ERROR "${checkItemId}:Comm_check_backup_dir:/opt/dsware/update/backup and /opt/dsware/update/work are not empty"
            log ERROR "${checkItemId}:Comm_check_backup_dir:unok"
            return 1
        fi
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 /opt/dsware/update/backup 或者 /opt/dsware/update/work 目录不存在
        originalInfo="command:cd /opt/dsware/update/backup ; cd /opt/dsware/update/work\n"
        originalInfo="${originalInfo}""review:/opt/dsware/update/backup or /opt/dsware/update/work not found.\n"
        originalInfo="${originalInfo}""result:/opt/dsware/update/backup or /opt/dsware/update/work does not exist"
        log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/backup or /opt/dsware/update/work does not exist"
        log ERROR "${checkItemId}:Comm_check_backup_dir:unok"
        return 1
    fi
}




function main()
{
    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        check_backup_file
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        check_backup_file
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 /opt/dsware/update/backup或者/opt/dsware/update/work不存在
#  0002 backup目录下有残留
#  0003 work目录下有残留
#  0004 backup和work目录下都有残留
#
##############################