#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4342"
resultCode=0
errorKey=""
params=""
originalInfo=""
srcVersion="$(get_src_version)"

#脚本入参，节点类型
NODE_TYPE=$1


##############################################################
## @Description 检查目录权限
##############################################################
function check_dir_permissions()
{
    checkRootDir="$(mount | grep -w "/" | grep -w "ro")"
 
    if [ -n "${checkRootDir}" ]
    then
        #根目录只读
        resultCode=1
        errorKey="${checkItemId}0001"   # 根目录只读
        originalInfo="${originalInfo}""command:mount | grep -w / | grep -w ro \n"
        originalInfo="${originalInfo}""review:${checkRootDir}\n"
        originalInfo="${originalInfo}""result:Dir permissions Read Only:${checkRootDir}."
        log ERROR "Dir permissions Read Only:${checkRootDir}."
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""command:mount | grep -w / | grep -w ro \n"
        originalInfo="${originalInfo}""review:checkRootDir=${checkRootDir}\n"
        originalInfo="${originalInfo}""result:Dir permissions can Read and write.\n"
    fi
    
    

}

function check_FSM_ScriptDir()
{
    checkScriptDir="$(ls -l /opt/dsware/manager/ |grep script |awk '{print $1}')"
    checkScriptDir=${checkScriptDir:0:10}
    if [[ "${checkScriptDir}" != "drwxr-xr-x" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"   # 备份元数据脚本目录权限不是755
        originalInfo="command:ll /opt/dsware/manager/ |grep script |awk '{print \$1}'"
        originalInfo="${originalInfo}""review:${checkScriptDir}\n"
        originalInfo="${originalInfo}""result:/opt/dsware/manager/script permissions is not 755."
        log ERROR "/opt/dsware/manager/script permissions is not 755."
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""command:ll /opt/dsware/manager/ |grep script |awk '{print \$1}'"
        originalInfo="${originalInfo}""review:${checkScriptDir}\n"
        originalInfo="${originalInfo}""result:/opt/dsware/manager/script permissions is  755.\n"
        log INFO "Dir permissions can Read and write."
        log INFO "/opt/dsware/manager/script permissions is 755."
        log INFO "nodeVersion is exist"
        return 0
    fi
}
 
function getAgentNodeInfo()
{
    if [ ! -f "/opt/dsware/DSwareAgentNodeVersion" ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"   # 获取FSA节点信息失败
        originalInfo="${originalInfo}""review:\n"
        originalInfo="${originalInfo}""result:/opt/dsware/DSwareAgentNodeVersion is not exist."
        log ERROR "/opt/dsware/DSwareAgentNodeVersion is not exist."
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""result:/opt/dsware/DSwareAgentNodeVersion is exist.\n"
        return 0
    fi
}

function getManagerNodeInfo()
{

    if [[ ! -f "/opt/dsware/DSwareManagerNodeVersion" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"   # 获取FSM节点信息失败
        originalInfo="${originalInfo}""review:\n"
        originalInfo="${originalInfo}""result:/opt/dsware/DSwareManagerNodeVersion is not exist."
        log ERROR "/opt/dsware/DSwareManagerNodeVersion is not exist."
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""result:/opt/dsware/DSwareManagerNodeVersion is exist.\n"
        return 0
    fi
}


function check_FSA_disk_space()
{
    local result=""
    local opt_Available="$(df -mP "/opt" |tail -n1 | awk '{print $4}')"
    local var_Available="$(df -mP "/var/log" |tail -n1 | awk '{print $4}')"
    local tmp_Available="$(df -mP "/tmp" |tail -n1 | awk '{print $4}')"
    local home_Available="$(df -mP "/home" |tail -n1 | awk '{print $4}')"
    if [ "${tmp_Available}" -lt "10" ]
    then
        resultCode=1
        errorKey="${checkItemId}0005"   # FSA /tmp 剩余空间小于10M
        originalInfo="${originalInfo}""commnd:df -mP /tmp |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${tmp_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /tmp is not enough; tmpSpace=${tmp_Available},tmpNeedSpace=10"
        log ERROR "Available space of /tmp is not enough; tmpSpace=${tmp_Available},tmpNeedSpace=10"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /tmp |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${tmp_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /tmp is enough; tmpSpace=${tmp_Available},tmpNeedSpace=10\n"
    fi  
 
    if [ "${var_Available}" -lt "1024" ]
        then
        resultCode=1
        errorKey="${checkItemId}0006"   # FSA /var/log 剩余空间小于1024M
        originalInfo="${originalInfo}""commnd:df -mP /var/log |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${var_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /var is not enough; varSpace=${var_Available},varLogNeedSpace=1024"
        log ERROR "Available space of /var is not enough; varSpace=${var_Available},varLogNeedSpace=1024"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /var/log |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${var_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /var is enough; varSpace=${var_Available},varLogNeedSpace=1024\n"
    fi 
    
    if [ "${opt_Available}" -lt "2048" ]
    then
        resultCode=2
        errorKey="${checkItemId}0007"   # FSA /opt 剩余空间小于2048M
        originalInfo="${originalInfo}""commnd:df -mP /opt |tail -n1 | awk '{print \$4}'\n"
        originalInfo="${originalInfo}""review:${opt_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /opt is not enough; optSpace=${opt_Available},optNeedSpace=2048"
        log ERROR "Available space of /opt is not enough; optSpace=${opt_Available},optNeedSpace=2048"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /opt |tail -n1 | awk '{print \$4}'\n"
        originalInfo="${originalInfo}""review:${opt_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /opt is enough; optSpace=${opt_Available},optNeedSpace=2048 \n"
    fi

    if [ "${home_Available}" -lt "50" ]
    then
        resultCode=1
        errorKey="${checkItemId}0008"   # FSA /home 剩余空间小于50M
        originalInfo="${originalInfo}""commnd:df -mP /home |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${home_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /home is not enough; homeSpace=${home_Available},homeNeedSpace=50"
        log ERROR "Available space of /home is not enough; homeSpace=${home_Available},homeNeedSpace=50"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /home |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${home_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /home is enough; homeSpace=${home_Available},homeNeedSpace=50 \n"
        return 0
    fi   
}

function check_FSM_disk_space()
{
    local result=""
    local opt_Available="$(df -mP "/opt" |tail -n1 | awk '{print $4}')"
    local var_Available="$(df -mP "/var/log" |tail -n1 | awk '{print $4}')"
    local tmp_Available="$(df -mP "/tmp" |tail -n1 | awk '{print $4}')"
    local home_Available="$(df -mP "/home" |tail -n1 | awk '{print $4}')"

    if [ "${tmp_Available}" -lt "10" ]
    then
        resultCode=1
        errorKey="${checkItemId}0009"   # FSM /tmp 剩余空间小于10M
        originalInfo="${originalInfo}""commnd:df -mP /tmp |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${tmp_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /tmp is not enough; tmpSpace=${tmp_Available},tmpNeedSpace=10"
        log ERROR "Available space of /tmp is not enough; tmpSpace=${tmp_Available},tmpNeedSpace=10"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /tmp |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${tmp_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /tmp is enough; tmpSpace=${tmp_Available},tmpNeedSpace=10 \n"
    fi  
 
    if [ "${var_Available}" -lt "1024" ]
    then
        resultCode=1
        errorKey="${checkItemId}0010"   # FSM /var/log 剩余空间小于1024M
        originalInfo="${originalInfo}""commnd:df -mP /var/log |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${var_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /var is not enough; varSpace=${var_Available},varLogNeedSpace=1024"
        log ERROR "Available space of /var is not enough; varSpace=${var_Available},varLogNeedSpace=1024"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /var/log |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${var_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /var is enough; varSpace=${var_Available},varLogNeedSpace=1024 \n"
    fi 
    
    
    srcVersion="$(get_src_version)"
    #FSM 各目录需要空间大小 单位：M  需求 /opt 3G (FSM和FSA合布则需要5G) ; /var/log 300M; /tmp 10M ; /home 50M
    if [ ${srcVersion} == "V100R006C30SPC801" ];then
        [ -f /opt/dsware/DSwareAgentNodeVersion ] && optNeedSpace="5620" || optNeedSpace="3572"
    else
        [ -f /opt/dsware/DSwareAgentNodeVersion ] && optNeedSpace="5120" || optNeedSpace="3072"
    fi
    if [ "${opt_Available}" -lt ${optNeedSpace} ]
    then
        resultCode=2
        errorKey="${checkItemId}0011"   # FSM /opt 剩余空间小于3072M
        originalInfo="${originalInfo}""commnd:df -mP /opt |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${opt_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /opt is not enough; optSpace=${opt_Available},optNeedSpace=${optNeedSpace},product_version=${srcVersion}."
        log ERROR "Available space of /opt is not enough; optSpace=${opt_Available},optNeedSpace=${optNeedSpace},product_version=${srcVersion}."
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /opt |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${opt_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /opt is enough; optSpace=${opt_Available},optNeedSpace=3072 \n"
    fi

    if [ "${home_Available}" -lt "50" ]
    then
        resultCode=1
        errorKey="${checkItemId}0012"   # FSM /home 剩余空间小于50M
        originalInfo="${originalInfo}""commnd:df -mP /home |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${home_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /home is not enough; homeSpace=${home_Available},homeNeedSpace=50"
        log ERROR "Available space of /home is not enough; homeSpace=${home_Available},homeNeedSpace=50"
        log ERROR "${checkItemId}:Comm_4342:unok"
        return 1
    else
        originalInfo="${originalInfo}""commnd:df -mP /home |tail -n1 | awk '{print \$4}' \n"
        originalInfo="${originalInfo}""review:${home_Available}\n"
        originalInfo="${originalInfo}""result:Available space of /home is enough; homeSpace=${home_Available},homeNeedSpace=50 \n"
        return 0
    fi
        
    
}

function main()
{
    if [ "${NODE_TYPE}" == "Agent" ] 
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        getAgentNodeInfo
        check_FSA_disk_space
        check_dir_permissions
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        fi
        getManagerNodeInfo
        check_FSM_disk_space
        check_dir_permissions
        check_FSM_ScriptDir
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 根目录只读
#  0002 /opt/dsware/manager/script，不是755（-rwxr-xr-x）权限
#  0003 获取FSA节点信息失败
#  0004 获取FSM节点信息失败
#  0005  FSA /tmp 剩余空间小于10M
#  0006  FSA /var/log 剩余空间小于1024M
#  0007  FSA /opt 剩余空间小于2048M，仅在升级场景有影响，建议保持目录分区充足
#  0008  FSA /home 剩余空间小于50M
#  0009  FSM /tmp 剩余空间小于10M
#  0010  FSM /var/log 剩余空间小于1024M
#  0011  FSM /opt 剩余空间小于3072M，仅在升级场景有影响，建议保持目录分区充足
#  0012  FSM /home 剩余空间小于50M
#
##############################