#!/bin/bash

#############################################################
#
# 名  称：检查 crontab 是否监控 OMA ，及 OMA 进程状态
# 错误码：
#         0000 正常
#         0001 该节点无 no /etc/init.d/cron(d) 或者 /usr/lib/systemd/system/cron(d).service 文件
#         0002 该节点无 /opt/dsware/DSwareManagerNodeVersion 或者 /opt/dsware/DSwareAgentNodeVersion 文件
#         0003 crontab 没有监控 OMA 服务
#         0004 /opt/omm/oma/workspace/tools/status_oma_app 文件不存在或者不可以执行
#         0005 OMA 模块进程状态存在问题
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4344"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

cron_user="root"
SUSE_cron_cfg_file="/var/spool/cron/tabs/${cron_user}"
RedHat_cron_cfg_file="/var/spool/cron/${cron_user}"

function main()
{
    if [[ "${NODE_TYPE}" == "Agent" ]]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        fi
    fi

    if [[ "${NODE_TYPE}" == "Manager" ]]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
        log INFO "${checkItemId} do not select, pass"
        return 0
        fi
    fi

    if [ -f /usr/bin/FusionStorageAgentControl ] ; then
        originalInfo="/usr/bin/FusionStorageAgentControl is exist, no need to check oma_monitor in crontab."
        log INFO "Comm_${checkItemId}:/usr/bin/FusionStorageAgentControl is exist, no need to check oma_monitor in crontab."
        log INFO "Comm_${checkItemId}:ok"
        
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    fi

    if [ -f "/etc/init.d/crond" -o  -f "/usr/lib/systemd/system/crond.service" ] ; then
        cron_cfg_file="${RedHat_cron_cfg_file}"
    elif [ -f "/etc/init.d/cron" -o -f "/usr/lib/systemd/system/cron.service" ] ; then
        cron_cfg_file="${SUSE_cron_cfg_file}"
    else
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 该节点无 no /etc/init.d/cron(d) 或者 /usr/lib/systemd/system/cron(d).service 文件
        originalInfo="${originalInfo}""result:There is no /etc/init.d/cron(d) or /usr/lib/systemd/system/cron(d).service."
        log ERROR "Comm_${checkItemId}:There is no /etc/init.d/cron(d) or /usr/lib/systemd/system/cron(d).service."
        log ERROR "Comm_${checkItemId}:unok"
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

    if [ -f /opt/dsware/DSwareManagerNodeVersion ] && [ -f /opt/dsware/DSwareAgentNodeVersion ]
    then
	    cron_oma_path="/opt/omm/oma/tools/oma_monitor"
        cron_oma_line="* * * * * sh ${cron_oma_path} >/dev/null 2>&1 &"
	elif [ -f /opt/dsware/DSwareAgentNodeVersion ]
    then
	    cron_oma_path="/opt/omm/oma/tools/oma_monitor"
        cron_oma_line="* * * * * sh ${cron_oma_path} >/dev/null 2>&1 &"
	elif [ -f /opt/dsware/DSwareManagerNodeVersion ]
    then
	    cron_oma_path="/opt/omm/oma/workspace/tools/oma_monitor"
        cron_oma_line="* * * * * sh ${cron_oma_path} >/dev/null 2>&1 &"
	else
	    resultCode=1
        errorKey="${checkItemId}0002"  # 0002 该节点无 /opt/dsware/DSwareManagerNodeVersion 或者 /opt/dsware/DSwareAgentNodeVersion 文件
        originalInfo="${originalInfo}""result:there is no /opt/dsware/DSwareManagerNodeVersion or /opt/dsware/DSwareAgentNodeVersion."
        log ERROR "Comm_${checkItemId}:there is no /opt/dsware/DSwareManagerNodeVersion or /opt/dsware/DSwareAgentNodeVersion."
        log ERROR "Comm_${checkItemId}:unok"
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
	fi

    oma_str=`cat ${cron_cfg_file} | grep "${cron_oma_line}"`
    originalInfo="${originalInfo}""command:cat ${cron_cfg_file} | grep ${cron_oma_line}\n"
    originalInfo="${originalInfo}""review:${oma_str}\n"

    if [[ "${oma_str}" != "${cron_oma_line}" ]]
    then
	    resultCode=1
        errorKey="${checkItemId}0003"  # 0003 crontab 没有监控 OMA 服务
        originalInfo="${originalInfo}""result:crontab does not monitor ${cron_oma_path}."
        log ERROR "Comm_${checkItemId}:crontab does not monitor ${cron_oma_path}."
        log ERROR "Comm_${checkItemId}:unok"
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

    originalInfo="${originalInfo}""result:crontab has already monitored ${cron_oma_path}.\n"
    log INFO "Comm_${checkItemId}:crontab has already monitored ${cron_oma_path}."

    checkTools="/opt/omm/oma/workspace/tools/status_oma_app"
    if [[ ! -x "${checkTools}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  # 0004 /opt/omm/oma/workspace/tools/status_oma_app 文件不存在或者不可以执行
        originalInfo="${originalInfo}""result:${checkTools} can not be exec.\n"
        log ERROR "Comm_${checkItemId}:${checkTools} can not be exec."
        log ERROR "Comm_${checkItemId}:unok"
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

    subResult=""
    for i in {1..3}
    do
        subResult=$($checkTools | grep -vw "is running")
        originalInfo="${originalInfo}""command:$checkTools | grep -vw 'is running'\n"
        originalInfo="${originalInfo}""review:command_result=${subResult}\n"
        if [ -n "${subResult}" ]
        then
            resultCode=1
            errorKey="${checkItemId}0005"  # 0005 OMA 模块进程状态存在问题
            originalInfo="${originalInfo}""result:There is process abnormal: ${subResult}"
            log ERROR "Comm_${checkItemId}:There is process abnormal: ${subResult}"
            log ERROR "Comm_${checkItemId}:unok"
            if [[ "${NODE_TYPE}" == "Agent" ]]
            then
                FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            fi

            if [[ "${NODE_TYPE}" == "Manager" ]]
            then
                FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            fi
        fi
    done

    originalInfo="${originalInfo}""result:OMA service is healthy."
    log INFO "Comm_${checkItemId}:OMA service is healthy."
    log INFO "Comm_${checkItemId}:ok"
    if [[ "${NODE_TYPE}" == "Agent" ]]
    then
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [[ "${NODE_TYPE}" == "Manager" ]]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}