#!/bin/bash

#############################################################
#
# 名  称：希捷硬盘hang io
# 错误码：
#         0000=正常
#         0002=节点存在硬盘型号为 ST1800MM0129/ST2400MM0129/ST1800MM0159 ,且固件版本为 C003|C001|C0B1|CI01 的 RAID 卡
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools:/opt/dsware/agent/tool"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4414"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    if [[ "${NODE_TYPE}" == "Agent" ]]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        fi
    fi

    if [[ "${NODE_TYPE}" == "Manager" ]]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
        log INFO "${checkItemId} do not select, pass"
        return 0
        fi
    fi


    other_raid_check_result=`/opt/dsware/agent/tool/lsscsi | grep -E 'ST1800MM0129|ST2400MM0129|ST1800MM0159' | grep -E 'C003|C001|C0B1|CI01'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/lsscsi | grep -E 'ST1800MM0129|ST1200MM0129|ST2400MM0129|ST1800MM0159' | grep -E 'C003|C001|C0B1|CI01'\n"
    originalInfo="${originalInfo}""review:${other_raid_check_result}\n"
    if [[ -n "${other_raid_check_result}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 节点存在硬盘型号为 ST1800MM0129/ST2400MM0129/ST1800MM0159 ,且固件版本为 C001/C003/C0B1/CI01 的硬盘
        originalInfo="${originalInfo}""result:this node has RaidCard which raid_type=${raid_type} and raid_version=${raid_version}."
        log ERROR "Comm_${checkItemId}:this node has RaidCard which raid_type=${raid_type} and raid_version=${raid_version}."
        log ERROR "Comm_${checkItemId}:unok"
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    else
        originalInfo="${originalInfo}""result:there is no abnormal Seagate RaidCard."
        log INFO "Comm_${checkItemId}:there is no abnormal Seagate RaidCard."
        log INFO "Comm_${checkItemId}:ok"
        
        if [[ "${NODE_TYPE}" == "Agent" ]]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi

        if [[ "${NODE_TYPE}" == "Manager" ]]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    fi

   

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
