#!/bin/bash

#############################################################
#
# 名  称：检查PT分布情况
# 错误码：
#         0000 正常
#         0001 存在 PT 分布不均率超过10%的存储池
#         0002 Dsware_insight 工具未获取到 PT 信息
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4101"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    mdc_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep mdc | grep -v alarm | grep -E 'True'`
    if [[ -z ${mdc_judg} ]]
    then
        originalInfo="command:cat /opt/dsware/agent/conf/agentMonitor | grep mdc | grep -v alarm | grep -E 'True'\n"
        originalInfo="${originalInfo}""review:null\n"
        originalInfo="${originalInfo}""result:This node does not have MDC."
        log INFO "FSA_${checkItemId}:This node does not have MDC."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    mdc_id=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_id|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_id|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:mdc_id=${mdc_id}\n"
    mdc_ip=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_ip|awk -F '=' '{print $2}' |awk -F '@' '{print $1}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_ip|awk -F '=' '{print \$2}' |awk -F '@' '{print \$1}'\n"
    originalInfo="${originalInfo}""review:mdc_ip=${mdc_ip}\n"
    mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_port|awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_port|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:mdc_port=${mdc_port}\n"
    
    pool_list=`/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 165 -1 | grep -v POOL_ID | awk -F '|' '{print $2}' | awk '{print $2}'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 165 -1 | grep -v POOL_ID | awk -F '|' '{print \$2}' | awk '{print \$2}'\n"
    originalInfo="${originalInfo}""review:pool_list=\n${pool_list}\n"

    error_pool_id=""
    for pool_id in ${pool_list[@]}
    do
        originalInfo="${originalInfo}""pool_id=${pool_id}\n"
        cmd_result=`/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 1808 ${pool_id}`
        if [ $? -ne 0 ]
        then
            resultCode=1
            errorKey="${checkItemId}0002"  # 0002 Dsware_insight 工具未获取到 PT 信息
            originalInfo="${originalInfo}""result:Dsware_insight command error to get partition info."
            log ERROR "FSA_${checkItemId}:Dsware_insight command error to get partition info."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 1808 ${pool_id}\n"
        originalInfo="${originalInfo}""review:\n${cmd_result}\n"
        cmd_result_check=`echo "${cmd_result}" | grep "pt placement balance result:pass"`
        if [[ -z "$cmd_result_check" ]]
        then
            error_pool_id="${error_pool_id}, ${pool_id}"
        fi
    done

    if [[ -n "${error_pool_id}" ]]
    then
        error_pool_id="${error_pool_id:2}"
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 存在 PT 分布不均率超过10%的存储池
        originalInfo="${originalInfo}""result:pt placement in pool(id=${error_pool_id}) not balance."
        log ERROR "FSA_${checkItemId}:pt placement in pool(id=${error_pool_id}) not balance."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:All pool pt placement is balance."
        log INFO "FSA_${checkItemId}:All pool pt placement is balance."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
