#!/bin/bash

#############################################################
#
# 名  称：检查MDC进程是否正常提供服务
# 错误码：
#         0000 正常
#         0001 MDC进程服务异常
#         0002 MDC 的 id、ip、port中有一个或多个为空
# 
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4103"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    mdc_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep mdc | grep -v alarm | grep -E 'True'`
    if [[ -z ${mdc_judg} ]]
    then
        originalInfo="command:cat /opt/dsware/agent/conf/agentMonitor | grep mdc | grep -v alarm | grep -E 'True'\n"
        originalInfo="${originalInfo}""review:null\n"
        originalInfo="${originalInfo}""result:This node does not have MDC."
        log INFO "FSA_${checkItemId}:This node does not have MDC."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    mdc_id=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_id|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_id|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:mdc_id=${mdc_id}\n"
    mdc_ip=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_ip|awk -F '=' '{print $2}' |awk -F '@' '{print $1}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_ip|awk -F '=' '{print \$2}' |awk -F '@' '{print \$1}'\n"
    originalInfo="${originalInfo}""review:mdc_ip=${mdc_ip}\n"
    mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_port|awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_port|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:mdc_port=${mdc_port}\n"

    if [[ -z "${mdc_id}" ]] || [[ -z "${mdc_ip}" ]] || [[ -z "${mdc_port}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 MDC 的 id、ip、port中有一个或多个为空
        originalInfo="${originalInfo}""result:At least one of mdc_id, mdc_ip, and mdc_port is empty."
        log ERROR "FSA_${checkItemId}:At least one of mdc_id, mdc_ip, and mdc_port is empty."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    mdc_status=`/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 181 | grep ${mdc_ip} | awk -F '|' '{print$6}' | awk '{print$1}'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 181 | grep ${mdc_ip} | awk -F '|' '{print\$6}' | awk '{print\$1}'\n"
    originalInfo="${originalInfo}""review:mdc_status=${mdc_status}\n"
    if [ $mdc_status -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 MDC进程服务异常
        originalInfo="${originalInfo}""result:This node MDC is wrong."
        log ERROR "FSA_${checkItemId}:This node MDC is wrong."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:This node MDC is right."
        log INFO "FSA_${checkItemId}:This node MDC is right."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

