#!/bin/bash

#############################################################
#
# 名  称：检查VBS进程是否正常提供服务
# 错误码：
#         0000 正常
#         0001 VBS进程服务异常
#         0002 dsware_insight 工具执行失败或获取本地VBS信息失败
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4105"
resultCode=0
errorKey=""
params=""
originalInfo=""

IP_TYPE="ipv4"
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"

function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        log "ERROR" "networkType file ${NET_WORK_TYPE_FILE} not exist!"
        return 1
    fi

    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')

    if [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    else
        IP_TYPE="ipv4"
    fi

    log INFO "current ip type: ${IP_TYPE}"

    return 0
}

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    vbs_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep vbs | grep -v alarm | grep -E 'True'`
    if [[ -z ${vbs_judg} ]]
    then
        originalInfo="command:cat /opt/dsware/agent/conf/agentMonitor | grep vbs | grep -v alarm | grep -E 'True'\n"
        originalInfo="${originalInfo}""review:null\n"
        originalInfo="${originalInfo}""result:This node does not have VBS."
        log INFO "FSA_${checkItemId}:This node does not have VBS."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    getNetworkType
    local split_flag=""
    
    if [[ ${IP_TYPE} == "ipv6" ]]
    then
        split_flag="-"
    else
        split_flag=":"
    fi
    
    x_mdc_info=`cat /opt/dsware/vbs/conf/vbs_*.cfg | grep vbs_mdc_url | awk -F '=' '{print$2}' | awk -F ',' '{print$1}'`
    mdc_id=`echo ${x_mdc_info} | awk -F ${split_flag} '{print$1}'`
    mdc_ip=`echo ${x_mdc_info} | awk -F ${split_flag} '{print$2}' | awk -F '@' '{print$1}'`
    mdc_port=`echo ${x_mdc_info} |awk -F ${split_flag} '{print$3}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*.cfg | grep vbs_mdc_url | awk -F '=' '{print\$2}' | awk -F ',' '{print\$1}'\n"
    originalInfo="${originalInfo}""review:x_mdc_info=${x_mdc_info}\n"
    originalInfo="${originalInfo}""result:mdc_id=${mdc_id};mdc_ip=${mdc_ip};mdc_port=${mdc_port}\n"

    primary_mdc_info=`/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 100 | grep -v 'STORAGE IP'`
    primary_mdc_id=`echo "${primary_mdc_info}" | awk -F '|' '{print $2}' | awk '{print$1}'`
    primary_mdc_ip=`echo "${primary_mdc_info}" | awk -F '|' '{print $5}' | awk '{print$1}'`
    primary_mdc_port=`echo "${primary_mdc_info}" | awk -F '|' '{print $6}' | awk '{print$1}'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 100 | grep -v 'STORAGE IP'\n"
    originalInfo="${originalInfo}""review:primary_mdc_info=${primary_mdc_info}\n"
    originalInfo="${originalInfo}""result:primary_mdc_id=${primary_mdc_id};primary_mdc_ip=${primary_mdc_ip};primary_mdc_port=${primary_mdc_port}\n"

    vbs_ip=`cat /opt/dsware/vbs/conf/vbs_*.cfg | grep vbs_ip | awk -F '=' '{print$2}' | awk -F '@' '{print$1}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*.cfg | grep vbs_ip | awk -F '=' '{print\$2}' | awk -F '@' '{print\$1}'\n"
    originalInfo="${originalInfo}""review:vbs_ip=${vbs_ip}\n"
    vbs_info=`/opt/dsware/agent/tool/dsware_insight 0 ${primary_mdc_id} ${primary_mdc_ip} ${primary_mdc_port} 8 123 | grep ${vbs_ip}`
    if [[ -z "${vbs_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  #0002 dsware_insight 工具执行失败或获取本地VBS信息失败
        originalInfo="${originalInfo}""result:dsware_insight_tool maybe have error , or get VBS_info failed."
        log ERROR "FSA_${checkItemId}:dsware_insight_tool maybe have error , or get VBS_info failed."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    vbs_id=`echo ${vbs_info} | awk -F'|' '{print $2}' | awk '{print$1}'`
    vbs_port=`echo ${vbs_info} | awk -F'|' '{print $5}' | awk '{print$1}'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${primary_mdc_id} ${primary_mdc_ip} ${primary_mdc_port} 8 123 | grep ${vbs_ip}\n"
    originalInfo="${originalInfo}""review:vbs_info=${vbs_info}\n"
    originalInfo="${originalInfo}""result:vbs_ip=${vbs_ip};vbs_id=${vbs_id};vbs_port=${vbs_port}\n"

    vbs_status=`/opt/dsware/agent/tool/dsware_insight 2 ${vbs_id} ${vbs_ip} ${vbs_port} 13 808 | sed -n "2p" | awk -F '|' '{print$4}' | awk '{print$1}'`
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 2 ${vbs_id} ${vbs_ip} ${vbs_port} 13 808 | sed -n '2p' | awk -F '|' '{print\$4}' | awk '{print\$1}'\n"
    originalInfo="${originalInfo}""review:vbs_status=${vbs_status}\n"
    if [ ${vbs_status} -ne 0 ]
    then
        resultCode=2
        errorKey="${checkItemId}0001"  #0001 VBS进程服务异常
        originalInfo="${originalInfo}""result:This node vbs client has error io."
        log ERROR "FSA_${checkItemId}:This node vbs client has error_io."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:This node does not have error_io."
        log INFO "FSA_${checkItemId}:This node does not have error_io."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
