#!/bin/bash

#############################################################
#
# 名  称：检查业务进程状态
# 错误码：
#         0000 正常
#         0001 存在Z状态的进程
#         0002 存在D状态的进程
#         0003 Z状态和D状态进程均存在
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4106"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    z_process_info=""
    d_process_info=""
    
    process_flag=(dsware_agent zookeeper dsware_mdc dsware_osd dsware_vbs dsware_vfs)
    for ((i=0;i<${#process_flag[@]};i++))
    do
        tmp_process_flag="${process_flag[$i]}"
        
        z_process_count=$(ps -e -o stat,cmd | grep -w "${tmp_process_flag}" | grep -v grep | awk '{print $1}' | grep -E "Z"  | wc -l)
        originalInfo="${originalInfo}""command:ps -e -o stat,cmd | grep -w ${tmp_process_flag} | grep -v grep | awk '{print \$1}' | grep -E Z  | wc -l\n"
        originalInfo="${originalInfo}""review:${tmp_process_flag}_Z_status_total=${z_process_count}\n"
        if [[ "${z_process_count}" != "0" ]]
        then
            z_process_info="${tmp_process_flag},${z_process_info}"
        fi

        d_process_count=$(ps -e -o stat,cmd | grep -w "${tmp_process_flag}" | grep -v grep | awk '{print $1}' | grep -E "D"  | wc -l)
        originalInfo="${originalInfo}""command:ps -e -o stat,cmd | grep -w ${tmp_process_flag} | grep -v grep | awk '{print \$1}' | grep -E D  | wc -l\n"
        originalInfo="${originalInfo}""review:${tmp_process_flag}_D_status_total=${d_process_count}\n"
        if [[ "${d_process_count}" != "0" ]]
        then
            d_process_info="${tmp_process_flag},${d_process_info}"
        fi
    done

    z_process_info=${z_process_info%?}
    d_process_info=${d_process_info%?}

    if [[ -z "${z_process_info}" ]] && [[ -z "${d_process_info}" ]]
    then
        originalInfo="${originalInfo}""result:This node is healthy."
        log INFO "FSA_${checkItemId}:This node is healthy."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    elif [[ -n "${z_process_info}" ]] && [[ -z "${d_process_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 存在Z状态的进程
        originalInfo="${originalInfo}""result:This node have Z_status process ,include ${z_process_info}."
        log ERROR "FSA_${checkItemId}:This node have Z_status process ,include ${z_process_info}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -z "${z_process_info}" ]] && [[ -n "${d_process_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 存在D状态的进程
        originalInfo="${originalInfo}""This node have D_status process ,include ${d_process_info}."
        log ERROR "FSA_${checkItemId}:This node have D_status process ,include ${d_process_info}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=1
        errorKey="${checkItemId}0003"  # Z状态和D状态进程均存在
        originalInfo="${originalInfo}""This node have Z_status and D_status process.Z_status include ${z_process_info};D_status include ${d_process_info}."
        log ERROR "FSA_${checkItemId}:This node have Z_status and D_status process.Z_status include ${z_process_info};D_status include ${d_process_info}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
