#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4108"
resultCode=0
errorKey=""
params=""
originalInfo=""


#############################################################
# 描述：检查是否存在core文件（Common）
# 错误码：（0~9为正常，10及以上为异常）
#         0 正常
#         0002 相关目录下存在非core.gz后缀名的其他文件，有风险
#         0001 存在core文件，进程名为：$1
#############################################################


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    DSWARE_CORE_DIR="/var/log/dsware/core/"
    file_array=($(find $DSWARE_CORE_DIR -name "*.core.gz" -mtime -30 -type f 2>/dev/null))
    for ((i=0;i<${#file_array[@]};i++))
    do
        file_name_tmp="${file_array[$i]}"
        if [ -f "$file_name_tmp" ]; then   
            resultCode=1
            errorKey="${checkItemId}0001"   # 存在一个月内并且后缀名为.core.gz的文件
            originalInfo="command:find ${DSWARE_CORE_DIR} -name *.core.gz -mtime -30 -type f \n"
            originalInfo="$originalInfo""review:file_name=${file_name_tmp}\n"
            originalInfo="$originalInfo""result:The /var/log/dsware/core/ directory exists .core.gz file."
            log ERROR "The /var/log/dsware/core/ directory exists .core.gz file."
            log ERROR "${checkItemId}:FSA_4108:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    done

    if [ -z "$file_array" ]
    then
        fileCount=$(ls /var/log/dsware/core/ |wc -l)
        if [ "$fileCount" -gt 0 ]
        then
            last_file_time=`ls -t /var/log/dsware/core/ |head -n 1| xargs -I x date +%Y%m%d -r /var/log/dsware/core/x`
            last_month_time=`date -d last-month +%Y%m%d`
            if [ ${last_file_time} -gt ${last_month_time} ]
            then
                resultCode=2
                errorKey="${checkItemId}0002"   # 相关目录下存在非core.gz后缀名的其他文件，有风险
                originalInfo="command:find ${DSWARE_CORE_DIR} -name *.core.gz -mtime -30 -type f;ls /var/log/dsware/core/ |wc -l \n"
                originalInfo="$originalInfo""review:fileCount=${fileCount}\n"
                originalInfo="$originalInfo""result:The /var/log/dsware/core/ directory exists other file."
                log ERROR "The /var/log/dsware/core/ directory exists other file."
                log ERROR "${checkItemId}:FSA_4108:unok"
                FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            fi
        fi    
    fi        

    resultCode=0
    originalInfo="command:find ${DSWARE_CORE_DIR} -name *.core.gz -mtime -30 -type f;\nls /var/log/dsware/core/ |wc -l;\n"
    originalInfo="$originalInfo""review:fileCount=${fileCount}\n"
    originalInfo="${originalInfo}""result:No abnormal files exist in this directory."
    log INFO "Normal: files exist in this directory."
    log INFO "${checkItemId}:FSA_4108:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 存在一个月内并且后缀名为.core.gz的文件
#  0002 相关目录下存在非core.gz后缀名的其他文件，有风险
#
##############################