#!/bin/bash

#############################################################
#
# 名  称：检查日志是否被转储
# 错误码：
#         0000=正常
#         0001=日志未转储
#         0002=
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4111"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi
    
    files_same_flag="/var/log/dsware/dsware_agent.log*"

    if [ ! -f "/etc/uvp_version" ]
    then
        originalInfo="${originalInfo}""result:there is no /etc/uvp_version in this node."
        log INFO "FSA_${checkItemId}:there is no /etc/uvp_version in this node."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    earliest_log_time=`ls -t ${files_same_flag} 2>/dev/null | tail -n 1 | xargs -I x date +%Y%m%d%H%M%S -r x`
    originalInfo="${originalInfo}""command:ls -t ${files_same_flag} 2>/dev/null | tail -n 1 | xargs -I x date +%Y%m%d%H%M%S -r x\n"
    originalInfo="${originalInfo}""review:earliest_log_time=${earliest_log_time}\n"
    judg_time=`date -d "-60minute" +%Y%m%d%H%M%S`
    originalInfo="${originalInfo}""command:date -d '-60minute' +%Y%m%d%H%M%S\n"
    originalInfo="${originalInfo}""review:judg_time=${judg_time}\n"

    if [[ -z ${earliest_log_time} ]] || [ ${earliest_log_time} -gt ${judg_time} ]
    then
        originalInfo="${originalInfo}""result:there is no transfer_log_files, or there is no transfer_log which time is earlier than current time 60 minutes."
        log INFO "FSA_${checkItemId}:there is no transfer_log_files, or there is no transfer_log which time is earlier than current time 60 minutes."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 日志未转储
        originalInfo="${originalInfo}""result:log is not transfered which have exceed 60 minutes: earliest_log_time=${earliest_log_time}, judg_time=${judg_time}."
        log ERROR "FSA_${checkItemId}:log is not transfered which have exceed 60 minutes: earliest_log_time=${earliest_log_time}, judg_time=${judg_time}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi


}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
