#!/bin/bash

#############################################################
#
# 名  称：查多盘位情况下是否对OSD做流量限制
# 错误码：
#         0000 正常
#         0001 无OSD配置文件
#         0002 配置文件中无流控相关信息
#         0003 未做流控
#         0004 OSD 节点，无 OSD 运行
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4114"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    osd_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep osd | grep -v alarm | grep -E 'True'`
    if [[ -z ${osd_judg} ]]
    then
        originalInfo="command:cat /opt/dsware/agent/conf/agentMonitor | grep osd | grep -v alarm | grep -E 'True'\n"
        originalInfo="${originalInfo}""review:null\n"
        originalInfo="${originalInfo}""result:this node does not have OSD."
        log INFO "FSA_${checkItemId}:this node does not have OSD."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    osd_cnt=`cat /opt/dsware/agent/conf/agentMonitor | grep -E "osd_.*_is_monitor=True" | wc -l`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/agentMonitor | grep -E 'osd_.*_is_monitor=True' | wc -l\n"
    originalInfo="${originalInfo}""review:osd_cnt=${osd_cnt}\n"
    if [ ${osd_cnt} -le 24 ]
    then
        originalInfo="${originalInfo}""result:The count of osd processes is less than 24, count: ${osd_cnt}."
        log INFO "FSA_${checkItemId}:The count of osd processes is less than 24, count: ${osd_cnt}."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    osd_running=`ps aux | grep ./dsware_osd | grep -v grep`
    originalInfo="${originalInfo}""command:ps aux | grep ./dsware_osd | grep -v grep\n"
    originalInfo="${originalInfo}""review:\n${osd_running}\n"
    if [[ -z "${osd_running}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  # 0004 OSD 节点，无 OSD 运行
        originalInfo="${originalInfo}""result:This node have OSD , but no process running."
        log ERROR "FSA_${checkItemId}:This node have OSD , but no process running."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    osd_conf="/opt/dsware/osd/conf/osd_*_conf.cfg"
    osd_conf_cnt=`ls -l ${osd_conf} 2>/dev/null|wc -l`
    if [ "$osd_conf_cnt" -eq 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 无OSD配置文件
        originalInfo="${originalInfo}""result:osd configuration file doesn't exist, file:${osd_conf}."
        log ERROR "FSA_${checkItemId}:osd configuration file doesn't exist, file:${osd_conf}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    ssd_card_judg=`cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep p_media_type | awk -F '=' '{print$2}'`
    originalInfo="command:cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep p_media_type | awk -F '=' '{print\$2}'\n"
    originalInfo="${originalInfo}""review:${ssd_card_judg}\n"
    if [[ "${ssd_card_judg}"x == "ssd"x ]]
    then
        originalInfo="${originalInfo}""result:p_media_type is ssd, no need to check.\n"
        log INFO "FSA_${checkItemId}:p_media_type is ssd, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    check_result=`sed -n 's/^p_rsm_max_get_throughput=//p' ${osd_conf}`
    originalInfo="${originalInfo}""command:sed -n 's/^p_rsm_max_get_throughput=//p' ${osd_conf}\n"
    originalInfo="${originalInfo}""review:${check_result}\n"
    if [[ -z "${check_result}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 配置文件中无流控相关信息
        originalInfo="${originalInfo}""result:No flow control information in osd configuration file, file:${osd_conf}."
        log ERROR "FSA_${checkItemId}:No flow control information in osd configuration file, file:${osd_conf}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${check_result} -gt 30 ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 未做流控
        originalInfo="${originalInfo}""result:The flow control isn't done."
        log ERROR "FSA_${checkItemId}:The flow control isn't done."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    originalInfo="${originalInfo}""result:The flow control is done."
    log INFO "FSA_${checkItemId}:The flow control is done."
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
