#!/bin/bash

#############################################################
#
# 名  称：检查FSA网口故障状态是否清理
# 错误码：
#         0000 正常
#         0001 网口故障状态未清理
#         0002 解压最新转储日志失败
#         0003 /var/log/dsware/dsware_agent.log 日志超过100MB
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4123"
resultCode=0
errorKey=""
params=""
originalInfo=""

# 日志文件最大100MB
LOG_MAX_SIZE_MB=100

# 检查日志大小，如果超过100MB，则返回1
function check_log_size() {
    log_file=$1
    [[ ! -f ${log_file} ]] && return 0
    log_size=$(du -m ${log_file} | awk '{print $1}')
    if [ ${log_size} -gt ${LOG_MAX_SIZE_MB} ]; then
        log ERROR "FSA_${checkItemId}:${log_file} (${log_size}MB) is larger than ${LOG_MAX_SIZE_MB}MB."
        return 1
    fi
    return 0
}

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    key="decsion_bond_stat_for_ha:.*bond(.*).*nic.*fault"
    log_file="/var/log/dsware/dsware_agent.log"
    now_time=`date  +"%Y-%m-%d %H:%M:%S"`
    time_one=`date -d "1 seconds ago" +"%Y-%m-%d %H:%M:%S"`
    time_two=`date -d "2 seconds ago" +"%Y-%m-%d %H:%M:%S"`

    check_log_size ${log_file}
    if [ $? -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # /var/log/dsware/dsware_agent.log 日志超过100MB
        originalInfo="${originalInfo}""command:du -m ${log_file}"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    
    result1=`grep -E "${key}" ${log_file} | grep "${now_time}"`
    originalInfo="${originalInfo}""command:grep -E '${key}' ${log_file} | grep '${now_time}'\n"
    originalInfo="${originalInfo}""review:${result1}\n"
    result2=`grep -E "${key}" ${log_file} | grep "${time_one}"`
    originalInfo="${originalInfo}""command:grep -E '${key}' ${log_file} | grep '${time_one}'\n"
    originalInfo="${originalInfo}""review:${result2}\n"
    result3=`grep -E "${key}" ${log_file} | grep "${time_two}"`
    originalInfo="${originalInfo}""command:grep -E '${key}' ${log_file} | grep '${time_two}'\n"
    originalInfo="${originalInfo}""review:${result3}\n"
    
    if [[ -n "${result1}" ]] || [[ -n "${result2}" ]] || [[ -n "${result3}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 网口故障状态未清理
        originalInfo="${originalInfo}""result:Network breakdown status is not cleared,log in ${log_file}."
        log ERROR "FSA_${checkItemId}:Network breakdown status is not cleared,log in ${log_file}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 获取最新的转储日志进行检测
    tar_log_file=`ls -r /var/log/dsware/dsware.*.tar.gz | head -n 1`
    originalInfo="${originalInfo}""command:ls -r /var/log/dsware/dsware.*.tar.gz | head -n 1\n"
    originalInfo="${originalInfo}""review:tar_log_file=${tar_log_file}\n"
    if [[ -n "${tar_log_file}" ]]
    then
        tar -zxvf ${tar_log_file} 2>&1 >/dev/null
        if [ $? -ne 0 ]
        then
            errorKey="${checkItemId}0002"  # 0002 解压最新转储日志失败
            originalInfo="${originalInfo}""result:command(tar -zxvf ${tar_log_file} 2>&1 >/dev/null) is failed."
            log ERROR "FSA_${checkItemId}:command(tar -zxvf ${tar_log_file} 2>&1 >/dev/null) is failed."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        # 检测最新转储日志中，是否存在问题关键字
        old_log_file=`ls ./var/log/dsware | grep FSA-dsware_agent.log`
        originalInfo="${originalInfo}""command:tar -zxvf ${tar_log_file} 2>&1 >/dev/null;ls ./var/log/dsware | grep FSA-dsware_agent.log\n"
        originalInfo="${originalInfo}""review:old_log_file_name=${old_log_file}\n"
        old_log_file="./var/log/dsware/${old_log_file}"
        originalInfo="${originalInfo}""result:old_log_file=${old_log_file}\n"
        result1=`grep -E "${key}" ${old_log_file} | grep "${now_time}"`
        originalInfo="${originalInfo}""command:grep -E '${key}' ${old_log_file} | grep '${now_time}'\n"
        originalInfo="${originalInfo}""review:${result1}\n"
        result2=`grep -E "${key}" ${old_log_file} | grep "${time_one}"`
        originalInfo="${originalInfo}""command:grep -E '${key}' ${old_log_file} | grep '${time_one}'\n"
        originalInfo="${originalInfo}""review:${result2}\n"
        result3=`grep -E "${key}" ${old_log_file} | grep "${time_two}"`
        originalInfo="${originalInfo}""command:grep -E '${key}' ${old_log_file} | grep '${time_two}'\n"
        originalInfo="${originalInfo}""review:${result3}\n"

        # 删除解压最新转储压缩包产生的垃圾数据
        rm -rf ./var 2>&1 >/dev/null

        if [[ -n "${result1}" ]] || [[ -n "${result2}" ]] || [[ -n "${result3}" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0001"  # 0001 网口故障状态未清理
            originalInfo="${originalInfo}""result:Network breakdown status is not cleared,log in old_log_file=${old_log_file} of tar_log_file=${tar_log_file}."
            log ERROR "FSA_${checkItemId}:Network breakdown status is not cleared,log in old_log_file=${old_log_file} of tar_log_file=${tar_log_file}."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

    originalInfo="${originalInfo}""result:Network breakdown status is cleared."
    log INFO "FSA_${checkItemId}:Network breakdown status is cleared."
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
