#!/bin/bash

#############################################################
#
# 名  称：检查是否存在网络误码
# 错误码：
#         0000 正常
#         0001 节点没有 /opt/dsware/agent/conf/node_storage_ip 文件
#         0002 获取存储网卡信息失败
#         0003 存储网卡存在网络误码
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4204"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    if [ ! -f "/opt/dsware/agent/conf/node_storage_ip" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 节点没有 /opt/dsware/agent/conf/node_storage_ip 文件
        originalInfo="${originalInfo}""result:There is no '/opt/dsware/agent/conf/node_storage_ip' file, get storage_ip failed."
        log ERROR "FSA_${checkItemId}:There is no '/opt/dsware/agent/conf/node_storage_ip' file, get storage_ip failed."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    storage_ip=`cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print$2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print\$2}'\n"
    originalInfo="${originalInfo}""review:storage_ip=${storage_ip}\n"
    storage_net_card=`ip a | grep ${storage_ip} | awk '{print$NF}'`
    originalInfo="${originalInfo}""command:ip a | grep ${storage_ip} | awk '{print\$NF}'\n"
    originalInfo="${originalInfo}""review:storage_net_card=${storage_net_card}\n"

    if [[ -z "${storage_net_card}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 获取存储网卡信息失败
        originalInfo="${originalInfo}""result:Failed to query the storage network card information of FSA."
        log ERROR "FSA_${checkItemId}:Failed to query the storage network card information of FSA."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    net_info=`cat /proc/net/dev`
    originalInfo="${originalInfo}""command:cat /proc/net/dev\n"
    originalInfo="${originalInfo}""review:\n${net_info}\n"
    recv_errs=`echo "${net_info}" | grep ${storage_net_card} | awk '{print$4}'`
    send_errs=`echo "${net_info}" | grep ${storage_net_card} | awk '{print$12}'`
    originalInfo="${originalInfo}""result:recv_errs=${recv_errs};send_errs=${send_errs}\n"
    
    if [ ${recv_errs} -gt 200000 -o ${send_errs} -gt 200000 ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 存储网卡存在网络误码
        originalInfo="${originalInfo}""result:storage_net_card=${storage_net_card}:recv_errs=${recv_errs};send_errs=${send_errs}."
        log ERROR "FSA_${checkItemId}:storage_net_card=${storage_net_card}:recv_errs=${recv_errs};send_errs=${send_errs}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:There is no error packet for storage network card."
        log INFO "FSA_${checkItemId}:There is no error packet for storage network card."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
