#!/bin/bash

#############################################################
#
# 名  称：检查VBS进程是否正常提供服务
# 错误码：
#         0000 正常
#         0001 版本信息文件不存在
#         0002 防火墙开机自启动
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4206"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    if [ ! -f "/opt/dsware/DSwareAgentNodeVersion" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 版本信息文件不存在
        originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion \n"
        originalInfo="$originalInfo""result:There is no version information file."
        log ERROR "There is no version information file."
        log ERROR "${checkItemId}:FSA_4206:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local osdInfo="$(ps -ef | grep -w './dsware_osd' | grep -v grep)"
    originalInfo="command:ps -ef | grep -w './dsware_osd' | grep -v grep \n"
    originalInfo="${originalInfo}""review:${osdInfo} \n"
    
	#检查是否是存储节点，若不是则不用检查防火墙是否开机自启动
	if [ -z "${osdInfo}" ]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:this node is not a storage node, no need to check."
        log INFO "FSA_${checkItemId}:this node is not a storage node, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        originalInfo="${originalInfo}""result:this node is OSD_node.\n"
	fi

    #检查SUSE OS
    if [ -f "/etc/SuSE-release" ]
    then
        firewall_setup="$(chkconfig | grep SuSEfirewall2_setup | awk '{print $2}')"
        originalInfo="command:chkconfig | grep SuSEfirewall2_setup | awk '{print \$2}'\n"
        originalInfo="${originalInfo}""review:firewall_setup=${firewall_setup}\n"
        firewall_init="$(chkconfig | grep SuSEfirewall2_init | awk '{print $2}')"
        originalInfo="${originalInfo}""command:chkconfig | grep SuSEfirewall2_init | awk '{print \$2}'; \n"
        originalInfo="${originalInfo}""review:firewall_init=${firewall_init} \n"
    
        if [[ "${firewall_setup}" != "off" || "${firewall_init}" != "off" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0002"   # 防火墙开机自启动
            originalInfo="${originalInfo}""result:SUSE OS: No Disable boot firewall."
            log ERROR "FSA_${checkItemId}: No Disable boot firewall."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1    
        fi        
    fi 
    
    #检查Euler OS
    if [ -f "/etc/euleros-release" ]
    then
        result="$(systemctl is-enabled firewalld)"
        originalInfo="command:systemctl is-enabled firewalld; \n"
        originalInfo="${originalInfo}""review:${result}; \n"
        
        if [ "${result}" == "enabled" ]
        then 
            resultCode=1
            errorKey="${checkItemId}0002"   # 防火墙开机自启动
            originalInfo="$originalInfo""result:Euler OS: No Disable boot firewall."
            log ERROR "FSA_${checkItemId}: No Disable boot firewall."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1  
        fi
    fi

    resultCode=0
    originalInfo="${originalInfo}""result:Disable boot firewall."
    log INFO "FSA_${checkItemId}:Disable boot firewall."
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0


}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
