#!/bin/bash

#############################################################
#
# 名  称：检查InfiniBand网卡状态
# 错误码：
#         0000 正常
#         0001 获取IB网卡信息失败,请检查IB网卡是否被启用
#         0002 IB网卡状态异常，请检查IB网卡是否被启用或者IB网卡存在异常
#         0003 IB网卡状态正常，获取丢包、错包信息失败
#         0004 ib网卡端口未运行
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4301"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    ib_judg=`lspci | grep -i mellanox|grep -v "Ethernet"`
    originalInfo="${originalInfo}""command:lspci | grep -i mellanox|grep -v Ethernet\n"
    originalInfo="${originalInfo}""review:ib_judg=${ib_judg}\n"
    if [[ -z "${ib_judg}" ]]
    then
        originalInfo="${originalInfo}""result:ibnetwork does not exist."
        log INFO "FSA_${checkItemId}:ibnetwork does not exist."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    ib_status=`ibstat | grep "State:" | grep "Active" | wc -l`
    ret=$?
    originalInfo="${originalInfo}""command:ibstat | grep 'State:' | grep 'Active' | wc -l\n"
    originalInfo="${originalInfo}""review:\$?=${ret};ib_status=${ib_status}\n"

    if [ ${ret} -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 获取IB网卡信息失败,请检查IB网卡是否被启用
        originalInfo="${originalInfo}""result:Get ibstat info failed."
        log ERROR "FSA_${checkItemId}:Get ibstat info failed."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${ib_status} -ge 1 ]
    then
        ib_name_list=`ibstat -l`
        originalInfo="${originalInfo}""command:ibstat -l\n"
        originalInfo="${originalInfo}""review:ib_name_list is :\n${ib_name_list}\n"

        for ib_name in ${ib_name_list[@]}
        do
            originalInfo="${originalInfo}""ib_name=${ib_name}\n"
            result_out_put=""
            port_num=`ibstat | grep -A5 "${ib_name}" | grep -E "Number[[:space:]]+of[[:space:]]+ports" | awk -F ':' '{print $2}' | sed s/\ //g`
            originalInfo="${originalInfo}""command:ibstat | grep -A5 '${ib_name}' | grep -E 'Number[[:space:]]+of[[:space:]]+ports' | awk -F ':' '{print \$2}'\n"
            originalInfo="${originalInfo}""review:port_num_total=${port_num}\n"
            for ((i=1; i<=${port_num}; i++))
            do
                port_stat=`ibstat "${ib_name}" | grep -A5 -E "Port[[:space:]]${i}" | grep "State" | grep "Active"`
                originalInfo="${originalInfo}""command:ibstat '${ib_name}' | grep -A5 -E 'Port[[:space:]]${i}' | grep State | grep Active\n"
                originalInfo="${originalInfo}""review:port_stat=${port_stat}\n"

                if [ -n "${port_stat}" ]
                then
                    originalInfo="${originalInfo}""result:port ${i} is active.\n"
                    results=`perfquery -C ${ib_name} -P ${i}|grep -E "SymbolErrorCounter|LinkDownedCounter"`
                    ret=$?
                    originalInfo="${originalInfo}""command:perfquery -C ${ib_name} -P ${i}|grep -E 'SymbolErrorCounter|LinkDownedCounter'\n"
                    originalInfo="${originalInfo}""review:\$?=${ret};result=${results}\n"
                    if [ ${ret} -ne 0 ]
                    then
                        resultCode=1
                        errorKey="${checkItemId}0003"  # 0003 IB网卡状态正常，获取丢包、错包信息失败
                        originalInfo="${originalInfo}""result:ib_name=${ib_name} port_num=${i}:Get ib link info failed."
                        log ERROR "FSA_${checkItemId}:ib_name=${ib_name} port_num=${i}:Get ib link info failed."
                        log ERROR "FSA_${checkItemId}:unok"
                        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                        return 1
                    else
                        resultOutPut="${resultOutPut}ib_name=${ib_name} port_num=${i}:${results[0]},${results[1]}\n" 
                    fi
                else
                    resultCode=1
                    errorKey="${checkItemId}0004"  # 0004 ib网卡端口未运行
                    originalInfo="${originalInfo}""result:ib_name=${ib_name} port_num=${i} is not active."
                    log ERROR "FSA_${checkItemId}:ib_name=${ib_name} port_num=${i}:Get ib link info failed."
                    log ERROR "FSA_${checkItemId}:unok"
                    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                    return 1
                fi
            done

            if [ -n "${resultOutPut}" ]
            then
                one_data_info="${one_data_info}${ib_name}:\n${resultOutPut}"
            fi
        done

        if [[ -z "${one_data_info}" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0003"  # 0003 IB网卡状态正常，获取丢包、错包信息失败
            originalInfo="${originalInfo}""result:ib_status is right , but get net_error_pack info failed."
            log ERROR "FSA_${checkItemId}:ib_status is right , but get net_error_pack info failed."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            originalInfo="${originalInfo}""result:ibstat is normal.ib link info infomation:${one_data_info}"
            log INFO "FSA_${checkItemId}:ibstat is normal."
            log INFO "FSA_${checkItemId}:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    else
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 IB网卡状态异常，请检查IB网卡是否被启用或者IB网卡存在异常
        originalInfo="${originalInfo}""result:ibstat is abnormal."
        log ERROR "FSA_${checkItemId}:ibstat is abnormal."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi



}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
