#!/bin/bash

#############################################################
#
# 名  称：检查RoCE网卡状态
# 错误码：
#         0000=正常
#         0001=驱动没有安装
#         0002=驱动未加载
#         0003=所有RoCE网卡都不是ACTIVE状态
#         0004=RoCE网络未安装RoCE网卡
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4303"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    IB_SYS_PATH=/sys/class/infiniband/

    network_type=`cat /opt/dsware/agent/conf/network.cfg |grep -i network_type|awk -F '"' '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/network.cfg |grep -i network_type\n"
    originalInfo="${originalInfo}""review:network_type=${network_type}\n"
    if [[ "${network_type}"x != "RoCE"x ]]
    then
        originalInfo="${originalInfo}""result:The network_type is not RoCE."
        log INFO "FSA_${checkItemId}:The network_type is not RoCE."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        originalInfo="${originalInfo}""result:The network_type is RoCE.\n"
    fi

    pci_dev=`lspci |grep -i mellanox|grep "Ethernet"`
    originalInfo="${originalInfo}""command:lspci |grep -i mellanox|grep Ethernet\n"
    originalInfo="${originalInfo}""review:${pci_dev}\n"
    if [[ -z "${pci_dev}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  # 0004 RoCE网络未安装RoCE网卡
        originalInfo="${originalInfo}""result:this network_type is RoCE, but there is no RoCE_card on this node."
        log ERROR "FSA_${checkItemId}:this network_type is RoCE, but there is no RoCE_card on this node."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:there is(are) RoCE_card(s) on the node.\n"
    fi

    tmp_command=`command -v ofed_info`
    originalInfo="${originalInfo}""command:command -v ofed_info\n"
    originalInfo="${originalInfo}""review:${tmp_command}\n"
    if [ -z "${tmp_command}" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 驱动没有安装
        originalInfo="${originalInfo}""result:ofed driver not install, command ofed_info not found."
        log ERROR "FSA_${checkItemId}:ofed driver not install, command ofed_info not found."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ! -d "${IB_SYS_PATH}" ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 驱动未加载
        originalInfo="${originalInfo}""result:infiniband core driver not loaded, there is no dir of /sys/class/infiniband/."
        log ERROR "FSA_${checkItemId}:ofed driver not install, there is no dir of /sys/class/infiniband/."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    ibv_dev_list=$(ls ${IB_SYS_PATH} 2>/dev/null)
    originalInfo="${originalInfo}""command:ls ${IB_SYS_PATH} 2>/dev/null\n"
    originalInfo="${originalInfo}""review:${ibv_dev_list}\n"
    roce_dev_list=""
    for dev in ${ibv_dev_list}
    do
        link_layer=$(find ${IB_SYS_PATH}/${dev}/ports -name link_layer|xargs cat|head -1)
        originalInfo="${originalInfo}""command:find ${IB_SYS_PATH}/${dev}/ports -name link_layer|xargs cat|head -1\n"
        originalInfo="${originalInfo}""review:${link_layer}"
        if [[ "${link_layer}"x = "Ethernet"x ]]
        then
            originalInfo="${originalInfo}""result:${dev} network_card maybe is ACTIVE.\n"
            roce_dev_list=${roce_dev_list}" "${dev}
        fi
    done
    originalInfo="${originalInfo}""result:roce dev list :${roce_dev_list}\n"
    if [ -z "${roce_dev_list}" ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 所有RoCE网卡都不是ACTIVE状态
        originalInfo="${originalInfo}""result:RoCE interface not exist."
        log ERROR "FSA_${checkItemId}:RoCE interface not exist."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    output=""
    active_interface=""
    for dev in ${roce_dev_list}
    do
        dev_info=""
        dev_ports=($(ls ${IB_SYS_PATH}/${dev}/ports/))
        originalInfo="${originalInfo}""command:ls ${IB_SYS_PATH}/${dev}/ports/\n"
        originalInfo="${originalInfo}""review:RoCE_card_ports of ${dev} is include:${dev_ports}\n"
        for port in `ls ${IB_SYS_PATH}/${dev}/ports/`
        do
            dir_port=${IB_SYS_PATH}/${dev}/ports/${port}
            state=$(cat $dir_port/state)
            originalInfo="${originalInfo}""command:cat $dir_port/state\n"
            originalInfo="${originalInfo}""review:${state}\n"
            if [ -n "`echo $state|grep -i ACTIVE`" ]
            then
                active_interface="${active_interface} $dev"
                originalInfo="${originalInfo}""result:${dir_port}/state have keyword which is ACTIVE.\n"
            fi
            results="SymbolErrorCounter......`cat ${dir_port}/counters/symbol_error`"
            results=$results",""LinkDownedCounter.......`cat ${dir_port}/counters/link_downed`"
            results="Port $port: state:[${state:3}]   "$results
            [ -n "$results" ] && [ -n "$dev_info" ] && dev_info="${dev_info}\n${results}" || dev_info=$results
        done
        [ -n "$dev_info" ] && output="${output}${dev}:\n${dev_info}\n"
    done

    if [ -n "${active_interface}" ];then
        originalInfo="${originalInfo}""RoCE_card_info:${output}\n"
        originalInfo="${originalInfo}""result:there have RoCE_card(s) that is(are) ACTIVE."
        log INFO "FSA_${checkItemId}:there have RoCE_card(s) that is(are) ACTIVE."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 所有RoCE网卡都不是ACTIVE状态
        originalInfo="${originalInfo}""RoCE_card_info:${output}\n"
        originalInfo="${originalInfo}""result:there is no RoCE_card_port_state which is ACTIVE."
        log ERROR "FSA_${checkItemId}:there is no RoCE_card_port_state which is ACTIVE."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
