#!/bin/bash


UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4304"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
            return 0
	fi

	disk_error_result=""
	local file="/proc/smio_host"
	local line_cnt=$(cat $file | grep -v ScsiId | wc -l)
	originalInfo="${originalInfo}""command:cat /proc/smio_host | grep -v ScsiId | wc -l \n"
	originalInfo="${originalInfo}""review:smio_host_total_line:${line_cnt}\n"

	if [ ${line_cnt} -eq 0 ]
	then
		resultCode=1
		errorKey="${checkItemId}0001"   #0001 没有硬盘
		originalInfo="${originalInfo}""result:There is no hard disk."
		log ERROR "There is no hard disk."
		log ERROR "${checkItemId}:FSA_4304:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1
	fi

	smio_info=`cat ${file}`
	originalInfo="${originalInfo}""command:cat ${file}\n"
	originalInfo="${originalInfo}""review:smio_info:\n${smio_info}\n\n"

	for ((i=2;i<=$line_cnt+1;i++))
	do
		line_info=$(sed -n ${i}p $file)
		disk_info=`echo "${line_info}" | tr -s " "`
		falt_info=`echo "${disk_info}" | awk -F'|' '{print $17}' | sed 's/ //g'`
		if [[ "${falt_info}"x == "NULL"x ]]
		then
			HW_status=$(echo "${disk_info}" | awk -F'|' '{print $14}' | sed 's/ //g')
			ALM_TYPE=$(echo "${disk_info}" | awk -F'|' '{print $15}' | sed 's/ //g')
			ALM_LEV=$(echo "${disk_info}" | awk -F'|' '{print $16}' | sed 's/ //g')
			[ ${HW_status} -eq 0 -a ${ALM_TYPE} -eq 0 -a ${ALM_LEV} -eq 0 ] && { continue; }
		fi
		name=$(echo ${disk_info} | awk -F '|' '{print $3}')
		esn=$(echo ${disk_info} | awk -F'|' '{print $7}' | sed 's/ //g')
		state=$(echo ${disk_info} | awk -F '|' '{print $11}')
		slot=$(echo ${disk_info} | awk -F'|' '{print $6}' | awk -F ':' '{print $2}' | sed 's/ //g')
		HW_status=$(echo "${disk_info}" | awk -F'|' '{print $14}' | sed 's/ //g')
		ALM_TYPE=$(echo "${disk_info}" | awk -F'|' '{print $15}' | sed 's/ //g')
		ALM_LEV=$(echo "${disk_info}" | awk -F'|' '{print $16}' | sed 's/ //g')
		[ $slot == '-1' ] && { continue; }
		disk_error_result="Slot:${slot}, Name:${name}, Esn: ${esn}, State: ${state},FALT_INFO:${falt_info}, HW_status:${HW_status}, ALM_TYPE:${ALM_TYPE}, ALM_LEV:${ALM_LEV};\n${disk_error_result}"
	done

	if [[ -z "${disk_error_result}" ]]
	then
		originalInfo="${originalInfo}""result:All hard disks are normal."
		log INFO "FSA_${checkItemId}:All hard disks are normal."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
	else
		resultCode=1
		errorKey="${checkItemId}0002"   #0002 硬盘故障
		originalInfo="${originalInfo}""result:This node has a faulty hard disk, include:\n${disk_error_result}."
		log ERROR "FSA_${checkItemId}:This node has a faulty hard osd_disk, include:\n${disk_error_result}."
		log ERROR "FSA_${checkItemId}:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1
	fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001  没有硬盘
#  0002  硬盘故障
# 
##############################