#!/bin/bash

PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4305"
resultCode=0
errorKey=""
params=""
originalInfo=""



#############################################################
# 描述：网卡bond状态检查(FSA)
# 错误码：(0~9为正常，10及以上为异常)
#         0 正常
#         10 FSA存储网络未组bond
#         11 bond网卡模式不正确，bond网卡模式为：$1
#         12 查询FSA存储IP信息失败
#############################################################
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"
IP_TYPE=""

function get_storage_ip()
{
    if [ -f /opt/dsware/agent/conf/node_storage_ip ];then
        storage_ip=$(sed -n 's/node_storage_ip=//p' /opt/dsware/agent/conf/node_storage_ip)
        originalInfo="command:sed -n 's/node_storage_ip=//p' /opt/dsware/agent/conf/node_storage_ip\n"
        originalInfo="${originalInfo}""review:${storage_ip}\n"
		return
	fi
	
	storage_ip=$(sh /opt/dsware/agent/script/inquiry_disk.sh XX get_storage_ip)
    if [ 0 -eq $? ] && [ -n "$storage_ip" ];then
        originalInfo="command:sh /opt/dsware/agent/script/inquiry_disk.sh XX get_storage_ip\n"
        if [ "Xipv4" == "X${IP_TYPE}" ];then
            storage_ip=$(echo $storage_ip|awk -F : '{print $2}')
        else
            storage_ip=$(echo $storage_ip|awk -F , '{print $2}')
        fi
        originalInfo="${originalInfo}""review:${storage_ip}"
		return
	fi
	
	network_name=$(sed -n 's/network_name=//p' /opt/dsware/agent/conf/network.cfg | sed 's/\"//g')
	originalInfo="command:sed -n 's/network_name=//p' /opt/dsware/agent/conf/network.cfg\n"
	originalInfo="${originalInfo}""review:${network_name}\n"
	storage_ip=$(ifconfig | grep -A 1 $network_name | sed -n '$p' | awk -F':' '{print $2}' | awk '{print $1}')
	originalInfo="${originalInfo}""ifconfig | grep -A 1 $network_name | sed -n '$p' | awk -F':' '{print \$2}' | awk '{print \$1}'"
	originalInfo="${originalInfo}""review:${storage_ip}"
}

function get_network_type()
{
    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')
    if [ "X0" != "X${IP_TYPE}" -a "X1" != "X${IP_TYPE}" ];then
        [[ -z "${IP_TYPE}" ]] && IP_TYPE="0"
    fi

    if [ "X0" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv4"
    elif [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    fi
    log INFO "P_STORAGE_IP_FAMILY=${IP_TYPE}"
    return 0
}

function main()
{	
	agent_items_check ${checkItemId}
	if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
	fi

    fsp=$(id fsp &>/dev/null)
	if [ $? -eq 0 ];then
	    originalInfo="command: id fsp"
	    originalInfo="${originalInfo}""result:fsp exist do not need check."
	    log INFO "FSA_${checkItemId}:fsp exist.do not need check."
	    log INFO "FSA_${checkItemId}:ok"
	    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	    return 0
	fi

    get_network_type
	get_storage_ip
	if [ -z "$storage_ip" ];then
		resultCode=1
		errorKey="${checkItemId}0001"   # 查询FSA存储IP信息失败
		originalInfo="${originalInfo}""result:The storage ip doesn't exist.\n"
		log ERROR "The storage ip doesn't exist."
		log ERROR "${checkItemId}:FSA_4305:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	    return 1
	fi

	local netcard=""
	if [ "Xipv4" == "X${IP_TYPE}" ];then
	    netcard=$(ifconfig | grep -B 1 $storage_ip | head -1 | awk '{print $1}' | tr ':' ' '|  sed 's/ //g')
	    originalInfo="${originalInfo}""ifconfig | grep -B 1 $storage_ip | head -1 | awk '{print \$1}'\n"
	    originalInfo="${originalInfo}""review:${netcard}\n"
	else
	    netcard=$(ifconfig | grep -B 2 $storage_ip | head -1 | awk '{print $1}' | tr ':' ' '|  sed 's/ //g')
	    originalInfo="${originalInfo}""ifconfig | grep -B 2 $storage_ip | head -1 | awk '{print \$1}' \n"
	    originalInfo="${originalInfo}""review:${netcard}\n"
	fi

	if [ -z "$netcard" ];then
		resultCode=1
		errorKey="${checkItemId}0002"   # FSA存储网络未组bond
		#originalInfo="${originalInfo}""command:sed -n 's/node_storage_ip=//p' /opt/dsware/agent/conf/node_storage_ip\n"
		originalInfo="${originalInfo}""result:The storage network card doesn't exist.\n"
		log ERROR "The storage network card doesn't exist."
		log ERROR "${checkItemId}:FSA_4305:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	    return 1
	fi
	
	if [ ! -f /proc/net/bonding/$netcard ];then
	    if [ -f  /etc/sysconfig/network-scripts/ifcfg-${netcard} ];then
	        file="/etc/sysconfig/network-scripts/ifcfg-${netcard}"
		fi		
		if [ -f  /etc/sysconfig/network/ifcfg-${netcard} ];then
	        file="/etc/sysconfig/network/ifcfg-${netcard}"
		fi

		if [ -z "${file}" ]
		then
			originalInfo="${originalInfo}""result:no bond file, no need to check.\n"
			log INFO "FSA_${checkItemId}:no bond file, no need to check.\n"
			log INFO "FSA_${checkItemId}:ok"
			FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
			return 0
		fi

		bond=$(sed -n 's/PHYSDEV=//p' $file)
	    if [ -z "$bond" ] || [ ! -f /proc/net/bonding/$bond ];then
			resultCode=1
			errorKey="${checkItemId}0003"   # FSA存储网络未组bond
			originalInfo="${originalInfo}""command:sed -n 's/PHYSDEV=//p' ${file}"
			originalInfo="${originalInfo}""result:The bond network card doesn't exist.\n"
			log ERROR "The bond network card doesn't exist."
			log ERROR "${checkItemId}:FSA_4305:unok"
			FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
			return 1
		fi
		netcard=$bond
	fi
	
	mode=$(sed -n 's/Bonding Mode: //p' /proc/net/bonding/$netcard)
	if [ "$(echo $mode | grep -i active-backup)" == "" ];then
		resultCode=1
		errorKey="${checkItemId}0004"   # bond网卡模式不正确，bond网卡模式为：$1
		originalInfo="command:sed -n 's/node_storage_ip=//p' /opt/dsware/agent/conf/node_storage_ip"
		originalInfo="${originalInfo}""result:The bond network card mode is inaccurate, bond network card mode is: $mode"
		log ERROR "The bond network card mode is inaccurate, bond network card mode is: $mode"
		log ERROR "${checkItemId}:FSA_4305:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1
	fi
	originalInfo="${originalInfo}""result:The bond network card exists."
	log INFO "FSA_${checkItemId}:The bond network card exists."
	log INFO "FSA_${checkItemId}:ok"
	FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 
#  0002  
#
##############################