#!/bin/bash

#############################################################
#
# 名  称：检查V3/V5 SSD盘及SSD卡寿命
# 错误码：
#         0000=正常
#         0001=未安装 smartctl ，查询SATA_SSD盘信息失败
#         0002=没有ssd卡或者ssd盘
#         0003=查询SAS_SSD磁盘的剩余生命周期不支持
#         0004=查询SATA SSD磁盘信息失败
#         0005=未安装hioadm或不支持hioadm信息
#         0006=存在寿命低于20%的硬盘；且系统不支持smartctl命令
#         0007=存在寿命低于20%的硬盘
#         0008=lspci 命令执行失败
#
#############################################################

PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4308"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    osd_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep osd | grep monitor | grep True | wc -l`
    if [ ${osd_judg} -eq 0 ]
    then
        originalInfo="${originalInfo}""result:this is not OSD_node, no need to check."
        log INFO "FSA_${checkItemId}:this is not OSD_node, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    ssd_card_type="PCIE_SSD NVME_SSD"
	
	ssd_card_names=""
	sata_ssd_names=""
	sas_ssd_names=""
	ssd_card_result=""
	sata_ssd_result=""
	
	hioadm_fail=0
	smartctl_fail=0

    lspci_judg=`which lspci`
    originalInfo="${originalInfo}""command:which lspci\n"
    originalInfo="${originalInfo}""review:${lspci_judg}\n"
    if [[ -z "${lspci_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0008"  # 0008 lspci 命令执行失败
        originalInfo="${originalInfo}""result:command of lspci can not excute."
        log ERROR "FSA_${checkItemId}:command of lspci can not excute."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    V1_V2_judg=`lspci -v | grep -E '19e5:0007|19e5:0008|19e5:0009'`
    originalInfo="${originalInfo}""command:lspci -v | grep -E '19e5:0007|19e5:0008|19e5:0009'\n"
    originalInfo="${originalInfo}""review:V1_V2_judg=\n${V1_V2_judg}\n"
    if [[ -n "${V1_V2_judg}" ]]
    then
        originalInfo="${originalInfo}""result:there is  V1 or V2 SSD card on the node, no need to check ."
        log INFO "FSA_${checkItemId}:there is  V1 or V2 SSD card on the node, no need to check ."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

	check_STATA_SSD=$(which smartctl > /dev/null 2>&1)
    ret=$?
    originalInfo="command:which smartctl \n"
    originalInfo="${originalInfo}""review:\$?=${ret}\n"
	if [ ${ret} -ne 0 ]
    then
		smartctl_fail=1
        resultCode=2
        errorKey="${checkItemId}0001"  # 0001 未安装 smartctl ，查询SATA_SSD盘信息失败
        originalInfo="${originalInfo}""result:the smartctl is uninstalled."
        log ERROR "FSA_${checkItemId}:the smartctl is uninstalled."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
	fi	
	
    smio_info=`cat /proc/smio_host`
	originalInfo="${originalInfo}""command:cat /proc/smio_host\n"
    originalInfo="${originalInfo}""review:\n${smio_info}\n"
    while read line
    do
	    local type=$(echo $line | awk -F'|' '{print $9}' | sed 's/ //g')
		dev_name=$(echo $line | awk -F'|' '{print $3}' | sed 's/ //g')
		
		if [ -n "$(echo $ssd_card_type | grep -w $type)" ]
        then
		    ssd_card_names="$dev_name $ssd_card_names"
		elif [ "$type" == "SATA_SSD" ]
        then
			sata_ssd_names="$dev_name $sata_ssd_names"
            if [ "$smartctl_fail" -eq 1 ];then
			    continue
			fi
			
			dev_id=$(echo $line | awk -F'|' '{print $10}' | awk -F':' '{print $2}')
            smartinfo=$(smartctl -a --device=sat+megaraid,${dev_id} /dev/${dev_name})
			info=$(smartctl -a --device=sat+megaraid,${dev_id} /dev/${dev_name} | grep -i Media_Wearout_Indicator)
            originalInfo="${originalInfo}""command:(smartctl -a --device=sat+megaraid,${dev_id} /dev/${dev_name} | grep -i Media_Wearout_Indicator\n"
            originalInfo="${originalInfo}""review:${info}\n"
            originalInfo="${originalInfo}""smartinfo:${smartinfo}\n"
			if [ -z "$info" ];then
                smartctl_fail=1			
			    continue
			fi
			
			left=$(echo "$info" | awk '{print $4}' | awk '{print $0+0}')
			if [ -n "$left" -a $left -lt 20 ]
            then
                originalInfo="${originalInfo}""result:${dev_name} left ${left}%.\n"
			    sata_ssd_result="${sata_ssd_result}, ${dev_name}(${left}%)"
			fi
		elif [ "$type" == "SAS_SSD" ]
        then
			sas_ssd_names="$dev_name $sas_ssd_names"
            smartinfo=$(smartctl -a /dev/${dev_name})
            originalInfo="${originalInfo}""smartinfo:${smartinfo}\n"
		fi
	done < /proc/smio_host
	
	if [ -z "$ssd_card_names" ] && [ -z "$sata_ssd_names" ] && [ -z "$sas_ssd_names" ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 没有ssd卡或者ssd盘
        originalInfo="${originalInfo}""result:There is no ssd card or ssd disk."
        log ERROR "FSA_${checkItemId}:There is no ssd card or ssd disk."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
	fi
	
	if [ -z "$ssd_card_names" ] && [ -z "$sata_ssd_names" ] && [ -n "$sas_ssd_names" ]
    then
		resultCode=2
        errorKey="${checkItemId}0003"  # 0003 查询SAS_SSD磁盘的剩余生命周期不支持
        originalInfo="${originalInfo}""result:Query left lifetime of SAS_SSD disk doesn't support, SAS_SSD is ${sas_ssd_names}."
        log ERROR "FSA_${checkItemId}:Query left lifetime of SAS_SSD disk doesn't support, SAS_SSD is ${sas_ssd_names}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
	fi
	
	if [ -z "$ssd_card_names" ] && [ -n "$sata_ssd_names" ] && [ "${smartctl_fail}"  -eq 1 ]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  # 0004 查询SATA SSD磁盘信息失败
        originalInfo="${originalInfo}""result:Query SATA SSD disk information failed, details: the smartctl isn't supported, SATA_SSD disk is ${sata_ssd_names}."
        log ERROR "FSA_${checkItemId}:Query SATA SSD disk information failed, details: the  smartctl isn't supported, SATA_SSD disk is ${sata_ssd_names}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
	fi
	
    if [ -n "$ssd_card_names" ]
    then
	    which hioadm > /dev/null 2>&1
        res1=$?
        originalInfo="${originalInfo}""command:which hioadm\n"
        originalInfo="${originalInfo}""review:\$?=${res1}\n"
	    hioadm info > /dev/null 2>&1
		res2=$?
        originalInfo="${originalInfo}""command:hioadm info\n"
        originalInfo="${originalInfo}""review:\$?=${res2}\n"
	    if [ $res1 -ne 0 ] || [ $res2 -ne 0 ]
        then
		    hioadm_fail=1
            resultCode=2
            errorKey="${checkItemId}0005"  # 0005 未安装hioadm或不支持hioadm信息
            originalInfo="${originalInfo}""result: the hioadm is uninstalled."
            log ERROR "FSA_${checkItemId}:the hioadm is uninstalled."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
	    fi
        
		if [  "$hioadm_fail" -eq 0 ]
        then
            ssd_card_name=$(hioadm info | grep "^|---- " | awk '{print $2}')
            originalInfo="${originalInfo}""command:hioadm info | grep '^|---- ' | awk '{print \$2}'\n"
            originalInfo="${originalInfo}""review:ssd_card_name=${ssd_card_name}\n"
            for ssd in $ssd_card_name
            do
                smartinfo=$(hioadm info -d ${ssd} -s)
                used=$(hioadm info -d ${ssd} -s  | grep -i "percentage used" | awk -F":" '{print $2}' | awk -F"%" '{print $1}' | sed 's/ //g')
                originalInfo="${originalInfo}""command:hioadm info -d $ssd -s  | grep -i 'percentage used' | awk -F ':' '{print \$2}'\n"
                originalInfo="${originalInfo}""review:used=${used}%\n"
                originalInfo="${originalInfo}""smartinfo:${smartinfo}\n"
                left=$(awk "BEGIN{print 100 - $used }")
                if [ $left -lt 20 ]
                then
                    originalInfo="${originalInfo}""result:The ${ssd} disk left lifetime is less than 20%."
			        ssd_card_result="${ssd_card_result}, $ssd(${left}%)"
			    fi
		    done
		fi
    fi

	if [ -n "$ssd_card_names" ] && [ -n "$sata_ssd_names" ]
    then
		if [ -n "$ssd_card_result" ] && [ "$smartctl_fail" -eq 1 ];then
		    ssd_card_result=${ssd_card_result:2}
            resultCode=1
            errorKey="${checkItemId}0006"  # 0006 存在寿命低于20%的硬盘；且系统不支持smartctl命令
            originalInfo="${originalInfo}""result:There are some disks that left lifetime are less than 20%, include: ${ssd_card_result}; and the smartctl isn't supported."
            log ERROR "FSA_${checkItemId}:There are some disks that left lifetime are less than 20%, include: ${ssd_card_result}; and the smartctl isn't supported."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
		fi
	fi
	
	if [ -n "$ssd_card_result" ] || [ -n "$sata_ssd_result" ];then
		ssd_card_result=${ssd_card_result:2} 
		sata_ssd_result=${sata_ssd_result:2}
		result="${ssd_card_result} ${sata_ssd_result}"
        resultCode=1
        errorKey="${checkItemId}0007"  # 0007 存在寿命低于20%的硬盘
        originalInfo="${originalInfo}""result:There are some disks that left lifetime are less than 20%, include: ${result}"
        log ERROR "FSA_${checkItemId}::There are some disks that left lifetime are less than 20%, include: ${result}"
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi		   
	
    originalInfo="${originalInfo}""result:All SSD cards or SSD disks are normal."
	log INFO "FSA_${checkItemId}:All SSD cards or SSD disks are normal."
	log INFO "FSA_${checkItemId}:ok"
	FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

