#!/bin/bash

#############################################################
#
# 名  称：检查 OSD 进程是否可能会进入阻塞状态
# 错误码：
#         0000 正常
#         0001 存在 RAID 卡驱动异常 
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4356"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    osd_list=`ps -ef |grep dsware_osd |grep -v grep |awk '{print $2}'`
    originalInfo="${originalInfo}""command:ps -ef |grep dsware_osd |grep -v grep |awk '{print \$2}'\n"
    originalInfo="${originalInfo}""review:osd_list=\n${osd_list}\n"

    error_raid_info=""
    for osd in ${osd_list}
    do
        raid_status=`cat /proc/${osd}/task/*/stack | grep megaraid`
        originalInfo="${originalInfo}""command:cat /proc/${osd}/task/*/stack | grep megaraid\n"
        originalInfo="${originalInfo}""review:raid_status=${raid_status}\n"
        if [[ -n "${raid_status}" ]]
        then
            error_raid_info="${osd},${error_raid_info}"
        fi
    done

    error_raid_info=${error_raid_info%?}
    if [[ -z "${error_raid_info}" ]]
    then
        originalInfo="${originalInfo}""result:OSD_process is healthy."
        log INFO "FSA_${checkItemId}:OSD_process is healthy."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 存在 RAID 卡驱动异常
        originalInfo="${originalInfo}""result:There is some raid_cards is wrong , include ${error_raid_info}."
        log ERROR "FSA_${checkItemId}:There is some raid_cards is wrong , include ${error_raid_info}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
