#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4357"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    checkRuslt="$(ls -d /opt/dsware/osd/ko/`uname -r`/smio)"
    if [ -z "${checkRuslt}" ]
    then 
        resultCode=1
		errorKey="${checkItemId}0001"   # smio目录被修改
		originalInfo="command:ls -d /opt/dsware/osd/ko/`uname -r`/smio"
        originalInfo="${originalInfo}""review:${checkRuslt}\n"
        originalInfo="${originalInfo}""result:ls -d /opt/dsware/osd/ko/`uname -r`/smio is not exist."
		log ERROR "ls -d /opt/dsware/osd/ko/`uname -r`/smio is not exist."
		log ERROR "${checkItemId}:FSA_4357:unok"
		FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1 
    fi

    originalInfo="${originalInfo}""result:ls -d /opt/dsware/osd/ko/`uname -r`/smio is exist."
    log INFO "FSA_${checkItemId}:ls -d /opt/dsware/osd/ko/`uname -r`/smio is exist."
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001  smio目录被修改
#
##############################