#!/bin/bash	

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4365"
resultCode=0
errorKey=""
params=""
originalInfo=""


###############################################################
#  描述：数据库场景：检查udev规则是否正确
#  错误码：
#  0001 数据库场景：检查udev规则不正确       
#  0002 数据库场景：检查udev规则不正确，存在其他类似规则文件       
#  0003 数据库场景：检查udev规则正确，但存在其他类似规则文件       
#         
##############################################################

# --------------------------------------------------------------------------- #
#                          全局变量
# --------------------------------------------------------------------------- #
# 配置文件
declare ruleFilePath="/etc/udev/rules.d/99-oracle-asmdevices.rules"
declare rulePath="/etc/udev/rules.d/"
declare g_curPath=""
declare g_scriptName=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    local res=$(find ${rulePath} -name "*-oracle-*.rules")	
    if [ -n "$res" ]; then
        local num=$(echo "${res}" | wc -l)
        local result=""
        for ((i=1; i<=${num};i++)); do
            lineinfo=$(echo "${res}" | sed -n "${i}p")
            if [ ${lineinfo} == ${ruleFilePath} ]; then
                local check_info=$(cat ${ruleFilePath} | grep SYMLINK)
            else
                result="${lineinfo}\n$result"
            fi
        done
        # 判断规则文件是否存在，存在才判断检查结果
        if [ -e ${ruleFilePath} ] && [ -z "${check_info}" ]; then
            if [ -z "$result" ]; then
                resultCode=1
                errorKey="${checkItemId}0001"  # 0001 数据库场景：检查udev规则不正确
                originalInfo="${originalInfo}""result:Database scenario: Checking udev rules is incorrect."
                log ERROR "FSA_{$checkItemId}:Database scenario: Checking udev rules is incorrect."
                log ERROR "FSA_{$checkItemId}:unok"
                FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            fi
            resultCode=1
            errorKey="${checkItemId}0002"  # 0002 数据库场景：检查udev规则不正确，存在其他类似规则文件
            originalInfo="${originalInfo}""result:Database scenario: Checking udev rules is incorrect.Existother rules file, as follows: $result"
            log ERROR "FSA_{$checkItemId}:Database scenario: Checking udev rules is incorrect.Existother rules file, as follows: $result"
            log ERROR "FSA_{$checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
        if [ -z "$result" ]; then
            resultCode=0
            originalInfo="${originalInfo}""result:Udev rules are normal."
            log INFO "FSA_${checkItemId}:Udev rules are normal."
            log INFO "FSA_${checkItemId}:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
        resultCode=2
        errorKey="${checkItemId}0003"  # 0003 数据库场景：检查udev规则正确，但存在其他类似规则文件
        originalInfo="${originalInfo}""result:Udev rules are normal,but exist other rule file. as follows: $result"
        log ERROR "FSA_{$checkItemId}:Udev rules are normal,but exist other rule file. as follows: $result"
        log ERROR "FSA_{$checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    resultCode=0
    originalInfo="${originalInfo}""result:Udev rules are normal."
    log INFO "FSA_${checkItemId}:Udev rules are normal."
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
