#!/bin/bash

#############################################################
#
# 名  称：检查VBS/MDC/OSD/dsware_insight/dsware_agent运行依赖的动态库是否正常
# 错误码：
#         0000 正常
#         0001 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个动态库缺失
#         0002 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个动态库文件缺失
#         0003 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个动态库文件缺失，且存在一个或多个的动态库缺失
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4368"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_bin_x_lib()
{
    process_name="$1"
    process_judg=`ps -ef | grep dsware_${process_name} | grep -v grep`
    if [[ -n "${process_judg}" ]]
    then
        if [ ! -f "/opt/dsware/${process_name}/bin/dsware_${process_name}" ]
        then
            process_lld_file_error="${process_lld_file_error}"" ,/opt/dsware/${process_name}/bin/dsware_${process_name}"
            originalInfo="${originalInfo}""result:this node have dsware_${process_name}_process ,but there is no /opt/dsware/${process_name}/bin/dsware_${process_name}.\n"
            log ERROR "FSA_${checkItemId}:this node have dsware_${process_name}_process ,but there is no /opt/dsware/${process_name}/bin/dsware_${process_name}."
            return
        fi

        process_lib_judg=`ldd /opt/dsware/${process_name}/bin/dsware_${process_name} | grep 'not found'`
        originalInfo="${originalInfo}""command:ldd /opt/dsware/${process_name}/bin/dsware_${process_name} | grep 'not found'\n"
        originalInfo="${originalInfo}""review:${process_name}_lib_judg=${process_lib_judg}\n"
        if [[ -n "${process_lib_judg}" ]]
        then
            error_result="${error_result}"" ${process_name}"
            originalInfo="${originalInfo}""result:${process_name}_lld is wrong.\n"
            log ERROR "FSA_${checkItemId}:${process_name}_lld is wrong."
        else
            originalInfo="${originalInfo}""result:${process_name}_lld is right.\n"
            log INFO "FSA_${checkItemId}:${process_name}_lld is right."
        fi
    else
        originalInfo="${originalInfo}""result:this node does not have ${process_name}_process.\n"
    fi
    return
}

function check_tool_dsware_insight()
{
    if [ ! -f "/opt/dsware/agent/tool/dsware_insight" ]
    then
        process_lld_file_error="${process_lld_file_error}"" ,/opt/dsware/agent/tool/dsware_insight"
        originalInfo="${originalInfo}""result:there is no /opt/dsware/agent/tool/dsware_insight.\n"
        log ERROR "FSA_${checkItemId}:there is no /opt/dsware/agent/tool/dsware_insight."
        return
    fi

    insight_lib_judg=`ldd /opt/dsware/agent/tool/dsware_insight | grep 'not found'`
    originalInfo="${originalInfo}""command:ldd /opt/dsware/agent/tool/dsware_insight | grep 'not found'\n"
    originalInfo="${originalInfo}""review:dsware_insight_lib_judg=${insight_lib_judg}\n"
    if [[ -n "${insight_lib_judg}" ]]
    then
        error_result="${error_result}"" dsware_insight"
        originalInfo="${originalInfo}""result:dsware_insight_lld is wrong.\n"
        log ERROR "FSA_${checkItemId}:dsware_insight_lld is wrong."
    else
        originalInfo="${originalInfo}""result:dsware_insight_lld is right.\n"
        log INFO "FSA_${checkItemId}:dsware_insight_lld is right."
    fi
}

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    error_result=""
    process_lld_file_error=""

    check_bin_x_lib vbs
    check_bin_x_lib mdc
    check_bin_x_lib osd
    check_bin_x_lib agent
    check_tool_dsware_insight

    process_lld_file_error=${process_lld_file_error:2}

    if [[ -n "${error_result}" ]] && [[ -z "${process_lld_file_error}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个的动态库缺失
        originalInfo="${originalInfo}""result:${error_result} process's list dynamic dependencies have error."
        log ERROR "FSA_${checkItemId}:${error_result} process's list dynamic dependencies have error."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -z "${error_result}" ]] && [[ -n "${process_lld_file_error}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个动态库文件缺失
        originalInfo="${originalInfo}""result:This node does not find: ${process_lld_file_error}."
        log ERROR "FSA_${checkItemId}:This node does not find: ${process_lld_file_error}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -n "${error_result}" ]] && [[ -n "${process_lld_file_error}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 VBS/MDC/OSD/dsware_agent/dsware_insight 中存在一个或多个动态库文件缺失，且存在一个或多个的动态库缺失
        originalInfo="${originalInfo}""result:This node does not find: ${process_lld_file_error}.\n"
        originalInfo="${originalInfo}""result:${error_result} process's list dynamic dependencies have error."
        log ERROR "FSA_${checkItemId}:This node does not find: ${process_lld_file_error}."
        log ERROR "FSA_${checkItemId}:${error_result} process's list dynamic dependencies have error."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:All of process's list dynamic dependencies is healthy."
        log INFO "FSA_${checkItemId}:All of process's list dynamic dependencies is healthy."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

