#!/bin/bash

#############################################################
#
# 名  称：检查FSA监控是否正常
# 错误码：
#         0000 正常
#         0001 FSA监控不存在
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4408"
resultCode=0
errorKey=""
params=""
originalInfo=""

function isEluerOSV2R9()
{
    local osReleaseFile="/etc/*-release"
    local eulerOsReleaseFile="/etc/euleros-release"
    if [ ! -f ${eulerOsReleaseFile} ]; then
        echo 0
        return 0
    fi
    local sys_version=$(cat $osReleaseFile | grep "VERSION=" | grep "\"2.0 (SP9")
    if [ -z "${sys_version}" ]; then
        echo 0
        return 0
    fi
    echo 1
    return 0
}

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # EulerOS V2R9需要只检查dsware_agent_chk.service
    local is_euler_v2r9=$(isEluerOSV2R9)
    if [ ${is_euler_v2r9} -eq 1 ];then
        systemctl status dsware_agent_chk.service | grep -w activating >/dev/null 2>&1
        local ret=$?
        if [ ${ret} -ne 0 ];then
            log ERROR "there is no process monitor dsware_agent"
            resultCode=1
            errorKey="${checkItemId}0001"
            originalInfo="command:systemctl status dsware_agent_chk.service | grep -w activating\n"
            originalInfo="${originalInfo}""review:`systemctl status dsware_agent_chk.service | grep -w activating`\n"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
        originalInfo="command:systemctl status dsware_agent_chk.service | grep -w activating\n"
        originalInfo="${originalInfo}""review:`systemctl status dsware_agent_chk.service | grep -w activating`\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local cron_task=`crontab -l |grep -w "dswareAgent_crontab_chk.sh" | awk -F " " '{print $7}'`
    local cps_task=`ps -ef|grep "fsa_heart_beat.py"|grep -v grep`
    if [[ -z "$cron_task" ]] && [[ -z "$cps_task" ]]
    then
        log ERROR "there is no process monitor dsware_agent"
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="command:crontab -l |grep -w dswareAgent_crontab_chk.sh | awk -F "" '{print \$7}'\n"
        originalInfo="${originalInfo}""review:${cron_task}\n"
        originalInfo="${originalInfo}""command:ps -ef|grep fsa_heart_beat.py |grep -v grep \n"
        originalInfo="${originalInfo}""review:${cps_task}\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    originalInfo="command:crontab -l |grep -w dswareAgent_crontab_chk.sh \n"
    originalInfo="${originalInfo}""review:${cron_task}\n"
    originalInfo="${originalInfo}""command:ps -ef|grep fsa_heart_beat.py |grep -v grep \n"
    originalInfo="${originalInfo}""review:${cps_task}\n"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

