#!/bin/bash

#############################################################
#
#
# 名  称：检查inter内存管理开关，redhat配置intel_iommu=on会导致网络发包路径上存在大量slab分配。每次分配时，都需要争抢一把锁，导致发包的效率降低
# 错误码：
#         44120000 正常
#         44120001 IOMMU开关开启状态
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4412"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    redhat_os_judg=`cat /etc/*-release | grep -i red | grep -i hat`
    os_judg=$?
    originalInfo="${originalInfo}""command:cat /etc/*-release | grep -i red | grep -i hat\n"
    originalInfo="${originalInfo}""review:\$?=${os_judg}\n"
    version_os_judg=`cat /etc/*-release | grep 6.5`
    version_judg=$?
    originalInfo="${originalInfo}""command:cat /etc/*-release | grep 6.5\n"
    originalInfo="${originalInfo}""review:\$?=${version_judg}\n"

    if [[ -z "${redhat_os_judg}" ]] || [[ -z "${version_os_judg}" ]]
    then
        originalInfo="${originalInfo}""result:this node os is not RedHat 6.5, no need to check."
        log INFO "FSA_${checkItemId}:this node os is not RedHat 6.5, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    result=`cat /boot/grub/menu.lst | grep "intel_iommu=on"`
    if [ $? -eq 0 ]
    then
        originalInfo="${originalInfo}""command:cat /boot/grub/menu.lst | grep intel_iommu=on\n"
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}""review:${result}\n"
        originalInfo="${originalInfo}""result:intel_iommu is on"
        log ERROR "FSA_${checkItemId}:intel_iommu is on."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""command:cat /boot/grub/menu.lst | grep intel_iommu=on\n"
        originalInfo="${originalInfo}""review:${result}\n"
        originalInfo="${originalInfo}""result:intel_iommu is off"
        log INFO "FSA_${checkItemId}:intel_iommu is off."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi


}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

