#!/bin/bash

#############################################################
#
# 名  称：
# 错误码：
#         0000=正常
#         0001=FSA 节点无 OSD 或 VBS 进程
#         0002=内存资源充足，但CPU资源不足
#         0003=CPU资源充足，但内存资源不足
#         0004=CPU资源和内存资源均不足
#         0005=工具扫描期间获取dsware_agent进程的cgroup文件失败，请按照检查标准手工执行验证
#         0006=节点无 /opt/dsware/agent/conf/network.cfg 文件，无法获取网络类型
#         0007=OSD_monitor 数量大于 OSD 进程数量，可能资源分配不足
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4417"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # 判断CPU和内存是否足够的标志位，0为足够
    cpu_enough_judg=0
    memory_enough_judg=0

    agent_process_judg=`ps -ef | grep dsware_agent | grep -v grep`
    if [[ -z "${agent_process_judg}" ]]
    then
        resultCode=2
        errorKey="${checkItemId}0008"  # 0008 巡检此刻未发现dsware_agent进程
        originalInfo="${originalInfo}""result:dsware_agent process is not running at this moment ."
        log ERROR "FSA_${checkItemId}:dsware_agent process is not running at this moment ."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    
    # 获取节点分给agent的资源
    if [ ! -f "/proc/$(pidof dsware_agent)/cgroup" ]
    then
        resultCode=2
        errorKey="${checkItemId}0005"  # 0005 工具扫描期间获取dsware_agent进程的cgroup文件失败，请按照检查标准手工执行验证
        originalInfo="${originalInfo}""result:agent_process does not have cgroup file ."
        log ERROR "FSA_${checkItemId}:agent_process does not have cgroup file."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ! -f "/opt/dsware/agent/conf/network.cfg" ]
    then
        resultCode=2
        errorKey="${checkItemId}0006"  # 0006 节点无 /opt/dsware/agent/conf/network.cfg 文件，无法获取网络类型
        originalInfo="${originalInfo}""result:there is no /opt/dsware/agent/conf/network.cfg file, can not get network_type ."
        log ERROR "FSA_${checkItemId}:there is no /opt/dsware/agent/conf/network.cfg file, can not get network_type ."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    cgroup_check=`cat /proc/$(pidof dsware_agent)/cgroup | grep -iE 'cpuset|memory'`
    originalInfo="${originalInfo}""command:cat /proc/$(pidof dsware_agent)/cgroup | grep -iE 'cpuset|memory'\n"
    originalInfo="${originalInfo}""review:${cgroup_check}\n"
    if [[ -z "${cgroup_check}" ]]
    then
        originalInfo="${originalInfo}""result:agent_cgroup_file is empty, no need to check."
        log INFO "FSA_${checkItemId}:agent_cgroup_file is empty, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    cpu_check_path=`cat /proc/$(pidof dsware_agent)/cgroup | grep cpuset | awk -F ':' '{print$3}'`
    memory_check_path=`cat /proc/$(pidof dsware_agent)/cgroup | grep memory | awk -F ':' '{print$3}'`

    if [[ "${cpu_check_path}"x == "/"x ]] && [[ "${memory_check_path}"x == "/"x ]]
    then
        originalInfo="${originalInfo}""result:cpu_check_path is / and memory_check_path is / , so no need to check."
        log INFO "FSA_${checkItemId}:cpu_check_path is / and memory_check_path is / , so no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    get_os_cpus_list=($(cat /sys/fs/cgroup/cpuset${cpu_check_path}/cpuset.cpus))
    originalInfo="${originalInfo}""command:cat /sys/fs/cgroup/cpuset${cpu_check_path}/cpuset.cpus\n"
    originalInfo="${originalInfo}""review:${get_os_cpus_list}\n"
    get_os_cpus_list=($(cat /sys/fs/cgroup/cpuset${cpu_check_path}/cpuset.cpus | tr ',' ' ' | tr '-' ' '))
    get_os_cpu_total=0
    for ((i=0;i<${#get_os_cpus_list[@]};i=i+2))
    do
        get_os_cpu_tmp=$(awk "BEGIN{print ${get_os_cpus_list[i+1]} - ${get_os_cpus_list[i]} + 1 }")
        get_os_cpu_total=$(awk "BEGIN{print ${get_os_cpu_total} + ${get_os_cpu_tmp} }")
    done
    originalInfo="${originalInfo}""result:this node give ${get_os_cpu_total} vcpu to fusion storage block.\n"
    
    get_os_memory_total=`cat /sys/fs/cgroup/memory${memory_check_path}/memory.limit_in_bytes`
    originalInfo="${originalInfo}""command:cat /sys/fs/cgroup/memory${memory_check_path}/memory.limit_in_bytes\n"
    originalInfo="${originalInfo}""review:${get_os_memory_total}(bytes)\n"

    # 获取VBS和OSD的数量
    get_vbs_total=`cat /opt/dsware/agent/conf/agentMonitor | grep vbs | grep monitor | wc -l`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/agentMonitor | grep vbs | grep monitor | wc -l\n"
    originalInfo="${originalInfo}""review:vbs_monitor_total=${get_vbs_total}\n"
    get_osd_total=`cat /opt/dsware/agent/conf/agentMonitor | grep osd | grep monitor | grep True | wc -l`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/agentMonitor | grep osd | grep monitor | wc -l\n"
    originalInfo="${originalInfo}""review:osd_monitor_total=${get_osd_total}\n"

    get_osd_process_num=`ps -ef | grep ./dsware_osd | grep -v grep | wc -l`
    originalInfo="${originalInfo}""command:ps -ef | grep ./dsware_osd | grep -v grep | wc -l\n"
    originalInfo="${originalInfo}""review:osd_process_num=${get_osd_process_num}\n"
    if [ ${get_osd_total} -gt ${get_osd_process_num} ]
    then
        resultCode=2
        errorKey="${checkItemId}0007"  # 0007 OSD_monitor 数量大于 OSD 进程数量，可能资源分配不足
        originalInfo="${originalInfo}""result:osd_monitor_total=${get_osd_total} is great than osd_process_num=${get_osd_process_num}, The resource maybe not enough on this node."
        log ERROR "FSA_${checkItemId}:osd_monitor_total=${get_osd_total} is great than osd_process_num=${get_osd_process_num}, The resource maybe not enough on this node."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:osd_monitor_total=${get_osd_total} is equal osd_process_num=${get_osd_process_num} .\n"
    fi
    
    # 判断CPU资源是否符合
    if [ ${get_vbs_total} -ne 0 -a ${get_osd_total} -eq 0 ]
    then
        cpu_need_num=$(awk "BEGIN{print ${get_vbs_total} * 4 }")
        originalInfo="${originalInfo}""result:cpu_need_num=${cpu_need_num}\n"
    elif [ ${get_vbs_total} -eq 0 -a ${get_osd_total} -ne 0 ]
    then
        if [ ${get_osd_total} -le 12 ]
        then
            cpu_need_num=6
            originalInfo="${originalInfo}""result:cpu_need_num=${cpu_need_num}\n"
        else
            cpu_need_num=$(awk "BEGIN{print ${get_osd_total} - 12 }")
            cpu_need_num=$(awk "BEGIN{print ${cpu_need_num} * 0.5 + 6 }")
            originalInfo="${originalInfo}""result:cpu_need_num=${cpu_need_num}\n"
        fi
    elif [ ${get_vbs_total} -ne 0 -a ${get_osd_total} -ne 0 ]
    then
        if [ ${get_osd_total} -le 12 ]
        then
            cpu_need_num=$(awk "BEGIN{print ${get_vbs_total} * 4 + 4 }")
            originalInfo="${originalInfo}""result:cpu_need_num=${cpu_need_num}\n"
        else
            cpu_need_num=$(awk "BEGIN{print ${get_osd_total} - 12 }")
            cpu_need_num=$(awk "BEGIN{print ${cpu_need_num} * 0.5 + 4 }")
            cpu_need_num=$(awk "BEGIN{print ${get_vbs_total} * 4 + ${cpu_need_num} }")
            originalInfo="${originalInfo}""result:cpu_need_num=${cpu_need_num}\n"
        fi
    else
        resultCode=2
        errorKey="${checkItemId}0001"  # 0001 FSA 节点无 OSD 或 VBS 进程
        originalInfo="${originalInfo}""result:there is no osd_process or vbs_process on the FSA node."
        log ERROR "FSA_${checkItemId}:there is no osd_process or vbs_process on the FSA node."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ `echo "${cpu_need_num} > ${get_os_cpu_total}" | bc` -eq 1 ]
    then
        cpu_enough_judg=1
        originalInfo="${originalInfo}""result:fusoin storage block not get enough cpu_resource.\n"
        log ERROR "FSA_${checkItemId}:fusoin storage block not get enough cpu_resource."
    else
        cpu_enough_judg=0
        originalInfo="${originalInfo}""result:fusoin storage block get enough cpu_resource.\n"
        log INFO "FSA_${checkItemId}:fusoin storage block get enough cpu_resource."
    fi
    
    if [ ${cpu_enough_judg} -eq 0 -a ${get_os_memory_total} -eq 9223372036854771712 ]
    then
        originalInfo="${originalInfo}""result:fusion storage block get enough cpu_resource and memory_resource."
        log INFO "FSA_${checkItemId}:fusion storage block get enough cpu_resource and memory_resource."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    elif [ ${cpu_enough_judg} -eq 1 -a ${get_os_memory_total} -eq 9223372036854771712 ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"  # 0002 内存资源充足，但CPU资源不足
        originalInfo="${originalInfo}""result:fusion storage block get enough memory_resource, but FSA just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) ."
        log ERROR "FSA_${checkItemId}:fusion storage block get enough memory_resource, but FSA just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) ."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 计算内存所需资源及判断是否充足
    memory_capacity_need=14

    network_type=`cat /opt/dsware/agent/conf/network.cfg |grep -i network_type|awk -F '"' '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/network.cfg |grep -i network_type\n"
    originalInfo="${originalInfo}""review:network_type=${network_type}\n"

    osd_disk_esn=($(ps -ef | grep ./dsware_osd | grep -v grep | awk '{print$10}'))
    originalInfo="${originalInfo}""command:ps -ef | grep ./dsware_osd | grep -v grep | awk '{print\$10}'\n"
    originalInfo="${originalInfo}""review:osd_disk_esn=${osd_disk_esn[@]}\n"
    osd_memory_capacity_need=0
    for ((i=0;i<${#osd_disk_esn[@]};i++))
    do
        osd_disk_capacity=`cat /proc/smio_host | grep ${osd_disk_esn[i]} | awk -F '|' '{print$5}' | egrep -o '[0-9]+'`
        originalInfo="${originalInfo}""command:cat /proc/smio_host | grep ${osd_disk_esn[i]} | awk -F '|' '{print\$5}' | egrep -o '[0-9]+'\n"
        originalInfo="${originalInfo}""review:osd_disk_esn=${osd_disk_esn[i]} , osd_disk_capacity=${osd_disk_capacity}G\n"
        if [ ${osd_disk_capacity} -lt 2048 ]
        then
            osd_memory_capacity_need=$(awk "BEGIN{print ${osd_memory_capacity_need} + 1.5 }")
        elif [ ${osd_disk_capacity} -lt 4096 ]
        then
            osd_memory_capacity_need=$(awk "BEGIN{print ${osd_memory_capacity_need} + 2.25 }")
        elif [ ${osd_disk_capacity} -lt 6144 ]
        then
            osd_memory_capacity_need=$(awk "BEGIN{print ${osd_memory_capacity_need} + 2.63 }")
        elif [ ${osd_disk_capacity} -lt 8192 ]
        then
            osd_memory_capacity_need=$(awk "BEGIN{print ${osd_memory_capacity_need} + 3.01 }")
        else
            osd_memory_capacity_need=$(awk "BEGIN{print ${osd_memory_capacity_need} + 3.39 }")
        fi
    done
    originalInfo="${originalInfo}""result:osd_memory_capacity_need=${osd_memory_capacity_need}G\n"

    if [[ "${network_type}" == "InfiniBand" ]]
    then
        vbs_memory_capacity_need=$(awk "BEGIN{print ${get_vbs_total} * 9.3 }")
    else
        vbs_memory_capacity_need=$(awk "BEGIN{print ${get_vbs_total} * 5.7 }")
    fi
    originalInfo="${originalInfo}""result:vbs_memory_capacity_need=${vbs_memory_capacity_need}G\n"
    
    cache_capacity_list=($(cat /proc/smio_host | grep -iE 'ssd|nvme' |awk -F '|' '{print$5}' | egrep -o '[0-9]+'))
    originalInfo="${originalInfo}""command:cat /proc/smio_host | grep -iE 'ssd|nvme' |awk -F '|' '{print\$5}' | egrep -o '[0-9]+'\n"
    originalInfo="${originalInfo}""review:cache_capacity_list=${cache_capacity_list[@]}G\n"
    cache_capacity_total=0
    for ((i=0;i<${#cache_capacity_list[@]};i++))
    do
        cache_capacity_total=$(awk "BEGIN{print ${cache_capacity_total} + ${cache_capacity_list[i]} }")
    done
    cache_memory_capacity_need=$(awk "BEGIN{print ${cache_capacity_total} / 128 }")
    originalInfo="${originalInfo}""result:cache_memory_capacity_need=${cache_memory_capacity_need}G\n"

    if [ ${get_osd_total} -ne 0 ]
    then
        memory_capacity_need=$(awk "BEGIN{print ${memory_capacity_need} + ${vbs_memory_capacity_need} + ${osd_memory_capacity_need} + ${cache_memory_capacity_need} }")
        originalInfo="${originalInfo}""result:memory_capacity_need=${memory_capacity_need}G\n"
    else
        memory_capacity_need=${vbs_memory_capacity_need}
        originalInfo="${originalInfo}""result:memory_capacity_need=${memory_capacity_need}G\n"
    fi
    memory_capacity_need=`echo ${memory_capacity_need} | awk -F '.' '{print$1}'`
    memory_capacity_need=$(awk "BEGIN{print ${memory_capacity_need} + 1 }")
    memory_capacity_need=$(awk "BEGIN{print ${memory_capacity_need} * 1024 * 1024 * 1024 }")

    if [ `echo "${memory_capacity_need} > ${get_os_memory_total}" | bc` -eq 1 ]
    then
        memory_enough_judg=1
        originalInfo="${originalInfo}""result:fusoin storage block not get enough memory_resource.\n"
        log ERROR "FSA_${checkItemId}:fusoin storage block not get enough memory_resource."
    else
        memory_enough_judg=0
        originalInfo="${originalInfo}""result:fusoin storage block get enough memory_resource.\n"
        log INFO "FSA_${checkItemId}:fusoin storage block get enough memory_resource."
    fi

    # 汇总判断
    if [ ${cpu_enough_judg} -eq 0 -a ${memory_enough_judg} -eq 0 ]
    then
        originalInfo="${originalInfo}""result:fusion storage block get enough cpu_resource and memory_resource."
        log INFO "FSA_${checkItemId}:fusion storage block get enough cpu_resource and memory_resource."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    elif [ ${cpu_enough_judg} -eq 1 -a ${memory_enough_judg} -eq 0 ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"  # 0002 内存资源充足，但CPU资源不足
        originalInfo="${originalInfo}""result:fusion storage block get enough memory_resource, but FSA just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) ."
        log ERROR "FSA_${checkItemId}:fusion storage block get enough memory_resource, but FSA just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) ."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [ ${cpu_enough_judg} -eq 0 -a ${memory_enough_judg} -eq 1 ]
    then
        resultCode=2
        errorKey="${checkItemId}0003"  # 0003 CPU资源充足，但内存资源不足
        originalInfo="${originalInfo}""result:fusion storage block get enough cpu_resource, but FSA just get memory_resource(${get_os_memory_total}B) is less than need_memory_resource(${memory_capacity_need}B)."
        log ERROR "FSA_${checkItemId}:fusion storage block get enough cpu_resource, but FSA just get memory_resource(${get_os_memory_total}B) is less than need_memory_resource(${memory_capacity_need}B)."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=2
        errorKey="${checkItemId}0004"  # 0004 CPU资源和内存资源均不足
        originalInfo="${originalInfo}""result:fusion storage block just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) and memory_resource(${get_os_memory_total}B) is less than need_memory_resource(${memory_capacity_need}B)."
        log ERROR "FSA_${checkItemId}:fusion storage block just get ${get_os_cpu_total} vcpus is less than need_vcpu_resource(${cpu_need_num}) and memory_resource(${get_os_memory_total}B) is less than need_memory_resource(${memory_capacity_need}B)."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
