#!/bin/bash

#############################################################
#
# 名  称：检查VBS进程是否正常提供服务
# 错误码：
#         0000 正常
#         0001 当前mdc节点信息不完整
#         0002 当前6.3集群，存在虚拟机和VBS元数据同时异常风险
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4419"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    mdc_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep -i mdc | grep -i monitor | grep -i True`
    if [[ -z "${mdc_judg}" ]]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:this is not mdc node, no need to check."
        log INFO "FSA_${checkItemId}:this is not mdc node, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    product_version=`cat /opt/dsware/DSwareAgentNodeVersion | grep -i version | awk -F '=' '{print$2}'`
    if [[ ! "${product_version}" =~ "V100R006C30" ]]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:NodeVersion is not 6.3, this item is not applicable."
        log INFO "FSA_${checkItemId}:NodeVersion is not 6.3, this item is not applicable."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    mdc_id=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_id|awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""mdc_id=${mdc_id}\n"
    mdc_ip=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_ip|awk -F '=' '{print $2}' |awk -F '@' '{print $1}'`
    originalInfo="${originalInfo}""mdc_ip=${mdc_ip}\n"
    mdc_port=`cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep mdc_port|awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""mdc_port=${mdc_port}\n"

    if [[ -z "${mdc_id}" ]] || [[ -z "${mdc_ip}" ]] || [[ -z "${mdc_port}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 当前mdc节点信息不完整
        originalInfo="${originalInfo}""result:mdc_info is not complete(info from /opt/dsware/mdc/conf/mdc_conf.cfg).\n"
        log ERROR "FSA_${checkItemId}:mdc_info is not complete."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    pool_list=($(/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 165 -1 | grep -v POOL_ID | awk -F '|' '{print $2}' | awk '{print $2}'))
    originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 165 -1 | grep -v POOL_ID | awk -F '|' '{print \$2}' | awk '{print \$2}'\n"
    originalInfo="${originalInfo}""review:pool_list=${pool_list}\n"

    if [ ${#pool_list[@]} -lt 3 ]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:total_pool_number is less than 3, no need to check."
        log INFO "FSA_${checkItemId}:total_pool_number is less than 3, no need to check."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    error_pool_id=""
    for pool_id in ${pool_list[@]}
    do
        originalInfo="${originalInfo}""pool_id=${pool_id}\n"
        echo -e "Yes\n" | /opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 136 ${pool_id} -33 2146435072 512 0 0 tmp /home 1
        originalInfo="${originalInfo}""command:/opt/dsware/agent/tool/dsware_insight 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 136 ${pool_id} -33 2146435072 512 0 0 tmp /home 1\n"
        result_file_name=`ls /home | grep -i version | grep tmp --color=never`
        if [ -f "/home/${result_file_name}" ]
        then
            meta_ver_value=`cat /home/${result_file_name} | grep -w meta_ver | awk -F '=' '{print$2}'`
            originalInfo="${originalInfo}""command:cat /home/${result_file_name} | grep -w meta_ver | awk -F '=' '{print\$2}'\n"
            originalInfo="${originalInfo}""meta_ver=${meta_ver_value}\n"
            if [ ${meta_ver_value} -lt 21 ]
            then
                error_pool_id="${error_pool_id} ${pool_id}"
                originalInfo="${originalInfo}""result:pool_id=${pool_id} is abnormal."
                log ERROR "FSA_${checkItemId}:pool_id=${pool_id} is abnormal."
            fi
        else
            originalInfo="${originalInfo}""result:this pool do not output version meta_ver file.\n"
            continue
        fi
    done

    if [[ -z "${error_pool_id}" ]]
    then
        resultCode=0
        originalInfo="${originalInfo}""result:this check is passed."
        log INFO "FSA_${checkItemId}:this check is passed."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 存在虚拟机和VBS元数据同时异常风险
        originalInfo="${originalInfo}""result:there must have a pool that has risk, error_pool_id=${error_pool_id}\n"
        log ERROR "FSA_${checkItemId}:there must have a pool that has risk, error_pool_id=${error_pool_id}."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi


}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
