#!/bin/bash

#############################################################
#
# 名  称：xen虚拟化场景日志转储系统配置检查
# 错误码：
#         0000 正常
#         0001 日志转储配置规则不存在
#         0002 系统配置文件不存在
#
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4420"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # 场景检查
    # 非xen虚拟化场景，日志转储由agent进程管理控制。
    local isXen=$(uname -r |grep -i "xen")
    if [ -z "${isXen}" ]
    then
        modify_result 0 "" "xen uvp is not exsit,not need check log dumping rules"
        return 0
    fi

    # 系统文件存在性检查
    sys_conf_file="/etc/usb_sysconfig.conf"
    if [ ! -f "$sys_conf_file" ]; then
        modify_result 1 "${checkItemId}0002" "sys config file($sys_conf_file) not exist"
        return 1
    fi

    # audit log  日志转储规则检查
    check_audit_log_res=$(cat "$sys_conf_file" |grep -F "/var/log/dsware/audit_log::*log?*")
    if [ -z "$check_audit_log_res" ]; then
        modify_result 1 "${checkItemId}0001" "audit_log has not config log dumping rules"
        return 1
    fi
    # 检查ok，无问题
    modify_result 0 "" "log dumping rules check success."
    return 0
}

function modify_result(){

      resultCode=$1
      errorKey=$2
      msg=$3
      local result=""
      [ $resultCode -eq 0 ] && { result="ok"; } || { result="unok";}
      originalInfo="${originalInfo}""result:${msg}"
      log INFO "FSA_${checkItemId}:${msg}"
      log INFO "$result"
      FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
