#!/bin/bash

#############################################################
#
# 名  称：检查raid卡是否在位
# 错误码：
#         0001 EID不对等
#         0002 raid卡命令不存在
#############################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="4422"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
storcli_cmd="/opt/MegaRAID/storcli/storcli64"
perccli64="/opt/MegaRAID/perccli/perccli64"
query_cli="${storcli_cmd}"

##############################################################
## 检查是否为存储节点
##############################################################
function checkStorageNode()
{
    # 监控文件不存在
    if [ ! -f ${agentMonitorFile} ]
    then
        return 1
    fi
    
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep osd |grep -v alarm | grep -E "True" | wc -l)
    if [ "${CNT_MONITOR}" == "0" ]
    then
        # 当前节点没有OSD
        return 1
    fi
    
    return 0
}

function check_disk_info_in_jbod_mod()
{
    local __raid_adapter_id=$1
    device_id=`${query_cli} /c${__raid_adapter_id} show | grep "JBOD" | grep -v "JBOD LIST\|JBOD Drives\|JBOD Target ID" | column -t | sort -u| grep JBOD | awk -F ":" '{print $1}' | head -1`
    if [ -z "${device_id}" ]; then
        log INFO "raid${__raid_adapter_id} not have JBOD info."
        originalInfo="${originalInfo},""raid${__raid_adapter_id} not have JBOD info"
        return 0
    fi
    
    is_eid_ok=`${query_cli} /c${__raid_adapter_id} /eall show | grep OK | awk -F " " '{print $1}' | grep ${device_id}`
    if [ "x${is_eid_ok}" == "x" ]
    then
         log ERROR "raid${__raid_adapter_id}'s EID ${device_id} JBOD INFO is NOT OK."
         originalInfo="raid${__raid_adapter_id}'s EID ${device_id} JBOD INFO is NOT OK."
         errorKey="${checkItemId}0001"
         return 1
    fi
    return 0
}

function check_disk_info_in_raid_mod()
{
    local __raid_adapter_id=$1
    
    device_id=`$query_cli  /c${__raid_adapter_id} /v1 show all | grep "Onln" |head -1 | awk '{print $1}' | awk -F ":" '{print $1}' | sed 's/ //g'`
    if [ -z "${device_id}" ]; then
        log INFO "raid${__raid_adapter_id} not have RAID0 info."
        originalInfo="${originalInfo},""raid${__raid_adapter_id} not have RAID0 info"
        return 0
    fi
    
    is_eid_ok=`${query_cli} /c${__raid_adapter_id} /eall show | grep OK | awk -F " " '{print $1}' | grep ${device_id}`
    if [ "x${is_eid_ok}" == "x" ]
    then
         log ERROR "raid${__raid_adapter_id}'s EID ${device_id} RAID0 INFO is NOT OK."
         originalInfo="raid${__raid_adapter_id}'s EID ${device_id} RAID0 INFO is NOT OK."
         errorKey="${checkItemId}0001"
         return 1
    fi
    return 0
}

function checkDiskInfo()
{
    is_megaraid=`lspci |grep  LSI |grep MegaRAID`
    if [ "x${is_megaraid}" == "x" ];then
        log INFO "INFO is not MegaRAID OK."
        originalInfo="INFO is not MegaRAID OK."
        return 0
    fi
    if [ ! -f ${storcli_cmd} ];then
        if [ -f ${perccli64} ];then
            query_cli="sudo ${perccli64}"
        else
            log ERROR "ERR: Can't Find ${query_cli} command."
            originalInfo="Can't Find ${query_cli} command."
            errorKey="${checkItemId}0002"
            return 1
        fi
    fi
    
    local __host_list=`$query_cli /call show | grep "^Controller" | grep -v "Time" | awk -F "=" '{print $2}' | sed 's/\s//g'`
    if [ "x${__host_list}" == "x" ];then
        log INFO "no MegaRaid card"
        originalInfo="no MegaRaid card"
        return 0
    fi
    
    for __host_no in ${__host_list}
    do
        # 判断是否主存
        local have_raid=`${query_cli} /c${__host_no} show | grep -iwE 'JBOD|RAID0' | wc -l`
        if [ ${have_raid} -eq 0 ];then
            continue
        fi
        
        local __is_jbod_enable=`$query_cli /c${__host_no} show jbod | grep -i jbod | grep -i -w "on"`
        if [ "x${__is_jbod_enable}" != "x" ];then
            check_disk_info_in_jbod_mod "${__host_no}"
            ret=$?
            if [ ${ret} -ne 0 ];then
                return 1
            fi
        else
            check_disk_info_in_raid_mod "${__host_no}"
            ret=$?
            if [ ${ret} -ne 0 ];then
                return 1
            fi
        fi
    done

    log INFO "EID ${device_id} is OK."
    originalInfo=${originalInfo}", EID ${device_id} is OK."
    return 0
}

main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi
    
    checkStorageNode
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        originalInfo="No osd is_mornitor=True in ${agentMonitorFile}. No need to check disk info."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    checkDiskInfo
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        resultCode=1
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 EID不对等
#  0002 raid卡命令不存在
#
##############################