#!/bin/bash

#############################################################
#
# 名  称：检查ES3000 V5寿命
# 错误码：
#  0001 #  0001 升级华为V5盘FW版本到3257及之后.
#############################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="4431"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
NET_FILTER_CFG_PATH="/proc/sys/net/netfilter/"

CODE_WHITELIST="
03032YHR
03033AUN
03033CQQ
03033FKM
03034AUT
03034AUU
03033FJB
03033FKF
03032WFN
03033BCW
03033FWL
03032WFM
03033FBL
03033GTB
03033JPV
03033JTC
03033QGV
03033QGW
03033QGY
03032VUA
03033FWK
03032WGK
03033AAX
03032YRE
03033BPF
03033GJS
03033BDA
03033FKJ
03033RXK
03033GSK
03033QRJ
03032WET
03033AXP
03032VUL
03032WEJ
03032WEP
03032YWH
03033AUP
03033CQU
03033CQV
03033GDP
03032WFG
03032VUM
03032WEK
03032WEQ
03032WFB
03033CWY
03033LBA
03032WFA
03032WFF
03032YHV
03033FJH
03033FKH
03033FJK
03033FKL
03033FKN
03033BGA
03033FAM
03033BGB
03033FAW
"

FW_WHITELIST="
1009
1010
1011
1012
1022
1025
1026
1027
1030
1031
1033
1035
1036
1037
1038
2130
2131
2150
2151
2152
2153
2155
2156
2158
2252
3216
3220
3221
3222
3230
3231
3232
3233
3234
3235
3241
3242
3243
3245
3246
3247
3248
3252
3253
3255
"

##############################################################
## 检查是否为存储节点
## 返回值：0 存在节点，1 不是存储节点
##############################################################
function checkOSDNode()
{
    # 监控文件不存在
    if [ ! -f ${agentMonitorFile} ]
    then
        return 1
    fi
    # 检查是否有OSD监控
    local osd_judg=`cat ${agentMonitorFile} | grep osd | grep monitor | grep True | wc -l`
    if [ ${osd_judg} -eq 0 ]
    then
        return 1
    fi

    return 0
}

main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # 检查是否为风险节点版本
    local nodePath="/opt/dsware/DSwareAgentNodeVersion"
    local nodeVersion=`cat $nodePath | grep "nodeVersion" | awk -F'=' '{print $2}' | sed -e 's/[ ]//g' | grep -E 'V100R006'`
    if [ -z "$nodeVersion" ];then
        originalInfo="NodeVersion is not risk, no need to check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # 检查是否为存储节点
    checkOSDNode
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        originalInfo="Not storage node, no need check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local diskInfo=`cat /proc/smio_host | grep -E "HSSD-D6|HWE5"`
    if [ -z "$diskInfo" ];then
        originalInfo="This node does not have a ES3000/HSSD V5 disk. No need check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    while read line
    do
        local sn=`echo $line | awk -F"|" '{print $7}' | sed -e 's/[ ]//g'`
        local fw=`echo $line | awk -F"|" '{print $8}' | awk -F"," '{print $3}' | sed -e 's/[ ]//g' | grep '^[0-9]\{4\}'`
        local isRiskFw=`grep "$fw" <<< "$FW_WHITELIST"`
        if [ -z "$fw" ] || [ -z "$isRiskFw" ];then
            log INFO "Disk sn:${sn},  fw version is higher than 3255, no need check."
            continue
        fi
        
        local isRisk0303=$(awk '$1=="03'${sn:0:6}'" {printf("%s", $1)}' <<< "$CODE_WHITELIST")
        if [ -z "$isRisk0303" ];then
            log INFO "Disk sn:${sn}, not exist risk , no need check."
            continue
        fi

        resultCode=1
        originalInfo="${originalInfo}Disk sn:${sn} fw:${fw} exist risk. The 2024 storage product rectification notice (OceanStor Pacific series/FusionStorage block storage product problem 2) is involved. suggestions upgrade disk to 3257 or latter.\n"
        log ERROR "Disk sn:${sn} fw:${fw} exist risk. The 2024 storage product rectification notice (OceanStor Pacific series/FusionStorage block storage product problem 2) is involved. suggestions upgrade disk to 3257 or latter." ${FUNCNAME} ${SCRIPT_NAME} # 报不通过
    done <<< "$diskInfo"

    if [[ $resultCode -eq 0 ]];then
        originalInfo="This node has no risk."
    else
        errorKey="${checkItemId}000$resultCode"
    fi

    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return $resultCode
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 es3000 V5硬盘存在寿命风险.
##############################