#!/bin/bash

########################################################################################
# 描述：检查节点网络bond配置
#  错误码：
#         0000 正常
#         0001 异常
########################################################################################
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
LOG_FILE="/var/log/dsware/fusionstorage_inspect.log"

source "${UPG_LIB_PATH}/func.sh" >> ${LOG_FILE} 2>&1 || { echo "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { log ERROR "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }

declare -r checkItemId="4432"
resultCode=0
errorKey=""
params=""
originalInfo=""
bond_path="/proc/net/bonding/"
active_bond_status="up"
err_bond_polling_interval="0"

# 1.是否做linux系统类型检测

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
      log INFO "${checkItemId} do not select, pass"
      originalInfo='do not select, pass'
      FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
      return 0
    fi

    if [ ! -d "${bond_path}" ]
    then
        originalInfo='The OS type of the node is not within the check range, skip.'
        log INFO "FSA_${checkItemId}:The OS type of the node is not within the check range, skip"
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    for file in "${bond_path}"*
    do
      bond_status=$(grep "MII Status" "${file}"| head -1 | awk '{print $NF}')
      bond_polling_interval=$(grep "MII Polling Interval" "${file}" | head -1 |  awk '{print $NF}')
      if [ "x${bond_status}" != "x${active_bond_status}" ]
      then
          continue
      fi
      if [ "x${bond_polling_interval}" == "x${err_bond_polling_interval}" ]
      then
          resultCode=1
          errorKey="${checkItemId}0001"  # 0001 还没写
          originalInfo="command:cat /proc/net/bonding/* | grep 'MII Polling Interval' |  awk '{print \$NF}'\n"
          originalInfo="${originalInfo}""review:MII Polling Interval(ms): ${bond_polling_interval}\n"
          originalInfo="${originalInfo}""result:The bond configuration of the node is abnormal. PATH: ${file}"
          log INFO "FSA_${checkItemId}:The bond configuration of the node is abnormal.PATH: ${file}"
          log INFO "FSA_${checkItemId}:unok"
          FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
          return $resultCode
      fi
    done

    if [ "x${bond_polling_interval}" == "x" ]
    then
        originalInfo='No bonding information needs to be checked, skip.'
        log INFO "FSA_${checkItemId}:No bonding information needs to be checked, skip."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    originalInfo="command:cat /proc/net/bonding/* | grep 'MII Polling Interval' |  awk '{print \$NF}'\n"
    originalInfo="${originalInfo}""review:MII Polling Interval(ms): ${bond_polling_interval}\n"
    originalInfo="${originalInfo}""result:The bond configuration of the node is normal."
    log INFO "FSA_${checkItemId}:The bond configuration of the node is normal"
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0


}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}