#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

# common source
SMIO=/proc/smio_host
TMPFILE=/tmp/iostat`date +%s`.txt
ADISK_THRESHOLD=80
ADISK_EXCLUDE=10
TOTAL_THRESHOLD=60

# FSA节点检查数据
nodeIp=""
storageIp=""
poolId=""
nodeType=""

osdNum=""
vbsNum=""
zkNum=""
mdcNum=""

osVer=""
kernelVer=""

totalMemory=""
freeMemory=""
vbsUsedLimitMemory=""
totalCpuNum=""
cpuUsage=""
vbsUsedCPUs=""
deficiencyMod=""
cloneVolNum=""
nicName=""
networkType=""
nicSpeed=""
bondMode=""
nicUtil=""
# 网卡型号待收集
nicModel=""
nicFirmwareVer=""
nicOFEDVer=""

diskUtil=""

volumeNum=""
isIscsiOpen=""
expansionPortUsed=""


# 日志文件最大100MB
LOG_MAX_SIZE_MB=100

# 检查日志大小，如果超过100MB，则返回1
function check_log_size() {
    log_file=$1
    [[ ! -f ${log_file} ]] && return 0
    log_size=$(du -m ${log_file} | awk '{print $1}')
    if [ ${log_size} -gt ${LOG_MAX_SIZE_MB} ]; then
        log ERROR "FSA_${checkItemId}:${log_file} (${log_size}MB) is larger than ${LOG_MAX_SIZE_MB}MB."
        return 1
    fi
    return 0
}

function get_nodeIp()
{
    local updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
    nodeIp=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}')
}

function get_pool_id()
{
    poolId=$(ls /opt/dsware/osd/conf/osd_*_conf.cfg | awk -F '_' '{printf $2}')
    if [ -z "${poolId}" ];then
        poolId="NA"
    fi
}

#关键进程名称及数量
function get_process()
{
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    vbsNum=`cat $agentMonitor | grep -i vbs|grep is_monitor | grep -w "True" | wc -l`
    osdNum=`cat $agentMonitor | grep -i osd|grep is_monitor | grep -w "True" | wc -l`
    mdcNum=`cat $agentMonitor | grep -i mdc|grep is_monitor | grep -w "True" | wc -l`
    zkNum=`cat $agentMonitor | grep -i zk|grep is_monitor | grep -w "True" | wc -l`
    log INFO "vbsNum=${nodeType};osdNum=${osdNum};mdcNum=${mdcNum};zkNum=${zkNum}"

    if [ $vbsNum -ne 0 ] && [ $osdNum -eq 0 ] && [ $mdcNum -eq 0 ] && [ $zkNum -eq 0 ]
    then
        #Only VBS node
        nodeType="compute"
    elif [ $vbsNum -eq 0 ] && [ $osdNum -ne 0 ]
    then
        #Only OSD node
        nodeType="storage"
    elif [ $vbsNum -ne 0 ] && [ $osdNum -ne 0 ]
    then
        #Both VBS and OSD node
        nodeType="converged"
    else
        nodeType="NA" 
    fi
    log INFO "nodeType=${nodeType}"
}

function get_OSInfo()
{
    osVer="$(cat /etc/*-release | grep -E 'release|Server' | head -n 1 | awk -F'"' '{if (NF>1) print $2; else print $1}')"
    kernelVer="$(uname -r)"
}

#节点的内存及CPU
function get_mem_and_cpu_Info()
{
    local dsware_pid=$(pidof dsware_agent | head -1)

    # 总内存
    local totalMemory_k=$(cat /proc/meminfo | grep -w MemTotal | awk '{print $2}');
    totalMemory=$(echo "scale=2;${totalMemory_k}/1024/1024" | bc)
    log INFO "totalMemory=${totalMemory}G"

    #剩余内存
    local freeMemory_k=$(cat /proc/meminfo|awk 'BEGIN{memfree=0}{if($1~"MemFree"||$1~"Buffers"||$1~"Cached"){memfree+=$2}}END{print memfree}');
    freeMemory=$(echo "scale=2;${freeMemory_k}/1024/1024" | bc)
    log INFO "freeMemory=${freeMemory}G"

    vbsUsedLimitMemory=0;
    local VBSMemUsage=($(ps aux|grep dsware_vbs | grep -v grep | awk '{print $4}'))
    for((i=0;i<${#VBSMemUsage[@]};i++))
    do
        vbsUsedLimitMemory=$(echo "scale=2; ${vbsUsedLimitMemory} + ${totalMemory} * ${VBSMemUsage[$i]} / 100" | bc)
    done

    # 节点总CPU数
    totalCpuNum=$(lscpu | grep "CPU(s):" | grep -v "node" | head -1 | awk '{print $2}')
    log INFO "totalCpuNum=${totalCpuNum}"

    # 节点CPU使用率
    omm_agent_log="/var/log/omm/oma/omm_agent.log"
    check_log_size ${omm_agent_log}
    if [ $? -ne 0 ]
    then
        cpuUsage=-1.00
        log ERROR "cpuUsage=${cpuUsage}"
    else
        local used_cpu=$(grep vm_cpu_usage ${omm_agent_log} | head -1 | awk -F[:,] '{print $9}')
        cpuUsage=$(echo "scale=2; ${used_cpu} / ${totalCpuNum} * 100" | bc)
        log INFO "cpuUsage=${cpuUsage}"
    fi

    vbsUsedCPUs=0;
    local VBSCPUUsage=($(ps aux|grep dsware_vbs | grep -v grep | awk '{print $4}'))
    for((i=0;i<${#VBSCPUUsage[@]};i++))
    do
        vbsUsedCPUs=$(echo "scale=2; ${vbsUsedCPUs} + ${totalCpuNum} * ${VBSCPUUsage[$i]} / 100" | bc)
    done
    # 四舍五入
    vbsUsedCPUs=$(printf "%.0f\n" ${vbsUsedCPUs})
}

# 网口信息获取
function get_nic_info()
{
    local tmpNic=""
    local nicInfoItem=""
    local nicValue=""
    local index=""
    local nicLoad=""
    local network_cfg=""
    local tmp_flag=""
    local bond_name=""
    local nicDevName=""

    #网络类型 IB/Roce/tcp
    networkType="$(cat /opt/dsware/agent/conf/network.cfg | grep network_type | awk -F'"' '{print $2}')"
    log INFO "networkType=${networkType}"

    #存储IP
    log INFO "dirname1=`pwd`"
    cd /opt/dsware/agent/script/
    log INFO "dirname2=`pwd`"
    inquiry_disk="/opt/dsware/agent/script/inquiry_disk.sh"
    local storage_ip_and_type="$(sh ${inquiry_disk} inquiry_disk get_storage_ip_and_type)"
    cd -
    log INFO "dirname3=`pwd`"
    storageIp="$(echo ${storage_ip_and_type} | awk -F '=' '{print $1}')"
    log INFO "storageIp=${storageIp}"

    # bond模式
    bondMode="$(echo ${storage_ip_and_type} | awk -F '=' '{print $2}')"
    if [ ${bondMode} -eq 1 ]
    then
        bondMode="active-backup"
    elif [ ${bondMode} -eq 0 ]
    then
        bondMode="balance-rr"
    else
        bondMode="NA"
    fi
    log INFO "bondMode=${bondMode}"

    local storage_ip_and_dev_name="$(sh ${inquiry_disk} inquiry_disk get_storage_ip_and_dev_name)"
    #网卡名称
    nicName=$(echo ${storage_ip_and_dev_name} | awk -F '=' '{print $1}')
    log INFO "nicName=${nicName}"

    nicDevName="${nicName}"

    #网卡负载,网卡速率
    nicUtilRes="$(cat /var/log/dsware/tmp_net_stat.log | awk -F ';' '{print $1}')"
    if [ ${nicUtilRes} -ne 0 ]
    then
        nicUtil="NA"
        nicSpeed=0
    else
        local nicInfo="$(cat /var/log/dsware/tmp_net_stat.log | awk -F ';' '{print $2}')"
        IFS='@' read -ra nicInfoItem <<< "$nicInfo"
        
        # 没组bond直接输出当前网卡的速率，组bond后输出主网口速率
        if [ ${bondMode} == "NA" ]
        then
            # 没组bond，直接输出当前网卡速率
            nicDevName="${nicName}"
        else
            # 组bond，检查主网口负载及速率，如果是vlan需要找到vlan的bond的主网口
            bond_name="${nicName}"
            if [ -d "/etc/sysconfig/network" ]; then
                network_cfg="/etc/sysconfig/network/"
            elif [ -d "/etc/sysconfig/network-scripts" ]; then
                network_cfg="/etc/sysconfig/network-scripts/"
            fi
            tmp_flag=$(cat /etc/sysconfig/network-scripts/ifcfg-${nicDevName} | grep -i "VLAN=yes")
            if [ -n "${tmp_flag}" ]
            then
                # vlan，需要查找bond名称
                bond_name=$(cat /etc/sysconfig/network-scripts/ifcfg-${nicDevName} | grep -i PHYSDEV | awk -F '=' '{print $2}')
            fi

            nicDevName=$(cat /sys/class/net/${bond_name}/bonding/active_slave)
        fi

        # 找到对应的网卡，解析速率和负载(如果没有网卡，则使用速率最大的网卡，错杀一百不放过一个)
        local gusDevName=""
        local gusNicSpeed=0
        local tmpgusNicLoad=0
        local gusNicLoad=0
        local gusNicUtil=0
        for((i=0;i<${#nicInfoItem[@]};i++))
        do
            # 网口名称
            nicValue=$(echo "${nicInfoItem[i]}" | awk -F '=' '{print $2}')
            
            # 找最大的速率
            index=$(expr $i + 1)
            tmpgusNicLoad=$(echo "${nicInfoItem[index]}" | awk -F '=' '{print $2}')
            if [ ${tmpgusNicLoad} -ge ${gusNicLoad} ]
            then
                gusNicLoad=$(echo "${nicInfoItem[index]}" | awk -F '=' '{print $2}')
                index=$(expr $i + 2)
                gusNicSpeed=$(echo "${nicInfoItem[index]}" | awk -F '=' '{print $2}')
                gusDevName=$(echo "${nicInfoItem[i]}" | awk -F '=' '{print $2}')
                gusNicUtil=$(echo "scale=2;${gusNicLoad}/${gusNicSpeed}*100" | bc)
            fi
            
            if [ "$nicValue" == "${nicDevName}" ]
            then
                index=$(expr $i + 2)
                nicSpeed=$(echo "${nicInfoItem[index]}" | awk -F '=' '{print $2}')
                index=$(expr $i + 1)
                nicLoad=$(echo "${nicInfoItem[index]}" | awk -F '=' '{print $2}')
                nicUtil=$(echo "scale=2;${nicLoad}/${nicSpeed}*100" | bc)
                break
            fi
            # 每次跳两格
            i=$(expr $i + 2)
        done
        # 如果没有找到，则使用最大的速率
        if [ -z "${nicSpeed}" ]
        then
            nicSpeed=${gusNicSpeed}
            nicUtil=${gusNicUtil}
            nicDevName=${gusDevName}
        fi
    fi
    log INFO "nicSpeed=${nicSpeed}"
    log INFO "nicUtil=${nicUtil}"

    #网卡类型
    nicModel=$(lspci |grep -i Ethernet | awk -F ': +' '{print $2}' | sort | uniq | tr '\n' ';' | sed s'/.$//')

    # 网卡固件版本和驱动版本
    nicFirmwareVer=$(ethtool -i $nicDevName | grep 'firmware-version' | awk -F ':' '{print $2}')
    nicOFEDVer=$(ethtool -i $nicDevName | grep -E 'driver|version' | grep -C 1 'driver' | awk -F ': +' '{print $2}' | tr '\n' ':' | sed s'/.$//')

    if [ -z "${nicFirmwareVer}" ];then
        nicFirmwareVer="--"
    fi
    if [ -z "${nicOFEDVer}" ];then
        nicOFEDVer="--"
    fi
    log INFO "nicFirmwareVer=${nicFirmwareVer}"
    log INFO "nicOFEDVer=${nicOFEDVer}"
}

function get_cloneVolNum()
{
    cloneVolNum=0
    DIRuner="/opt/dsware/vbs/script/vbs/vbs_cmd.sh"
    if [ ! -f "${DIRuner}" ]
    then
        DIRuner="/opt/dsware/agent/tool/dsware_insight"
        if [ ! -f "${DIRuner}" ]
        then
            return 0
        else
            existCmd=0
        fi
    else
        existCmd=1    
    fi

    vbs_conf="/opt/dsware/vbs/conf/vbs_*conf*.cfg";
    vbs_node_type=2;
    vbs_dest_id=$(cat $vbs_conf|grep vbs_url|awk -F'=' '{printf $2}'|awk -F':' '{printf $1}');
    vbs_dest_ip=$(cat $vbs_conf|grep vbs_ip_2|awk -F'=' '{printf $2}'|awk -F'@' '{printf $1}');
    vbs_dest_port=10901;
    # 查询是否是主VBS
    if [ 1 -eq $existCmd ]
    then
        vbsInfo=$("${DIRuner}" 14 403 | grep MASTER)
    else
        vbsInfo=$("${DIRuner}" "${vbs_node_type}" "${vbs_dest_id}" "${vbs_dest_ip}" "${vbs_dest_port}" 14 403 | grep MASTER)
    fi
    if [ ! -n "${vbsInfo}" ]
    then
        return 0
    fi
    
    judgeEmpty=0
    # 父快照与子卷可能不在同一页
    remainTreeId=-1


    for((i=1024;i<9216;i++))
    do
        if [ 1 -eq $existCmd ]
        then
            metaInfo=$("${DIRuner}" 14 1490 -35 $i | grep 'VOLUME')
        else
            metaInfo=$("${DIRuner}" "${vbs_node_type}" "${vbs_dest_id}" "${vbs_dest_ip}" "${vbs_dest_port}" 14 1490 -35 $i | grep 'VOLUME')
        fi

        pageMessage=$(echo "${metaInfo}" | tr ',' '\n' | grep -E 'vol_name|node_key|parent_key|node_type')
        volumeMessage=$(echo -e "${volumeMessage}\n${pageMessage}")
        if [ -n "${metaInfo}" ]
        then
            judgeEmpty=0
            snapInfo=$(echo "${metaInfo}" | grep "node_type:101")
            if [ -n "${snapInfo}" ]
            then
                treeIdInfo=$(echo "${snapInfo}" | tr ',' '\n' | grep "node_key" | awk -F ':' '{print $1}' | awk -F '(' '{print $2}')
                treeIdInfo=$(echo -e "${remainTreeId}\n${treeIdInfo}")
                for treeId in $treeIdInfo
                do
                    remainTreeId=$treeId
                    cloneVolInfo=$(echo "${metaInfo}" | grep "node_key(${treeId}:" | grep "node_type:100" | grep "node_key(${treeId}\:[1-9]\:[0-9])")
                    if [ -n "${cloneVolInfo}" ]
                    then
                        branchId=$(echo "${cloneVolInfo}" | tr ',' '\n' | grep -E 'node_key|parent_key' | awk -F ':' '{print $2}')
                        nodeBranchId=$(echo "${branchId}" | tr '\n' ',' | awk -F ',' '{print $1}')
                        parBranchId=$(echo "${branchId}" | tr '\n' ',' | awk -F ',' '{print $2}')
                        if [ ! ${nodeBranchId} ==  ${parBranchId} ]
                        then
                            cloneVolNum=$(($cloneVolNum + 1))
                            
                        fi
                    fi
                done
            fi
        else
            judgeEmpty=$(($judgeEmpty + 1))
        fi

        if [ $judgeEmpty -eq 100 ]
        then
            break
        fi
    done
    echo $cloneVolNum
}

function get_isIscsiOpen()
{
    local mangerIp=$(sed -n 's/dsware_manager_ip=//p' /opt/dsware/agent/conf/dsware_manager_ip)
    if [ -f  /opt/dsware/vbs/conf/vbs_${mangerIp}_conf.cfg ];then
        isIscsiOpen=$(cat /opt/dsware/vbs/conf/vbs_${mangerIp}_conf.cfg | grep iscsi_switch | awk -F '=' '{print $2}')
    else
        isIscsiOpen=0
    fi

    log INFO "isIscsiOpen=${isIscsiOpen}"
}

function get_volumeNum() {
    volumeNum=$(lsscsi | grep -w "VBS fileIO" | wc -l)
    if [ -z "${volumeNum}" ];then
        volumeNum=0
    fi
    log INFO "volumeNum=${volumeNum}"
}

function get_expansionPortUsed()
{
    local need_free_port=3260

    # 两个区域内需要至少一个满足有连续40个未占用端口，不含头尾。
    local start_port1=11900
    local end_port1=12000
    local start_port2=12100
    local end_port2=12201

    local last_port=0
    expansionPortUsed="No"


    # 去除空行和字母行
    local port_list=$(timeout 60 ss -tan | awk '{print $4}' | cut -d':' -f2 | grep -v '^$\|[a-zA-Z]' \
    | awk "BEGIN{print \"$start_port1\n$end_port1\n$start_port2\n$end_port2\"}{print}"| sort -n | uniq)



    # 检查需要预留的端口是否占用
    for port in $port_list; do

        if (( port == need_free_port )); then
            break
        elif (( (port > start_port1 && port <= end_port1) || (port > start_port2 && port <= end_port2) )); then
            if (( port - last_port > 40 )); then
                expansionPortUsed="Yes"
                break
            fi
        elif (( port > end_port2 )); then
            break
        fi

        last_port=$port
    done
    log INFO "expansionPortUsed=${expansionPortUsed}"
}

function check_osd_node()
{
    if [ ! -f $SMIO ]
    then
        return 0
    fi

    PID=`ps -ef|grep -w "dsware_osd"|grep -v "grep"`
    if [ X"$PID" != "X" ]
    then
        return 0
    else 
        return 1
    fi
}

function get_iostat_info()
{
    which iostat > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        return 1
    fi
	
    iostat -kx 2 3 > $TMPFILE
    return 0
}	

function get_smiodisk_util()
{
    UTIL_TOTAL=0
    UTIL_AVG=0
    declare -a disk_arr
	
    SDISK=`cat $SMIO |awk -F "|" '{print $3}'|grep -v "sda"|grep -v "Name"`
    index=0
	diskUtil=0
    #get /proc/smio_host disk and save in disk_arr array
    for i in $(echo $SDISK|awk '{print}')  
    do
        disk_arr[$index]=$i
        let "index+=1"
    done

    i=0
    while [ $i -lt $index ]
    do
        DISK_UTIL=`cat $TMPFILE |grep -w ${disk_arr[$i]} | awk 'begin {sum=0} {if (NR>1) sum+=$NF } END {print sum/(NR-1)}'`
        #only those disks with util higher than 10% are added to calculation
        if [ `echo "$DISK_UTIL>$diskUtil"|bc` -eq 1 ]
        then
            diskUtil=${DISK_UTIL}
        fi

        let "i+=1"
    done
	
    return 0
}

function get_disk_util()
{
    which bc > /dev/null 2>&1
    chk_ret=$?
    if [ $chk_ret -ne 0 ]
    then
        diskUtil="NA"
        return 0
    fi
	
    check_osd_node   
    chk_ret=$?
    if [ $chk_ret -ne 0 ]
    then
        diskUtil="NA"
        return 0
    fi
  
    get_iostat_info
    chk_ret=$?
    if [ $chk_ret -ne 0 ]
    then
        diskUtil="NA"
        return 0
    fi

    get_smiodisk_util
    chk_ret=$?
    if [ $chk_ret -ne 0 ]
    then
        rm $TMPFILE	
        return $chk_ret
    fi
    rm $TMPFILE
    return 0
}

function fsa_smart_migration_json_out()
{
    local file_name="/var/log/dsware/FSA_${ip}_smart_migration_info_collect_result.json"
    echo > ${file_name}
    chmod 666 ${file_name}
    local now_json="    {\n        \"nodeIp\":\"${nodeIp}\",\n        \"storageIp\":\"${storageIp}\",\n        \"poolId\":\"${poolId}\",\n        \"nodeType\":\"${nodeType}\",\n        \"osdNum\":\"${osdNum}\",\n        \"vbsNum\":\"${vbsNum}\",\n        \"zkNum\":\"${zkNum}\",\n        \"mdcNum\":\"${mdcNum}\",\n        \"osVer\":\"${osVer}\",\n        \"kernelVer\":\"${kernelVer}\",\n        \"totalMemory\":\"${totalMemory}\",\n        \"freeMemory\":\"${freeMemory}\",\n        \"vbsUsedLimitMemory\":\"${vbsUsedLimitMemory}\",\n        \"totalCpuNum\":\"${totalCpuNum}\",\n        \"cpuUsage\":\"${cpuUsage}\",\n        \"vbsUsedCPUs\":\"${vbsUsedCPUs}\",\n        \"deficiencyMod\":\"${deficiencyMod}\",\n        \"nicName\":\"${nicName}\",\n        \"cloneVolNum\":\"${cloneVolNum}\",\n        \"networkType\":\"${networkType}\",\n        \"nicSpeed\":\"${nicSpeed}\",\n        \"bondMode\":\"${bondMode}\",\n        \"nicUtil\":\"${nicUtil}\",\n        \"nicModel\":\"${nicModel}\",\n        \"nicFirmwareVer\":\"${nicFirmwareVer}\",\n        \"nicOFEDVer\":\"${nicOFEDVer}\",\n        \"diskUtil\":\"${diskUtil}\",\n        \"volumeNum\":\"${volumeNum}\",\n        \"isIscsiOpen\":\"${isIscsiOpen}\",\n        \"expansionPortUsed\":\"${expansionPortUsed}\"\n    }\n"
    local new_json="[\n""${now_json}""]"
    echo -e "${new_json}" > ${file_name}
    return 0
}

function check_agent_version()
{
    vbs_version=`cat /opt/dsware/DSwareAgentNodeVersion | grep V100R006`
    if [ -n "$vbs_version" ]
    then
       return 0
    fi
    return 1
}

function get_deficiency_mod()
{
    if [ -f "/opt/dsware/agent/conf/agentMonitor" ]
    then
        vbs_monitor=`cat /opt/dsware/agent/conf/agentMonitor | grep vbs_1_is_monitor | awk -F '=' '{print $2}'`
        if [ "True" != "${vbs_monitor}" ]
        then
            deficiencyMod="-"
            return 0
        fi
    else
        deficiencyMod="-"
        return 0
    fi
    
    strArrray1=("traceroute" "unzip" "zip" "lsof" "dos2unix" "expect" "wget" "curl" "lsscsi"  "bc" "rsync")
    for value in ${strArrray1[@]}
    do
        ret=`command -v ${value}`
        if [ ! -n "${ret}" ]
        then
            deficiencyMod=${deficiencyMod}${value}" "
        fi    
    done

    strArrray2=("net-tools" "libnl" "pciutils" "sysstat" "perf")
    for value in ${strArrray2[@]}
    do
        ret=`rpm -qa | grep ${value}`
        if [ ! -n "${ret}" ]
        then
            deficiencyMod=${deficiencyMod}${value}" "
        fi    
    done

    ret=`command -v python`
    if [ ! -n "${ret}" ]
    then
        ret=`command -v python3`
        if [ ! -n "${ret}" ]
        then
            deficiencyMod=${deficiencyMod}"python"
        fi
    fi

    if [ -n "${deficiencyMod}"]
    then
        deficiencyMod="-"
    fi
}

function clear_node_result()
{
    rm -rf /var/log/dsware/FSA_${ip}_smart_migration_info_collect_result.json
}

function main()
{
    clear_node_result

    #检查存储版本
    check_agent_version
    if [ $? -ne 0 ]
    then
        log INFO "agent version is not 6.x"
        return 3
    fi

    get_nodeIp
    get_pool_id
    get_process
    get_OSInfo
    get_mem_and_cpu_Info
    get_nic_info
    get_isIscsiOpen
    get_volumeNum
    get_expansionPortUsed
    get_disk_util
    get_deficiency_mod
    #get_cloneVolNum

    # 输出结果
    fsa_smart_migration_json_out
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}