#!/bin/bash

#############################################################
#
# 名  称：检查ZooKeeper进程是否正常提供服务
# 错误码：
#         0000 正常
#         0001 zkRole 中有unknown
#         0002 ZooKeeper 无主
#         0003 ZooKeeper 多主
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4104"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    zk_judg=`cat /opt/dsware/agent/conf/agentMonitor | grep zk | grep -v alarm | grep -E 'True'`
    if [[ -z ${zk_judg} ]]
    then
        originalInfo="command:cat /opt/dsware/agent/conf/agentMonitor | grep zk | grep -v alarm | grep -E 'True'\n"
        originalInfo="${originalInfo}""review:null\n"
        originalInfo="${originalInfo}""result:this node does not have ZK."
        log INFO "FSM_${checkItemId}:this node does not have ZK."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    dsware_cmd="queryManageCluster"
    paras="-zkRoleFlag true"
    dsware_result=`run_dswaretool "${dsware_cmd}" "${paras}"`
    originalInfo="${originalInfo}""command:run_dswaretool ${dsware_cmd} ${paras}\n"
    originalInfo="${originalInfo}""review:""${dsware_result}\n"
    unknown_status=`echo "${dsware_result}" | grep unknown`
    leader_status_num=`echo "${dsware_result}" | grep leader -c`

    if [[ -n "${unknown_status}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  #0001 zkRole 中有unknown
        originalInfo="${originalInfo}""result:zkRole have unknown."
        log ERROR "FSM_${checkItemId}:zkRole have unknown"
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${leader_status_num} -eq 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  #0002 ZooKeeper 无主
        originalInfo="${originalInfo}""result:zkRole does not have leader."
        log ERROR "FSM_${checkItemId}:zkRole does not have leader"
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${leader_status_num} -ge 2 ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  #0003 ZooKeeper 多主
        leader_ips=`echo "${dsware_result}" | grep leader | egrep -o '[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+'`
        originalInfo="${originalInfo}""result:zkRole have leaders that are more than two, leader_ip is ${leader_ips}."
        log ERROR "FSM_${checkItemId}:zkRole have leaders that are more than two, leader_ip is \n${leader_ips}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    originalInfo="${originalInfo}""result:This check is pass."
    log INFO "FSM_${checkItemId}:This check is pass."
    log INFO "FSM_${checkItemId}:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

