#!/bin/bash

#############################################################
#
# 名  称：检查系统是否存在重要或紧急的告警
# 错误码：
#         0000=正常
#         0001=存在重要或紧急的告警
#         0002=查询告警失败，请重试或联系技术支持工程师
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4109"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_main()
{
    float_ip=$(getFloatIp)
    log INFO "float_ip=${float_ip}"

    cmd="--op healthCheck -nodeIp ${float_ip} -nodeType Cluster -items 4109;ps -ef|grep -v grep|grep healthCheck|grep -v root;"

    check_result_info=$(run_dswaretool_new ${cmd})
    log INFO "${check_result_info}"

    result_detail="$(echo -e "${check_result_info}" |grep "itemId-result-resultDetail")"

    if [[ -z "${result_detail}" ]]
    then
        log ERROR "Failed to execute the dswareTool command.[--op healthCheck -nodeIp ${float_ip} -nodeType Cluster -items 4109]"
        resultCode=1
        errorKey="${checkItemId}""0002"
        originalInfo="ERROR:Failed to query alarm information. Please retry or contact technical support engineers."
        return 1
    fi

    originalInfo=$(echo ${result_detail} | awk -F"-" '{print $5}')

    if [[ -z "$(echo ${result_detail} | grep "No major or critical alarm has been generated")" ]]
    then
        log ERROR "${result_detail}"
        resultCode=1
        errorKey="${checkItemId}""0001"
        return 1
    fi

    log INFO "${result_detail}"

    return 0
}

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    check_main
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

