#!/bin/bash

#############################################################
#
# 名  称：检查存储软件版本是否一致
# 错误码：
#         0000=正常
#         0001=集群中存在多种存储软件版本
#         0002=
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4110"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    dsware_cmd="--op queryAllHost"
    dsware_result=`run_dswaretool_new ${dsware_cmd} 2>/dev/null | grep -i version | uniq | wc -l`
    originalInfo="${originalInfo}""command:sh /opt/dsware/client/bin/dswareTool.sh --op queryAllHost | grep -i version | uniq | wc -l\n"
    originalInfo="${originalInfo}""review:version_type_total=${dsware_result}\n"

    if [ ${dsware_result} -ne 1 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 0001 集群中存在多种存储软件版本
        originalInfo="${originalInfo}""result:there are different agent_versions in the cluster."
        log ERROR "FSM_${checkItemId}:there is different agent_version in the cluster."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" " ${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:agent_version is same in the cluster."
        log INFO "FSM_${checkItemId}:agent_version is same in the cluster."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    


}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

