#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4113"
resultCode=0
errorKey=""
params=""
originalInfo=""



function main()
{
    
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi
    NodeVersion=$(cat /opt/dsware/DSwareManagerNodeVersion |grep nodeVersion |awk -F '=' '{print $2}')
    if [ -z "$NodeVersion" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"   # 没有版本信息文件
        originalInfo="command:cat /opt/dsware/DSwareManagerNodeVersion |grep nodeVersion\n"
        originalInfo="$originalInfo""review:${NodeVersion}\n"
        originalInfo="$originalInfo""result:There is no version information file."
        log ERROR "There is no version information file."
        log ERROR "${checkItemId}:FSM_4113:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        if [[ "${NodeVersion}" == "V100R006C30SPH505" || 
              "${NodeVersion}" == "V100R006C30SPH506" || 
              "${NodeVersion}" == "V100R006C30SPC600" || 
              "${NodeVersion}" == "V100R006C30SPC601" || 
              "${NodeVersion}" == "V100R006C30SPC801" || 
              "${NodeVersion}" == "V100R006C30SPC802" || 
              "${NodeVersion}" == "V100R006C30SPC803" ||
              "${NodeVersion}" == "V100R006C30SPC805" ||
              "${NodeVersion}" == "V100R006C30SPC810" ]]
        then
            resultCode=0
            originalInfo="command:cat /opt/dsware/DSwareManagerNodeVersion |grep nodeVersion\n"
            originalInfo="$originalInfo""review:${NodeVersion}\n"
            originalInfo="$originalInfo""result:The node version ${NodeVersion} is normal."
            log INFO "The node version ${NodeVersion} is normal."
            log INFO "${checkItemId}:FSM_4113:ok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        else
            resultCode=1
            errorKey="${checkItemId}0002"   # 版本过低请升级
            originalInfo="command:cat /opt/dsware/DSwareManagerNodeVersion |grep nodeVersion\n"
            originalInfo="$originalInfo""review:${NodeVersion}\n"
            originalInfo="$originalInfo""result:The node version ${NodeVersion} is too low, please upgrade."
            log ERROR "The node version ${NodeVersion} is too low, please upgrade."
            log ERROR "${checkItemId}:FSM_4113:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 没有版本信息文件
#  0002 版本过低请升级
#
##############################