#!/bin/bash

#############################################################
#
# 名  称：检查存储池空间利用率
# 错误码：
#         0000 正常
#         0001 存在使用率超过85%的存储池
#         0002 告警：存在使用率超过75%的存储池
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4115"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    storage_pool_info=`run_dswaretool queryStoragePool`
    originalInfo="${originalInfo}""command:run_dswaretool queryStoragePool\n"
    originalInfo="${originalInfo}""review:\n${storage_pool_info}\n"
    pool_num=`echo "${storage_pool_info}" | grep -E '^[0-9]+' | awk '{print$1}'`
    originalInfo="${originalInfo}""result:pool_num=${pool_num}\n"
    for i in ${pool_num}
    do 
        paras="-id $i"
        originalInfo="${originalInfo}""pool_id=${i}\n"
        S=`run_dswaretool queryStorageNodeInfo "${paras}" | grep "nodeMgrIp" -c`
        originalInfo="${originalInfo}""command:run_dswaretool queryStorageNodeInfo -id $i | grep nodeMgrIp -c\n"
        originalInfo="${originalInfo}""review:S=${S}\n"
        if [[ $(get_src_version) == V100R006* ]]
        then
            T=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $4}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$4}'\n"
            originalInfo="${originalInfo}""review:T=${T}\n"
            U=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $5}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$5}'\n"
            originalInfo="${originalInfo}""review:U=${U}\n"
        else
            T=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $3}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$3}'\n"
            originalInfo="${originalInfo}""review:T=${T}\n"
            U=`echo "${storage_pool_info}" | grep -wE "^${i}" | awk '{print $4}'`
            originalInfo="${originalInfo}""command:echo \$storage_pool_info | grep -wE ^\${i} | awk '{print \$5}'\n"
            originalInfo="${originalInfo}""review:U=${U}\n"
        fi
       
        result_tmp=$(awk 'BEGIN{printf "%.2f\n",('$U'/('$T'-'$T'/'$S'))}')
        originalInfo="${originalInfo}""command:percent=U/(T-T/S)\n"
        result=$(awk 'BEGIN{printf "%d\n",'${result_tmp}*100'}')
        originalInfo="${originalInfo}""review:percent=${result_tmp}\n"
        
        error_info=""
        warning_info=""
        if [ ${result} -gt 85 ]
        then
            resultCode=1
            originalInfo="${originalInfo}""result:poolId=${i},usage=${result}%\n"
            error_info="${error_info}""poolId=${i},usage=${result}%;"
        elif [ ${result} -gt 75 -a ${result} -le 85 ]
        then
            if [ ${resultCode} -ne 1 ]
            then
                resultCode=2
            fi
            originalInfo="${originalInfo}""result:poolId=${i},usage=${result}%\n"
            warning_info="${warning_info}""poolId=${i},usage=${result}%;"
        fi
    done  

    if [ ${resultCode} -eq 1 ]
    then
        errorKey="${checkItemId}0001"   # 0001 存在使用率超过85%的存储池
        originalInfo="${originalInfo}""result:Storage pool usage more than 85% , include:${error_info} Maybe have warning_pool that usage more than 75% , include:${warning_info}"
        log ERROR "FSM_${checkItemId}:Storage pool usage more than 85% , include:${error_info} Maybe have warning_pool that usage more than 75% , include:${warning_info}"
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" " ${params}" "${originalInfo}"
        return 1
    elif [ ${resultCode} -eq 2 ]
    then
        errorKey="${checkItemId}0002"  # 0002 告警：存在使用率超过75%的存储池
        originalInfo="${originalInfo}""result: WARNING:Storage pool usage more than 75% , include:${warning_info}."
        log ERROR "FSM_${checkItemId}:WARNING:Storage pool usage more than 75% , include:${warning_info}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" " ${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:there is no Storage pool usage more than 75%."
        log INFO "FSM_${checkItemId}:there is no Storage pool usage more than 75%."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}


log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
