#!/bin/bash

#############################################################
#
# 名  称：检查数据迁移状态
# 错误码：
#         0000 正常
#         0001 获取存储池ID信息失败
#         0002 存在查询存储池重构信息失败，及部分存储池迁移未完成
#         0003 存在查询存储池重构信息失败
#         0004 部分存储池迁移未完成
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4117"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    storage_pool_info=`run_dswaretool queryStoragePool`
    originalInfo="${originalInfo}""command:run_dswaretool queryStoragePool\n"
    originalInfo="${originalInfo}""review:\n${storage_pool_info}\n"
    pool_nums=`echo "${storage_pool_info}" | grep -E '^[0-9]+' | awk '{print$1}'`
    originalInfo="${originalInfo}""result:pool_nums=${pool_nums}\n"

    if [[ -z "${pool_nums}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  #0001 获取存储池ID信息失败
        originalInfo="${originalInfo}""result:get pool_id_info failed."
        log ERROR "FSM_${checkItemId}:get pool_id_info failed."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    
    error_pool_info=""
    error_pool_rate_info=""
    for pool_id in ${pool_nums}
    do
        dsware_tool_cmd="--op queryStoragePoolStatus -id ${pool_id}"
        pool_check_result=`run_dswaretool_new ${dsware_tool_cmd} | grep "The ok-partition rate is"`
        originalInfo="${originalInfo}""command:run_dswaretool_new ${dsware_tool_cmd} | grep 'The ok-partition rate is 100%'\n"
        originalInfo="${originalInfo}""review:pool_id=${pool_id},pool_check_result=${pool_check_result};\n"
        if [[ -z "${pool_check_result}" ]]
        then
            originalInfo="${originalInfo}""result:pool_id=${pool_id},Data rebalance query failed.\n"
            log ERROR "FSM_${checkItemId}:pool_id=${pool_id},Data rebalance query failed."
            error_pool_info="${error_pool_info}"" ,${pool_id}"
            continue
        fi

        pool_check_result_rate=`echo "${pool_check_result}" | awk '{print$5}'`        
        if [[ "${pool_check_result_rate}"x != "100%"x ]]
        then
            originalInfo="${originalInfo}""result:pool_id=${pool_id}, data rebalance exists, but rebalance rate is ${pool_check_result_rate}\n"
            log ERROR "FSM_${checkItemId}:pool_id=${pool_id}, data rebalance exists, but rebalance rate is ${pool_check_result_rate}"
            error_pool_rate_info="${error_pool_rate_info}"" ;pool_id=${pool_id} ,pool_rebalance_rate=${pool_check_result_rate}"
        fi
    done

    error_pool_info=${error_pool_info:2}
    error_pool_rate_info=${error_pool_rate_info:2}

    if [[ -n "${error_pool_info}" ]] && [[ -n "${error_pool_rate_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  #0002 存在查询存储池重构信息失败，及部分存储池迁移未完成
        originalInfo="${originalInfo}""result:Data rebalance query failed，pool_ids include: ${error_pool_info}.\nData rebalance exists, pool_rate_info: ${error_pool_rate_info}."
        log ERROR "FSM_${checkItemId}:Data rebalance query failed，pool_ids include: ${error_pool_info}."
        log ERROR "FSM_${checkItemId}:Data rebalance exists, pool_rate_info: ${error_pool_rate_info}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -n "${error_pool_info}" ]] && [[ -z "${error_pool_rate_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  #0003 存在查询存储池重构信息失败
        originalInfo="${originalInfo}""result:Data rebalance query failed，pool_ids include: ${error_pool_info}."
        log ERROR "FSM_${checkItemId}:Data rebalance query failed，pool_ids include: ${error_pool_info}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -z "${error_pool_info}" ]] && [[ -n "${error_pool_rate_info}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  #0004 部分存储池迁移未完成
        originalInfo="${originalInfo}""result:Data rebalance exists, pool_rate_info: ${error_pool_rate_info}."
        log ERROR "FSM_${checkItemId}:Data rebalance exists, pool_rate_info: ${error_pool_rate_info}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:there is no pool_data rebalance."
        log INFO "FSM_${checkItemId}:there is no pool_data rebalance."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

