#!/bin/bash

#############################################################
#
# 名  称：检查FSM集群状态
# 错误码：
#         0000 正常
#         0001 检查 FSM 集群失败
#         0002 FSM 集群异常
#         0003 /opt/omm/oms/workspace/ha/module/hacom/conf/hacom.xml 文件不存在
#         0004 HA 监控的资源状态异常
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4121"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    for i in {1..5}
    do
        FSM_status=`sh /opt/omm/oms/workspace/ha/module/hacom/script/status_ha.sh | grep -iA 2 HAAllResOK`
        originalInfo="${originalInfo}""command:sh /opt/omm/oms/workspace/ha/module/hacom/script/status_ha.sh | grep -iA 2 HAAllResOK\n"
        originalInfo="${originalInfo}""review:\n${FSM_status}\n"
        if [[ -z "${FSM_status}" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0001"  # 0001 检查 FSM 集群失败
            originalInfo="${originalInfo}""result:Checking status for FSM cluster failed."
            log ERROR "FSM_${checkItemId}:Checking status for FSM cluster failed."
            log ERROR "FSM_${checkItemId}:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        error_result=""
        info=`echo "${FSM_status}" | sed '1d' | sed '/^$/d' | awk '{print $1,$7}'`
        num=$(echo "$info" | wc -l)
        for((i=1;i<=$num;i++));do
            line=`echo "${info}" | sed -n "${i}p"`
            node_state=`echo "$line" | awk '{print $2}'`
            if [[ "${node_state}"x != "normal"x ]]
            then
                node_name=`echo "$line" | awk '{print $1}'`
                error_result="${error_result}, ${node_name}"
            fi
        done

        if [[ -n "${error_result}" ]]
        then
            error_result="${error_result:2}"
            resultCode=1
            errorKey="${checkItemId}0002"  # 0002 FSM 集群异常
            originalInfo="${originalInfo}""result:FSM cluster status is abnormal, the abnormal node is: ${error_result}."
            log ERROR "FSM_${checkItemId}:FSM cluster status is abnormal, the abnormal node is: ${error_result}."
            log ERROR "FSM_${checkItemId}:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            originalInfo="${originalInfo}""result:FSM cluster status is normal.\n"
            log INFO "FSM_${checkItemId}:FSM cluster status is normal."
        fi

        sleep 1

    done

    HA_xml="/opt/omm/oms/workspace/ha/module/hacom/conf/hacom.xml"
    if [ ! -f "${HA_xml}" ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 /opt/omm/oms/workspace/ha/module/hacom/conf/hacom.xml 文件不存在
        originalInfo="${originalInfo}""result:${HA_xml} not exist,can not get HA mode."
        log ERROR "FSM_${checkItemId}:${HA_xml} not exist,can not get HA mode."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    HA_mode=`grep -w 'hamode value' ${HA_xml} | awk -F '"' '{print $2}'`
    originalInfo="${originalInfo}""command:grep -w 'hamode value' ${HA_xml}\n"
    originalInfo="${originalInfo}""review:HA_mode=${HA_mode}\n"
    if [[ "${HA_mode}"x != "double"x ]] && [[ "${HA_mode}"x != "single"x ]]
    then
        resultCode=1
        errorKey="${checkItemId}0004"  # 0004 HA 监控的资源状态异常
        originalInfo="${originalInfo}""result:get HA mode failed, HA_mode=${HA_mode}."
        log ERROR "FSM_${checkItemId}:get HA mode failed, HA_mode=${HA_mode}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    originalInfo="${originalInfo}""result:HA_status is normal."
    log INFO "FSM_${checkItemId}:HA_status is normal."
    log INFO "FSM_${checkItemId}:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

