#!/bin/bash


UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4122"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{   
    manager_items_check ${checkItemId}
    if [[ $? -ne 0 ]]
    then
        log INFO "${checkItemId} do not select, pass"
            return 0
	fi

    node_version=$(sed -n 's/nodeVersion=//p' /opt/dsware/DSwareManagerNodeVersion)
	if [[ -z "$node_version" ]];then
	    resultCode=1
		errorKey="${checkItemId}0001"   # 节点版本信息没有找到
		originalInfo="command:sed -n 's/nodeVersion=//p' /opt/dsware/DSwareManagerNodeVersion"
        originalInfo="${originalInfo}""review:${node_version}\n"
        originalInfo="${originalInfo}""result:The node version information is not found."
		log ERROR "The node version information is not found."
		log ERROR "${checkItemId}:FSA_4122:unok"
		FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1 
	fi
    g_tool_kit_path="/opt/dsware/tools/ops_tool/tool_kit"
    source ${g_tool_kit_path}/get_db_common_info.sh 1
    if [ $? -ne 0 ];then
	    log ERROR "Query db_user_name failed."
	    resultCode=1
	    errorKey="${checkItemId}0004"
	    originalInfo="command:source ${g_tool_kit_path}\/get_db_common_info.sh 1"
	    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	    return 1
	fi
    source  ${g_tool_kit_path}/get_db_common_info.sh 2
	if [ $? -ne 0 ];then
	    log ERROR "Query db_user_passwd failed."
	    resultCode=1
	    errorKey="${checkItemId}0005"
	    originalInfo="command:source  ${g_tool_kit_path}\/get_db_common_info.sh 2"
	    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	    return 1
	fi
    db_user_name=${DbUsername}
    db_user_passwd=${DecryptPasswd}

    query_sql="select LICENSESN from TBL_LIC_STATUS_CONTROL;"
    license_info=$(echo ${db_user_passwd} | xargs -i su - omm -c "gsql -U ${db_user_name} -p 21600 -W {} -c 'set search_path=dsware_1;${query_sql}'" | tail -3 | head -1)

	if [ $? -ne 0  -o -z "$license_info" ];then
        resultCode=1
		errorKey="${checkItemId}0002"   # license信息查询失败
		originalInfo="command:su - omm -c gsql -U omm -p 21600 -W passwd -c 'set search_path=dsware_1;${query_sql}' | tail -3 | head -1"
        originalInfo="${originalInfo}""review:${node_version}\n"
        originalInfo="${originalInfo}""result:The license information is not found in db."
		log ERROR "The license information is not found in db."
		log ERROR "${checkItemId}:FSA_4122:unok"
		FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1 
	fi
	
	license_sn=$(echo $license_info | awk -F '|' '{print $1}' | sed  's/ //g')
	if [[ "$license_sn" == "no_license" ]];then
        resultCode=1
		errorKey="${checkItemId}0003"   # license未导入
		originalInfo="command:su - omm -c gsql -U omm -p 21600 -W passwd -c 'set search_path=dsware_1;${query_sql}' | tail -3 | head -1"
        originalInfo="${originalInfo}""review:${node_version}\n"
        originalInfo="${originalInfo}""result:The license is not loaded."
		log ERROR "The license is not loaded."
		log ERROR "${checkItemId}:FSA_4122:unok"
		FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
		return 1 
	fi

    resultCode=0
    originalInfo="command:sed -n 's/nodeVersion=//p' /opt/dsware/DSwareManagerNodeVersion"
    originalInfo="${originalInfo}""review:${node_version}\n"
    originalInfo="${originalInfo}""result:License is normal."
	log INFO "License is normal."
	log INFO "${checkItemId}:FSA_4122:ok"
	FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
	return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001  节点版本信息没有找到
#  0002  license信息查询失败
#  0003  license未导入
#  0004  Query db_user_name failed
#  0005  Query db_user_passwd failed
##############################