#!/bin/bash

#############################################################
#
# 名  称：网络亚健康开关检查
# 错误码：
#         0000=正常
#         0001=该节点无 /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh 文件或不具备可执行权限，无法获取集群IP地址
#         0002=集群中存在未开启网络亚健康开关节点
#         0003=当前产品版本低于 R3U2
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4405"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    product_version=`get_src_version`
    echo "${product_version}"

    if [[ ! "${product_version}" =~ "V100R006C" ]] && [[ ! "${product_version}" =~ "V100R003C30U2" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0003"  # 0003 当前产品版本低于 R3U2
        originalInfo="${originalInfo}""result:the product_version is ${product_version}."
        log ERROR "FSM_${checkItemId}:the product_version is ${product_version}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ! -x "/opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 该节点无 /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh 文件或不具备可执行权限，无法获取集群IP地址
        originalInfo="${originalInfo}""result:there is no /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh."
        log ERROR "FSM_${checkItemId}:there is no /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    FSA_IPs=`sh /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh`
    originalInfo="${originalInfo}""command:sh /opt/dsware/tools/ops_tool/tool_kit/get_all_node_ip.sh\n"
    originalInfo="${originalInfo}""review: FSA_IPs include:\n${FSA_IPs}\n"

    count=0
    check_ips=""
    error_ips_info=""
    for fsa_ip in ${FSA_IPs}
    do
        check_ips="${check_ips}"",${fsa_ip}"
        count=$[${count}+1]
        if [ ${count} -eq 30 ]
        then
            check_ips=${check_ips:1}
            dsware_cmd="--op queryNetworkSubhealthSwitch -ip ${check_ips}"
            dsware_result=`run_dswaretool_new ${dsware_cmd}`
            originalInfo="${originalInfo}""command:run_dswaretool_new ${dsware_cmd}\n"
            originalInfo="${originalInfo}""review:\n${dsware_result}\n"
            
            dsware_result_lines_total=`echo "${dsware_result}" | wc -l`
            info__tail_line_num=$[${dsware_result_lines_total}-2]
            error_infos=`echo "${dsware_result}" | sed -n "5,${info__tail_line_num}p" | grep -v open`
            
            if [[ -n "${error_infos}" ]]
            then
                error_ips=(`echo "${error_infos}" | awk '{print$1}'`)
                error_status=(`echo "${error_infos}" | awk '{print$2}'`)
                for ((i=0;i<${#error_ips[@]};i++))
                do
                    error_ips_info="${error_ips_info}"" ;error_ip=${error_ips[i]} ,error_status=${error_status[i]}"
                done
            fi
            count=0
            check_ips=""
        fi
    done

    if [[ -n "${check_ips}" ]]
    then
        check_ips=${check_ips:1}
        dsware_cmd="--op queryNetworkSubhealthSwitch -ip ${check_ips}"
        dsware_result=`run_dswaretool_new ${dsware_cmd}`
        originalInfo="${originalInfo}""command:run_dswaretool_new ${dsware_cmd}\n"
        originalInfo="${originalInfo}""review:\n${dsware_result}\n"
        
        dsware_result_lines_total=`echo "${dsware_result}" | wc -l`
        info__tail_line_num=$[${dsware_result_lines_total}-2]
        error_infos=`echo "${dsware_result}" | sed -n "5,${info__tail_line_num}p" | grep -v open`
        
        if [[ -n "${error_infos}" ]]
        then
            error_ips=(`echo "${error_infos}" | awk '{print$1}'`)
            error_status=(`echo "${error_infos}" | awk '{print$2}'`)
            for ((i=0;i<${#error_ips[@]};i++))
            do
                error_ips_info="${error_ips_info}"" ;error_ip=${error_ips[i]} ,error_status=${error_status[i]}"
            done
        fi
    fi

    error_ips_info=${error_ips_info:2}

    close_status_judg=`echo "${error_status}" | grep -i close`
    unknown_status_judg=`echo "${error_status}" | grep -i unknown`

    if [[ -n "${close_status_judg}" ]] && [[ -z "${unknown_status_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0002"  # 0002 集群中存在未开启网络亚健康开关节点
        originalInfo="${originalInfo}""result:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -z "${close_status_judg}" ]] && [[ -n "${unknown_status_judg}" ]]
    then
        resultCode=2
        errorKey="${checkItemId}0004"  # 0004 集群中存在接入但未配置的节点
        originalInfo="${originalInfo}""result:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    elif [[ -n "${close_status_judg}" ]] && [[ -n "${unknown_status_judg}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0005"  # 0005 集群中存在未开启网络亚健康开关节点和接入但未配置的节点
        originalInfo="${originalInfo}""result:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:this cluster have some node(s) not open the check sub-health switch, such as: ${error_ips_info} ."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:this cluster's network is health."
        log INFO "FSM_${checkItemId}:this cluster's network is health."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

