#!/bin/bash
#############################################################
#
# 名  称：FSM和FSA合并部署管理和存储共用一个网卡
# 错误码：
#         0000 正常
#         0001 管理和存储共用网卡
#         0002 管理和存储mac地址为空
#
#############################################################
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="4415"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ -f /opt/dsware/DSwareAgentNodeVersion && -f /opt/dsware/DSwareManagerNodeVersion ]]
    then
        originalInfo="${originalInfo}""result:this FSM point deploy with FSA.\n"
        log INFO "${checkItemId}FSM_check_deploy_FSA.sh:this FSM point deploy with FSA."


        manager_ip=`cat /etc/node_manager_ip | awk -F '=' '{print$2}'`
        originalInfo="${originalInfo}""command:cat /etc/node_manager_ip | awk -F '=' '{print\$2}'\n"
        originalInfo="${originalInfo}""review:manager_ip is ${manager_ip}\n"
        storage_ip=`cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print$2}'`
        originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print\$2}'\n"
        originalInfo="${originalInfo}""review:storage_ip is ${storage_ip}\n"


        manager_net=`ip a | grep -w ${manager_ip} | awk '{print$NF}'`
        originalInfo="${originalInfo}""command:ip a | grep -w ${manager_ip} | awk '{print\$NF}'\n"
        originalInfo="${originalInfo}""review:manager_net is ${manager_net}\n"
        manager_net_mac=`cat /sys/class/net/${manager_net}/address`
        originalInfo="${originalInfo}""command:cat /sys/class/net/${manager_net}/address\n"
        originalInfo="${originalInfo}""review:manager_net_mac is ${manager_net_mac}\n"
        log INFO "manager_net is ${manager_net},manager_net_mac is ${manager_net_mac}"


        storage_net=`ip a | grep -w ${storage_ip} | awk '{print$NF}'`
        originalInfo="${originalInfo}""command:ip a | grep -w ${storage_ip} | awk '{print\$NF}'\n"
        originalInfo="${originalInfo}""review:storage_net is ${storage_net}\n"
        storage_net_mac=`cat /sys/class/net/${storage_net}/address`
        originalInfo="${originalInfo}""command:cat /sys/class/net/${storage_net}/address\n"
        originalInfo="${originalInfo}""review:storage_net_mac is ${storage_net_mac}\n"
        log INFO "storage_net is ${storage_net},storage_net_mac is ${storage_net_mac}"

        if [[ -z "${manager_net_mac}" || -z "${storage_net_mac}" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0002"
            originalInfo="${originalInfo}""result:manager_net_mac or storage_net_mac is null."
            log ERROR "${checkItemId}FSM_4415.sh:manager_net_mac or storage_net_mac is null"
            log ERROR "${checkItemId}:FSM_4415.sh:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi

        if [[ "${manager_net_mac}" == "${storage_net_mac}" ]]
        then
            resultCode=1
            errorKey="${checkItemId}0001"
            originalInfo="${originalInfo}""result:manager_net_mac is equal storage_net_mac."
            log ERROR "${checkItemId}FSM_4415.sh:manager_net_mac is equal storage_net_mac."
            log ERROR "${checkItemId}:FSM_4415.sh:unok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            originalInfo="${originalInfo}""result:manager_net_mac is not equal storage_net_mac."
            log INFO "${checkItemId}FSM_4415.sh:manager_net_mac is not equal storage_net_mac."
            log INFO "${checkItemId}:FSM_4415.sh:ok"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    else
        originalInfo="${originalInfo}""result:FSM do not deploy with FSA."
        log INFO "${checkItemId}FSM_4415.sh:FSM do not deploy with FSA."
        log INFO "${checkItemId}:FSM_4415.sh:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}



