#!/bin/bash

#############################################################
#
# 名  称：MDC聚类算法内存泄漏规避
# 错误码：
#         0000=正常
#         0001=存在节点MDC参数值不是最优值
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }

checkItemId="4418"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    src_version=$(get_src_version)
    originalInfo="${originalInfo}""command:get_src_version\n"
    originalInfo="${originalInfo}""review:node_version=${src_version}\n"

    if [[ "${src_version}"x != "V100R006C30SPC500"x ]] && [[ "${src_version}"x != "V100R006C30SPC501"x ]] && [[ "${src_version}"x != "V100R006C30SPC600"x ]] && [[ "${src_version}"x != "V100R006C30SPH505"x ]]
    then
        originalInfo="${originalInfo}""result:Node_version is ${src_version}, not belong to R6C30SPC500/501/600 or R6C30SPH505, no need to check."
        log INFO "FSM_${checkItemId}:Node_version is ${src_version}, not belong to R6C30SPC500/501/600 or R6C30SPH505, no need to check."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    dsware_result_info=`run_dswaretool_new --op queryGlobalParameters -paraName g_mdc_cfm_min_points`
    originalInfo="${originalInfo}""command:/opt/dsware/client/bin/dswareTool.sh --op queryGlobalParameters -paraName g_mdc_cfm_min_points\n"
    originalInfo="${originalInfo}""review:\n${dsware_result_info}\n"
    result_num=`echo "${dsware_result_info}" | grep g_mdc_cfm_min_points | awk '{print$2}'`
    originalInfo="${originalInfo}""result:parameterValue=${result_num}\n"
    if [ ${result_num} -eq 1024 ]
    then
        originalInfo="${originalInfo}""result:parameterValue is equal 1024."
        log INFO "FSM_${checkItemId}:parameterValue is equal 1024."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        originalInfo="${originalInfo}""result:parameterValue is not equal 1024.\n\n"
    fi
    

    dsware_result_info=`echo "y" | run_dswaretool_new --op globalParametersOperation -opType modify -parameter g_mdc_cfm_min_points:1024`
    originalInfo="${originalInfo}""command:/opt/dsware/client/bin/dswareTool.sh --op globalParametersOperation -opType modify -parameter g_mdc_cfm_min_points:1024\n"
    originalInfo="${originalInfo}""review:\n${dsware_result_info}\n"
    result_num=`echo "${dsware_result_info}" | grep 'The count of failed nodes is' | egrep -o '[0-9]+'`
    originalInfo="${originalInfo}""result:Setting failed nodes num is ${result_num}\n"
    if [ ${result_num} -eq 0 ]
    then
        originalInfo="${originalInfo}""result:Setting is successfully."
        log INFO "FSM_${checkItemId}:Setting is successfully."
        log INFO "FSM_${checkItemId}:ok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        failed_ip=($(echo "${dsware_result_info}" | grep ip | egrep -o '[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+'))
        resultCode=1
        errorKey="${checkItemId}0001"  # 0001 存在节点MDC参数值不是最优值
        originalInfo="${originalInfo}""result:Some nodes which is setted is failed, include: ${failed_ip[@]}."
        log ERROR "FSM_${checkItemId}:Some nodes which is setted is failed, include: ${failed_ip[@]}."
        log ERROR "FSM_${checkItemId}:unok"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
