#!/bin/bash

#############################################################
#
# 名  称：检查IBping全集
# 错误码：
#         0001 获取数据库密码失败
#         0002 查询语句执行失败
#         0003 IBping全集检查失败
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/func.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="4426"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    manager_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    # 获取数据库密码GetDBPassword
    originalInfo="GetDBPassword: Failed to obtain the database password.\n"
    db_password="$(GetDBPassword | awk '{print $1}')"
    if [ $? -ne 0 ]; then
        log ERROR "Failed to obtain the database password."
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}result:1\n"
        # detail
        originalInfo="${originalInfo}detail:Failed to obtain the database password."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 针对 TBL_IB_PORT_INFO 中的所有项，检查是否也同时在 TBL_SERVER_INFO 中存在，如果不存在，left jion时，后者会为空值
    originalInfo="command:
    echo \${db_password} | xargs -i su - omm -c \\\"gsql -p 21600 -W  -XAtc 'select t1.MANAGER_IP,t2.MANAGEIP from omm_1.TBL_IB_PORT_INFO as t1 left join dsware_1.TBL_SERVER_INFO as t2 on t1.MANAGER_IP=t2.MANAGEIP where t2.MANAGEIP is null;'\\\"\n"

    records=`($(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'select t1.MANAGER_IP,t2.MANAGEIP from omm_1.TBL_IB_PORT_INFO as t1 left join dsware_1.TBL_SERVER_INFO as t2 on t1.MANAGER_IP=t2.MANAGEIP where t2.MANAGEIP is null;'"))`
    # 若查询执行失败，则直接失败退出
    if [ $? -ne 0 ]; then
        log ERROR "Failed to execute the query statement."
        resultCode=1
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}result:1\n"
        originalInfo="${originalInfo}detail:Failed to execute the query statement."
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 若查询执行成功且有输出，则说明存在 TBL_IB_PORT_INFO 中管理IP 在 TBL_SERVER_INFO 中匹配失败
    if [ "${records}" ]; then
        unmatched_ip_list=""
        for record in ${records[@]}
        do
            mgr_ip=`echo "${record}" | awk -F"|" '{print $1}'`
            [ "${unmatched_ip_list}" ] && unmatched_ip_list="${unmatched_ip_list},${mgr_ip}" || unmatched_ip_list="${mgr_ip}"
        done
        log ERROR "Failed to check all IBping sets. unmatched manager ip: ${unmatched_ip_list}"
        resultCode=1
        errorKey="${checkItemId}0003"
        originalInfo="${originalInfo}result:1\n"
        originalInfo="${originalInfo}detail:Failed to check all IBping sets. unmatched manager ip: ${unmatched_ip_list}"
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    originalInfo="${originalInfo}result:0\n"
    originalInfo="${originalInfo}detail:Checking all IBping sets succeeded."

    log INFO "FSM_${checkItemId}:ok"
    FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

# --------------------------------------------------------------------------- #
#                          脚本开始运行
# --------------------------------------------------------------------------- #
log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}