#!/bin/bash
UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/dswareTool_lib.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/dswareTool_lib.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/func.sh"|| { log ERROR "source ${UPG_LIB_PATH}/func.sh failed."; exit 130; }

poolId=""
poolName=""
redundancyPolicy=""
hostNum=""
replicationFactor=""
storageNum=""
mediaType=""
cacheNum=""
cacheMediaType=""
volumeNum=""
securityLevel=""
storageCacheRate=""
cacheDifSwitch=""
mainstorageDifSwitch=""
belongMdcIp=""
poolStatus=""
totalCapacity=""
usedCapacity=""
allocatedCapacity=""
freeCapacityRate=""
snapshotNum=""
cloneVolNum=""
averageIOPS=""
maxIOPS=""
averageDelay=""
maxDelay=""
averageBondwith=""
maxBondwith=""
volumeMessage=""

updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
ip=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}')

function fsm_volume_info_out()
{
    local vol_file_name="/var/log/dsware/FSM_${ip}_volumn_info_collect_result.txt"
    if [ -f "${vol_file_name}" ]
    then
        clear_vol_info
    fi
    echo -e "${volumeMessage}" > ${vol_file_name}
    chmod 666 ${vol_file_name}
    return 0
}

function fsm_smart_migration_json_out()
{
    local file_name="/var/log/dsware/FSM_${ip}_smart_migration_info_collect_result.json"
    if [ ! -f "${file_name}" ]
    then
        local now_json="    {\n        \"poolId\":\"${poolId}\",\n        \"poolName\":\"${poolName}\",\n        \"redundancyPolicy\":\"${redundancyPolicy}\",\n        \"hostNum\":\"${hostNum}\",\n        \"replicationFactor\":\"${replicationFactor}\",\n        \"storageNum\":\"${storageNum}\",\n        \"mediaType\":\"${mediaType}\",\n        \"cacheNum\":\"${cacheNum}\",\n        \"cacheMediaType\":\"${cacheMediaType}\",\n        \"volumeNum\":\"${volumeNum}\",\n        \"securityLevel\":\"${securityLevel}\",\n        \"storageCacheRate\":\"${storageCacheRate}\",\n        \"cacheDifSwitch\":\"${cacheDifSwitch}\",\n        \"mainstorageDifSwitch\":\"${mainstorageDifSwitch}\",\n        \"belongMdcIp\":\"${belongMdcIp}\",\n        \"poolStatus\":\"${poolStatus}\",\n        \"totalCapacity\":\"${totalCapacity}\",\n        \"usedCapacity\":\"${usedCapacity}\",\n        \"allocatedCapacity\":\"${allocatedCapacity}\",\n        \"freeCapacityRate\":\"${freeCapacityRate}\",\n        \"snapshotNum\":\"${snapshotNum}\",\n        \"cloneVolNum\":\"${cloneVolNum}\"\n    }\n"
        local new_json="[\n""${now_json}""]"
        echo -e "${new_json}" > ${file_name}
        chmod 666 ${file_name}
        return 0
    fi

    local lines_total=`cat ${file_name} | wc -l`
    local lines_need=$[${lines_total}-1]
    local lines_need="${lines_need}""p"
    local pro_json=`cat ${file_name} | sed -n "2,${lines_need}" 2>/dev/null`
    local now_json="    {\n        \"poolId\":\"${poolId}\",\n        \"poolName\":\"${poolName}\",\n        \"redundancyPolicy\":\"${redundancyPolicy}\",\n        \"hostNum\":\"${hostNum}\",\n        \"replicationFactor\":\"${replicationFactor}\",\n        \"storageNum\":\"${storageNum}\",\n        \"mediaType\":\"${mediaType}\",\n        \"cacheNum\":\"${cacheNum}\",\n        \"cacheMediaType\":\"${cacheMediaType}\",\n        \"volumeNum\":\"${volumeNum}\",\n        \"securityLevel\":\"${securityLevel}\",\n        \"storageCacheRate\":\"${storageCacheRate}\",\n        \"cacheDifSwitch\":\"${cacheDifSwitch}\",\n        \"mainstorageDifSwitch\":\"${mainstorageDifSwitch}\",\n        \"belongMdcIp\":\"${belongMdcIp}\",\n        \"poolStatus\":\"${poolStatus}\",\n        \"totalCapacity\":\"${totalCapacity}\",\n        \"usedCapacity\":\"${usedCapacity}\",\n        \"allocatedCapacity\":\"${allocatedCapacity}\",\n        \"freeCapacityRate\":\"${freeCapacityRate}\",\n        \"snapshotNum\":\"${snapshotNum}\",\n        \"cloneVolNum\":\"${cloneVolNum}\"\n    }\n"
    local new_json="[\n""${pro_json},""${now_json}""]"
    echo -e "${new_json}" > ${file_name}
    return 0
}

function clear_all_val()
{
    poolId=""
    poolName=""
    redundancyPolicy=""
    hostNum=""
    replicationFactor=""
    storageNum=""
    mediaType=""
    cacheNum=""
    cacheMediaType=""
    volumeNum=""
    securityLevel=""
    storageCacheRate=""
    cacheDifSwitch=""
    mainstorageDifSwitch=""
    belongMdcIp=""
    poolStatus=""
    totalCapacity=""
    usedCapacity=""
    allocatedCapacity=""
    freeCapacityRate=""
    snapshotNum=""
    cloneVolNum=""
}

function clear_vol_info()
{
    rm -f /var/log/dsware/FSM_${ip}_volumn_info_collect_result.txt
}

function clear_node_result()
{
    rm -rf /var/log/dsware/FSM_${ip}_smart_migration_info_collect_result.json
}

function queryStoragePoolById()
{
    local storagePoolInfo=`run_dswaretool_new --op queryStoragePool -id ${poolId}`

    poolName=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$2}'`
    totalCapacity=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$4}'`
    totalCapacity=$(echo $(printf "%.2f" $(echo "scale=2; (${totalCapacity})/1024/1024" | bc)))
    usedCapacity=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$5}'`
    usedCapacity=$(echo $(printf "%.2f" $(echo "scale=2; (${usedCapacity})/1024/1024" | bc)))
    allocatedCapacity=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$6}'`
    allocatedCapacity=$(echo $(printf "%.2f" $(echo "scale=2; (${allocatedCapacity})/1024/1024" | bc)))
    redundancyPolicy=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$9}'`
    replicationFactor=`echo "${storagePoolInfo}" | grep -E '^[0-9]+' | awk '{print$10}'`

    # 如果totalCapacity或usedCapacity为空，则将其设置为0
    if [[ -z "${totalCapacity}" ]]; then
        totalCapacity=0
    fi
    if [[ -z "${usedCapacity}" ]]; then
        usedCapacity=0
    fi

    if [[ "${totalCapacity}" -eq 0 ]]; then
        freeCapacityRate=0
    else
        freeCapacityRate=$(echo "scale=2; (${totalCapacity}-${usedCapacity})/${totalCapacity}" | bc)
        freeCapacityRate=$(printf "%.2f" $freeCapacityRate)
    fi
}

function get_hostNum()
{
    local hostInfo=`run_dswaretool_new --op queryStorageNodeInfo -id ${poolId}`

    hostNum="$(echo ${hostInfo} | grep -o 'nodeMgrIp' | wc -l)"
}

function get_volumeNum()
{
    local volumeInfo=`run_dswaretool_new --op queryAllVolumeDetailInfo -poolId ${poolId}`

    volumeNum=$(echo "${volumeInfo}" |grep -E "^T" |tr -cd "[0-9]")
}

function get_storage_node_info()
{
    local storage_node_info=$(run_dswaretool_new --op queryStorageNodeInfo -id ${poolId})

    storageNum=$(echo "${storage_node_info}" | grep -c 'diskSn:')
    cacheNum=$(echo "${storage_node_info}" | grep -c 'cacheEsn:')

    # storageNum或cacheNum为空，则将其设置为0
    if [[ -z "${storageNum}" ]]; then
        storageNum=0
    fi
    if [[ -z "${cacheNum}" ]]; then
        cacheNum=0
    fi
}

function get_poolStatus()
{
    poolStatus="Normal"
    local poolStatusInfo=`run_dswaretool_new --op queryStoragePoolStatus -id ${poolId}`
    local poolStatusNum=$(echo "${poolStatusInfo}" | grep -oP 'StoragePool status: \K\d+')
    if [ ${poolStatusNum} -ne 0 ];then
        poolStatus="UnNormal"
    fi
}

function get_snapshotNum()
{
    local snapShotNumInfo=`run_dswaretool_new --op queryAllSnapshot -p ${poolId}`

    snapshotNum=$(echo "${snapShotNumInfo}" | grep -oP 'Total snapshot number:\K\d+')

    if [[ -z "${snapshotNum}" ]]; then
    snapshotNum=0
    fi
}

function get_cloneVolNum()
{
    cloneVolNum=0
    DIRuner="/opt/dsware/vbs/script/vbs/vbs_cmd.sh"
    if [ ! -f "${DIRuner}" ]
    then
        return 0
    fi
    judgeEmpty=0
    # 父快照与子卷可能不在同一页
    remainTreeId=-1
    for((i=1024;i<9216;i++))
    do
        metaInfo=$("${DIRuner}" 14 1490 -35 $i | grep 'VOLUME')
        pageMessage=$(echo "${metaInfo}" | tr ',' '\n' | grep -E 'vol_name|node_key|parent_key|node_type')
        volumeMessage=$(echo -e "${volumeMessage}\n${pageMessage}")
        if [ -n "${metaInfo}" ]
        then
            judgeEmpty=0
            snapInfo=$(echo "${metaInfo}" | grep "node_type:101")
            if [ -n "${snapInfo}" ]
            then
                treeIdInfo=$(echo "${snapInfo}" | tr ',' '\n' | grep "node_key" | awk -F ':' '{print $1}' | awk -F '(' '{print $2}')
                treeIdInfo=$(echo -e "${remainTreeId}\n${treeIdInfo}")
                for treeId in $treeIdInfo
                do
                    remainTreeId=$treeId
                    cloneVolInfo=$(echo "${metaInfo}" | grep "node_key(${treeId}:" | grep "node_type:100" | grep 'node_key([0-9]\:[1-9]\:[0-9])')
                    if [ -n "${cloneVolInfo}" ]
                    then
                        branchId=$(echo "${cloneVolInfo}" | tr ',' '\n' | grep -E 'node_key|parent_key' | awk -F ':' '{print $2}')
                        nodeBranchId=$(echo "${branchId}" | tr '\n' ',' | awk -F ',' '{print $1}')
                        parBranchId=$(echo "${branchId}" | tr '\n' ',' | awk -F ',' '{print $2}')
                        if [ ! ${nodeBranchId} ==  ${parBranchId} ]
                        then
                            cloneVolNum=$(($cloneVolNum + 1))
                        fi
                    fi
                done
            fi
        else
            judgeEmpty=$(($judgeEmpty + 1))
        fi

        if [ $judgeEmpty -eq 100 ]
        then
            break
        fi
    done
    echo $cloneVolNum
}


function get_storage_info_from_TBL()
{
    if [ -z "${db_password}" ]
    then
        log ERROR "Failed to obtain the database password."
        return 1
    fi

    # 在TBL_STORAGE_POOL_INFO中查字段
    mediaType=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select STORAGEMEDIATYPE from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${mediaType}" ]]; then
    mediaType="--"
    fi
    
    cacheMediaType=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select CACHEMEDIATYPE from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${cacheMediaType}" ]]; then
    cacheMediaType="--"
    fi

    securityLevel=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select SECURITYLEVEL from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${securityLevel}" ]]; then
    securityLevel="--"
    fi

    storageCacheRate=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select STORAGECACHERATE from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${storageCacheRate}" ]]; then
    storageCacheRate=0
    fi

    cacheDifSwitch=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select CACHEDIFSWITCH from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${cacheDifSwitch}" ]]; then
    cacheDifSwitch="--"
    fi

    mainstorageDifSwitch=$(echo ${db_password} | xargs -i su - omm -c "gsql -p 21600 -W {} -XAtc 'set search_path=dsware_1;\
    select MAINSTORAGEDIFSWITCH from TBL_STORAGE_POOL_INFO where POOLID=${poolId};'")
    if [[ -z "${mainstorageDifSwitch}" ]]; then
    mainstorageDifSwitch="--"
    fi
}

function get_pool_info()
{
    # 清理全局变量
    clear_all_val

    poolId=$1
    queryStoragePoolById
    get_hostNum
    get_volumeNum
    get_storage_node_info
    get_poolStatus
    get_snapshotNum
    get_storage_info_from_TBL
    get_cloneVolNum
    # todo 完善函数

    # 输出结果
    fsm_smart_migration_json_out
    fsm_volume_info_out
}

function check_manager_version()
{
    vbs_version=`cat /opt/dsware/DSwareManagerNodeVersion | grep V100R006`
    if [ -n "$vbs_version" ]
    then
       return 0
    fi
    return 1
}

function main()
{
    #清理结果文件
    clear_node_result
    clear_vol_info
    #主FSM执行
    get_harole="/opt/omm/oms/workspace/ha/module/hacom/script/get_harole.sh"
    local harole=`sh ${get_harole} | grep active`
    if [ -z "$harole" ]
    then
        log INFO "${checkItemId} not master FSM, pass"
       return 0
    fi

    #检查存储版本
    check_manager_version
    if [ $? -ne 0 ]
    then
        log INFO "manager version is not 6.x"
        return 3
    fi

    # 获取密码
    db_password="$(GetDBPassword | awk '{print $1}')"

    # 查询存储池数量
    storage_pool_info=`run_dswaretool queryStoragePool`
    pool_nums=`echo "${storage_pool_info}" | grep -E '^[0-9]+' | awk '{print$1}'`
    for pool_id in ${pool_nums}
    do
        get_pool_info $pool_id
    done
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}