#!/bin/bash
##############################################################
## @Company: HUAWEI Tech. Co., Ltd.
## @Filename func.sh
## @Usage . func.sh
## @Description ��������
##############################################################


LOG_FILE="/var/log/dsware/fusionstorage_inspect.log"

[ -z "$OMA_PATH" ] && OMA_PATH="/opt/omm/oma/workspace/tools"
LOG_TOOL="$OMA_PATH/omm_log"

OMS_RUN_PATH="/opt/omm/oms/"

#��ʾ����
SHOW_MSG="YES"

##############################################################
## @Usage log
## @Return 0 : 
## @Description ��¼����־�ļ�
##############################################################
log()
{
    local subLv="$1" && shift
    local subTag="$1" && shift
    $LOG_TOOL "$LOG_FILE" "${subLv}" "$*" "[$subTag]($$)"
    return 0
}

##############################################################
## @Usage showMsg
## @Return 0 : 
## @Description ����ӡ��Ϣ����ΪYES����ӡ��Ϣ
##############################################################
showMsg()
{
    [ "${SHOW_MSG}" = "NO" ] && { return 0; }
    log "$@"
    echo "$@"
}

##############################################################
## @Usage getFloatIp
## @Return 0 : succ
## @Description get float ip from tomcat server.xml
##############################################################
getFloatIp()
{
    local updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
    local floatIp=$(cat $updaCfg | grep "SERVERIP=" | awk -F '=' '{print $2}');
    
    echo "$floatIp"
    return 0
}

##############################################################
## @Usage getLocalIp
## @Return 0 : succ
## @Description get local ip from tomcat server.xml
##############################################################
getLocalIp()
{
    local updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
    local localIp=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}');

    echo "$localIp"
    return 0
}

#############################################################################
# FUNCTION   : decrpt
# DESCRIPTION: decrpt an encrption word
# INPUT      : encript word
# USAGE      : xxx=$(decrpt | awk '{print}')
#############################################################################
decrpt()
{

    #declare envs.wcc修改密钥管理方式
    local parmas="$1"
    local encType="AES256"
    local rootDir="${OMS_RUN_PATH}/workspace"
    local selfDir="${OMS_RUN_PATH}/workspace/tools/encrypt"
    local wcc=$(find ${rootDir}/lib/ -maxdepth 1 -name 'wc2frm*.jar')
    local log4j=$(find ${rootDir}/lib/ -maxdepth 1 -name 'log4j*.jar')
    local commons=$(find ${rootDir}/lib/ -maxdepth 1 -name 'commons-codec*.jar')
    local javaArgs="-Dbeetle.application.home.path=${rootDir}/security/config"
    local classpath="${wcc}:${log4j}:${commons}:${selfDir}/main.jar"
    local className="com.omm.encrypt.DecryptCommandWithoutParam"
    local java_cmd="${OMS_RUN_PATH}/jre/bin/java -cp ${classpath} ${javaArgs} ${className}"

    #check params
    if [ -z "$parmas" ]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encript word is necessary parameter.";         
        return 1
    fi
    
    #加密类型这里以新老版本的加密脚本为准，只要支持AES256_CBC，则均使用此加密模式
    local isSupCBC=$(${OMS_RUN_PATH}/tools/encrypt/encryptWithoutParam.sh | grep -w "AES256_CBC")
    if [ -n "$isSupCBC" ]; then
        encType="AES256_CBC"
    fi
    
    local result=`${java_cmd} 2>/dev/null <<EOF
strSrc:$parmas
encType:$encType
EOF`
    if [[ "$result" =~ "ERROR" ]]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas failed!"
        return 1
    fi
    if [[ "$result" =~ "ception" ]]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas cause exceptsion!"
        return 1
    fi
    if [ -z "$result" ]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas result is null!"
        return 1
    fi
    
    echo "$result"
    log "INFO" "$g_scriptName:$LINENO(decrpt)" "Exit decrpt."
    return 0
}

##############################################################
## @Usage GetDBPassword 
## @Return 0 : 
## @Description 获取GSDB数据库密码
##############################################################
GetDBPassword()
{           
    #1.判断两个工具脚本存在与否
    local getCipherKeyTool="${OMS_RUN_PATH}/tools/getdbNameOrPasswd"
    [ -e "${getCipherKeyTool}" ] || { log "ERROR" "$g_scriptName:$LINENO(alterschema)" "${getCipherKeyTool} is not exist."; return 1; }

    local CipherKey=$(${getCipherKeyTool} 2 | awk '{print '$1'}')
    if [ -z "${CipherKey}" ];then
        log "ERROR" "$g_scriptName:$LINENO(alterschema)" "OMS's DB CipherKey is empty."
        return 1; 
    fi 

    local DecryptKey=$(decrpt ${CipherKey} | awk '{print}')
    if [ -z "${DecryptKey}" ];then
        log "ERROR" "$g_scriptName:$LINENO(alterschema)" "OMS's DecryptKey is empty.";
        return 1; 
    fi

    echo ${DecryptKey};
    return 0;
}

##############################################################
## @Usage: Converting an Incompatible Time Zone to a Compatible Mode
## @Parameter: $1 string
## @Return: 0 succ; others: failed
## @Description: translate a string value
##############################################################
function timeTranslate()
{
    local confPath=$(dirname $0)
    local sysTime=$1
    local timeZone=$(echo "$sysTime" | awk -F ' ' '{print $5}')
    local isTranslate=$(cat ${OMS_RUN_PATH}/workspace/tools/timeConf | grep -w "$timeZone")
    
    if [ -n "$isTranslate" ]
    then
        local translateTime=$(echo "$isTranslate" | awk -F ' ' '{print $2}')
        local tempTime=$(echo "$sysTime" | sed "s/${timeZone}/${translateTime}/g" 2>/dev/null)
        echo "$tempTime"
        return 0
    fi
    echo "$sysTime"
    return 0
}

##############################################################
## @Usage: decript string by kmc
## @Parameter: $1 string
## @Return: 0 succ; others: failed
## @Description: decript a string value
##############################################################
function decrptByKMC()
{
    local cipher="$1"
    if [ -z "${cipher}" ]; then
        log "ERROR" "empty cipher!"
        return 1
    fi

    export LD_LIBRARY_PATH="/opt/dsware/tools/kmc/lib"
    [ -f "/etc/profile.d/omm-oms.sh" ] && source /etc/profile.d/omm-oms.sh >/dev/null 2>&1
    local rootDir="/opt/omm/oms/workspace"
    local selfDir="/opt/omm/oma/atoms/Inspect/lib"
    local FSM_DOMAIN_ID=2
    local wcc=$(find ${rootDir}/lib/ -maxdepth 1 -name 'wc2frm*.jar')
    local log4j=$(find ${rootDir}/webapps/dsware/WEB-INF/lib/ -maxdepth 1 -name 'log4j*' | awk '{printf $0":"}' | awk '{print substr($0,0,length($0)-1)}')
    local commons=$(find ${rootDir}/lib/ -maxdepth 1 -name 'commons-codec*.jar')
    local jna=$(find ${rootDir}/lib/ -maxdepth 1 -name 'jna*.jar')
    local javaArgs="-Dbeetle.application.home.path=${rootDir}/security/config"
    local classpath="${wcc}:${log4j}:${commons}:${jna}:${selfDir}/mainKMC.jar"
    local className="com.omm.encrypt.kmc.DecryptCommandByKMC"
    local java_cmd="/opt/omm/oms/jre/bin/java -cp ${classpath} ${javaArgs} ${className}"

    local result=$(${java_cmd} "${cipher}" "${FSM_DOMAIN_ID}" 2>>/dev/null)
    if [ -z "${result}" ]; then
        log "ERROR" "decrypt failed!"
        return 1
    fi

    echo "${result}"
    return 0
}