#!/bin/bash

function get_package_version()
{
    local package_cfg_file="/opt/dsware/update/work/Precheck/package.cfg"
    local version_in_pkg="$(cat ${package_cfg_file} | grep targetVersion)"
    eval ${version_in_pkg}
    echo "${targetVersion}"
}

function get_src_version()
{
    local node_version_file="/opt/dsware/DSwareAgentNodeVersion"
    local node_version_fsm_file="/opt/dsware/DSwareManagerNodeVersion"
    
    if [ -f "${node_version_file}" ]
    then
        srcVersion="$(cat "${node_version_file}" | grep "nodeVersion=" | awk -F"=" '{print $2}')"
    elif [ -f "${node_version_fsm_file}" ]
    then
        srcVersion="$(cat "${node_version_fsm_file}" | grep "nodeVersion=" | awk -F"=" '{print $2}')"
    fi
    
    echo "${srcVersion}"
}
#是否要在manager上执行检查项
function manager_items_check()
{
    local current_id=$1
    cat /opt/omm/oma/atoms/Inspect/package.cfg | grep ManagerCheckItems | grep $current_id > /dev/null

    if [ $? -eq 0 ]
    then
       return 0
    fi
    return 1

}
function agent_items_check()
{
    local current_id=$1
    cat /opt/omm/oma/atoms/Inspect/package.cfg | grep AgentCheckItems| grep $current_id > /dev/null
    if [ $? -eq 0 ]
    then
       return 0
    fi
    return 1

}
