--------------------------------------------------------------------------------
--                   Copyright, 2012-2013, Huawei Tech. Co., Ltd.
--                             All Rights Reserved
--------------------------------------------------------------------------------
-- Project Code    : OMM UPD V1.0
-- File name       : upd_atoms.lua
-- Description     : DSware Agentļ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2012.1.12
--    Modification : ļ
--------------------------------------------------------------------------------

function UpdFrame_GetFileName(path)  
    local ts = string.reverse(path)  
    local param1, param2 = string.find(ts, "/")
    local m = string.len(path) - param2 + 1     
    local result = string.sub(path, m+1, string.len(path)-4)   
    return result  
end  

function UpdFrame_IsDir(path)
    path = path.."/"
    local file = io.open(path, "rb")
    if file then file:close() end
    return file ~= nil
end

function UpdFrame_LoadSubFlowFile(flowPath)
    local dirMatch = "%/$"
    local luaMatch = "%.lua$"
    
    local cmd = "find * " .. flowPath .." | grep " .. flowPath
    local fileList = io.popen(cmd)
    
    local lastChar = string.sub(package.path, -1, -1)
    if (lastChar ~= ";") then
        package.path = package.path..";"
    end
    LogText(LL_NOTICE, "package.path = " .. package.path)
    
    -- package.pathlua·ʱǷѴ·ȥ
    if (nil ~= string.find(flowPath, "/Service/lua/Agent/") or nil ~= string.find(flowPath, "/opt/omm/oma/flow/default/") ) then
        local pathTmp = ""
        local pathArray = nil
        pathArray = Split(package.path, ";")
        if (nil ~= pathArray) then
            for i = 1, #pathArray do
                if (nil == string.find(pathArray[i], "/opt/omm/oma/flow/default/") and nil == string.find(pathArray[i], "/Service/lua/Agent/") ) then
                    pathTmp = pathTmp..pathArray[i]
                    if (string.sub(pathTmp, -1) ~= ";") then
                        pathTmp = pathTmp..";"
                    end
                end
            end
            
            if ("" ~= pathTmp) then
                package.path = pathTmp
            end
            LogText(LL_NOTICE, "pathTmp = " .. package.path)
        end
    end
    
    for file in fileList:lines() do
        LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to load lua dir = " .. file)
        if (UpdFrame_IsDir(file)) then
            if (nil == string.find(package.path, file)) then
                LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to add lua dir = " .. file)
                package.path = package.path..file.."/?.lua;"
            end
        end
        LogText(LL_NOTICE, "package.path = " .. package.path)
        if string.find(file, luaMatch) then
            local filename = UpdFrame_GetFileName(file)
            LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to load lua file = " .. file.." "..filename)
            package.loaded[filename] = nil
            require(filename)
        end
    end
    io.close(fileList)
end

UpdFrame_LoadSubFlowFile("/opt/omm/oma/flow/comm")
local luaFile = io.open("/opt/omm/oma/flow/upda_lua_path", "r");
if (luaFile == nil) then
    LogText(LL_NOTICE, "Load default")
    UpdFrame_LoadSubFlowFile("/opt/omm/oma/flow/default/")
else
    local luaPath = string.sub(luaFile:read("*all"), 1, -2);
    if (luaPath == "" or luaPath == nil) then
        LogText(LL_NOTICE, "Load default")
        UpdFrame_LoadSubFlowFile("/opt/omm/oma/flow/default/")
    else
        luaPath = luaPath.."/Service/lua/Agent/"
        UpdFrame_LoadSubFlowFile(luaPath)
    end
end

-------------------------------------------------------------------------------
--------------------------------- AtomGroupȫֱ start ---------------------
-------------------------------------------------------------------------------
-- AtomGroupִ״̬
g_UpdState =
{
    FlowId = 0,        --ǰִе̵ˮ
    AtomGroup = "",    --ǰִеԭ
    NodeIp = "",       --ǰڵIPַ
    NodeIndex = "",
    Step = "",         --ǰ
    ParamList = {},    --б
    Result = 0,        --ԭִн
    OmsWorkspace = "", --Ͱ汾OMS workspaceָĿ¼
    OmaWorkspace = ""  --Ͱ汾OMA workspaceָĿ¼
}

-- ȡϢʱԼ,15Σÿμ5S
function GetMsgRetryInfo()
    return 180, 5
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_Retry
-- Description     : ԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.10
--    Modification : ļ
--------------------------------------------------------------------------------
function UpdFrame_Retry(atom, ret)
    local _retry;
    _retry = function (atom, ret, times, interval)
        if (times <= 0) then
            return ret;
        end

        if (atom.retry[ret] ~= nil) then
            if (atom.retry[ret][1] <= 0) then
                return ret;
            end
        else
            if (atom.retry['other'] == nil) then
                return ret;
            else
                if (atom.retry['other'][1] <= 0) then
                    return ret;
                end
            end
        end

        os.execute("sleep " .. interval);
        local ret = atom.func();
        return _retry(atom, ret, times - 1, interval);
    end

    if (atom ~= nil) and (atom.retry ~= nil) then
        if (atom.retry[ret] ~= nil) then
            local times = atom.retry[ret][1];
            local interval = atom.retry[ret][2];
            if (times <= 0) or (interval < 0) then
                LogText(LL_NOTICE, "(UpdFrame_Retry) Times or interval is zero.");
                return ret;
            end

            os.execute("sleep " .. interval);
            local ret = atom.func();
            return _retry(atom, ret, times - 1, interval);
        elseif (atom.retry['other'] ~= nil) then
            local times = atom.retry['other'][1];
            local interval = atom.retry['other'][2];
            if (times <= 0) or (interval < 0) then
                LogText(LL_NOTICE, "(UpdFrame_Retry) Times or interval is zero.");
                return ret;
            end

            os.execute("sleep " .. interval);
            local ret = atom.func();
            return _retry(atom, ret, times - 1, interval);
        else --ӦĴ벻Ҫ
            return ret;
        end
    else --Ҫ
        return ret;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : ReportAgentExecing
-- Description     : ϱԭִ Ϊ20000ʾڵִԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function ReportAgentExecing()
    -- дԭϱ
    local execResult = {};
    local isFrame = IsFrameVersion()
    if(g_UpdState.NodeIp ~= nil or g_UpdState.NodeIp ~= "" or g_UpdState.AtomGroup ~= nil or g_UpdState.AtomGroup ~= "")then
        execResult.node_ip = g_UpdState.NodeIp
        execResult.atom_group = g_UpdState.AtomGroup
        execResult.atom = g_UpdState.Step;
        execResult.start_time = os.time();
        execResult.progress = 100;
        execResult.error_code = 0;
        execResult.result = ATOM_RET_EXECING;
        execResult.end_time = os.time();
        LogText(LL_INFO, "Node (" .. g_UpdState.NodeIp .. ") run atom group (" .. g_UpdState.AtomGroup .. ") and report execing.");
        if (isFrame) then
            execResult.node_index = g_UpdState.NodeIndex
            ReportAtomExecResultWithParam(execResult)
        else
            ReportAtomExecResult(execResult)
        end
    else
        LogText(LL_INFO, "Node ip is nil or atom group is nil.");
    end

end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_Run
-- Description     : ִָԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function UpdFrame_Run(FlowId, NodeIp, Index, AtomGroup, inputParamList)
    LogText(LL_INFO, "Node (" .. NodeIp .. ") run atom group (" .. AtomGroup .. "), flow id: " .. FlowId .. ", param list: " .. inputParamList.." "..Index);

    --ظִ, ֱӷϴεִн
    if (FlowId == g_UpdState.FlowId) and (NodeIp == g_UpdState.NodeIp) and (AtomGroup == g_UpdState.AtomGroup) then
        LogText(LL_WARN, "Repeated task.");
        return g_UpdState.Result;
    end

    -- ҵԭӣʼִ
    local ag_tbl = GetAtomGroupTbl(AtomGroup)
    if (ag_tbl == nil or next(ag_tbl) == nil) then
        LogText(LL_ERROR, "Fail to get atom group table.");
    end
    local atom_name = ag_tbl.entry;
    local next_atom = ag_tbl[atom_name];
    
    g_UpdState.FlowId = FlowId;
    g_UpdState.AtomGroup = AtomGroup;
    g_UpdState.NodeIp = NodeIp;
    g_UpdState.NodeIndex = Index;
    g_UpdState.ParamList = {};
    --local func = loadstring("return " .. ParamList); --ַתtable
    --g_UpdState.ParamList = func();
    LogText(LL_INFO, "ParamList = "..inputParamList)
    local pList = Split(inputParamList, ",")
    LogText(LL_INFO, "paramList = "..Table2String(pList))
    if (pList ~= nil) then
        for _, param in pairs(pList) do
            local kv = Division(param, "=")
            LogText(LL_INFO, "Node = "..Table2String(kv))
            local key = kv[1]
            local value = kv[2]
            g_UpdState.ParamList[key] = value
        end
    end
    g_UpdState.Step = atom_name;
    g_UpdState.Result = RET_INIT;
    SaveState(g_UpdState);
    LogText(LL_INFO, "Node exec atom group start.");
    Fsync();

    -- дԭϱ
    local execResult = {};
    execResult.node_ip = NodeIp;
    execResult.atom_group = AtomGroup;
    execResult.atom = atom_name;
    execResult.start_time = os.time();
    execResult.progress = next_atom.progress;
    execResult.node_index = g_UpdState.NodeIndex
    
    -- ִԭ
    local ret = next_atom.func();
    ret = UpdFrame_Retry(next_atom, ret); --Զԭ
    LogText(LL_INFO, "Atom (".. atom_name .. ") exec result: " .. ret);

    -- дִн
    if (0 ~= ret) then
        execResult.error_code = OFFSET + ret;
    else
        execResult.error_code = ret;
    end

    if (next_atom.retstate[ret] == "#Succ") then
        execResult.error_code = 0;
        execResult.result = ATOM_RET_SUCC;
    else
        execResult.result = ATOM_RET_FAIL;
    end

    execResult.end_time = os.time();

    -- ϱԭִн
    if((next_atom.retstate[ret] ~= "#Succ") or (next_atom.isReport == nil ) or (next_atom.isReport == true)) then
        ReportAtomExecResultWithParam(execResult);
    end

    local next_atom_name = next_atom.retcode[ret];
    while (true) do
        if (next_atom_name == nil) then
            LogText(LL_WARN, "Atom return unexpected code: " .. ret);

            next_atom_name = next_atom.retcode['other'];
            if (next_atom_name == nil) then
                LogText(LL_ERROR, "Not configured 'other'.");
                g_UpdState.Result = RET_FAIL;
                SaveState(g_UpdState);
                LogText(LL_INFO, "Node exec atom group finish and failed.");
                Fsync();
                return RET_FAIL;
            end
        end

        g_UpdState.Step = next_atom_name;
        SaveState(g_UpdState);

        LogText(LL_INFO, "---Next atom name: " .. next_atom_name .. "---");
        if (next_atom_name == "#SuccExit") then
            g_UpdState.Result = RET_SUCC;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and succeed.");
            Fsync();
            return RET_SUCC;
        elseif (next_atom_name == "#SuccRbk") then
            g_UpdState.Result = RET_RBK_SUCC;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and rbk succeed.");
            Fsync();
            return RET_RBK_SUCC;
        elseif (next_atom_name == "#FailExit") then
            g_UpdState.Result = RET_FAIL;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and failed.");
            Fsync();
            return RET_FAIL;
        else
            next_atom = ag_tbl[next_atom_name];

            -- дԭִн
            execResult.atom = next_atom_name;
            execResult.progress =  next_atom.progress;
            execResult.start_time = os.time();
            execResult.node_index = g_UpdState.NodeIndex
            
            ret = next_atom.func();
            ret = UpdFrame_Retry(next_atom, ret); --Զԭ
            LogText(LL_INFO, "Atom (".. next_atom_name .. ") exec result: " .. ret);

            if (0 ~= ret) then --ƫ
                execResult.error_code = OFFSET + ret;
            else
                execResult.error_code = ret;
            end

            if (next_atom.retstate[ret] == "#Succ") then
                execResult.error_code = 0
                execResult.result = ATOM_RET_SUCC;
            else
                execResult.result = ATOM_RET_FAIL;
            end

            execResult.end_time = os.time();

            -- ϱԭִн
            if((next_atom.retstate[ret] ~= "#Succ") or (next_atom.isReport == nil ) or (next_atom.isReport == true)) then
                ReportAtomExecResultWithParam(execResult);
            end

            next_atom_name = ag_tbl[next_atom_name].retcode[ret];
        end
    end

    g_UpdState.Result = RET_SUCC;
    SaveState(g_UpdState);
    LogText(LL_INFO, "Node exec atom group finish and succeed.");
    Fsync();
    return RET_SUCC;
end

--------------------------------------------------------------------------------
-- Func Name       : Run
-- Description     : ִָԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function Run(FlowId, NodeIp, AtomGroup, inputParamList)
    LogText(LL_INFO, "Node (" .. NodeIp .. ") run atom group (" .. AtomGroup .. "), flow id: " .. FlowId .. ", param list: " .. inputParamList);

    --ظִ, ֱӷϴεִн
    if (FlowId == g_UpdState.FlowId) and (NodeIp == g_UpdState.NodeIp) and (AtomGroup == g_UpdState.AtomGroup) then
        LogText(LL_WARN, "Repeated task.");
        return g_UpdState.Result;
    end

    -- ҵԭӣʼִ
    local ag_tbl = GetAtomGroupTbl(AtomGroup)
    if (ag_tbl == nil or next(ag_tbl) == nil) then
        LogText(LL_ERROR, "Fail to get atom group table.");
    end
    local atom_name = ag_tbl.entry;
    local next_atom = ag_tbl[atom_name];
    
    g_UpdState.FlowId = FlowId;
    g_UpdState.AtomGroup = AtomGroup;
    g_UpdState.NodeIp = NodeIp;
    g_UpdState.ParamList = {};
    --local func = loadstring("return " .. ParamList); --ַתtable
    --g_UpdState.ParamList = func();
    LogText(LL_INFO, "ParamList = "..inputParamList)
    local pList = Split(inputParamList, ",")
    LogText(LL_INFO, "paramList = "..Table2String(pList))
    if (pList ~= nil) then
        for _, param in pairs(pList) do
            local kv = Division(param, "=")
            LogText(LL_INFO, "Node = "..Table2String(kv))
            local key = kv[1]
            local value = kv[2]
            g_UpdState.ParamList[key] = value
        end
    end
    g_UpdState.Step = atom_name;
    g_UpdState.Result = RET_INIT;
    SaveState(g_UpdState);
    LogText(LL_INFO, "Node exec atom group start.");
    Fsync();

    -- дԭϱ
    local execResult = {};
    execResult.node_ip = NodeIp;
    execResult.atom_group = AtomGroup;
    execResult.atom = atom_name;
    execResult.start_time = os.time();
    execResult.progress = next_atom.progress;

    -- ִԭ
    local ret = next_atom.func();
    ret = UpdFrame_Retry(next_atom, ret); --Զԭ
    LogText(LL_INFO, "Atom (".. atom_name .. ") exec result: " .. ret);

    -- дִн
    if (0 ~= ret) then
        execResult.error_code = OFFSET + ret;
    else
        execResult.error_code = ret;
    end

    if (next_atom.retstate[ret] == "#Succ") then
        execResult.error_code = 0;
        execResult.result = ATOM_RET_SUCC;
    else
        execResult.result = ATOM_RET_FAIL;
    end

    execResult.end_time = os.time();

    -- ϱԭִн
    if((next_atom.retstate[ret] ~= "#Succ") or (next_atom.isReport == nil ) or (next_atom.isReport == true)) then
        ReportAtomExecResult(execResult);
    end

    local next_atom_name = next_atom.retcode[ret];
    while (true) do
        if (next_atom_name == nil) then
            LogText(LL_WARN, "Atom return unexpected code: " .. ret);

            next_atom_name = next_atom.retcode['other'];
            if (next_atom_name == nil) then
                LogText(LL_ERROR, "Not configured 'other'.");
                g_UpdState.Result = RET_FAIL;
                SaveState(g_UpdState);
                LogText(LL_INFO, "Node exec atom group finish and failed.");
                Fsync();
                return RET_FAIL;
            end
        end

        g_UpdState.Step = next_atom_name;
        SaveState(g_UpdState);

        LogText(LL_INFO, "---Next atom name: " .. next_atom_name .. "---");
        if (next_atom_name == "#SuccExit") then
            g_UpdState.Result = RET_SUCC;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and succeed.");
            Fsync();
            return RET_SUCC;
        elseif (next_atom_name == "#SuccRbk") then
            g_UpdState.Result = RET_RBK_SUCC;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and rbk succeed.");
            Fsync();
            return RET_RBK_SUCC;
        elseif (next_atom_name == "#FailExit") then
            g_UpdState.Result = RET_FAIL;
            SaveState(g_UpdState);
            LogText(LL_INFO, "Node exec atom group finish and failed.");
            Fsync();
            return RET_FAIL;
        else
            next_atom = ag_tbl[next_atom_name];

            -- дԭִн
            execResult.atom = next_atom_name;
            execResult.progress =  next_atom.progress;
            execResult.start_time = os.time();

            ret = next_atom.func();
            ret = UpdFrame_Retry(next_atom, ret); --Զԭ
            LogText(LL_INFO, "Atom (".. next_atom_name .. ") exec result: " .. ret);

            if (0 ~= ret) then --ƫ
                execResult.error_code = OFFSET + ret;
            else
                execResult.error_code = ret;
            end

            if (next_atom.retstate[ret] == "#Succ") then
                execResult.error_code = 0
                execResult.result = ATOM_RET_SUCC;
            else
                execResult.result = ATOM_RET_FAIL;
            end

            execResult.end_time = os.time();

            -- ϱԭִн
            if((next_atom.retstate[ret] ~= "#Succ") or (next_atom.isReport == nil ) or (next_atom.isReport == true)) then
                ReportAtomExecResult(execResult);
            end

            next_atom_name = ag_tbl[next_atom_name].retcode[ret];
        end
    end

    g_UpdState.Result = RET_SUCC;
    SaveState(g_UpdState);
    LogText(LL_INFO, "Node exec atom group finish and succeed.");
    Fsync();
    return RET_SUCC;
end

--̸λִָеǰ
--------------------------------------------------------------------------------
-- Func Name       :
-- Description     :
-- Caution         :
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function Resume()
    LogText(LL_NOTICE, "Resume: AtomGroup=" .. g_UpdState.AtomGroup .. " Step=" .. g_UpdState.Step);

    if ((nil == g_UpdState) or (nil == g_UpdState.AtomGroup) or ("" == g_UpdState.AtomGroup)) then
        return RET_INIT;
    end
    local isFrame = IsFrameVersion()
    -- Ϊ˽˹ݿУϵͳߵ磬ᵼ޷ָ˹ݿ
    -- ҪupdaĻָ׶Σommgsdbha.sh.bakļҪupda˹ݿ
    local fn = "/opt/omm/oms/workspace/ha/module/hacom/script/start_ha.sh";
    local f = io.open(fn, "r");
    if (nil ~= f) then
        System("/opt/omm/oma/atoms/common/startHAAndDBInW.sh", EIGHT_MINUTES);
    end
    
    if (g_UpdState.Step == "") then
        LogText(LL_ERROR, "Resume step is empty, AtomGroup=" .. g_UpdState.AtomGroup);
        return RET_FAIL
        --return Run(g_UpdState.FlowId, g_UpdState.NodeIp, g_UpdState.AtomGroup, Table2String(g_UpdState.ParamList));
    elseif (g_UpdState.Step == "#SuccExit") then
        g_UpdState.Result = RET_SUCC;
        SaveState(g_UpdState);
        return RET_SUCC;
    elseif (g_UpdState.Step == "#SuccRbk") then
        g_UpdState.Result = RET_RBK_SUCC;
        SaveState(g_UpdState);
        return RET_RBK_SUCC;
    elseif (g_UpdState.Step == "#FailExit") then
        g_UpdState.Result = RET_FAIL;
        SaveState(g_UpdState);
        return RET_FAIL;
    end

    -- ҵǰִеԭӣִ
    local ag_tbl = GetAtomGroupTbl(g_UpdState.AtomGroup)
    if (ag_tbl == nil or next(ag_tbl) == nil) then
        LogText(LL_ERROR, "Fail to get atom group table.");
    end
    local atom = ag_tbl[g_UpdState.Step];
    if (atom == nil) then
        LogText(LL_INFO, "Not found atom: " .. g_UpdState.Step);
        g_UpdState.Result = RET_FAIL;
        SaveState(g_UpdState);
        return RET_FAIL;
    end

    -- дԭϱ
    local execResult = {}
    execResult.node_ip = g_UpdState.NodeIp
    execResult.atom_group = g_UpdState.AtomGroup
    execResult.atom = g_UpdState.Step;
    execResult.start_time = os.time();
    execResult.progress = atom.progress;

    -- ִԭ
    local ret = atom.func();
    ret = UpdFrame_Retry(atom, ret); --Զԭ
    LogText(LL_INFO, "Atom (".. g_UpdState.Step .. ") exec result: " .. ret);

    -- дִн
    if (0 ~= ret) then
        execResult.error_code = OFFSET + ret;
    else
        execResult.error_code = ret;
    end

    if (atom.retstate[ret] == "#Succ") then
        execResult.error_code = 0
        execResult.result = ATOM_RET_SUCC;
    else
        execResult.result = ATOM_RET_FAIL;
    end

    execResult.end_time = os.time();

    -- ϱԭִн
    if((atom.retstate[ret] ~= "#Succ") or (atom.isReport == nil ) or (atom.isReport == true)) then
        if (isFrame) then
            execResult.node_index = g_UpdState.NodeIndex
            ReportAtomExecResultWithParam(execResult)
        else
            ReportAtomExecResult(execResult)
        end
    end

    local next_atom_name = atom.retcode[ret];
    if (nil == next_atom_name) then
        LogText(LL_WARN, "Atom return unexpected code: " .. ret);

        next_atom_name = atom.retcode['other'];
        if (next_atom_name == nil) then
            LogText(LL_ERROR, "Not configured 'other'.");
            g_UpdState.Result = RET_FAIL;
            SaveState(g_UpdState);
            return RET_FAIL;
        end
    end

    while (true) do
        g_UpdState.Step = next_atom_name;
        SaveState(g_UpdState);

        LogText(LL_INFO, "---" .. next_atom_name .. "---");
        if (next_atom_name == "#SuccExit") then
            g_UpdState.Result = RET_SUCC;
            SaveState(g_UpdState);
            return RET_SUCC;
        elseif (next_atom_name == "#SuccRbk") then
            g_UpdState.Result = RET_RBK_SUCC;
            SaveState(g_UpdState);
            return RET_RBK_SUCC;
        elseif (next_atom_name == "#FailExit") then
            g_UpdState.Result = RET_FAIL;
            SaveState(g_UpdState);
            return RET_FAIL;
        else
            local next_atom = ag_tbl[next_atom_name];

            -- дִн
            execResult.atom = next_atom_name;
            execResult.progress = next_atom.progress;
            execResult.start_time = os.time();

            -- ִԭ
            ret = next_atom.func();
            ret = UpdFrame_Retry(next_atom, ret); --Զԭ
            LogText(LL_INFO, "Atom (".. next_atom_name .. ") exec result: " .. ret);

            if (0 ~= ret) then -- ƫ
                execResult.error_code = OFFSET + ret;
            else
                execResult.error_code = ret;
            end

            if (next_atom.retstate[ret] == "#Succ") then
                execResult.error_code = 0
                execResult.result = ATOM_RET_SUCC;
            else
                execResult.result = ATOM_RET_FAIL;
            end

            execResult.end_time = os.time();

            -- ϱԭִн
            if((next_atom.retstate[ret] ~= "#Succ") or (next_atom.isReport == nil ) or (next_atom.isReport == true)) then
                if (isFrame) then
                    execResult.node_index = g_UpdState.NodeIndex
                    ReportAtomExecResultWithParam(execResult)
                else
                    ReportAtomExecResult(execResult)
                end
            end

            next_atom_name = ag_tbl[next_atom_name].retcode[ret];
            if (next_atom_name == nil) then
                LogText(LL_WARN, "Atom return unexpected code: " .. ret);

                next_atom_name = next_atom.retcode['other'];
                if (next_atom_name == nil) then
                    LogText(LL_ERROR, "Not configured 'other'.");
                    g_UpdState.Result = RET_FAIL;
                    SaveState(g_UpdState);
                    return RET_FAIL;
                end
            end
        end
    end

    g_UpdState.Result = RET_SUCC;
    SaveState(g_UpdState);
    return RET_SUCC;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetCurTask
-- Description     : ȡǰִеϢ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ1: int ִн, RET_OK: ɹ, RET_ERR: ʧ
--                   ֵ2: int ̵ˮ
--                   ֵ3: string ԭ
--                   ֵ4: string ڵIPַ
--------------------------------------------------------------------------------
function UpdFrame_GetCurTask()
    if (g_UpdState == nil) then
        return RET_ERR, nil, nil, nil, nil;
    else
        return RET_OK, g_UpdState.FlowId, g_UpdState.AtomGroup, g_UpdState.NodeIp, g_UpdState.NodeIndex;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : GetCurTask
-- Description     : ȡǰִеϢ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ1: int ִн, RET_OK: ɹ, RET_ERR: ʧ
--                   ֵ2: int ̵ˮ
--                   ֵ3: string ԭ
--                   ֵ4: string ڵIPַ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013-03-09
--    Modification : 
--------------------------------------------------------------------------------
function GetCurTask()
    if (g_UpdState == nil) then
        return RET_ERR, nil, nil, nil;
    else
        return RET_OK, g_UpdState.FlowId, g_UpdState.AtomGroup, g_UpdState.NodeIp;
    end
end

--ļм״̬
--------------------------------------------------------------------------------
-- Func Name       :
-- Description     :
-- Caution         :
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function LoadState()
    local fn = "/opt/omm/tmp/upd_state_atoms.lua";
    local f = io.open(fn, "r");
    if (nil == f) then
        LogText(LL_WARN, "Can not read flows state file.");
        return;
    end

    local s = f:read("*all");
    f:close();
    if (s == nil) or (s == "") then
        LogText(LL_WARN, "Atom state file is blank.");
        return;
    end

    s = "return " .. s;
    local func = loadstring(s);
    if (nil == func) then
        LogText(LL_WARN, "No content in flows state file.");
        return;
    end
    g_UpdState = func();
    LogText(LL_INFO, "LoadState g_UpdState.ParamList= "..Table2String(g_UpdState.ParamList))
end

--------------------------------------------------------------------------------
-- Func Name       :
-- Description     : ־û״̬ļ
-- Caution         :
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function SaveState()
    if (nil == g_UpdState) then
        LogText(LL_ERROR, "The state table is nil.");
        return;
    end

    local s = Serialize(g_UpdState);
    LogText(LL_INFO, "Serialized upd state:\n" .. s);
    local fn = "/opt/omm/tmp/upd_state_atoms.lua.tmp";
    local f = io.open(fn, "w+");
    if (nil == f) then
        os.execute("if [ ! -d /opt/omm/tmp ]; then  mkdir /opt/omm/tmp; fi");
        f = io.open(fn, "w+");
        if (nil == f) then
            LogText(LL_WARN, "Can not open flows state file.");
            return;
        end
    end

    f:write(s);
    f:flush();
    f:close();
    System("mv -f /opt/omm/tmp/upd_state_atoms.lua.tmp /opt/omm/tmp/upd_state_atoms.lua", 1)
    System("chmod 600 /opt/omm/tmp/upd_state_atoms.lua", 1);
end

-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------Դ--------------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

g_InitFrameVersion = "uninit" -- Ƿȡܰ汾
g_IsFrameVersion = true       -- ܰ汾

function IsFrameVersion()
    local isFrame = true
    if (g_InitFrameVersion == "uninit") then
        if CheckDswareVersion then
            isFrame = CheckDswareVersion()
        end
        g_InitFrameVersion = "init"
        g_IsFrameVersion = isFrame
        LogText(LL_NOTICE, "Init g_IsFrameVersion")
    else
        LogText(LL_NOTICE, "Return g_IsFrameVersion")
        isFrame = g_IsFrameVersion
    end

    if (isFrame) then
        LogText(LL_NOTICE, "g_IsFrameVersion is 1")
    else
        LogText(LL_NOTICE, "g_IsFrameVersion is 0")
    end

    return isFrame
end

-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------Դ--------------------------------------------------------
--------------------------------------------------------END----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------
