--------------------------------------------------------------------------------
--                   Copyright, 2012-2013, Huawei Tech. Co., Ltd.
--                             All Rights Reserved
--------------------------------------------------------------------------------
-- Project Code    : OMM UPD V1.0
-- File name       : upd_flows.lua
-- Description     : DSware Serverļ
--------------------------------------------------------------------------------

-----------------------------------------------------------------------------------------------------------------------
--------------------------/opt/omm/oms/flow/comm/upd_lua_path·µlua-------------------------------------
----------------------------------------------------START--------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetFileName
-- Description     : ȡĿ¼µļ
-- Caution         : OMMά, ޸
-- Input           : ļĿ¼
-- Output          : 
-- Return          : ļ
--------------------------------------------------------------------------------
function UpdFrame_GetFileName(path)
    local ts = string.reverse(path)  
    local param1, param2 = string.find(ts, "/")
    local m = string.len(path) - param2 + 1     
    local result = string.sub(path, m+1, string.len(path)-4)   
    return result  
end  

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsDir
-- Description     : жǷĿ¼
-- Caution         : OMMά, ޸
-- Input           : ·
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_IsDir(path)
    path = path.."/"
    local file = io.open(path, "rb")
    if file then file:close() end
    return file ~= nil
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadSubFlowFile
-- Description     : ·µlua
-- Caution         : OMMά, ޸
-- Input           : ·
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadSubFlowFile(flowPath)
    local dirMatch = "%/$"
    local luaMatch = "%.lua$"
    
    local cmd = "find * " .. flowPath .." | grep " .. flowPath
    local fileList = io.popen(cmd)
    
    local lastChar = string.sub(package.path, -1, -1)
    if (lastChar ~= ";") then
        package.path = package.path..";"
    end
    LogText(LL_NOTICE, "package.path = " .. package.path)
    
    -- package.pathlua·ʱǷѴ·ȥ
    if (nil ~= string.find(flowPath, "/Service/lua/Manager/") or nil ~= string.find(flowPath, "/opt/omm/oms/flow/default/") ) then
        local pathTmp = ""
        local pathArray = nil
        pathArray = Split(package.path, ";")
        if (nil ~= pathArray) then
            for i = 1, #pathArray do
                if (nil == string.find(pathArray[i], "/opt/omm/oms/flow/default/") and nil == string.find(pathArray[i], "/Service/lua/Manager/") ) then
                    pathTmp = pathTmp..pathArray[i]
                    if (string.sub(pathTmp, -1) ~= ";") then
                        pathTmp = pathTmp..";"
                    end
                end
            end
            
            if ("" ~= pathTmp) then
                package.path = pathTmp
            end
            LogText(LL_NOTICE, "pathTmp = " .. package.path)
        end
    end
    
    for file in fileList:lines() do
        LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to load lua dir = " .. file)
        if (UpdFrame_IsDir(file)) then
            if (nil == string.find(package.path, file)) then
                LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to add lua dir = " .. file)
                package.path = package.path..file.."/?.lua;"
            end
        end
        LogText(LL_NOTICE, "package.path = " .. package.path)
        if string.find(file, luaMatch) then
            local filename = UpdFrame_GetFileName(file)
            LogText(LL_NOTICE, "UpdFrame_LoadSubFlowFile begin to load lua file = " .. file.." "..filename)
            package.loaded[filename] = nil
            require(filename)
        end
    end
    io.close(fileList)
end

--------------------------------------------------------------------------------
-- Func Name       :
-- Description     : /opt/omm/oms/flow/comm/upd_lua_path·µlua
-- Caution         : OMMά, ޸
-- Input           : ·
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
UpdFrame_LoadSubFlowFile("/opt/omm/oms/flow/comm/")
local luaFile = io.open("/opt/omm/oms/flow/upd_lua_path", "r");
if (luaFile == nil) then
    LogText(LL_NOTICE, "Load default")
    UpdFrame_LoadSubFlowFile("/opt/omm/oms/flow/default/")
else
    local luaPath = string.sub(luaFile:read("*all"), 1, -2);
    if (luaPath == "" or luaPath == nil) then
        LogText(LL_NOTICE, "Load default")
        UpdFrame_LoadSubFlowFile("/opt/omm/oms/flow/default/")
    else
        luaPath = luaPath.."/Service/lua/Manager/"
        UpdFrame_LoadSubFlowFile(luaPath)
    end
end

-----------------------------------------------------------------------------------------------------------------------
--------------------------/opt/omm/oms/flow/comm/upd_lua_path·µlua-------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------TaskFlowȫֱ---------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

-- TaskʼϢ(task_info.xmlȡUPDSñڵݶ)
-- Ϣ߷͵йвı䣬OMM
g_TaskInfo =
{
    ID = "",        -- IDUPDWSĽӿߴݵrequestִйв
    TaskType = "",  -- ͣUPDWSĽӿߴݵrequestִйв
    Path = "",      -- luaļ·
    Nodes = {},     -- ĲUPDWSĽӿߴݵrequestִйв
                    -- {{ClusterId="",GroupId="",NodeList="192.168.40.7,192.1168.40.8,192.168.40.9", NodeType="Agent", LogicNodeType="MDC", UpgradeMode="online", AutoBatch="true", ParamList="key1=value1,key2=value2"},{}}
                    -- ClusterId Ⱥid
                    -- GroupId id
                    -- LogicNodeType ߼ڵ FSMMDCOSDClient
                    -- NodeList ߼ڵ͵ĽڵIPб 192.168.40.7,192.168.40.8,192.168.40.9
                    -- NodeType ߼ڵͶӦĽڵ ManagerAgent
                    -- UpgradeMode ģʽ
                    -- AutoBatch ǷɲƷη OMMùģ
                    -- ParamList б OMMùģ
}

-- Flowִ״̬Ϣ(ñڵݶ־ûUPDSػָ)
g_UpdState =
{
    Flow = "",              -- ǰִе̣OMM
    FlowId = 0,             -- IDΪǰʱ
    FlowState = 0,          -- ǰִ״̬
                            -- FLOW_STATE_RUNNING:ִ
                            -- FLOW_STATE_FINISH: ִн

    Manager_FlowState = 0,  -- Manager״̬
                            -- MANAGER_FLOW_STATE_UPG:
                            -- MANAGER_FLOW_STATE_UPG_RBK:ʧܻ
                            -- MANAGER_FLOW_STATE_RBK:
    Manager_UpgState = 0,   -- Managerڵִ״̬
                            -- MANAGER_UPG_STATE_INIT:δִ
                            -- MANAGER_UPG_STATE_SUCC:ִгɹ
                            -- MANAGER_UPG_STATE_RUN:ִ
                            -- MANAGER_UPG_STATE_FAIL:ִʧ
    Manager_UpgResult = 0,  -- Managerǰԭִн
                            -- ATOM_GROUP_EXEC_RET_INITδִ
                            -- ATOM_GROUP_EXEC_RET_SUCC ִгɹ
                            -- ATOM_GROUP_EXEC_RET_FAIL:ִʧܻʧ
                            -- ATOM_GROUP_EXEC_RET_SUCC_RBKִʧܻ˳ɹ
                            -- ATOM_GROUP_EXEC_RET_TIMEOUT: ִгʱ

    Manager_AGIndex = 0,    -- Managerڵ㵱ǰִеԭ
    Manager_BatchNo = 0,    -- Managerڵ㵱ǰ
    
    GetNodeListFlag = false,    -- ʱǷµĽڵб
    
    NodeListCount = 0,
    
    ErrCode = 0,
}
g_NodeIdList = {}
g_UpdNode = {};
g_CurNodeList = {};
g_WaitingNodeList = {};
g_SuccNodeList = {};
g_FailNodeList = {};
g_RbkNodeList = {};
g_AutoRbkSuccNodeList = {};

--OMSȺڵϢ, UPD-Serverʱ
g_ClusterInfo =
{
    ActiveNode = "",
    SlaveNode  = "",
}

-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------TaskFlowȫֱ---------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------ȫֱлļ-----------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveNodeListState
-- Description     : ־ûڵ״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveNodeListState(nodeState, fileID)
    local fileName = "nodelist_" .. fileID .. ".lua"
    local serializeFile = "/opt/omm/oms/flow/" .. fileName
    
    if (nil == nodeState) then
        LogText(LL_ERROR, "The node state table is nil.")
        return 0
    end
    
    UpdFrame_SaveLua(serializeFile, nodeState)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveNodeListState
-- Description     : ־ûڵ״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveIdListState()
    local serializeFile = "/opt/omm/oms/flow/upd_node_id"
    local idList = g_NodeIdList
    if (nil == idList) then
        LogText(LL_ERROR, "The node id list is nil.")
        return 0
    end
    
    UpdFrame_SaveLua(serializeFile, idList)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveFlowExecState
-- Description     : ־ûڵ״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveFlowExecState()
    local serializeFile = "/opt/omm/oms/flow/upd_flow_exe.lua"
    local updState = g_UpdState
    if (nil == updState) then
        LogText(LL_ERROR, "The flow state table is nil.")
        return;
    end
    
    UpdFrame_SaveLua(serializeFile, updState)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveCurExecState
-- Description     : ־ûڵ״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveCurExecState()
    local serializeFile = "/opt/omm/oms/flow/upd_cur_exe.lua"
    local updCurState = {}
    for key, SubCurList in pairs(g_CurNodeList) do
        if (nil ~= SubCurList[g_UpdFrame_Const.CurListExecInfo]) then
            updCurState[key] = SubCurList[g_UpdFrame_Const.CurListExecInfo]
        end
    end
    
    if (nil == updCurState) then
        LogText(LL_ERROR, "The flow state table is nil.")
        return
    end
    
    UpdFrame_SaveLua(serializeFile, updCurState)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveCurNodeList
-- Description     : ־ûǰڵб״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveCurNodeList()
    local serializeFile = "/opt/omm/oms/flow/upd_cur_node.lua"
    local curNodeList = g_CurNodeList

    if (nil == curNodeList) then
        LogText(LL_ERROR, "The flow state table is nil.")
        return
    end

    UpdFrame_SaveLua(serializeFile, curNodeList)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveWaitNodeList
-- Description     : ־ûȴڵб״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveWaitNodeList()
    local serializeFile = "/opt/omm/oms/flow/upd_wait_node.lua"
    local watingList = g_WaitingNodeList;

    if (nil == watingList) then
        LogText(LL_ERROR, "The flow state table is nil.")
        return
    end
    
    UpdFrame_SaveLua(serializeFile, watingList)
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveState
-- Description     : ־û״̬ļ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveState()
    if (nil == g_UpdState) then
        LogText(LL_ERROR, "The state table is nil.");
        return;
    end
    
    local serializeFile = "/opt/omm/oms/flow/upd_state_flows.lua"
    local tmpUpdState = g_UpdState;

    UpdFrame_SaveLua(serializeFile, tmpUpdState)
    
    ---˺ֻ̿ʼͽʱãطñ
    if (FLOW_STATE_FINISH == g_UpdState.FlowState) then
        for key, value in pairs(g_UpdNode) do
            UpdFrame_SaveNodeListState(g_UpdNode[key], key);
        end
    end

    UpdFrame_SaveCurExecState();
    UpdFrame_SaveFlowExecState();
    UpdFrame_SaveWaitNodeList();
    UpdFrame_SaveCurNodeList();
end

-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------ȫֱлļ-----------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------лļȫֱ---------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadCurNode
-- Description     : ָǰڵбϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadCurNode()
    if(FLOW_STATE_FINISH == g_UpdState.FlowState) then
        return
    end
    --ָǰбϢ
    g_CurNodeList = {}
    local serializeFile = "/opt/omm/oms/flow/upd_cur_node.lua"
    local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
    if (nil == tmpLuaInfo) then
        return
    end
    g_CurNodeList = tmpLuaInfo()
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadWaitNode
-- Description     : ָȴڵбϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadWaitNode()
    if(FLOW_STATE_FINISH == g_UpdState.FlowState) then
        return;
    end
    --ָȴбϢ
    g_WaitingNodeList = {};
    for id,nodelist in pairs(g_UpdNode) do
        for k,n in pairs(nodelist) do
            LogText(LL_DEBUG, "SuccNodeList = "..Table2String(g_SuccNodeList[k]))
            LogText(LL_DEBUG, "FailNodeList = "..Table2String(g_FailNodeList[k]))
            if (g_SuccNodeList[k] == nil and g_FailNodeList[k] == nil and g_AutoRbkSuccNodeList[k] == nil 
            and not UpdFrame_IsInCurNodeList(g_CurNodeList,k) and n.st ~= NODE_STATE_RUNNING) then
                local node = {};
                node.ip = n.ip;
                node.tp = n.tp;
                node.ltp = n.ltp;
                node.code = "";
                g_WaitingNodeList[k] = node;
                LogText(LL_DEBUG, "Resume WaitingNodeList = " .. n.ip);
            end
        end
    end
end
--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadFlowExeState
-- Description     : ִָϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadFlowExeState()
    if(FLOW_STATE_FINISH == g_UpdState.FlowState) then
        return
    end
    --ָȴбϢ
    local serializeFile = "/opt/omm/oms/flow/upd_flow_exe.lua";
    local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
    if (nil == tmpLuaInfo) then
        return
    end
    g_UpdState = tmpLuaInfo()
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadCurExeState
-- Description     : ָбִеϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadCurExeState()
    if(FLOW_STATE_FINISH == g_UpdState.FlowState) then
        return ;
    end
    --ָȴбϢ
    local serializeFile = "/opt/omm/oms/flow/upd_cur_exe.lua";
    local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
    if (nil == tmpLuaInfo) then
        return
    end

    local tmpCurState = tmpLuaInfo()
    for key, value in pairs (g_CurNodeList) do
        g_CurNodeList[key][g_UpdFrame_Const.CurListExecInfo] = {};
        if (tmpCurState[key] ~= nil) then
            g_CurNodeList[key][g_UpdFrame_Const.CurListExecInfo] = tmpCurState[key];
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadNodeId
-- Description     : ָnodelistнڵ״̬curnodeListнڵ״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadNodeId()
    local serializeFile = "/opt/omm/oms/flow/upd_node_id";
    local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
    if (nil == tmpLuaInfo) then
        return
    end
    
    g_NodeIdList = tmpLuaInfo()
    
    for id, idlist in pairs (g_NodeIdList) do
        LogText(LL_INFO, "UpdFrame_LoadNodeId g_NodeIdList["..id.."] = "..Table2String(idlist))
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadNodeList
-- Description     : ָnodelistнڵ״̬curnodeListнڵ״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadNodeList()
    --ָȴбϢ
    local serializeFile
    for i = 1, g_UpdState.NodeListCount do
        serializeFile = "/opt/omm/oms/flow/nodelist_" .. i .. ".lua"
        local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
        if (nil ~= tmpLuaInfo) then
            g_UpdNode[i] = tmpLuaInfo()
        end
    end

    ---ָCurNodeListеĽڵ״̬
    for key, value in pairs(g_CurNodeList) do
        for index, node in pairs(g_CurNodeList[key]) do
            if (g_UpdFrame_Const.CurListExecInfo ~= index and g_UpdFrame_Const.CurListAgTbl ~= index and g_UpdFrame_Const.CurListConfig ~= index) then
                LogText(LL_NOTICE, "UpdFrame_LoadNodeList index = "..index)
                local ID = g_NodeIdList[index].id
                node.state = g_UpdNode[ID][index].ct;
                node.rf = g_UpdNode[ID][index].rf;
            end
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadSuccFailNode
-- Description     : ָɹʧܽڵбǰֻҪָڵбѾɵĽڵϢ ڵδɣڵٴϱˢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadSuccFailNode()
    --ָȴбϢ
    if(FLOW_STATE_FINISH == g_UpdState.FlowState) then
        return ;
    end
    g_SuccNodeList = {};
    g_FailNodeList = {};

    ---ָNodeListнڵ״̬
    local TmpNode = {};
    for ID, nodelist in pairs(g_UpdNode) do
        for index, node in pairs(nodelist) do
            if (NODE_STATE_RUNNING ~= g_UpdNode[ID][index].st and NODE_STATE_INIT ~= g_UpdNode[ID][index].st) then
                TmpNode.ip = g_UpdNode[ID][index].ip;
                TmpNode.tp = g_UpdNode[ID][index].tp;
                TmpNode.ltp = g_UpdNode[ID][index].ltp;
                TmpNode.state = g_UpdNode[ID][index].ct;
                if (NODE_STATE_SUCC == g_UpdNode[ID][index].st) then
                    g_SuccNodeList[index] = TmpNode;
                else
                    local subKey = UpdFrame_GetSubKeyFromCurList(index)
                    if (ATOM_GROUP_EXEC_RET_SUCC_RBK == g_UpdNode[ID][index].st and not g_CurNodeList[subKey].agtbl.isRbk) then
                        g_AutoRbkSuccNodeList[index] = TmpNode;
                    end
                    g_FailNodeList[index] = TmpNode;
                end
            end
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : LoadState
-- Description     : ļм״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          : upds
--------------------------------------------------------------------------------
function LoadState()
    local serializeFile = "/opt/omm/oms/flow/upd_state_flows.lua";
    local tmpLuaInfo = UpdFrame_LoadLua(serializeFile)
    if (nil == tmpLuaInfo) then
        return
    end
    g_UpdState = tmpLuaInfo()
    UpdFrame_LoadNodeId()
    UpdFrame_LoadFlowExeState();
    UpdFrame_LoadCurNode();
    UpdFrame_LoadCurExeState();
    UpdFrame_LoadNodeList();
    UpdFrame_LoadSuccFailNode();
    ---ȴбˢ ɾɹ ʧ ִ  curnodelist еĽڵ
    UpdFrame_LoadWaitNode();
end

-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------лļȫֱ---------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------UPDSõķ-------------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_HandleAtomReportInfo
-- Description     : Ż
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_HandleAtomReportInfo(AtomName, ErrorCode, Progress, ExecResult, NodeIndex, AtomgGroup, StartTime, EndTime)
    local nodeIndex = tonumber(NodeIndex)
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local syncAG;
    if (-1 ~= subKey) then
        syncAG = g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG
    end
    local isFrame = IsFrameVersion()
    
    if(ErrorCode ~= 0 and  -1 ~= subKey and nil ~= syncAG and syncAG.ExcuteNodeType == g_UpdFrame_Const.NodeTypeManager and AtomgGroup == syncAG.AtomGroupName) then
        local agName = syncAG.AtomGroupName
        local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
        for index, Node in pairs(subList) do
            if (Node.state == ATOM_GROUP_EXEC_RET_INIT and NodeIp ~= Node.ip and
                Node.ip ~= nil and g_NodeList[index].ag == agName) then
                LogText(LL_NOTICE, "Node not finished and report: " .. Node.ip);
                if isFrame then
                    ReportOvertimeAtomWithParam{atom_group=AtomgGroup, atom=AtomName, node_ip=Node.ip, node_index=index, error_code=ErrorCode, result=ExecResult}
                else
                    ReportOvertimeAtom{atom_group=AtomgGroup, atom=AtomName, node_ip=Node.ip, error_code=ErrorCode, result=ExecResult}
                end
            end
        end
        for _, Node in pairs(g_RbkNodeList) do
            if (Node.state == ATOM_GROUP_EXEC_RET_INIT and NodeIp ~= Node.ip and Node.ip ~= nil) then
                LogText(LL_NOTICE, "Node not rollback finished and report: " .. Node.ip);
                if isFrame then
                    ReportOvertimeAtomWithParam{atom_group=AtomgGroup, atom=AtomName, node_ip=Node.ip, node_index=index, error_code=ErrorCode, result=ExecResult}
                else
                    ReportOvertimeAtom{atom_group=AtomgGroup, atom=AtomName, node_ip=Node.ip, error_code=ErrorCode, result=ExecResult}
                end
            end
        end
    end
    return 0;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdGetNodeList
-- Description     : sodʱȡĽڵбΪմȡڵϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdGetNodeList()
    --жǷҪȡϢ Ҫȡʱֱӷ
    if (nil == g_UpdState) or (nil == g_UpdState.Flow)
        or ("" == g_UpdState.Flow) or (nil == g_UpdState.FlowState) then
        LogText(LL_NOTICE, "No flow is executing and no need get node list.");
        g_UpdState.FlowState = FLOW_STATE_FINISH
        UpdFrame_UpdateNodeState(TERM_FLOW, {});
        UpdFrame_SaveState(g_UpdState); ----Resume̷̽ʱ һ
        return FLOW_DISPATCH_STATE_FINISH;
    end

    return UpdFrame_StartNewBatch();
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowId
-- Description     : ȡǰִе̵к
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ̵ˮ
--------------------------------------------------------------------------------
function GetFlowId()
    return g_UpdState.FlowId;
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowTimeout
-- Description     : ȡ̳ʱʱ
-- Caution         : OMMά, ޸
-- Input           : FlowName 
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetFlowTimeout(FlowName)
    local timeout = GetFlowTimeout_BatTsk(FlowName)
    if (timeout == 0) then
        return RET_ERR, timeout;
    else
        return RET_OK, timeout;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : GetMsgRetryInfo
-- Description     : ȡϢʱԼ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetMsgRetryInfo()
    return g_Config.msg_retry_times, g_Config.msg_retry_interval
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowProgress
-- Description     : ȡǰ̵ĽϢ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ1: int ִн, RET_OK: ɹ, RET_ERR: ʧ
--                   ֵ2: string ̵ĽϢ
--------------------------------------------------------------------------------
function GetFlowProgress()
    if (g_UpdState == nil) or (g_UpdNode == nil) then
        return RET_ERR, nil;
    else
        --table: {[112]={ip=112,tp='OMS',st=1,rt=1,bt=1111,et=1111,pr=10},{}}
        --תַ: {"112":{"ip":111,"tp":"OMS","st":1,"rt":1,"bt":1111,"et":1111,"pr":10},{}}
        local s = "{";
        for id, nodelist in pairs(g_UpdNode) do
            for key, Node in pairs(nodelist) do
                s = s .. "\"" .. key .. "\":{\"ip\":\"" .. Node.ip .. "\",\"tp\":\"" ..
                    Node.tp .. "\",\"st\":" .. Node.st .. ",\"rt\":" .. Node.rt ..
                    ",\"bt\":" .. Node.bt .. ",\"et\":" .. Node.et .. ",\"pr\":" ..
                    Node.pr .. "},";
            end
        end
        s = string.sub(s, 1, -2) .. "}"; --ȥһԪغ","

        LogText(LL_INFO, "GetFlowProgress: " .. s);
        return RET_OK, s;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : GetResumeFlowName
-- Description     : ָ̻ȡ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetResumeFlowName()
    if ((nil == g_UpdState.Flow) or ("" == g_UpdState.Flow)) then
        LogText(LL_NOTICE, "No flow is executing.");
        return "";
    end
    return g_UpdState.Flow;
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowState
-- Description     : ܵãȡǰ̵״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetFlowState()
    return g_UpdState.FlowState;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetCurIndex
-- Description     : ȡipӦĵǰindexֵ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetCurIndex(NodeIp)
    if (g_CurNodeList == nil or next(g_CurNodeList) == nil) then
        return ""
    end
    
    for _, SubCurList in pairs(g_CurNodeList) do
        for key, Node in pairs(SubCurList) do
            if (index ~= g_UpdFrame_Const.CurListExecInfo and index ~= g_UpdFrame_Const.CurListAgTbl and index ~= g_UpdFrame_Const.CurListConfig) then
                if (Node.ip == NodeIp) then
                    return tostring(index)
                end
            end
        end
    end
    return ""
end

--------------------------------------------------------------------------------
-- Func Name       : GetResumeNodeList
-- Description     : ָ̻ȡڵб
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetResumeNodeList()
    if ((nil == g_UpdState) or (nil == g_UpdState.Flow)
        or ("" == g_UpdState.Flow) or (nil == g_UpdNode)) then
        LogText(LL_NOTICE, "No flow is executing.");
        return "";
    end

    local nodeArray = "";
    for _, nodeList in pairs(g_UpdNode) do
        for _, Node in pairs(nodeList) do
            nodeArray = nodeArray .. Node.ip .. ",";
        end
    end
    return nodeArray;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsNodeFinished
-- Description     : жϽڵǷִ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ: BOOL
--------------------------------------------------------------------------------
function UpdFrame_IsNodeFinished(Index)
    local index = tonumber(Index)
    if (g_UpdState.FlowState == FLOW_STATE_FINISH) then
        return TRUE
    end

    local ID = g_NodeIdList[index].id
    local Node = g_UpdNode[ID][index]
    if (Node == nil ) then
        return TRUE
    end

    -- ڵ״̬ǳʼִУ˵ڵûִ
    if (Node.st == NODE_STATE_INIT) or (Node.st == NODE_STATE_RUNNING ) then
        return FALSE
    end

    return TRUE
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsAGFinish
-- Description     : жԭǷִɣյԭϱϢʱ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ: BOOL
--------------------------------------------------------------------------------
function UpdFrame_IsAGFinish(Index, AtomGroupName)
    local index = tonumber(Index)
    if (g_UpdState.FlowState == FLOW_STATE_FINISH) then
        return TRUE
    end
    
    local ID = g_NodeIdList[index].id
    local Node = g_UpdNode[ID][index]
    if (Node == nil ) then
        LogText(LL_NOTICE, "Node == nil, index = "..index)
        return TRUE
    end
    
    -- ڵ״̬ǳʼִ״̬ʱյ˸ԭִнϢڵûִн
    if (Node.st == NODE_STATE_INIT) or (Node.st == NODE_STATE_RUNNING) or (Node.rt == ATOM_GROUP_EXEC_RET_INIT) then
        if(AtomGroupName == Node.ag)then
            LogText(LL_NOTICE, "AtomGroup not finished:(" .. AtomGroupName .. " " .. index .. " " .. Node.st .. ")" );
            return FALSE
        end
    end

    LogText(LL_NOTICE, "AtomGroup has finished:(" .. AtomGroupName .. " " .. index .. " " .. Node.st .. ")");
    return TRUE
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsRbkAtomGroup
-- Description     : жϵǰԭǷڻ
-- Caution         : OMMά, ޸
-- Input           : flowName 
--                   atomGroupName ԭ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_IsRbkAtomGroup(Index, flowName, atomGroupName)
    local index = tonumber(Index)
    local rbkAtomGroups = nil


    -- ȡflowϢ
    local subKey = UpdFrame_GetSubKeyFromCurList(index)
    if (-1 == subKey) then
        return FALSE
    end
    local tbl = g_CurNodeList[subKey].agtbl

    -- ǻԭ
    if (tbl.isRbk) then
        return FALSE
    end

    -- жatomGroupNnameǷrollback
    rbkAtomGroups = tbl.rbk
    if (rbkAtomGroups == nil) then
        LogText(LL_ERROR, "Fail to find rollback atom group table(name:" .. flowName .. ").")
        return FALSE
    end

    -- ԭڻԭзTRUE
    for i = 1, #rbkAtomGroups do
        if (rbkAtomGroups[i].AtomGroupName == atomGroupName) then
            return TRUE
        end
    end

    return FALSE
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetRbkAtomGroup
-- Description     : ȡԭĻԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          : ֵ1: stringͣδҵء
--------------------------------------------------------------------------------
function UpdFrame_GetRbkAtomGroup(flowName, atomGroupName, Index)
    local index = tonumber(Index)
    local flow = nil
    local atomGroups = nil

    -- ǰύֱӷؿַ
    if ("PRECHECK" == flowName or "COMMIT" == flowName ) then
        return ""
    end

    -- ȡflowϢ
    local subKey = UpdFrame_GetSubKeyFromCurList(index)
    if (-1 == subKey) then
        return FALSE
    end
    local tbl = g_CurNodeList[subKey].agtbl

    -- ԭֱӷؿ
    if (agtbl.isRbk) then
        return ""
    end

    -- ҵatomgrouprbkԣ
    atomGroups = agtbl.upd
    for i = 1, #atomGroups do
        if (atomGroups[i].AtomGroupName == atomGroupName and atomGroups[i].rbk ~= nil) then
            return atomGroups[i].rbk
        end
    end

    return ""
end

--------------------------------------------------------------------------------
-- Func Name       : hasAtomGroup_BatTsk
-- Description     : жָԭǷڸýڵ㣬ֻ˫ManagerӰ
-- Caution         : ܵãơֵģһ
-- Input           : nodeIp ڵip
--                   flowName 
--                   atomGroupName ԭ
--                   nodeType ڵ
-- Output          :
-- Return          : ֵ1: int ִн, TRUE: , FALSE:
--------------------------------------------------------------------------------
function hasAtomGroup_BatTsk(nodeIp, flowName, atomGroupName, nodeType)
    -- ˫Managerֱӷtrue
    if (g_UpdFrame_Const.NodeTypeManager == nodeType and "" == g_ClusterInfo.SlaveNode) then
        return TRUE
    elseif (g_UpdFrame_Const.NodeTypeManager ~= nodeType) then
        return TRUE
    end
    if (g_UpdFrame_Const.FLOW_NAME_UPDATE ~= flowName and g_UpdFrame_Const.FLOW_NAME_ROLLBACK ~= flowName) then
        return TRUE
    end
    
    -- òƷȡAGǷipӦ
    local ret = HasAtomGroup(g_ClusterInfo.ActiveNode, g_ClusterInfo.SlaveNode, nodeIp, flowName, atomGroupName)
    if (ret) then
        return TRUE
    else
        return FALSE
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdateAllNodeState
-- Description     : ɿܵãֹʱˢ½ڵ״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdateAllNodeState()
    LogText(LL_INFO, "UpdateAllNodeState and FLowState is: " .. g_UpdState.FlowState);
    g_UpdState.FlowState = FLOW_STATE_FINISH ;
    UpdFrame_UpdateNodeState(TERM_FLOW, {});
    UpdFrame_SaveState(g_UpdState);  ----̽ʱˢһνڵ״̬ܵñһ
    return 0;
end

--------------------------------------------------------------------------------
-- Func Name       : Terminate
-- Description     : ֹǰִе
-- Caution         : ܵãơֵģһ
-- Input           : FlowId: int ̵к
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function Terminate(FlowId)
    if (g_UpdState.FlowId ~= FlowId) then
        LogText(LL_ERROR, "Terminate flow failed: " .. FlowId);
        return;
    end
    local isFrame = IsFrameVersion()
    
    -- ϱһ̳ʱԭ
    for subKey, SubCurList in pairs (g_CurNodeList) do
        local subList = UpdFrame_GetSubFromCurList(SubCurList)
        for key, Node in pairs(subList) do
            if isFrame then
                ReportOvertimeAtomWithParam{atom_group=UpdFrame_GetAtomGroupEx(key), atom=g_UpdState.Flow, node_ip=Node.ip, node_index=key, error_code=ERR_OVERTIME,result=ATOM_ERR_RET}
            else
                ReportOvertimeAtom{atom_group=UpdFrame_GetAtomGroupEx(key), atom=g_UpdState.Flow, node_ip=Node.ip, error_code=ERR_OVERTIME,result=ATOM_ERR_RET}
            end
        end
    end
    UpdFrame_UpdateNodeState(TERM_FLOW, {});
    g_UpdState.FlowState = FLOW_STATE_FINISH;
    UpdFrame_SaveState(g_UpdState); ----̳ʱֹʱ һ

    LogText(LL_WARN, "Terminate flow: " .. FlowId);
end

--------------------------------------------------------------------------------
-- Func Name       : SetErrCode
-- Description     : ɿܵãֹʱˢ½ڵ״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function SetErrCode(errCode)
    LogText(LL_INFO, "SetErrCode: " .. errCode);
    g_UpdState.ErrCode = errCode;
    UpdFrame_SaveState(g_UpdState); ----̽ʱôϢܵñһ
    return 0;
end

--------------------------------------------------------------------------------
-- Func Name       : GetErrCode
-- Description     : ɿܵãȡֹͣʧʱĴ
-- Caution         : OMMά, ޸
-- Input           : Index ڵбkey
-- Output          :
-- Return          : IndexӦĴ
--------------------------------------------------------------------------------
function GetErrCode(Index)
    LogText(LL_INFO, "Index = " .. Index);
    local indexLong = tonumber(Index)
    LogText(LL_INFO, "indexLong = " .. indexLong);
    if (g_UpdState.ErrCode ~= 0 and g_UpdState.ErrCode ~= nil) then
        LogText(LL_INFO, "GetErrCode return = " .. g_UpdState.ErrCode);
        return g_UpdState.ErrCode;
    end

    if (g_UpdState == nil) then
        return "NULL";
    elseif (g_WaitingNodeList == nil) then
        return "NULL"
    elseif (g_WaitingNodeList[indexLong] == nil) then
        return "NULL"
    else
        return g_WaitingNodeList[indexLong].code;
    end
end


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------UPDSõķ-------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------ʼg_TaskInfo-----------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetElementFromXML
-- Description     : ȡxmlļָǩ
-- Caution         : OMMά, ޸
-- Input           : Element xmlǩ
--                   Struct xmlĿṹ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetElementFromXML(Element, Struct)
    local startElement = "<"..Element..">"
    local endElement = "</"..Element..">"
    _,_,xmlContent = string.find(Struct, "("..startElement..".-"..endElement..")")
    
    if (nil == xmlContent) then
        xmlContent = ""
        return xmlContent
    end
    
    xmlContent = string.gsub(xmlContent, startElement, "")
    xmlContent = string.gsub(xmlContent, endElement, "")
    if ("NULL" == xmlContent) then
        xmlContent = ""
    end

    return xmlContent
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SetCurrentTaskInfo
-- Description     : xmlļʼg_TaskInfo
-- Caution         : OMMά, ޸
-- Input           : TaskId id
--                   TaskType 
--                   curtaskinfo ǰϢ
-- Output          :
-- Return          : 1--ʧ 0--ɹ
--------------------------------------------------------------------------------
function UpdFrame_SetCurrentTaskInfo(TaskId, TaskType, curtaskinfo)
    LogText(LL_NOTICE, "Start to set task, id: " .. TaskId);

    --taskIdtaskType
    g_TaskInfo.ID = TaskId
    g_TaskInfo.TaskType = TaskType
    LogText(LL_NOTICE, "taskId: " .. g_TaskInfo.ID..", taskType: " .. g_TaskInfo.TaskType);

    --ѭnodeinfo
    local i = 1
    while ("" ~= UpdFrame_GetStructById(i, curtaskinfo)) do
        local struct = UpdFrame_GetStructById(i, curtaskinfo)
        if (struct == nil ) then
            return 1
        end

        --ȡȺid
        local clusterid = UpdFrame_GetElementFromXML("clusterid", struct)
        --ȡid
        local groupid = UpdFrame_GetElementFromXML("groupid", struct)
        --ȡڵб
        local nodelist = UpdFrame_GetElementFromXML("nodelist", struct)
        --ȡڵ
        local nodetype = UpdFrame_GetElementFromXML("nodetype", struct)
        --ȡڵ߼
        local logicnodetype = UpdFrame_GetElementFromXML("logicnodetype", struct)
        --ȡģʽ
        local upgrademode = UpdFrame_GetElementFromXML("upgrademode", struct)
        --ȡԶ
        local autobatch = UpdFrame_GetElementFromXML("autobatch", struct)
        --ȡб
        local paramlist = UpdFrame_GetElementFromXML("paramlist", struct)

        if (nodelist == nil or nodetype == nil or logicnodetype == nil
            or upgrademode == nil or autobatch == nil or paramlist == nil) then
            return 1
        end

        local node = {};
        node.ClusterId = clusterid;
        node.GroupId = groupid;
        node.NodeList = nodelist;
        node.NodeType = nodetype;
        node.LogicNodeType = logicnodetype;
        node.UpgradeMode = upgrademode;
        node.AutoBatch = autobatch;
        node.ParamList = paramlist;
        LogText(LL_NOTICE, "ClusterId: " .. node.ClusterId)
        LogText(LL_NOTICE, "GroupId : " .. node.GroupId)
        LogText(LL_NOTICE, "nodeList: " .. node.NodeList)
        LogText(LL_NOTICE, "nodeType : " .. node.NodeType)
        LogText(LL_NOTICE, "logicNodeType: " .. node.LogicNodeType)
        LogText(LL_NOTICE, "upgradeMode : " .. node.UpgradeMode)
        LogText(LL_NOTICE, "autoBatch: " .. node.AutoBatch)
        LogText(LL_NOTICE, "paramList : " .. node.ParamList)
        table.insert(g_TaskInfo.Nodes, node);

        i = i + 1
    end
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetStructById
-- Description     : xmlļлȡָ߼ڵ͵Ϣ
-- Caution         : OMMά, ޸
-- Input           : StrcutId structǩid
--                   curtaskinfo taskinfoǩ
-- Output          :
-- Return          : idӦstructǩ
--------------------------------------------------------------------------------
function UpdFrame_GetStructById(StrcutId, curtaskinfo)
    LogText(LL_NOTICE, "Start to get struct, id: " .. StrcutId);

    local startElement = "<struct id=\""..StrcutId.."\">"
    local endElement = "</struct>"
    _,_,curStruct = string.find(curtaskinfo, "("..startElement..".-"..endElement..")")
    if (nil == curStruct) then
        return ""
    end

    LogText(LL_DEBUG, "curStruct: " .. curStruct);
    return curStruct
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetTaskById
-- Description     : xmlļлȡָidϢ
-- Caution         : OMMά, ޸
-- Input           : TaskId id
--                   fileData xmlļ
-- Output          :
-- Return          : idӦtaskinfoǩ
--------------------------------------------------------------------------------
function UpdFrame_GetTaskById(TaskId, fileData)
    LogText(LL_NOTICE, "Start to get task, id: " .. TaskId);

    --ȡǰtaskid
    local curtaskid = UpdFrame_GetElementFromXML("curtaskid", fileData)
    if (nil == curtaskid or TaskId ~= curtaskid) then
        return ""
    end

    --ȡidӦtaskinfo
    startElement = "<taskinfo id=\""..curtaskid.."\">"
    endElement = "</taskinfo>"
    _,_,curtaskinfo = string.find(fileData, "("..startElement..".-"..endElement..")")
    if (nil == curtaskinfo) then
        return ""
    end
    LogText(LL_DEBUG, "curtaskinfo: " .. curtaskinfo);

    return curtaskinfo
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_TaskToFlow
-- Description     : תΪ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_TaskToFlow()
    g_UpdState.Flow = string.upper(g_TaskInfo.TaskType);
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowName
-- Description     : ܵãʼg_TaskInfoȡ
-- Caution         : OMMά, ޸
-- Input           : TaskId id
--                   TaskType 
--                   XmlPath xmlļ·
--                   isResume ǷΪָ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetFlowName(TaskId, TaskType, XmlPath, isStart)
    LogText(LL_NOTICE, "Start task: " .. TaskType .. " with task id: " .. TaskId.." ,isStart: "..isStart);

    --xmlļ
    local file = io.open(XmlPath, "r");
    local fileData = file:read("*all");

    --ȡǰϢ
    local curtaskinfo = UpdFrame_GetTaskById(TaskId, fileData)
    if ("" == curtaskinfo) then
        LogText(LL_ERROR, "Fail to get current taskinfo, id " .. TaskId);
        file:close();
        return ""
    end

    --Ϣʼg_TaskInfo
    local ret = UpdFrame_SetCurrentTaskInfo(TaskId, TaskType, curtaskinfo)
    if (1 == ret) then
        LogText(LL_ERROR, "Fail to set current taskinfo, id " .. TaskId);
        file:close();
        return ""
    end

    if (isStart == TRUE) then
        --ڵϢʼg_UpdState.NodeList
        ret = UpdFrame_SetUpdStateNodeList(TaskId)
        if (1 == ret) then
            LogText(LL_ERROR, "Fail to set current nodelist, id " .. TaskId);
            file:close();
            return ""
        end
    end

    --GetNodeListFlow
    UpdFrame_TaskToFlow();
    if (isStart == TRUE) then
        UpdFrame_SaveState(g_UpdState);  ---ȡƴʱڵ㣬ܵã̿ʼʱһ
    end

    file:close();
    LogText(LL_INFO, "g_UpdState.Flow = " .. g_UpdState.Flow);
    return g_UpdState.Flow
end

-----------------------------------------------------------------------------------------------------------------------
--------------------------------------------------ʼg_TaskInfo-----------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
---------------------------------------------------ʼִ--------------------------------------------------------
------------------------------------------------------START------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_OmsFlowFsync
-- Description     : ϵͳ fsync ʹڴеˢӲ,ʧ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_OmsFlowFsync()
    LogText(LL_NOTICE, "Sync oms flow memery data to disk.");
    local cmd = "fsync /opt/omm/oms/flow/";
    System(cmd, 2);
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateStateBeforeGetNodeList
-- Description     : CurNodeListѾɵĽڵ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateStateBeforeGetNodeList()
    -- ½ڵ״̬CurNodeListѾִɵб
    for subKey, SubCurList in pairs(g_CurNodeList) do
        if (UpdFrame_IsCurListAllFinish(SubCurList)) then
            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            g_CurNodeList[subKey] = nil;
            LogText(LL_NOTICE, "----UpdFrame_UpdateStateBeforeGetNodeList clean subkey="..subKey)
        end
    end
    
    -- ڵ״̬Ϣ
    UpdFrame_SaveCurNodeList();
    UpdFrame_SaveCurExecState();
    for key, value in pairs(g_UpdNode) do
        UpdFrame_SaveNodeListState(g_UpdNode[key], key)
    end
    UpdFrame_OmsFlowFsync(); 
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateStateAfterGetNodeList
-- Description     : øҵ֮taskctl״̬
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateStateAfterGetNodeList(TaskCtl, WatingList, CurList)
    if (nil == TaskCtl or nil == WatingList or nil == CurList) then
        LogText(LL_NOTICE, "----GetBatchNodeList failed.");
        return FLOW_DISPATCH_STATE_FINISH;
    end
    
    local CurKey = 0
    for subKey, subList in pairs(g_CurNodeList) do
        if (subKey > CurKey) then
            CurKey = subKey
        end
    end
    CurKey = CurKey + 1
    g_UpdState.TaskControl = TaskCtl
    g_WaitingNodeList = WatingList
    for subKeyIn, subListIn in pairs(CurList) do
        g_UpdState.Agent_BatchNo = g_UpdState.Agent_BatchNo + 1; --ӦжϽڵ
        g_CurNodeList[CurKey] = subListIn
        g_CurNodeList[CurKey].curlist_config.Agent_AGIndex = 0
        g_CurNodeList[CurKey].curlist_config.AGTimerID = 0
        g_CurNodeList[CurKey].curlist_config.RepAG = ""
        g_CurNodeList[CurKey].curlist_config.RepIp = ""
        g_CurNodeList[CurKey].curlist_config.RepRet = ""
        CurKey = CurKey + 1
        LogText(LL_NOTICE, "----UpdFrame_UpdateStateAfterGetNodeList CurKey="..CurKey)
    end
    
    -- ϱͣ״̬
    if (g_Const.TASK_CONTROL_PAUSE == TaskCtl) then
        LogText(LL_NOTICE, "----Task Paused.");
        for Index, WaitingNode in pairs(WatingList) do
            g_UpdNode[Index].st = NODE_STATE_INIT;
        end
        g_UpdState.FlowState = FLOW_STATE_PAUSE
        ReportPauseState{task_id=g_TaskInfo.ID} 
        UpdFrame_StopTimer()
        UpdFrame_SaveState()
        return FLOW_DISPATCH_STATE_PAUSE;
        
    elseif (g_Const.TASK_CONTROL_STOP_SUCC == TaskCtl) then
        LogText(LL_NOTICE, "----Task succStop.");
        UpdFrame_FinishFlowHandle();
        return FLOW_DISPATCH_STATE_FINISH;
        
    elseif (g_Const.TASK_CONTROL_STOP_FAIL == TaskCtl) then
        LogText(LL_NOTICE, "----Task failStop.");
        UpdFrame_FinishFlowHandle();
        return FLOW_DISPATCH_STATE_FINISH;

    end
    
    LogText(LL_NOTICE, "----Task Continue.");
    return FLOW_DISPATCH_STATE_NORMAL
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_StartNewFlowTimer
-- Description     : OMMʹ ִжλ߶ʱɺ̳ʱʱ
-- Caution         : OMMά, ޸
-- Input           : SubCurList 
-- Output          :
-- Return          :
---------------------------------------------------------------------------
function UpdFrame_StartNewFlowTimer()
    local timeout = 0
    
    local timeout = GetFlowTimeout_BatTsk(g_UpdState.Flow)
    if (nil == timeout or 0 == timeout) then
        LogText(LL_INFO, "UpdFrame_StartNewFlowTimer get timeout failed")
        return
    end
    
    LogText(LL_INFO, "UpdFrame_StartNewFlowTimer timeout and flow id = " .. g_UpdState.FlowId)
    RestartFlowTimer{flow_time = timeout, flow_id = g_UpdState.FlowId}
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_StartFlow
-- Description     : ʼִһµ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_StartFlow()
    LogText(LL_INFO, "Enter UpdFrame_StartFlow.");
    for subKey, SubCurList in pairs(g_CurNodeList) do
        if (not UpdFrame_IsSubCurListBegin(SubCurList)) then
            -- ʼµʱ̶ʱ
            UpdFrame_StartNewFlowTimer();
            UpdFrame_UpdateNodeState(START_BATCH, SubCurList); --ʼһνڵ״̬
            -- ֪ͨڵִеһAG
            if (g_UpdState.Flow == g_UpdFrame_Const.FLOW_NAME_UPDATE and SubCurList.curlist_config.NodeType == g_UpdFrame_Const.NodeTypeManager) then
                UpdFrame_UpdateFSM(SubCurList);
            elseif (g_UpdState.Flow == g_UpdFrame_Const.FLOW_NAME_ROLLBACK and SubCurList.curlist_config.NodeType == g_UpdFrame_Const.NodeTypeManager) then
                UpdFrame_RollbackFSM(SubCurList);
            else    
                local AGIndex = 0;
                local AtomGroup = SubCurList.agtbl.upd[1]
                --ˢµǰڵϱϢ״̬ AG IP Result
                LogText(LL_INFO, "AtomGroup == "..AtomGroup.AtomGroupName)
                UpdFrame_NotifySubCurNodeNextAG(AtomGroup, subKey)
                SubCurList.curlist_config.Agent_AGIndex = AGIndex
            end
        end
    end
    
    -- ʼµκãʼһεһ
    for key, value in pairs(g_UpdNode) do
        UpdFrame_SaveNodeListState(g_UpdNode[key], key)
    end
    UpdFrame_SaveFlowExecState();
    UpdFrame_SaveCurExecState();

    for subKey, SubCurList in pairs(g_CurNodeList) do
        if (SubCurList.curlist_config.LogicNodeType == g_UpdFrame_Const.NodeTypeManager) then
            UpdFrame_UpdateFSM(SubCurList)
        else
            LogText(LL_INFO, "UpdFrame_StartFlow before UpdFrame_RunFlowAgent.");
            --UpdFrame_RunFlowAgent(SubCurList)
        end
    end
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_StartNewBatch
-- Description     : ʼִһµ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_StartNewBatch()
    local taskctl = ""
    local watinglist = {}
    local curlist = {}
    local ret = 0
    
    -- ȡ
    UpdFrame_UpdateStateBeforeGetNodeList()
    
    local NodeList = {}
    for ID, Node in pairs (g_UpdNode) do
        for index, node in pairs (Node) do
            NodeList[index] = node
        end
    end
    local ExecList = {}
    for subKey, subList in pairs (g_CurNodeList) do
        for index, node in pairs (subList) do
            if (node.ip ~= nil) then
                ExecList[index] = {}
                ExecList[index].ip = node.ip
                ExecList[index].tp = subList.curlist_config.NodeType
                ExecList[index].ltp = subList.curlist_config.LogicNodeType
            end
        end
    end
    taskctl, watinglist, curlist = GetBatchNodeList(g_UpdState.Flow, g_TaskInfo, NodeList, ExecList, g_SuccNodeList, g_FailNodeList, g_AutoRbkSuccNodeList)
    
    -- ʱƷûзµĽڵбһϢȴ´ε÷
    if (taskctl == g_Const.TASK_CONTROL_CONTINUE and (curlist == nil or next(curlist) == nil)) then
        LogText(LL_INFO, "Need report get node list msg.")
        ResetGetListTimer{reset_timer=1};
        g_UpdState.GetNodeListFlag = true;
        return 0;
    else
        LogText(LL_INFO, "No need report get node list msg.")
        ResetGetListTimer{reset_timer=0};
        g_UpdState.GetNodeListFlag = false;
    end
    
    ret = UpdFrame_UpdateStateAfterGetNodeList(taskctl, watinglist, curlist)
    UpdFrame_SaveCurNodeList();
    UpdFrame_SaveCurExecState();
    if (FLOW_DISPATCH_STATE_NORMAL ~= ret) then
        return ret
    end
    
    -- ȡһڵ󣬿ʼִ
    return UpdFrame_StartFlow()
end

--------------------------------------------------------------------------------
-- Func Name       : Start_BatTsk
-- Description     : ʼִ̣ʼg_UpdState
-- Caution         : OMMά, ޸
-- Input           : Flow ǰ̵
-- Output          :
-- Return          : FlowжϾִĸ
--------------------------------------------------------------------------------
function Start_BatTsk(Flow)
    LogText(LL_NOTICE, "Start flow: " .. Flow);
        
    -- ʼg_UpdStateȫֱ
    g_UpdState.Flow = Flow
    g_UpdState.TaskControl = ""
    g_UpdState.Agent_BatchNo = 0
    g_UpdState.Manager_FlowState = MANAGER_FLOW_STATE_UPG;
    g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_INIT;
    g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT;
    g_UpdState.Manager_AGIndex = 0;
    g_UpdState.Manager_BatchNo = 0;
    
    -- ʼ״̬ȫֱ
    g_CurNodeList = {};
    g_WaitingNodeList = {};
    g_SuccNodeList = {};
    g_FailNodeList = {};
    g_RbkNodeList = {};
    g_AutoRbkSuccNodeList = {};
    
    g_UpdState.FlowId = os.time();
    g_UpdState.FlowState = FLOW_STATE_RUNNING;
    return UpdFrame_StartNewBatch()
end

-----------------------------------------------------------------------------------------------------------------------
----------------------------------------------------ʼִ-------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------ת---------------------------------------------------------
--------------------------------------------------------STSRT----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ManagerRunAtomGroup
-- Description     : ִServerԭ
-- Caution         :
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ManagerRunAtomGroup(NodeIp, AtomGroupName, Timeout, NodeType, LogicNodeType)
    local fn = "/opt/omm/oms/flow/upd_flow_exe.lua";
    local luaPath = ""
    local f = io.open(g_UpdFrame_Const.LuaPath, "r");
    if (f ~= nil) then
        luaPath = string.sub(f:read("*all"), 1, -2);
    end
    local index = GetIndexValue(NodeIp, NodeType, LogicNodeType)
    local ID = g_NodeIdList[index].id
    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    local isFrame = IsFrameVersion()
    
    -- ˢִеԭ
    g_UpdNode[ID][index].ag = AtomGroupName
    if(g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].ExeCount == 0) then
        LogText(LL_NOTICE, "----UpdFrame_ManagerRunAtomGroup, first");
        g_CurNodeList[subKey].curlist_config.AGTimerID = g_CurNodeList[subKey].curlist_config.AGTimerID + 1;
        if isFrame then
            iRet = ExecAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, msg_ip=g_ClusterInfo.ActiveNode, over_time=Timeout, param=g_CurNodeList[subKey].curlist_config.ParamList, timer_id=g_CurNodeList[subKey].curlist_config.AGTimerID, node_index=index, lua_path=luaPath};
        else
            iRet = ExecAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, msg_ip=g_ClusterInfo.ActiveNode, over_time=Timeout, param=g_CurNodeList[subKey].curlist_config.ParamList, timer_id=g_CurNodeList[subKey].curlist_config.AGTimerID};
        end
        if (RET_ERR == iRet) then
            if isFrame then
                ReportAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, node_index=index, result=ATOM_GROUP_EXEC_RET_TIMEOUT}
            else
                ReportAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, result=ATOM_GROUP_EXEC_RET_TIMEOUT}
            end
        end
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].ExeCount = 1;
        UpdFrame_SaveCurExecState();
    else
        LogText(LL_NOTICE, "----UpdFrame_ManagerRunAtomGroup, next "..NodeIp.." "..index.." "..AtomGroupName);
        --ִеAGϱڵ㿪ʼִ
        if isFrame then
            ReportOvertimeAtomWithParam{atom_group=AtomGroupName, node_ip=NodeIp, node_index=index, error_code=0, result=ATOM_GROUP_EXEC_RET_FAIL}
        else
            ReportOvertimeAtom{atom_group=AtomGroupName, node_ip=NodeIp, error_code=0, result=ATOM_GROUP_EXEC_RET_FAIL}
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_AgentRunAtomGroup
-- Description     : ÿִܷԭ
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
--                   AtomGroupName ԭ
--                   Timeout ԭ鳬ʱʱ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_AgentRunAtomGroup(NodeIp, AtomGroupName, Timeout, NodeType, LogicNodeType)
    LogText(LL_INFO, "Enter UpdFrame_AgentRunAtomGroup, NodeIp = "..NodeIp..", AtomGroupName = "..AtomGroupName..", Timeout = "..Timeout..", NodeType = "..NodeType..", LogicNodeType = "..LogicNodeType)
    local luaPath = ""
    local f = io.open(g_UpdFrame_Const.LuaPath, "r");
    if (f ~= nil) then
        luaPath = string.sub(f:read("*all"), 1, -2);
    end
    local index = GetIndexValue(NodeIp, NodeType, LogicNodeType)
    local ID = g_NodeIdList[index].id
    local isFrame = IsFrameVersion()
    
    -- ˢִеԭ
    local Node = g_UpdNode[ID][index]
    if (Node ~= nil ) then
        g_UpdNode[ID][index].ag = AtomGroupName
    end
    local subKey = UpdFrame_GetSubKeyFromCurList(index)
    g_CurNodeList[subKey].curlist_config.AGTimerID = g_CurNodeList[subKey].curlist_config.AGTimerID + 1;
    if isFrame then
        iRet = ExecAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, over_time=Timeout, param=g_CurNodeList[subKey].curlist_config.ParamList, timer_id=g_CurNodeList[subKey].curlist_config.AGTimerID, node_index=index, lua_path=luaPath};
    else
        iRet = ExecAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, over_time=Timeout, param=g_CurNodeList[subKey].curlist_config.ParamList, timer_id=g_CurNodeList[subKey].curlist_config.AGTimerID};
    end
    if (RET_ERR == iRet) then
        if isFrame then
            ReportAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, node_index=index, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        else
            ReportAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=NodeIp, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateFSM_Upg
-- Description     : ִԭ飬ĿǰȻʹãַ෽ʽѾû
-- Caution         : OMMά, ޸
-- Input           : agType ڵ
--                   NodeIp ڵip
--                   agName ǰԭ
--                   Timeout ԭĳʱʱ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_RunAtomGroupEx(agType, NodeIp, agName, Timeout, NodeType, LogicNodeType)
    LogText(LL_INFO, "UpdFrame_RunAtomGroupEx. "..NodeIp.." "..agName.." "..Timeout.." "..NodeType.." "..LogicNodeType)
    if (g_UpdFrame_Const.NodeTypeManager == agType) then
        UpdFrame_ManagerRunAtomGroup(NodeIp, agName, Timeout, NodeType, LogicNodeType);
    else
        UpdFrame_AgentRunAtomGroup(NodeIp, agName, Timeout, NodeType, LogicNodeType);
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_Run
-- Description     : ʱĵ̣ĿǰʹgetNodeListת
-- Caution         : OMMά, ޸
-- Input           : FlowId ̱ʶ
--                   AtomGroup ǰԭ
--                   NodeIp ڵip
--                   Result ǰԭִн
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_Run(FlowId, AtomGroup, NodeIp, Index, Result)
    LogText(LL_NOTICE, "ip: "..NodeIp.." Run flow: " .. g_UpdState.Flow .. "AG:"..AtomGroup.." result: " .. Result);
    local index = tonumber(Index)
    
    if ((nil == g_UpdState) or (nil == g_UpdState.Flow) or ("" == g_UpdState.Flow)) then
        LogText(LL_WARN, "No flow is running.");
        return FLOW_DISPATCH_STATE_NO_FLOW;
    end

    if (NodeIp == nil) then
        LogText(LL_ERROR, "Node IP is nil.");
        return FLOW_DISPATCH_STATE_WRONG_IP;
    end

    -- ϱʱԭ
    UpdFrame_ProcessOvertimeAtomGroup(AtomGroup, NodeIp, index, Result)

    local subKey = UpdFrame_GetSubKeyFromCurList(index)
    local CurNode = g_CurNodeList[subKey];
    --FSMͻ̵״̬
    
    if (CurNode.curlist_config.NodeType == g_UpdFrame_Const.NodeTypeManager) then
        if (g_UpdState.Flow == g_UpdFrame_Const.FLOW_NAME_UPDATE) then
            g_UpdState.Manager_UpgResult = Result;
            LogText(LL_INFO, "UpdFrame_Run g_UpdState.Flow == UPDATE.");
            UpdFrame_UpdateManagerProgress(AtomGroup, NodeIp, index, Result);
            return UpdFrame_UpdateFSM(CurNode);
        elseif (g_UpdState.Flow == g_UpdFrame_Const.FLOW_NAME_ROLLBACK) then
            g_UpdState.Manager_UpgResult = Result;
            LogText(LL_INFO, "UpdFrame_Run g_UpdState.Flow == ROLLBACK.");
            UpdFrame_UpdateManagerProgress(AtomGroup, NodeIp, index, Result);
            return UpdFrame_RollbackFSM(CurNode);
        end
    end

    --ִʱ½ڵ״̬
    if not CurNode.agtbl.isRbk then
        UpdFrame_UpdateState(NodeIp, index, AtomGroup, Result);
    else --ִлʱ½ڵ״̬
        UpdFrame_UpdateRbkState(NodeIp, index, AtomGroup, Result);
    end

    --ˢµǰڵϱϢ״̬ AG IP Result
    CurNode.curlist_config.RepAG = AtomGroup
    CurNode.curlist_config.RepIp = NodeIp
    CurNode.curlist_config.RepRet = Result
    LogText(LL_INFO, "UpdFrame_Run before UpdFrame_RunFlowAgent.");
    return UpdFrame_RunFlowAgent(CurNode);
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsCurBatchFinishWhenAsync
-- Description     : 첽鵱ǰνڵǷ
-- Caution         : OMMά, ޸
-- Input           : NodeListڵ״̬(st)ʱ
--
--------------------------------------------------------------------------------
function UpdFrame_IsCurBatchFinishWhenAsync(NodeIp, nodeIndex)
    --ȡб
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
    local ID = g_NodeIdList[nodeIndex].id
    for index, Node in pairs(subList) do
        ID = g_NodeIdList[index].id
        if(g_UpdNode[ID][index].st == NODE_STATE_RUNNING or g_UpdNode[ID][index].st == NODE_STATE_INIT)then
            LogText(LL_NOTICE, "IsCurBatchFinish return false. "..index.." "..g_UpdNode[ID][index].st);
            return false
        end
    end
    LogText(LL_NOTICE, "IsCurBatchFinish return true.");
    return true;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetCurListNodeLenth
-- Description     : ȡǰбĽڵĿ
-- Caution         : OMMά, ޸
-- Input           : ǰб
--
--------------------------------------------------------------------------------
function UpdFrame_GetCurListNodeLenth(SubCurList)
    local nodeCount = 0
    local subList = UpdFrame_GetSubFromCurList(SubCurList)
    for key, Node in pairs(subList) do
        nodeCount = nodeCount + 1
    end
    LogText(LL_INFO, "num = "..nodeCount)
    return nodeCount
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsCanExecNextAG
-- Description     : һAG("aaa")Ҫִͬʱ жϵ
                   --нڵ㶼ִгɹһAGΪ("aaa")߽ڵִʧܽ  ڵ㿪ʼִл
                   --ɹڵ ʧܽڵ Զ˽ڵ ܺ͵ڵǰڵб
-- Caution         : OMMά, ޸
-- Input           : autrbk һAGupd  rbk
--
--------------------------------------------------------------------------------
function UpdFrame_IsCanExecNextAG(autrbk, subKey)
    local count = UpdFrame_GetCurListNodeLenth(g_CurNodeList[subKey])
    local ficount = 0;
    local rbkcount = 0;
    local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
    for index, CurNode in pairs(subList) do
        ---ڵʧɻʧܻ
        local ID = g_NodeIdList[index].id
        LogText(LL_INFO, "UpdFrame_IsCanExecNextAG ID="..ID.." index="..index)
        if(g_UpdNode[ID][index].st ~= NODE_STATE_RUNNING and g_UpdNode[ID][index].st ~= NODE_STATE_INIT)then
            ficount = ficount + 1;
        end
        ----ڵʧܿʼԶ˵δ
        if(g_UpdNode[ID][index].st == NODE_STATE_RUNNING and g_CurNodeList[subKey][index].rf == 1)then
            rbkcount = rbkcount + 1;
            LogText(LL_INFO, "UpdFrame_IsCanExecNextAG ---rbkcount." .. rbkcount)
        end
    end
    local needWait = g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait
    LogText(LL_INFO, "needWait rbkcount and finish:" .. needWait .. rbkcount .. ficount)
    if (autrbk == 0 and count == (ficount + rbkcount + needWait)) then
        LogText(LL_INFO, "---upd---UpdFrame_IsCanExecNextAG return true.")
        return true

    --rbk֧ͬҪ޸Ĵ˴߼(ֻעǰδڻ״̬Ľڵ ҽڵִеAGڴͬAG֮ǰ)
    --ǰ̻첽ִ ֻmdcʱִͬл
    --ִͬлʱȴڵɻ߻˵һAG
    elseif (autrbk == 1 and count == (ficount + needWait)) then
        LogText(LL_INFO, "----atuorbk----UpdFrame_IsCanExecNextAG return true.")
        return true
    else
        LogText(LL_INFO, "UpdFrame_IsCanExecNextAG return false.")
        return false
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_NotifyNodeExecBindAG
-- Description     : ֪ͨǰνڵִͬAG
--                   Ҫg_UpdState.SyncEnd = 1 ʾǰͬAGִ
--                   Ҫg_UpdState.NeedWait = 0 ʾͬAGѾ·ȴִеĽڵΪ0
-- Caution         : OMMά, ޸
-- Input           : ҪִеAGAG(updrbk)
--
--------------------------------------------------------------------------------
function UpdFrame_NotifyNodeExecBindAG(NextAtomGroup, autrbk, subKey, IsRbk)
    local agType = NextAtomGroup.ExcuteNodeType
    LogText(LL_INFO, "Next bind ag autrbk." .. autrbk)

    --g_UpdState.ExeCount = 0;
    local ID = 0;
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].ExeCount = 0
    local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
    for index, Node in pairs(subList) do
        if (UpdFrame_IsNodeExecSucc(Node.state, IsRbk) or (autrbk == 1 and Node.state == ATOM_GROUP_EXEC_RET_SUCC_RBK)) then
            ID = g_NodeIdList[index].id
            local tp = g_CurNodeList[subKey].curlist_config.NodeType
            local ltp = g_CurNodeList[subKey].curlist_config.LogicNodeType
            g_CurNodeList[subKey][index].state = ATOM_GROUP_EXEC_RET_INIT;
            g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_INIT;

            if (autrbk == 1) then
                g_CurNodeList[subKey][index].rf = 1
                g_UpdNode[ID][index].rf = 1
                LogText(LL_INFO, "Cur node exec autrbk." .. Node.rf)
            end
            -- NodeList״̬
            g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT
            UpdFrame_RunAtomGroupEx(agType, Node.ip, NextAtomGroup.AtomGroupName, NextAtomGroup.timeout, tp, ltp);
        end
    end

    ---֪ͨɺˢ״̬
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = {};
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait = 0;
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG = NextAtomGroup;
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncEnd = 1;

    --UpdFrame_SaveState(g_UpdState); ----֪ͨڵִͬAGã֪ͨһεһ
    for key, value in pairs(g_UpdNode) do
        UpdFrame_SaveNodeListState(g_UpdNode[key], key);
    end
    UpdFrame_SaveFlowExecState();
    UpdFrame_SaveCurExecState();
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_NotifyNodeExecNextAG
-- Description     : ָ֪ͨڵִһAG
-- Caution         : OMMά, ޸
-- Input           : ڵipҪִеԭ
--
--------------------------------------------------------------------------------
function UpdFrame_NotifyNodeExecNextAG(NodeIp, NextAtomGroup, autrbk, index)
    LogText(LL_INFO, "====next ag.")
    local agType = NextAtomGroup.ExcuteNodeType
    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    local ID = g_NodeIdList[index].id
    local tp = g_CurNodeList[subKey].curlist_config.NodeType
    local ltp = g_CurNodeList[subKey].curlist_config.LogicNodeType
    
    --֪ͨڵִһAG return 0
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].ExeCount = 0;
    g_CurNodeList[subKey][index].state = ATOM_GROUP_EXEC_RET_INIT;
    g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_INIT;

    if (autrbk == 1) then
        g_CurNodeList[subKey][index].rf = 1;
        g_UpdNode[ID][index].rf = 1;
        LogText(LL_INFO, "Next is rbk." .. g_CurNodeList[subKey][index].rf)
    end
    -- NodeList״̬
    g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT
    UpdFrame_RunAtomGroupEx(agType, NodeIp, NextAtomGroup.AtomGroupName, NextAtomGroup.timeout, tp, ltp);
    ---UpdFrame_SaveState(g_UpdState);  ----֪ͨڵִһAG֪ͨһαһ
    UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
    UpdFrame_SaveFlowExecState();
    UpdFrame_SaveCurExecState();
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_CurAGFinishType
-- Description     : ȴǰͬAG·Ľڵִ
--                   ǰбнڵ״̬Ϊɣҵǰڵִеagִͬag
-- Caution         : OMMά, ޸
-- Input           :
--
--------------------------------------------------------------------------------
function UpdFrame_CurAGFinishType(Result, NodeIp, nodeIndex)
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local ID = g_NodeIdList[nodeIndex].id
    local isFrame = IsFrameVersion()

    --ϴ·AGִͬ ͬһʱֻһAGͬ
    if (g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncEnd ==  1) then
        local agName = g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG.AtomGroupName
        local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
        for index, Node in pairs(subList) do
            ID = g_NodeIdList[index].id
            if (Node.state == ATOM_GROUP_EXEC_RET_INIT and g_UpdNode[ID][index].ag == agName and agName ~= nil) then
                LogText(LL_INFO, "Sync ag not finish." .. agName)
                --ִAG
                if (g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG.ExcuteNodeType == g_UpdFrame_Const.NodeTypeManager) then
                    LogText(LL_INFO, "UpdFrame_CurAGFinishType report manager:" .. Node.ip .. Result);
                    if isFrame then
                        ReportAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=agName, node_ip=Node.ip, node_index=index, result=Result}
                    else
                        ReportAtomGroup{flow_id=g_UpdState.FlowId, atom_group=agName, node_ip=Node.ip, result=Result}
                    end
                end
                return SYNC_WAIT
            end
        end
        LogText(LL_INFO, "Sync ag finish.")
        return SYNC_FINISH
    end
    --ǰνڵ·ag첽ִ
    LogText(LL_INFO, "IsCurAGNeedWait no need wait.")
    return ASYNC_FINISH;

end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsCurrentAGNeedSync
-- Description     : жϵǰAGǷҪͬ
-- Caution         : OMMά, ޸
-- Input           : ԭб
--
--------------------------------------------------------------------------------
function UpdFrame_IsCurrentAGNeedSync(NextAtomGroup, SyncFlow)
    if (NextAtomGroup.sync) then
        return true;
    elseif (SyncFlow) then
        return true;
    else
        return false;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_NotifyExecNextAG
-- Description     : ֪ͨڵִһAG
-- Caution         : OMMά, ޸
-- Input           : ԭб
--
--------------------------------------------------------------------------------
function UpdFrame_NotifyExecNextAG(AtomGroupTable, AtomGroup, Result, NodeIp, subKey, index, IsRbk)
    LogText(LL_NOTICE, "UpdFrame_NotifyExecNextAG:" .. NodeIp.." "..index.." ".. AtomGroup .. Result);
    local NextAtomGroup, autrbk = UpdFrame_GetNextAtomGroup(AtomGroupTable, AtomGroup, Result, NodeIp, IsRbk);
    local CurInfo = g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo];
    local ID = g_NodeIdList[index].id
    
    ---һAGΪʱֱýڵ
    if (nil == NextAtomGroup) then
        UpdFrame_SetUpdNodeFinish(NodeIp, Result, index, IsRbk);
        for i, Node in pairs(g_UpdNode[ID]) do
            LogText(LL_NOTICE, "UpdFrame_SetUpdNodeFinish after. "..NodeIp.." "..i.." "..g_UpdNode[ID][i].st);
        end
        ---жϵǰνڵǷִ
        if(UpdFrame_IsCurBatchFinishWhenAsync(NodeIp, index))then
            return UpdFrame_StartNewBatch()
        else
            ---жǷͬAGڵȴִ
            if (CurInfo.NeedWait >=  1) then
                LogText(LL_NOTICE, "===NeedWait .");
                if(UpdFrame_IsCanExecNextAG(CurInfo.AtuoRbk, subKey))then
                    UpdFrame_NotifyNodeExecBindAG(CurInfo.NeedWaitAG, CurInfo.AtuoRbk, subKey, IsRbk);
                end
            end
            LogText(LL_NOTICE, "Some node not finish.");

            UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
            UpdFrame_SaveCurExecState();
            return 0;
        end
    end

    ---һAGҪִͬȴڵ
    if (UpdFrame_IsCurrentAGNeedSync(NextAtomGroup, g_CurNodeList[subKey][g_UpdFrame_Const.CurListConfig].SyncFlow)) then
        if (nil == g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG
           or nil == next(g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG)) then
            g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = NextAtomGroup;
            g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].AtuoRbk = autrbk;
            g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait = 0;

            LogText(LL_NOTICE, "set next sync" .. NextAtomGroup.AtomGroupName .. g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].AtuoRbk);
        end
        --ǰAGҪͬʱˢµȴִдAGĽڵ ·ͬAGg_UpdState.NeedWait = 0
        if(g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait == 0) then
            g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait =  1;
        else
            g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait =  g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait + 1;
        end
        LogText(LL_NOTICE, "===set g_UpdState.NeedWait" .. g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait);
        if(UpdFrame_IsCanExecNextAG(autrbk, subKey))then
            LogText(LL_NOTICE, "===UpdFrame_IsCanExecNextAG .");
            UpdFrame_NotifyNodeExecBindAG(NextAtomGroup, autrbk, subKey, IsRbk);
            return 0;
        else
            LogText(LL_NOTICE, "===Need wait node.");
            --UpdFrame_SaveState(g_UpdState);  ----ڵϱȴڵɣ֪ͨڵִAG һ״̬
            UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
            UpdFrame_SaveCurExecState();
            return 0;
        end
    else
        ---һAGΪ жǷͬAGڵȴִ
        if (g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait >=  1) then
            if(UpdFrame_IsCanExecNextAG(g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].AtuoRbk, subKey))then
                LogText(LL_NOTICE, "Exec bind ag .");
                UpdFrame_NotifyNodeExecBindAG(g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG, g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].AtuoRbk, subKey, IsRb);
            end
        end
        --֪ͨǰڵִһAG return 0
        UpdFrame_NotifyNodeExecNextAG(NodeIp, NextAtomGroup, autrbk, index);
        return 0;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_RunFlowAgent
-- Description     : ִAgentڵǰ顢ύ
-- Caution         : OMMά, ޸
-- Input           : AtomGroupTableԭбIsRbkǷڻ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_RunFlowAgent(SubCurList)
    LogText(LL_NOTICE, "Enter UpdFrame_RunFlowAgent.");
    local AtomGroup = SubCurList.curlist_config.RepAG
    local NodeIp = SubCurList.curlist_config.RepIp
    local Result = SubCurList.curlist_config.RepRet
    local AtomGroupTable = SubCurList.agtbl
    local IsRbk = SubCurList.agtbl.isRbk;
    LogText(LL_INFO, "AtomGroup NodeIp Result."..AtomGroup.." "..NodeIp.." "..Result)
    LogText(LL_INFO, "Agent_BatchNo Agent_AGIndex."..g_UpdState.Agent_BatchNo.." "..SubCurList.curlist_config.Agent_AGIndex)
    
    if (AtomGroupTable == nil) then
        LogText(LL_ERROR, "Atom group table is nil.");
        UpdFrame_FinishFlowHandle()
        return FLOW_DISPATCH_STATE_FINISH;
    end

    --ʼһ
    if (0 == g_UpdState.Agent_BatchNo) then
        return UpdFrame_StartNewBatch()
    end

    --:CurNodeList
    --Ѿȡһֽڵ͵ĵһ
    if (AtomGroup == "" and NodeIp == "" and Result == ""
        and g_UpdState.Agent_BatchNo == 1 and SubCurList.curlist_config.Agent_AGIndex == 0) then
        LogText(LL_NOTICE, "Notify exec the first ag.");
        for subKey, SubCurList in pairs(g_CurNodeList) do
            if (not UpdFrame_IsSubCurListBegin(SubCurList)) then
                UpdFrame_UpdateNodeState(START_BATCH, SubCurList);

                --֪ͨڵִеһAG
                local AGIndex = 0;
                AGIndex = AGIndex + 1;
                local FirstAtomGroup = AtomGroupTable.upd[AGIndex];
                UpdFrame_NotifySubCurNodeNextAG(FirstAtomGroup, subKey);
                SubCurList.curlist_config.Agent_AGIndex = AGIndex;
            end
        end

        for key, value in pairs(g_UpdNode) do
            UpdFrame_SaveNodeListState(g_UpdNode[key], key);
        end
        UpdFrame_SaveCurExecState();
        UpdFrame_SaveFlowExecState();
        return 0
    end

    --ǵǰǷнڵִʧ
    local nodeIndex = GetIndexValue(NodeIp, SubCurList.curlist_config.NodeType, SubCurList.curlist_config.LogicNodeType)
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    LogText(LL_NOTICE, "CurNodeFail = "..SubCurList[g_UpdFrame_Const.CurListExecInfo].CurNodeFail);
    if (not UpdFrame_IsNodeExecSucc(Result, IsRbk) and 0 == SubCurList[g_UpdFrame_Const.CurListExecInfo].CurNodeFail) then
        LogText(LL_NOTICE, "Current batch has node fail.");
        SubCurList[g_UpdFrame_Const.CurListExecInfo].CurNodeFail = 1;
    end

    --ݵǰǷ󶨸½ڵ״̬Ϣ
    Result = UpdFrame_UpdateCurNodeStateASync(IsRbk, NodeIp, nodeIndex, Result);
    --ȡб
    local ID = g_NodeIdList[nodeIndex].id
    ---ǰagǷҪȴڵ
    local fiType = UpdFrame_CurAGFinishType(Result, NodeIp, nodeIndex);
    if (SYNC_WAIT == fiType) then
        LogText(LL_NOTICE, "Need wait other node.");
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
        return 0
    elseif (SYNC_FINISH == fiType) then
        LogText(LL_NOTICE, "No need wait other node.");
        local ret;
        local save = 0;
        local syncAGName = SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncExecAG.AtomGroupName
        SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncEnd = 0;
        SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncExecAG = {};
        UpdFrame_UpdateCurNodeStateSync(IsRbk, NodeIp, nodeIndex);

        local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
        for key, Node in pairs(subList) do
            --syncֻҪִеǰͬAGĽڵ·һAG
            local id = g_NodeIdList[key].id
            if (g_UpdNode[id][key].ag == syncAGName) then
                ret = UpdFrame_NotifyExecNextAG(AtomGroupTable, syncAGName, Node.state, Node.ip, subKey, key, IsRbk);
                save = 1;
                if(ret ~= 0) then
                    LogText(LL_NOTICE, "-----finish flow--------return." .. ret);
                    return ret;
                end
            end
        end
        if(save == 0)then
            --UpdFrame_SaveState(g_UpdState);  ----ͬAGδɣˢ½ڵ״̬ ϱһˢһ
            UpdFrame_SaveNodeListState(g_UpdNode[ID], ID)
            UpdFrame_SaveCurExecState();
        end
        return ret;
    else
        LogText(LL_NOTICE, "async notify." .. Result .. NodeIp);
        ret = UpdFrame_NotifyExecNextAG(AtomGroupTable, AtomGroup, Result, NodeIp, subKey, nodeIndex, IsRbk);
        return ret;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetCurAtomIndex
-- Description     : ȡǰAGӦindex
-- Caution         : OMMά, ޸
-- Input           : ǰ̶Ӧԭб flowõԭб
--
--------------------------------------------------------------------------------
function UpdFrame_GetCurAtomIndex(AtomGroupTable, AtomGroup, isRbk)
    local N;
    local curIndex = 0;
    if(not isRbk) then
        N = #AtomGroupTable.upd;
        for i=1, N do    --ҵǰԭ
            if (AtomGroup == AtomGroupTable.upd[i].AtomGroupName) then
                curIndex = i;
                break;
            end
        end
    else
        if (AtomGroupTable.rbk == nil) then
            return 0;
        end
        N = #AtomGroupTable.rbk;
        for i=1, N do    --ҵǰԭ
            if (AtomGroup == AtomGroupTable.rbk[i].AtomGroupName) then
                curIndex = i;
                break;
            end
        end
    end
    LogText(LL_NOTICE, "GetCurrentAGIndex return." .. curIndex);
    return curIndex;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetNextAtomIndex
-- Description     : ȡһAGӦindex
-- Caution         : OMMά, ޸
-- Input           : ûһҪִеAG0 index
--
--------------------------------------------------------------------------------
function UpdFrame_GetNextAtomIndex(AtomGroupTable, AtomGroup, isRbk)
    local curIndex = UpdFrame_GetCurAtomIndex(AtomGroupTable, AtomGroup, isRbk)
    local N;

    if isRbk then    --ԭ
        N = #AtomGroupTable.rbk;
    else
        N = #AtomGroupTable.upd;
    end

    if (curIndex >= N) then    --һԭ
        LogText(LL_NOTICE, "UpdFrame_GetNextAtomIndex return 0.");
        return 0;
    end
    curIndex = curIndex + 1;
    LogText(LL_NOTICE, "UpdFrame_GetNextAtomIndex return." .. curIndex);
    return curIndex;

end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsNodeExecSucc
-- Description     : жϽڵǷִгɹ
-- Caution         : OMMά, ޸
-- Input           : ״̬Ϊɹ ״̬Ϊ˳ɹʱʾڵִгɹ
--
--------------------------------------------------------------------------------
function UpdFrame_IsNodeExecSucc(Result, IsRbk)
    if ((not IsRbk) and (Result == ATOM_GROUP_EXEC_RET_SUCC))   --ɹ
        or (IsRbk and (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK))     --ǻһ˳ɹ
    then
        return true
    end
    return false
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsNodeExecSucc
-- Description     : ɹִһAG
--                   ˳ɹȡҪ˵AG
--                   ʧܻ߳ʱһAGΪnilýڵ
-- Caution         : OMMά, ޸
-- Input           : ״̬Ϊɹ ״̬Ϊ˳ɹʱʾڵִгɹ
--
--------------------------------------------------------------------------------
function UpdFrame_GetNextAtomGroup(AtomGroupTable, AtomGroup, Result, NodeIp, IsRbk)
    local nextAtomGroup = nil;
    local aturbk = 0;
    if (UpdFrame_IsNodeExecSucc(Result, IsRbk)) then    --̣ǰȡһԭ
        local nextAtomIndex = UpdFrame_GetNextAtomIndex(AtomGroupTable, AtomGroup, false);
        --ִеǰڵһԭ
        if (nextAtomIndex ~= 0) then
            nextAtomGroup = AtomGroupTable.upd[nextAtomIndex];
            aturbk = 0;
        end
    elseif ((not IsRbk) and (ATOM_GROUP_EXEC_RET_SUCC_RBK == Result)) then --˳ɹִк
        local curIndex = UpdFrame_GetCurAtomIndex(AtomGroupTable, AtomGroup, false);
        if (curIndex ~= 0) then    --ת
            local AtomGroupName = AtomGroupTable.upd[curIndex].rbk;
            local nextAtomIndex = UpdFrame_GetCurAtomIndex(AtomGroupTable, AtomGroupName, true);
            --ִеǰAG ӦĻAG
            if ((nextAtomIndex ~= 0) and (AtomGroupTable.rbk[nextAtomIndex] ~= nil)) then
                nextAtomGroup = AtomGroupTable.rbk[nextAtomIndex];
            end

        else    --ѾڻУһ
            local nextAtomIndex = UpdFrame_GetNextAtomIndex(AtomGroupTable, AtomGroup, true);
            --ִеǰڵһԭ
            if ((nextAtomIndex ~= 0) and (AtomGroupTable.rbk[nextAtomIndex] ~= nil)) then
                nextAtomGroup = AtomGroupTable.rbk[nextAtomIndex];
            end
        end
        aturbk = 1;
        if (nextAtomGroup ~= nil) then
            LogText(LL_NOTICE, "Need rbk.");
        end
    end
    if (nextAtomGroup == "") then
        nextAtomGroup = nil;
    end

    if(nil == nextAtomGroup)then
        LogText(LL_INFO, "=====nextAtomGroup is nil");
    end
    return nextAtomGroup, aturbk;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ProcessOvertimeAtomGroup
-- Description     : ϱʱԭ
-- Caution         : OMMά, ޸
-- Input           : AtomGroup ǰԭ
--                   NodeIp ڵip
--                   Result ǰԭִн
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ProcessOvertimeAtomGroup(AtomGroup, NodeIp, Index, Result)
    if (Result ~= ATOM_GROUP_EXEC_RET_TIMEOUT) then
        return
    end
    
    local isFrame = IsFrameVersion()
    if isFrame then
        ReportOvertimeAtomWithParam{atom_group=AtomGroup, node_ip=NodeIp, node_index=Index, error_code=ERR_EXECUTE,result=ATOM_ERR_RET}
    else
        ReportOvertimeAtom{atom_group=AtomGroup, node_ip=NodeIp, error_code=ERR_EXECUTE,result=ATOM_ERR_RET}
    end
    
    local ID = g_NodeIdList[Index].id
    g_UpdNode[ID][Index].st = NODE_STATE_TIMEOUT
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_CanExecuteNextAG
-- Description     : жԭǷִ
-- Caution         : OMMά, ޸
-- Input           : stateԭ״̬IsRbkǷڻ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_CanExecuteNextAG(state, IsRbk)
    if (state == ATOM_GROUP_EXEC_RET_INIT)                        --δʼִ
        or ((not IsRbk) and (state == ATOM_GROUP_EXEC_RET_SUCC))   --ɹ
        or (IsRbk and (state == ATOM_GROUP_EXEC_RET_SUCC_RBK))     --ǻһ˳ɹ
    then
        return true
    end
    return false
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_NotifySubCurNodeNextAG
-- Description     : ֪ͨǰνڵִеһAG
--                   һAGΪͬAGSyncExecAGڵһAG Ϊ
-- Caution         : OMMά, ޸
-- Input           : ҪִеԭӦı
--
--------------------------------------------------------------------------------
function UpdFrame_NotifySubCurNodeNextAG(AtomGroup, subKey)
    LogText(LL_INFO, "Enter UpdFrame_NotifySubCurNodeNextAG. "..subKey)
    --ִеԭ飬ýڵrt״̬Ϊʼ״̬-1
    g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].ExeCount = 0;
    local ID = 0;
    local NodeType = g_CurNodeList[subKey].curlist_config.NodeType
    local LogicNodeType = g_CurNodeList[subKey].curlist_config.LogicNodeType
    local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
    for index, Node in pairs(subList) do
        if (UpdFrame_CanExecuteNextAG(Node.state, IsRbk)) then
            LogText(LL_INFO, "UpdFrame_CanExecuteNextAG. "..Table2String(Node))
            UpdFrame_RunAtomGroupEx(AtomGroup.ExcuteNodeType, Node.ip, AtomGroup.AtomGroupName, AtomGroup.timeout, NodeType, LogicNodeType);
        end
    end
    --֪ͨɺˢ״̬Ϣ
    --жAGǷҪִͬҪִͬʱñ
    if (UpdFrame_IsCurrentAGNeedSync(AtomGroup, g_CurNodeList[subKey][g_UpdFrame_Const.CurListConfig].SyncFlow)) then
        --:ԵǰбˢȫϢ
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG =  AtomGroup;
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncEnd = 1;
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = {};
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].NeedWait = 0;
    else
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncExecAG = {};
        g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].SyncEnd = 0;
    end
end

-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------ת---------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------ָ---------------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ResumeUpdCurNodeList
-- Description     : ڵ㲻g_UpdState.CurNodeListnodelistнڵ״̬Ϊִ ʱҪڵ¼뵽curnodelistִ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ResumeUpdCurNodeList(SubCurList)
    local resumeFlag = false;
    for ID, nodeList in pairs(g_UpdNode) do
        for index, node in pairs(nodeList) do
            if (NODE_STATE_RUNNING == node.st and -1 == UpdFrame_GetSubKeyFromCurList(index)) then
                resumeFlag = true
                if (nil == SubCurList["omm_resume"]) then
                    SubCurList["omm_resume"] = {}
                end
                g_CurNodeList["omm_resume"][index] = {};
                g_CurNodeList["omm_resume"][index].ip = node.ip
                g_CurNodeList["omm_resume"][index].tp = node.tp
                g_CurNodeList["omm_resume"][index].ltp = node.ltp
                g_CurNodeList["omm_resume"][index].state = -1;
                g_CurNodeList["omm_resume"][index].rf = 0
                LogText(LL_INFO, "ResumeCurNodeList return node." .. node.ip);
            end
        end
        if (true == resumeFlag) then
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo] = {};
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = {};
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo].NeedWait   = 0;
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo].SyncExecAG = {};
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo].SyncEnd = 0;
            g_CurNodeList["omm_resume"][g_UpdFrame_Const.CurListExecInfo].ExeCount = 0;
            LogText(LL_INFO, "ResumeCurNodeList return true.");
        else
            LogText(LL_INFO, "ResumeCurNodeList return false.");
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : Resume
-- Description     : ̸λִָеǰ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function Resume()
    if (nil == g_UpdState) or (nil == g_UpdState.Flow) or ("" == g_UpdState.Flow) or (nil == g_UpdState.FlowState) or (0 == g_UpdState.FlowState) then
        LogText(LL_NOTICE, "No flow is executing.");
        g_UpdState.FlowState = FLOW_STATE_FINISH
        UpdFrame_UpdateNodeState(TERM_FLOW, {});
        UpdFrame_SaveState(g_UpdState); ----Resume̷̽ʱ һ
        return FLOW_DISPATCH_STATE_FINISH;
    end
    LogText(LL_NOTICE, "Resume flow: " .. g_UpdState.Flow);

    --ResumeʱҪ̴, Ҫ鵱ǰǷѾִ
    if (FLOW_STATE_PAUSE == g_UpdState.FlowState) then
        return FLOW_DISPATCH_STATE_PAUSE;
    elseif (FLOW_STATE_FINISH == g_UpdState.FlowState) then
        UpdFrame_UpdateNodeState(TERM_FLOW, {});
        UpdFrame_SaveState(g_UpdState); ----ϴResume̷̽ʱ һ
        return FLOW_DISPATCH_STATE_FINISH;
    else
        local UpgState = UpdFrame_ResumeFlow();
        if (FLOW_DISPATCH_STATE_NORMAL == UpgState and g_UpdState.GetNodeListFlag) then
            LogText(LL_NOTICE, "Resume get node list timer." );
            ResetGetListTimer{reset_timer=1};
        end
        return UpgState;
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ResumeFlow
-- Description     : UPDSָ ִ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ResumeFlow()
    local isFinish = true;
    --鿴nodelistнڵ״̬нڵ
    for _,nodelist in pairs(g_UpdNode) do
        for _, Node in pairs(nodelist) do
            if (Node.st == NODE_STATE_RUNNING or Node.st == NODE_STATE_INIT) then
                isFinish = false;
                break;
            end
        end
    end
    
    --нڵ㶼Ҫֱָ˳
    if (isFinish) then
        UpdFrame_UpdateNodeState(TERM_FLOW, {});
        g_UpdState.FlowState = FLOW_STATE_FINISH;
        ----:Resume 쳣һ 滻
        UpdFrame_SaveState(g_UpdState); ----Resume̷̽ʱ һ
        LogText(LL_NOTICE, "All node finish and return finish.");
        return FLOW_DISPATCH_STATE_FINISH;
    end

    --нڵδҪ֪ͨڵִAG
    local rtFinish = 0;

    for subKey, SubCurList in pairs (g_CurNodeList) do
        local IsRbk = SubCurList.agtbl.isRbk;
        if (SubCurList.curlist_config.NodeType == g_UpdFrame_Const.NodeTypeManager and (g_UpdState.Flow ~= "PRECHECK") and (g_UpdState.Flow ~= "COMMIT")) then
            local agIndex = g_UpdState.Manager_AGIndex;
            local agGroup = {};

            if (0 == agIndex) then
                LogText(LL_NOTICE, "Resume agindex is 0 and start.")
                g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_INIT;
                g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT;
                if (IsRbk) then
                    LogText(LL_NOTICE, "Resume start UpdFrame_RollbackFSM.")
                    return UpdFrame_RollbackFSM(SubCurList);
                else
                    LogText(LL_NOTICE, "Resume start UpdFrame_UpdateFSM.")
                    return UpdFrame_UpdateFSM(SubCurList);
                end
            end

            if (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG) then
                agGroup = SubCurList.agtbl.upd[agIndex];
            elseif (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG_RBK) then
                agGroup = SubCurList.agtbl.rbk[agIndex];
            else
                g_UpdState.FlowState = FLOW_STATE_FINISH;
                UpdFrame_UpdateNodeState(TERM_FLOW, {});
                 ----:Resumeʱ FSM״̬쳣һ 滻
                UpdFrame_SaveState(g_UpdState); ----Resume̷̽ʱ һ
                LogText(LL_NOTICE, "Manager_FlowState is wrong: " .. g_UpdState.Manager_FlowState);
                return FLOW_DISPATCH_STATE_FINISH;
            end

            g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT
            ---֪ͨǰһִеĽڵִAG
            local subList = UpdFrame_GetSubFromCurList(SubCurList)
            for index, Node in pairs(subList) do
                local ID = g_NodeIdList[index].id
                if (g_UpdNode[ID][index].ag == agGroup.AtomGroupName) then
                    LogText(LL_NOTICE, "Notify exec finish node exec resume ag.");
                    g_UpdNode[ID][index].st = NODE_STATE_RUNNING;
                    Node.state = ATOM_GROUP_EXEC_RET_INIT;
                    ---ResetAtomGroup˽ӿҪڵrtǳʼ״̬
                    g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT;
                    UpdFrame_ResetAtomGroup(g_UpdState.FlowId, SubCurList, index, Node.ip);
                    return FLOW_DISPATCH_STATE_NORMAL;
                end
            end

        else
            local fcount = 0;
            local scount = 0;
            local subList = UpdFrame_GetSubFromCurList(SubCurList)
            for index, Node in pairs(subList) do
                local ID = g_NodeIdList[index].id
                if (g_UpdNode[ID][index].st ~= NODE_STATE_RUNNING and g_UpdNode[ID][index].st ~= NODE_STATE_INIT) then
                    fcount = fcount + 1;
                elseif (g_UpdNode[ID][index].st == NODE_STATE_INIT ) then
                    scount = scount + 1;
                end
            end

            --쳣
            --ڵ㲻g_UpdState.CurNodeListnodelistнڵ״̬Ϊִ --ʱҪڵ¼뵽curnodelistִ
            UpdFrame_ResumeUpdCurNodeList(SubCurList);

            local curTbl = SubCurList.agtbl
            local len = UpdFrame_GetAllCurListLenth(g_CurNodeList)
            if (fcount == len or scount == len or (g_UpdState.Agent_BatchNo == 0 and g_UpdState.Agent_AGIndex == 0)) then
                LogText(LL_NOTICE, "Resume start new batch." .. fcount .. scount);
                return UpdFrame_StartNewBatch();
            end

            ----ˢ״̬Ϣ
            SubCurList[g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = {};
            SubCurList[g_UpdFrame_Const.CurListExecInfo].NeedWait = 0;
            SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncExecAG = {};
            SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncEnd = 0;

            ---ǷҪִͬеAG ִͬеAG һ·
            for index, Node in pairs(subList) do
                local timeout, agType, curAG, agTbl = UpdFrame_GetCurAGInfo(SubCurList, index);
                if (UpdFrame_IsCurrentAGNeedSync(agTbl, SubCurList[g_UpdFrame_Const.CurListConfig].SyncFlow) and 0 == SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncEnd) then
                    SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncExecAG =  agTbl;
                    SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncEnd =  1;
                    LogText(LL_NOTICE, "The resume ag is sync." .. curAG);
                    break;
                end
            end

            ---ִͬһ·
            ---ȶִͬAGͬʱ·
            SubCurList[g_UpdFrame_Const.CurListExecInfo].ExeCount = 0;
            local syncExecAGTbl = SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncExecAG
            for index, Node in pairs(subList) do
                local ID = g_NodeIdList[index].id
                if (g_UpdNode[ID][index].st == NODE_STATE_RUNNING and UpdFrame_GetAtomGroupEx(index) ~= nil
                    and UpdFrame_GetAtomGroupEx(index) == syncExecAGTbl.AtomGroupName) then
                    Node.state = ATOM_GROUP_EXEC_RET_INIT;
                    g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT;
                    ---ResetAtomGroup˽ӿҪڵrtǳʼ״̬
                    LogText(LL_NOTICE, "UpdFrame_ResumeFlow index = " .. index);
                    UpdFrame_RunAtomGroupEx(syncExecAGTbl.ExcuteNodeType, Node.ip, syncExecAGTbl.AtomGroupName, syncExecAGTbl.timeout, SubCurList.curlist_config.NodeType, SubCurList.curlist_config.LogicNodeType);
                    LogText(LL_NOTICE, "Resume notify node exec sync ag:" .. Node.ip .. g_UpdNode[ID][index].ag);
                end
            end
            ---첽·
            for index, Node in pairs(subList) do
                local ID = g_NodeIdList[index].id
                if (g_UpdNode[ID][index].st == NODE_STATE_RUNNING and UpdFrame_GetAtomGroupEx(index) ~= nil
                    and UpdFrame_GetAtomGroupEx(index) ~= syncExecAGTbl.AtomGroupName) then
                    SubCurList[g_UpdFrame_Const.CurListExecInfo].ExeCount = 0;
                    Node.state = ATOM_GROUP_EXEC_RET_INIT;
                    g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT;
                    ---ResetAtomGroup˽ӿҪڵrtǳʼ״̬
                    UpdFrame_ResetAtomGroup(g_UpdState.FlowId, SubCurList, index, Node.ip);
                    LogText(LL_NOTICE, "Resume notify node exec async ag:" .. Node.ip .. g_UpdNode[ID][index].ag);
                end
            end

            LogText(LL_NOTICE, "The current resume.");
            return FLOW_DISPATCH_STATE_NORMAL
        end
    end
    
    LogText(LL_NOTICE, "The current can not resume.");
    return FLOW_DISPATCH_STATE_NORMAL
end

--------------------------------------------------------------------------------
-- Func Name       : ResumeTaskInfo
-- Description     : ָ̣ȡ̵ԭӦĽ
-- Caution         : OMMά, ޸
-- Input           : TaskId id
--                   TaskType 
--                   XmlPath xmlļ·
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function ResumeTaskInfo(TaskId, TaskType, XmlPath)
    LogText(LL_NOTICE, "Start task id: " .. TaskId.."tp"..TaskType.."xp");

    --xmlļ
    local file = io.open(XmlPath, "r");
    local fileData = file:read("*all");

    --ȡǰϢ
    local curtaskinfo = UpdFrame_GetTaskById(TaskId, fileData)
    if ("" == curtaskinfo) then
        LogText(LL_ERROR, "Fail to get current taskinfo, id " .. TaskId);
        return 1
    end

    --Ϣʼg_TaskInfo
    local ret = UpdFrame_SetCurrentTaskInfo(TaskId, TaskType, curtaskinfo)
    if (1 == ret) then
        LogText(LL_ERROR, "Fail to set current taskinfo, id " .. TaskId);
        return 1
    end

    file:close()
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ResumeAGWhenFlowIdDiff
-- Description     : ˮŲͬʱظ
-- Caution         : OMMά, ޸
-- Input           : 
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ResumeAGWhenFlowIdDiff(SubList, NodeIndex)
    local agName = UpdFrame_GetAtomGroupEx(NodeIndex);
    --жǷǵһAGҵһAGִ
    local curTbl = "";
    local isFirst = false;
    local agIndex = g_UpdState.Manager_AGIndex;
    local agGroup = {};

    --ȡϱĽڵڵǰбеǸб
    local tp = SubList.curlist_config.NodeType
    local ltp = SubList.curlist_config.LogicNodeType
    local ID = g_NodeIdList[NodeIndex].id
    local NodeIp = SubList[NodeIndex].ip
    if (tp == g_UpdFrame_Const.NodeTypeManager and (g_UpdState.Flow ~= "PRECHECK") and (g_UpdState.Flow ~= "COMMIT")) then
        if (g_UpdNode[ID][NodeIndex].st == NODE_STATE_RUNNING and agName ~= nil) then
            UpdFrame_ReportAgentExecing(NodeIp, NodeIndex, agName);
            UpdFrame_ResetAtomGroup(g_UpdState.FlowId, SubList, NodeIndex, NodeIp);
            LogText(LL_NOTICE, "Flow id is different and reset atom group" .. NodeIp .. agName)
            return;
        end
        --AϱĽڵ㲻ڵǰڵб(֮ǰִеAgentصAG)
        if (agIndex >= 1) then
            if (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG) then
                agGroup = SubList.agtbl.upd[agIndex];
            elseif (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG_RBK) then
                agGroup = SubList.agtbl.rbk[agIndex];
            else
                LogText(LL_NOTICE, "Manager_FlowState is wrong: " .. g_UpdState.Manager_FlowState);
                return ;
            end
            ---֪ͨǰһִеĽڵִAG
            local subCur = UpdFrame_GetSubFromCurList(SubList)
            for key, Node in pairs(subCur) do
                local id = g_NodeIdList[key].id
                if (g_UpdNode[id][key].ag == agGroup.AtomGroupName) then
                    LogText(LL_NOTICE, "Notify cur node exec resume ag." .. agGroup.AtomGroupName .. Node.ip);
                    ---ResetAtomGroup˽ӿҪڵrtǳʼ״̬
                    UpdFrame_ReportAgentExecing(NodeIp, key, agGroup.AtomGroupName);
                    UpdFrame_ResetAtomGroup(g_UpdState.FlowId, SubList, key, Node.ip);
                end
            end
        end
        return;
    end

    curTbl = SubList.agtbl;
    local subCur = UpdFrame_GetSubFromCurList(SubList)
    for key, Node in pairs(subCur) do
         --֪ͨڵִеһAG
        local id = g_NodeIdList[key].id
        if (g_UpdNode[id][key].st == NODE_STATE_RUNNING
            and g_UpdNode[id][key].ag == curTbl.upd[1].AtomGroupName
            and g_UpdFrame_Const.NodeTypeManager == curTbl.upd[1].ExcuteNodeType ) then
            isFirst = true;
            UpdFrame_NotifySubCurNodeNextAG(curTbl.upd[1], subKey);
            LogText(LL_NOTICE, "Flow id is different and notify first atom group");
            return;
        end
    end
    if (SubList[NodeIndex] ~= nil and g_UpdNode[ID][NodeIndex].st == NODE_STATE_RUNNING and agName ~= nil) then
        UpdFrame_ReportAgentExecing(NodeIp, NodeIndex, agName);
        UpdFrame_ResetAtomGroup(g_UpdState.FlowId, SubList, NodeIndex, NodeIp);
        LogText(LL_NOTICE, "Flow id is different and reset atom group" .. NodeIp .. agName)
    end
    return;
end

-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------ָ---------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------FSM----------------------------------------------------------
-------------------------------------------------------START-----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateState
-- Description     : FSMʱNodeList״̬
-- Caution         : OMMά, ޸
-- Input           : AtomGroup ǰԭ
--                   NodeIp ڵip
--                   Result ǰԭִн
-- Output          :
-- Return          :
---------------------------------------------------------------------------
function UpdFrame_UpdateManagerProgress(AtomGroup, NodeIp, nodeIndex, Result)
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local ID = g_NodeIdList[nodeIndex].id;
    local progress = UpdFrame_GetAgProgress(g_UpdState.Flow, AtomGroup, g_CurNodeList[subKey])
    LogText(LL_INFO, "Get progress, atom group: " .. AtomGroup .. " progress: " .. progress..", Result: "..Result);

    
    -- NodeList״̬, ûҵ˵
    local NodeT = g_UpdNode[ID][nodeIndex]
    if (NodeT ~= nil ) then
        g_CurNodeList[subKey][nodeIndex].state = Result
        g_UpdNode[ID][nodeIndex].rt = Result
        g_UpdNode[ID][nodeIndex].ct = Result
    end

    if g_CurNodeList[subKey].agtbl.isRbk then
        if (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
            --ڻ˳ɹʱ½
            g_UpdNode[ID][nodeIndex].pr = progress;
        end
    else
        if (Result == ATOM_GROUP_EXEC_RET_SUCC) then
            --ɹʱ½
            g_UpdNode[ID][nodeIndex].pr = progress;
        elseif (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG_RBK) then
            --ʧܻ˳ɹʱ½
            if ((progress - g_UpdNode[ID][nodeIndex].pr) > 0) then
                g_UpdNode[ID][nodeIndex].pr = progress;
            end
        end
    end

    UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_RollbackFSM
-- Description     : FSM
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_RollbackFSM(SubCurList)
    LogText(LL_NOTICE, "Enter UpdFrame_RollbackFSM. ActiveNode:" .. g_ClusterInfo.ActiveNode .. " SlaveNode:" .. g_ClusterInfo.SlaveNode);

    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType

    local index = 0
    local ID = 0

    if (g_UpdState.Manager_UpgState == MANAGER_UPG_STATE_INIT) then --δִ
        --ǰ״̬޸Ϊִ
        index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
        ID = g_NodeIdList[index].id
        g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_RUN;
        g_UpdNode[ID][index].st = NODE_STATE_RUNNING;
        g_UpdNode[ID][index].bt = os.time();

        ---ʼһʱִ
        UpdFrame_SaveCurNodeList();
        UpdFrame_SaveCurExecState();
        UpdFrame_UpdateNodeState(START_BATCH, SubCurList);
        for key, value in pairs(g_UpdNode) do
            UpdFrame_SaveNodeListState(g_UpdNode[key], key);
        end
        UpdFrame_SaveCurExecState();

        if (g_ClusterInfo.SlaveNode ~= "") then
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            g_UpdNode[ID][index].st =  NODE_STATE_RUNNING;
            g_UpdNode[ID][index].bt = os.time();
        end
    elseif (g_UpdState.Manager_UpgState == MANAGER_UPG_STATE_RUN) then --ִ
        if (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_INIT) then
            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState); ----FSM̽ʱһ
            LogText(LL_ERROR, "Manager_UpgResult is wrong: " .. g_UpdState.Manager_UpgResult);
            return UpdFrame_StartNewBatch()
        end
    else --Ѿִгɹִʧ
        UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
        UpdFrame_SaveState(g_UpdState); ----FSM̽ʱһ
        LogText(LL_WARN, "Manager has been rollbacked.");
        return UpdFrame_StartNewBatch()
    end

    --ǰִгɹ,ִһ
    if (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_SUCC_RBK) or (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_INIT) then
        local AGIndex = g_UpdState.Manager_AGIndex;
        if (AGIndex >= #SubCurList.agtbl.upd) then
            g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_SUCC;
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_SUCC;
            g_UpdNode[ID][index].et = os.time();
            --ִгɹӵɹбԷķ
            local activeSuccNode = {}
            activeSuccNode.ip = g_ClusterInfo.ActiveNode
            activeSuccNode.tp = GetNTPValue(tp)
            activeSuccNode.ltp = GetLTPValue(ltp)
            activeSuccNode.state = ATOM_GROUP_EXEC_RET_SUCC_RBK
            g_SuccNodeList[index] = activeSuccNode
            if (g_ClusterInfo.SlaveNode ~= "") then
                index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
                ID = g_NodeIdList[index].id
                g_UpdNode[ID][index].st = NODE_STATE_SUCC;
                g_UpdNode[ID][index].et = os.time();
                local slaveSuccNode = {}
                slaveSuccNode.ip = g_ClusterInfo.SlaveNode
                slaveSuccNode.tp = GetNTPValue(tp)
                slaveSuccNode.ltp = GetLTPValue(ltp)
                slaveSuccNode.state = ATOM_GROUP_EXEC_RET_SUCC_RBK
                g_SuccNodeList[index] = slaveSuccNode
            end

            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState);  ----FSM̽ʱһ

            LogText(LL_NOTICE, "Rollback manager success.");
            return UpdFrame_StartNewBatch()
        end

        AGIndex = AGIndex + 1;
        local AtomGroup = SubCurList.agtbl.upd[AGIndex];
        g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT

        if (AtomGroup.RunOnActive) then
            UpdFrame_ActiveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Exec atom group:" .. AtomGroup.AtomGroupName);
        else
            UpdFrame_SlaveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            LogText(LL_NOTICE, "----Exec atom group:" .. AtomGroup.AtomGroupName);
        end

        g_UpdState.Manager_AGIndex = AGIndex;
        --UpdFrame_SaveState(g_UpdState);  ----FSM·AGʱ·һεһ
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
        UpdFrame_SaveFlowExecState();

        return FLOW_DISPATCH_STATE_NORMAL;
    else --ǰִʧ,жϻ˲
        g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_FAIL
        index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
        ID = g_NodeIdList[index].id
        g_UpdNode[ID][index].st = NODE_STATE_FAIL;
        g_UpdNode[ID][index].et = os.time();
        local activeFailNode = {}
        activeFailNode.ip = g_ClusterInfo.ActiveNode
        activeFailNode.tp = GetNTPValue(tp)
        activeFailNode.ltp = GetLTPValue(ltp)
        activeFailNode.state = ATOM_GROUP_EXEC_RET_FAIL
        g_FailNodeList[index] = activeFailNode
        if (g_ClusterInfo.SlaveNode ~= "") then
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            g_UpdNode[ID][index].st = NODE_STATE_FAIL;
            g_UpdNode[ID][index].et = os.time();
            local slaveFailNode = {}
            slaveFailNode.ip = g_ClusterInfo.SlaveNode
            slaveFailNode.tp = GetNTPValue(tp)
            slaveFailNode.ltp = GetLTPValue(ltp)
            slaveFailNode.state = ATOM_GROUP_EXEC_RET_FAIL
            g_FailNodeList[index] = slaveFailNode
        end
        UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
        UpdFrame_SaveState(g_UpdState); ----FSM̽ʱһ

        LogText(LL_ERROR, "Stop rollback.");
        return UpdFrame_StartNewBatch()
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateFSM
-- Description     : FSM
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateFSM(SubCurList)
    LogText(LL_NOTICE, "Enter UpdateFSM. ActiveNode:" .. g_ClusterInfo.ActiveNode .. " SlaveNode:" .. g_ClusterInfo.SlaveNode);
    LogText(LL_NOTICE, "g_UpdState.Manager_UpgResult = "..g_UpdState.Manager_UpgResult)

    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType

    local index = 0
    local ID = 0
    -- δִ
    if (g_UpdState.Manager_UpgState == MANAGER_UPG_STATE_INIT) then 
        --ǰ״̬޸Ϊִ
        g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_RUN;
        index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
        ID = g_NodeIdList[index].id
        g_UpdNode[ID][index].st = NODE_STATE_RUNNING;
        g_UpdNode[ID][index].bt = os.time();
        if (g_ClusterInfo.SlaveNode ~= "") then
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            g_UpdNode[ID][index].st = NODE_STATE_RUNNING;
            g_UpdNode[ID][index].bt = os.time();
        end
    
    -- ִ
    elseif (g_UpdState.Manager_UpgState == MANAGER_UPG_STATE_RUN) then
        if (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_INIT) then
            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState);
            LogText(LL_ERROR, "Manager_UpgResult is wrong: " .. g_UpdState.Manager_UpgResult);
            return UpdFrame_StartNewBatch()
        end
    
    -- Ѿִгɹִʧ
    else
        UpdFrame_UpdateNodeState(END_BATCH,SubCurList);
        UpdFrame_SaveState(g_UpdState);
        LogText(LL_WARN, "Manager has been upgraded.");
        return UpdFrame_StartNewBatch()
    end

    --ɹʧܻ
    if (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG) then
        return UpdFrame_UpdateFSM_Upg(SubCurList);
    elseif (g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG_RBK) then
        return UpdFrame_UpdateManager_Rbk(SubCurList);
    else
        UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
        UpdFrame_SaveState(g_UpdState)
        LogText(LL_ERROR, "Manager_FlowState is wrong: " .. g_UpdState.Manager_FlowState);
        return UpdFrame_StartNewBatch()
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateFSM_Upg
-- Description     : FSM
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateFSM_Upg(SubCurList)
    LogText(LL_NOTICE, "Enter UpdFrame_UpdateFSM_Upg");

    local AGIndex = g_UpdState.Manager_AGIndex;
    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType
    local index = 0
    local ID = 0
    
    -- ǰִгɹߵ1ִ,ִһ
    if (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_SUCC) or (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_INIT) then
        if (AGIndex >= #SubCurList.agtbl.upd) then
            g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_SUCC;
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_SUCC;
            g_UpdNode[ID][index].et = os.time();
            -- ִгɹӵɹбԷķ
            local activeSuccNode = {}
            activeSuccNode.ip = g_ClusterInfo.ActiveNode
            activeSuccNode.tp = GetNTPValue(tp)
            activeSuccNode.ltp = GetLTPValue(ltp)
            activeSuccNode.state = ATOM_GROUP_EXEC_RET_SUCC
            g_SuccNodeList[index] = activeSuccNode
            if (g_ClusterInfo.SlaveNode ~= "") then
                index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
                ID = g_NodeIdList[index].id;
                g_UpdNode[ID][index].st = NODE_STATE_SUCC;
                g_UpdNode[ID][index].et = os.time();
                local slaveSuccNode = {}
                slaveSuccNode.ip = g_ClusterInfo.SlaveNode
                slaveSuccNode.tp = GetNTPValue(tp)
                slaveSuccNode.ltp = GetLTPValue(ltp)
                slaveSuccNode.state = ATOM_GROUP_EXEC_RET_SUCC
                g_SuccNodeList[index] = slaveSuccNode
            end
            
            -- һɺʼµһ
            return UpdFrame_StartNewBatch()
        end

        for _, Node in pairs (g_UpdNode) do
            for _, node in pairs (Node) do
                LogText(LL_INFO, "UpdFrame_UpdateFSM_Upg Node = "..Table2String(node))
            end
        end

        --ȡִһԭ
        AGIndex = AGIndex + 1;
        LogText(LL_NOTICE, "AGIndex = "..AGIndex);
        local AtomGroup = SubCurList.agtbl.upd[AGIndex];
        g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT
        if (AtomGroup.RunOnActive) then
            UpdFrame_ActiveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Active exec atom group:" .. AtomGroup.AtomGroupName);
        else
            UpdFrame_SlaveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Slave exec atom group:" .. AtomGroup.AtomGroupName);
        end

        g_UpdState.Manager_AGIndex = AGIndex;
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
        UpdFrame_SaveFlowExecState();

        return 0;
        
    --ǰִʧһ˳ɹ,ִжӦĻAtomGroup
    elseif (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
        local RbkAtomGroupName = SubCurList.agtbl.upd[AGIndex].rbk;
        if (RbkAtomGroupName == nil) or (RbkAtomGroupName == "") then --Ƿ˻AtomGroup
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].pr = 100;
            g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
            g_UpdNode[ID][index].et = os.time();
            local activeAutoRbkNode = {}                        -- ԶɹӵԶбԷķ
            activeAutoRbkNode.ip = g_ClusterInfo.ActiveNode
            activeAutoRbkNode.tp = GetNTPValue(tp)
            activeAutoRbkNode.ltp = GetLTPValue(ltp)
            g_AutoRbkSuccNodeList[index] = activeAutoRbkNode
            if (g_ClusterInfo.SlaveNode ~= "") then
                index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
                ID = g_NodeIdList[index].id
                g_UpdNode[ID][index].pr = 100;
                g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
                g_UpdNode[ID][index].et = os.time();
                local slaveAutoRbkNode = {}                     -- ԶɹӵԶбԷķ
                slaveAutoRbkNode.ip = g_ClusterInfo.SlaveNode
                slaveAutoRbkNode.tp = GetNTPValue(tp)
                slaveAutoRbkNode.ltp = GetLTPValue(ltp)
                g_AutoRbkSuccNodeList[index] = slaveAutoRbkNode
            end

            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState);

            LogText(LL_NOTICE, "Need rollback, but no atom group.");
            return UpdFrame_StartNewBatch()
        end

        --һAtomGroupӦ
        AGIndex = 0;
        for i = 1, #SubCurList.agtbl.rbk do
            if (SubCurList.agtbl.rbk[i].AtomGroupName == RbkAtomGroupName) then
                AGIndex = i;
                break;
            end
        end

        --ӦAtomGroupǷ
        if (AGIndex == 0) then
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
            g_UpdNode[ID][index].et = os.time();
            local activeAutoRbkNode = {}                        -- ԶɹӵԶбԷķ
            activeAutoRbkNode.ip = g_ClusterInfo.ActiveNode
            activeAutoRbkNode.tp = GetNTPValue(tp)
            activeAutoRbkNode.ltp = GetLTPValue(ltp)
            g_AutoRbkSuccNodeList[index] = activeAutoRbkNode
            if (g_ClusterInfo.SlaveNode ~= "") then
                index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
                ID = g_NodeIdList[index].id
                g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
                g_UpdNode[ID][index].et = os.time();
                local slaveAutoRbkNode = {}                     -- ԶɹӵԶбԷķ
                slaveAutoRbkNode.ip = g_ClusterInfo.SlaveNode
                slaveAutoRbkNode.tp = GetNTPValue(tp)
                slaveAutoRbkNode.ltp = GetLTPValue(ltp)
                g_AutoRbkSuccNodeList[index] = slaveAutoRbkNode
            end
            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState);

            LogText(LL_ERROR, "Not found the specific rollback atom group:" .. RbkAtomGroupName);
            return UpdFrame_StartNewBatch()
        end

        -- ִжӦĻAtomGroup
        local RbkAtomGroup = SubCurList.agtbl.rbk[AGIndex];
        g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT
        if (RbkAtomGroup.RunOnActive) then
            UpdFrame_ActiveRunAtomGroup(SubCurList, RbkAtomGroup.AtomGroupName, RbkAtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Exec atom group:" .. RbkAtomGroup.AtomGroupName);
        else
            UpdFrame_SlaveRunAtomGroup(SubCurList, RbkAtomGroup.AtomGroupName, RbkAtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Exec atom group:" .. RbkAtomGroup.AtomGroupName);
        end

        g_UpdState.Manager_FlowState = MANAGER_FLOW_STATE_UPG_RBK;
        g_UpdState.Manager_AGIndex = AGIndex;

        -- FSMʱ·һAG һ
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID)
        UpdFrame_SaveFlowExecState();
        return FLOW_DISPATCH_STATE_NORMAL;
    
    -- ǰִʧһʧִܻгʱ,жϲ
    else
        g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_FAIL;
        index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
        ID = g_NodeIdList[index].id
        g_UpdNode[ID][index].st = NODE_STATE_FAIL;
        g_UpdNode[ID][index].et = os.time();
        local activeFailNode = {}
        activeFailNode.ip = g_ClusterInfo.ActiveNode
        activeFailNode.tp = GetNTPValue(tp)
        activeFailNode.ltp = GetLTPValue(ltp)
        activeFailNode.state = NODE_STATE_FAIL
        g_FailNodeList[index] = activeFailNode
        if (g_ClusterInfo.SlaveNode ~= "") then
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_FAIL;
            g_UpdNode[ID][index].et = os.time();
            local slaveFailNode = {}
            slaveFailNode.ip = g_ClusterInfo.SlaveNode
            slaveFailNode.tp = GetNTPValue(tp)
            slaveFailNode.ltp = GetLTPValue(ltp)
            slaveFailNode.state = NODE_STATE_FAIL
            g_FailNodeList[index] = slaveFailNode
        end
        UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
        UpdFrame_SaveState(g_UpdState);

        LogText(LL_ERROR, "Manager update failed.");
        return UpdFrame_StartNewBatch()
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateManager_Rbk
-- Description     : FSMĻ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateManager_Rbk(SubCurList)
    LogText(LL_NOTICE, "Enter UpdFrame_UpdateManager_Rbk");
    
    local AGIndex = g_UpdState.Manager_AGIndex;
    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType
    local index = 0
    local ID = 0
    
    --ǰִгɹ,ִһ
    if (g_UpdState.Manager_UpgResult == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
        if (AGIndex >= #SubCurList.agtbl.rbk) then
            g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_SUCC;
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
            g_UpdNode[ID][index].et = os.time();
            g_UpdNode[ID][index].pr = 100;
            local activeAutoRbkNode = {}                        -- ԶɹӵԶбԷķ
            activeAutoRbkNode.ip = g_ClusterInfo.ActiveNode
            activeAutoRbkNode.tp = GetNTPValue(tp)
            activeAutoRbkNode.ltp = GetLTPValue(ltp)
            g_AutoRbkSuccNodeList[index] = activeAutoRbkNode
            if (g_ClusterInfo.SlaveNode ~= "") then
                index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
                ID = g_NodeIdList[index].id;
                g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
                g_UpdNode[ID][index].et = os.time();
                g_UpdNode[ID][index].pr = 100;
                local slaveAutoRbkNode = {}                     -- ԶɹӵԶбԷķ
                slaveAutoRbkNode.ip = g_ClusterInfo.SlaveNode
                slaveAutoRbkNode.tp = GetNTPValue(tp)
                slaveAutoRbkNode.ltp = GetLTPValue(ltp)
                g_AutoRbkSuccNodeList[index] = slaveAutoRbkNode
            end
            UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
            UpdFrame_SaveState(g_UpdState); ----FSMʱһ

            LogText(LL_NOTICE, "Rollback manager success.");
            return UpdFrame_StartNewBatch()
        end

        --ȡִһԭ
        AGIndex = AGIndex + 1;
        local AtomGroup = SubCurList.agtbl.rbk[AGIndex];
        g_UpdState.Manager_UpgResult = ATOM_GROUP_EXEC_RET_INIT
        if (AtomGroup.RunOnActive) then
            UpdFrame_ActiveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
            ID = g_NodeIdList[index].id
            LogText(LL_NOTICE, "----Exec atom group:" .. AtomGroup.AtomGroupName);
        else
            UpdFrame_SlaveRunAtomGroup(SubCurList, AtomGroup.AtomGroupName, AtomGroup.timeout);
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            LogText(LL_NOTICE, "----Exec atom group:" .. AtomGroup.AtomGroupName);
        end

        g_UpdState.Manager_AGIndex = AGIndex;
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
        UpdFrame_SaveFlowExecState();
        UpdFrame_SaveCurExecState();

        return FLOW_DISPATCH_STATE_NORMAL;
    else --ǰִʧ,жϲ
        g_UpdState.Manager_UpgState = MANAGER_UPG_STATE_FAIL;
        index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
        ID = g_NodeIdList[index].id
        g_UpdNode[ID][index].st = NODE_STATE_FAIL;
        g_UpdNode[ID][index].et = os.time();
        local activeAutoRbkNode = {}                        -- ԶɹӵԶбԷķ
        activeAutoRbkNode.ip = g_ClusterInfo.ActiveNode
        activeAutoRbkNode.tp = GetNTPValue(tp)
        activeAutoRbkNode.ltp = GetLTPValue(ltp)
        g_AutoRbkSuccNodeList[index] = activeAutoRbkNode
        if (g_ClusterInfo.SlaveNode ~= "") then
            index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
            ID = g_NodeIdList[index].id;
            g_UpdNode[ID][index].st = NODE_STATE_FAIL;
            g_UpdNode[ID][index].et = os.time();
            local slaveAutoRbkNode = {}                     -- ԶɹӵԶбԷķ
            slaveAutoRbkNode.ip = g_ClusterInfo.SlaveNode
            slaveAutoRbkNode.tp = GetNTPValue(tp)
            slaveAutoRbkNode.ltp = GetLTPValue(ltp)
            g_AutoRbkSuccNodeList[index] = slaveAutoRbkNode
        end
        UpdFrame_UpdateNodeState(END_BATCH, SubCurList);
        UpdFrame_SaveState(g_UpdState);

        LogText(LL_ERROR, "Manager update failed.");
        return UpdFrame_StartNewBatch()
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ActiveRunAtomGroup
-- Description     : FSMʱڵԭִ
-- Caution         : OMMά, ޸
-- Input           : AtomGroupName ԭ
--                   Timeout ʱʱ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ActiveRunAtomGroup(SubCurList, AtomGroupName, Timeout)
    LogText(LL_INFO, "Enter UpdFrame_ActiveRunAtomGroup. ag = "..AtomGroupName)
    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType
    local index = GetIndexValue(g_ClusterInfo.ActiveNode, tp, ltp)
    local ID = g_NodeIdList[index].id
    local luaPath = ""
    local f = io.open(g_UpdFrame_Const.LuaPath, "r");
    if (f ~= nil) then
        luaPath = string.sub(f:read("*all"), 1, -2);
    end
    local isFrame = IsFrameVersion()
    
    -- ˢִеԭ
    local Node = g_UpdNode[ID][index]
    if (Node ~= nil ) then
        g_UpdNode[ID][index].ag = AtomGroupName
        g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT
    end

    if ("UpgSwitchHA" == AtomGroupName or "RbkSwitchHA" == AtomGroupName) then
        UpdFrame_SaveState();
        System("sleep 10", 1);
    end
    
    SubCurList.curlist_config.AGTimerID = SubCurList.curlist_config.AGTimerID + 1;
    if isFrame then
        iRet = ExecAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.ActiveNode, over_time=Timeout, param=SubCurList.curlist_config.ParamList, timer_id=SubCurList.curlist_config.AGTimerID, node_index=index, lua_path=luaPath};
    else
        iRet = ExecAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.ActiveNode, over_time=Timeout, param=SubCurList.curlist_config.ParamList, timer_id=SubCurList.curlist_config.AGTimerID};
    end
    if (RET_ERR == iRet) then
        if isFrame then
            ReportAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.ActiveNode, node_index=index, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        else
            ReportAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.ActiveNode, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SlaveRunAtomGroup
-- Description     : FSMʱڵԭִ̣UpdFrame_ActiveRunAtomGroupϲ
-- Caution         : OMMά, ޸
-- Input           : AtomGroupName ԭ
--                   Timeout ʱʱ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SlaveRunAtomGroup(SubCurList, AtomGroupName, Timeout)
    LogText(LL_INFO, "Enter UpdFrame_SlaveRunAtomGroup. ag = "..AtomGroupName)
    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType
    local index = GetIndexValue(g_ClusterInfo.SlaveNode, tp, ltp)
    local ID = g_NodeIdList[index].id
    local luaPath = ""
    local f = io.open(g_UpdFrame_Const.LuaPath, "r");
    if (f ~= nil) then
        luaPath = string.sub(f:read("*all"), 1, -2);
    end
    local isFrame = IsFrameVersion()
    
    -- ˢִеԭ
    local Node = g_UpdNode[ID][index]
    if (Node ~= nil ) then
        g_UpdNode[ID][index].ag = AtomGroupName
        g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT
    end
    
    SubCurList.curlist_config.AGTimerID = SubCurList.curlist_config.AGTimerID + 1;
    if isFrame then
        iRet = ExecAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.SlaveNode, over_time=Timeout, param=SubCurList.curlist_config.ParamList, timer_id=SubCurList.curlist_config.AGTimerID, node_index=index, lua_path=luaPath};
    else
        iRet = ExecAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.SlaveNode, over_time=Timeout, param=SubCurList.curlist_config.ParamList, timer_id=SubCurList.curlist_config.AGTimerID};
    end
    if (RET_ERR == iRet) then
        if isFrame then
            ReportAtomGroupWithParam{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.SlaveNode, node_index=index, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        else
            ReportAtomGroup{flow_id=g_UpdState.FlowId, atom_group=AtomGroupName, node_ip=g_ClusterInfo.SlaveNode, result=ATOM_GROUP_EXEC_RET_TIMEOUT};
        end
    end
end

-----------------------------------------------------------------------------------------------------------------------
------------------------------------------------------FSM----------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------״̬----------------------------------------------------------
-------------------------------------------------------START-----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateState
-- Description     : ¸б״̬
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
--                   AtomGroup ǰԭ
--                   Result ǰԭִн
-- Output          :
-- Return          :
---------------------------------------------------------------------------
function UpdFrame_UpdateState(NodeIp, nodeIndex, AtomGroup, Result)
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local ID = g_NodeIdList[nodeIndex].id;
    local progress = UpdFrame_GetAgProgress(g_UpdState.Flow, AtomGroup, g_CurNodeList[subKey])

    -- NodeList״̬
    if (g_UpdNode[ID][nodeIndex] ~= nil ) then
        g_UpdNode[ID][nodeIndex].rt = Result
        --ɹʱ½
        if (Result == ATOM_GROUP_EXEC_RET_SUCC) then
            g_UpdNode[ID][nodeIndex].pr = progress;
        end
    end

    --CurNodeList״̬
    --ʧܺԶ̶ˢCurNodeList е״̬ʾڵµ״̬Ϣ
    local CurNode = g_CurNodeList[subKey][nodeIndex];
    if (CurNode == nil) then
        return;
    end
    g_CurNodeList[subKey][nodeIndex].state = Result;
    g_UpdNode[ID][nodeIndex].ct = Result;

    --»˽ڵбеĽڵ״̬
    if (g_CurNodeList[subKey][nodeIndex].rf == 1) then
        LogText(LL_INFO, "Update rbk node pr.");
        --˳ɹʱ½
        if (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
            if (progress - g_UpdNode[ID][nodeIndex].pr > 0) then
                g_UpdNode[ID][nodeIndex].pr = progress;
            end
        end

        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
        return;
    end

    return;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateNodeState
-- Description     : g_UpdState.NodeListĿʼʱbtʱet״̬st
-- Caution         : OMMά, ޸
-- Input           : EventType ڵ״̬
--                   NodeList ڵб
--                   NodeType ڵ
--                   LogicNodeType ڵ߼
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_UpdateNodeState(EventType, SubCurList)
    if (EventType == TERM_FLOW) then
        LogText(LL_NOTICE, "----UpdFrame_UpdateNodeState SubCurList = "..Table2String(SubCurList))
    end
    
    local tp = ""
    local ltp = ""
    local isRbk = ""
    local key = 0;
    local ID = 0;
    if (nil ~= next(SubCurList)) then
        tp = SubCurList.curlist_config.NodeType
        ltp = SubCurList.curlist_config.LogicNodeType
        isRbk = SubCurList.agtbl.isRbk;
    end

    LogText(LL_INFO, "EventType == "..EventType.." , NodeType:"..tp..", LogicNodeType:"..ltp)
    
    -- ʼµʱǰбδĽڵбгʼ
    if (EventType == START_BATCH) then
        local sublist = UpdFrame_GetSubFromCurList(SubCurList)
        for index, Node in pairs(sublist) do
            LogText(LL_INFO, "Node = "..Table2String(Node))
            ID = g_NodeIdList[index].id
            g_UpdNode[ID][index].st = NODE_STATE_RUNNING;
            g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_INIT
            g_UpdNode[ID][index].rt = ATOM_GROUP_EXEC_RET_INIT
            g_UpdNode[ID][index].bt = os.time();
            SubCurList[index].state = ATOM_GROUP_EXEC_RET_INIT
            SubCurList[index].rf = 0
        end
        
        --ʼǰʹõıϢ
        SubCurList[g_UpdFrame_Const.CurListExecInfo] = {};
        SubCurList[g_UpdFrame_Const.CurListExecInfo].SyncEnd = 0;
        SubCurList[g_UpdFrame_Const.CurListExecInfo].CurNodeFail = 0;
        SubCurList[g_UpdFrame_Const.CurListExecInfo].NeedWait = 0;
        SubCurList[g_UpdFrame_Const.CurListExecInfo].NeedWaitAG = {};
        SubCurList[g_UpdFrame_Const.CurListExecInfo].AGTimerID = 0; --AGTimerӦindex 

    -- һʱǰбѽĽڵб״̬
    elseif (EventType == END_BATCH) then
        local sublist = UpdFrame_GetSubFromCurList(SubCurList)
        for index, Node in pairs(sublist) do
            ID = g_NodeIdList[index].id
            -- 
            if isRbk then
                if (Node.state == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
                    if (g_UpdNode[ID].bind == NODE_STATE_BIND_FAILED) then
                        g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                        LogText(LL_INFO, "update rbk node state bind " .. g_UpdNode[ID][index].st);
                    else
                        --FSMڵ״̬ͬﵥóɹ
                        if (g_UpdNode[ID][index].ltp ~= 0) then
                            g_UpdNode[ID][index].st = NODE_STATE_SUCC;
                        else
                            LogText(LL_INFO, "------don't update fsm node to success at here");
                        end
                    end
                elseif (Node.state == ATOM_GROUP_EXEC_RET_FAIL) then
                    if (g_UpdNode[ID][index].bind == NODE_STATE_BIND_FAILED) then
                        g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                        LogText(LL_INFO, "update rbk node state bind " .. g_UpdNode[ID][index].st);
                    else
                        g_UpdNode[ID][index].st = NODE_STATE_FAIL;
                    end
                elseif (Node.state == ATOM_GROUP_EXEC_RET_TIMEOUT) then
                    g_UpdNode[ID][index].st = NODE_STATE_TIMEOUT;
                end
            -- 
            else
                if (Node.state == ATOM_GROUP_EXEC_RET_SUCC) then
                    --FSMڵ״̬ͬﵥóɹ
                    if (g_UpdNode[ID][index].ltp ~= 0) then
                        g_UpdNode[ID][index].st = NODE_STATE_SUCC;
                    else
                        LogText(LL_INFO, "------don't update fsm node to success at here");
                    end
                elseif (Node.state == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
                    if (g_UpdNode[ID][index].bind == NODE_STATE_BIND_FAILED) then
                        g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                        LogText(LL_INFO, "update upd node state bind " .. g_UpdNode[ID][index].st);
                    else
                        g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
                    end
                elseif (Node.state == ATOM_GROUP_EXEC_RET_FAIL) then
                    g_UpdNode[ID][index].st = NODE_STATE_FAIL;
                elseif (Node.state == ATOM_GROUP_EXEC_RET_TIMEOUT) then
                    g_UpdNode[ID][index].st = NODE_STATE_TIMEOUT;
                end
            end
            -- FSMʱ
            if (NodeType == g_UpdFrame_Const.NodeTypeManager) then
                g_UpdNode[ID][index].et = os.time();
            end
        end
    
    -- ̽ʱ, δʼĽڵ״̬޸ΪԶȡ, Ҫˢ¿ʼʱ
    elseif (EventType == END_FLOW) then
        for ID, NodeList in pairs(g_UpdNode) do
            for index, Node in pairs(NodeList) do
                LogText(LL_INFO, "Node = "..Table2String(Node))
                if (Node.st == NODE_STATE_INIT) then
                    g_UpdNode[ID][index].st = NODE_STATE_CANCEL;
                end
            end
        end
        UpdFrame_StopTimer();
    
    -- ̳ʱʱ, δɵĽڵ״̬޸Ϊʱ
    elseif (EventType == TERM_FLOW) then
        for ID, NodeList in pairs(g_UpdNode) do
            for index, Node in pairs(NodeList) do
                LogText(LL_INFO, "Node = "..Table2String(Node))
                if (Node.st == NODE_STATE_INIT) then
                    g_UpdNode[ID][index].st = NODE_STATE_CANCEL;
                elseif (Node.st == NODE_STATE_RUNNING) then
                    g_UpdNode[ID][index].st = NODE_STATE_TIMEOUT;
                    g_UpdNode[ID][index].et = os.time();
                end
            end
        end
        UpdFrame_StopTimer();       
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateCurNodeStateASync
-- Description     : ʱ½ڵ״̬Ϣ
-- Caution         : OMMά, ޸
-- Input           :   
--
--------------------------------------------------------------------------------
function UpdFrame_UpdateCurNodeStateASync(IsRbk, NodeIp, index, Result)
    local iret = Result;
    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    local ID = g_NodeIdList[index].id;

   ---첽һڵʧнڵ㶼Ҫ˽ɹĽڵΪ˳ɹ״̬
    if (1 == g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].CurNodeFail and
        ((not IsRbk and g_CurNodeList[subKey].curlist_config.BindFlagForUpdate) or
        (IsRbk and g_CurNodeList[subKey].curlist_config.BindFlagForRollback))) then

        --ɹڵ³ɻ˳ɹ
        if (Result == ATOM_GROUP_EXEC_RET_SUCC and not IsRbk ) then
            g_UpdNode[ID][index].bd = NODE_STATE_BIND_FAILED;
            LogText(LL_NOTICE, "-------UpdFrame_UpdateCurNodeStateASync." .. NodeIp);
            iret = ATOM_GROUP_EXEC_RET_SUCC_RBK;
            g_CurNodeList[subKey][index].state = ATOM_GROUP_EXEC_RET_SUCC_RBK
            g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_SUCC_RBK
        end

        --˳ɹڵ³ɻʧ ýڵ״̬ʹ
        if (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK and IsRbk ) then
            g_UpdNode[ID][index].bd = NODE_STATE_BIND_FAILED;
            LogText(LL_NOTICE, "-------UpdFrame_UpdateCurNodeStateASync." .. NodeIp);
            iret = ATOM_GROUP_EXEC_RET_FAIL
            g_CurNodeList[subKey][index].state = ATOM_GROUP_EXEC_RET_FAIL
            g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_FAIL
        end

    end
    return iret;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateCurNodeStateSync
-- Description     : ʱ½ڵ״̬Ϣ
-- Caution         : OMMά, ޸
-- Input           :   
--
--------------------------------------------------------------------------------
function UpdFrame_UpdateCurNodeStateSync(IsRbk, NodeIp, nodeIndex)
    --ȡб
    local subKey = UpdFrame_GetSubKeyFromCurList(nodeIndex);
    local ID = g_NodeIdList[nodeIndex].id;

    --ʱ½ڵ״̬
    if(1 == g_CurNodeList[subKey][g_UpdFrame_Const.CurListExecInfo].CurNodeFail and
        ((not IsRbk and g_CurNodeList[subKey].curlist_config.BindFlagForUpdate) or
        (IsRbk and g_CurNodeList[subKey].curlist_config.BindFlagForRollback)))then
        local subList = UpdFrame_GetSubFromCurList(g_CurNodeList[subKey])
        for index, Node in pairs(subList) do
            ID = g_NodeIdList[index].id
            --ɹڵ³ɻ˳ɹ
            if(Node.state == ATOM_GROUP_EXEC_RET_SUCC and not IsRbk )then
                g_UpdNode[ID][index].bind = NODE_STATE_BIND_FAILED;
                LogText(LL_NOTICE, "-------update current node state." .. Node.ip);
                Node.state = ATOM_GROUP_EXEC_RET_SUCC_RBK
                g_UpdNode[ID][index].bd = NODE_STATE_BIND_FAILED;
                g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_SUCC_RBK

            end
            --˳ɹڵ³ɻʧ
            if(Node.state == ATOM_GROUP_EXEC_RET_SUCC_RBK and IsRbk )then
                g_UpdNode[ID][index].bind = NODE_STATE_BIND_FAILED;
                LogText(LL_NOTICE, "-------update current node state." .. Node.ip);
                Node.state = ATOM_GROUP_EXEC_RET_FAIL
                g_UpdNode[ID][index].bd = NODE_STATE_BIND_FAILED;
                g_UpdNode[ID][index].ct = ATOM_GROUP_EXEC_RET_FAIL
            end
        end
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SetUpdStateNodeList
-- Description     : ʼg_UpdStateNodeList
-- Caution         : OMMά, ޸
-- Input           : TaskId id
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SetUpdStateNodeList(TaskId)
    LogText(LL_NOTICE, "Start to set task, id: " .. TaskId);

    for _, Node in pairs(g_TaskInfo.Nodes) do
        LogText(LL_INFO, "Node = "..Table2String(Node))
        local nodeType = Node.NodeType
        local logicNodeType = Node.LogicNodeType

        --g_TaskInfoNodesенڵ뵽g_UpdStateNodeList
        if (nil ~= Node.NodeList) then
            local nodeList = Split(Node.NodeList, ",")
            local index = 0;
            local idcount = 0;
            local ID = 1;

            for _, node in pairs(nodeList) do
                if (nil == g_UpdNode[ID]) then
                    g_UpdNode[ID] = {};
                end
                index = GetIndexValue(node, nodeType, logicNodeType)
                g_NodeIdList[index] = {id=ID}
                g_UpdNode[ID][index] = {ip=node,tp=GetNTPValue(nodeType),ltp=GetLTPValue(logicNodeType),
                    st=NODE_STATE_INIT,rt=ATOM_GROUP_EXEC_RET_INIT,bt=-1,et=-1,pr=0,bind=0}
                idcount = idcount + 1;
                
                LogText(LL_INFO, "ID = ".. idcount .. g_Const.MAX_NODE_INFILE .. (idcount % g_Const.MAX_NODE_INFILE))
                if (0 == idcount % g_Const.MAX_NODE_INFILE) then
                    ID = ID + 1;
                end
            end
        end
    end

    local num = 0;
    for ID, list in pairs(g_UpdNode) do
        LogText(LL_INFO, "UpdFrame_SaveNodeListState = ".. ID)
        num = num + 1
        UpdFrame_SaveNodeListState(g_UpdNode[ID], ID)
    end

    g_UpdState.NodeListCount = num;
    UpdFrame_SaveFlowExecState();
    UpdFrame_SaveIdListState()
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SetUpdNodeFinish
-- Description     : õǰڵ
-- Caution         : OMMά, ޸
-- Input           : NodeListڵ״̬(st)ʱ
--
--------------------------------------------------------------------------------
function UpdFrame_SetUpdNodeFinish(NodeIp, Result, index, IsRbk)
    LogText(LL_INFO, "UpdFrame_SetUpdNodeFinish" .. NodeIp .. Result);

    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    local ID = g_NodeIdList[index].id

    --̸½ڵ״̬
    if(IsRbk) then
        Result = g_CurNodeList[subKey][index].state;
        if (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
            if (g_UpdNode[ID][index].bind == NODE_STATE_BIND_FAILED) then
                g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                LogText(LL_INFO, "update rbk node state bind" .. g_UpdNode[ID][index].st);
            else
                g_UpdNode[ID][index].st = NODE_STATE_SUCC;
            end
        elseif (Result == ATOM_GROUP_EXEC_RET_FAIL) then
            if (g_UpdNode[ID][index].bind == NODE_STATE_BIND_FAILED) then
                g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                LogText(LL_INFO, "update rbk node state bind" .. g_UpdNode[ID][index].st);
            else
                g_UpdNode[ID][index].st = NODE_STATE_FAIL;
            end
        elseif (Result == ATOM_GROUP_EXEC_RET_TIMEOUT) then
            g_UpdNode[ID][index].st = NODE_STATE_TIMEOUT;
        end
    --̸½ڵ״̬
    else
        if (Result == ATOM_GROUP_EXEC_RET_SUCC) then
            g_UpdNode[ID][index].st = NODE_STATE_SUCC;
        elseif (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
            --˳ɹڵ㽫ó100%
            g_UpdNode[ID][index].pr = 100
            if (g_UpdNode[ID][index].bind == NODE_STATE_BIND_FAILED) then
                g_UpdNode[ID][index].st = NODE_STATE_BIND_FAILED;
                LogText(LL_INFO, "update upd node state bind" .. g_UpdNode[ID][index].st);
            else
                g_UpdNode[ID][index].st = NODE_STATE_SUCC_RBK;
            end
        elseif (Result == ATOM_GROUP_EXEC_RET_FAIL) then
            g_UpdNode[ID][index].st = NODE_STATE_FAIL;
        elseif (Result == ATOM_GROUP_EXEC_RET_TIMEOUT) then
            g_UpdNode[ID][index].st = NODE_STATE_TIMEOUT;
        end
    end
    g_UpdNode[ID][index].et = os.time();
    LogText(LL_INFO, "update upd node state" .. g_UpdNode[ID][index].st);
    ----½ڵϢ
    local TmpNode = {};
    if (NODE_STATE_RUNNING ~= g_UpdNode[ID][index].st and NODE_STATE_INIT ~= g_UpdNode[ID][index].st) then
        TmpNode.ip = g_UpdNode[ID][index].ip;
        TmpNode.tp = g_UpdNode[ID][index].tp;
        TmpNode.ltp = g_UpdNode[ID][index].ltp;
        TmpNode.state = g_UpdNode[ID][index].ct;

        if (NODE_STATE_SUCC == g_UpdNode[ID][index].st) then
            g_SuccNodeList[index] = TmpNode;
        else
            if (ATOM_GROUP_EXEC_RET_SUCC_RBK == g_UpdNode[ID][index].st and not IsRbk) then
                g_AutoRbkSuccNodeList[index] = TmpNode;
            end
            g_FailNodeList[index] = TmpNode;
        end
    end
end

-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------״̬----------------------------------------------------------
--------------------------------------------------------END------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetCurAGInfo
-- Description     : Ż
-- Caution         : OMMά, ޸
-- Input           : SubCurList ǰб
--                   NodeIndex ڵ㵱ǰindex
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetCurAGInfo(SubCurList, NodeIndex)
    local curTbl = SubCurList.agtbl
    local agindex = 0
    local curAGTbl = "";
    local curNode = UpdFrame_GetNodeFromCurList(NodeIndex);
    local tp = SubCurList.curlist_config.NodeType
    if (curNode.rf == 1
        or (tp == g_UpdFrame_Const.NodeTypeManager and g_UpdState.Manager_FlowState == MANAGER_FLOW_STATE_UPG_RBK )) then
        curAGTbl = curTbl.rbk;
    else
        curAGTbl = curTbl.upd;
    end
    local curAGTblNum = #curAGTbl
    local curAG = UpdFrame_GetAtomGroupEx(NodeIndex);
    local timeout = 0;
    local agType = ""
    for i = 1, curAGTblNum do
        if (curAG == curAGTbl[i].AtomGroupName) then
            timeout = curAGTbl[i].timeout
            agType = curAGTbl[i].ExcuteNodeType;
            agindex = i;
        end
    end
    return timeout, agType, curAG, curAGTbl[agindex];
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetNodeState
-- Description     : ȡԭ״̬
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetNodeState(NodeIndex)
    local ID = g_NodeIdList[NodeIndex].id
    local Node = g_UpdNode[ID][NodeIndex]
    LogText(LL_INFO, "Node = "..Table2String(Node))
    if (Node ~= nil ) then
        return Node.st
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetAtomGroupState
-- Description     : ȡԭ״̬
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetAtomGroupState(NodeIndex)
    local ID = g_NodeIdList[NodeIndex].id
    local Node = g_UpdNode[ID][NodeIndex]
    LogText(LL_INFO, "Node = "..Table2String(Node))
    if (Node ~= nil ) then
        return Node.rt
    end
    return nil
end
--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetAtomGroupState
-- Description     : ȡԭ״̬
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetAtomGroupState(NodeIndex)
    local ID = g_NodeIdList[NodeIndex].id
    local Node = g_UpdNode[ID][NodeIndex]
    LogText(LL_INFO, "Node = "..Table2String(Node))
    if (Node ~= nil ) then
        return Node.rt
    end
    return nil
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ResetAtomGroup
-- Description     : updaϱͬAGظϢupdsطǰ
-- Caution         : OMMά, ޸
-- Input           : FlowIdidNodeIpڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ResetAtomGroup(FlowId, SubCurList, NodeIndex, NodeIp)
    local tp = SubCurList.curlist_config.NodeType
    local ltp = SubCurList.curlist_config.LogicNodeType
    local timeout, agType, curAG, agTbl = UpdFrame_GetCurAGInfo(SubCurList, NodeIndex);
    
    -- δȡʱʱ䲻Ҫ
    if (timeout == 0) then
        LogText(LL_NOTICE, "Node "..NodeIp.." can not get timeout.");
        return 1
    end

    -- ߼IsRepeatAGMsgͬҲ޸IsRepeatAGMsgķֵ
    -- ˮͬҪ
    if (FlowId ~= g_UpdState.FlowId) then
        LogText(LL_NOTICE, "Node "..NodeIp.." flow id is different.");
        return 1
    end

    -- ǰAG״̬ǳʼ̬Ҫ
    if (UpdFrame_GetAtomGroupState(NodeIndex) ~= ATOM_GROUP_EXEC_RET_INIT or
        UpdFrame_GetNodeState(NodeIndex) ~= NODE_STATE_RUNNING) then
        LogText(LL_NOTICE, "Node ".. NodeIp .." rt or st is not initial state.");
        return 1
    end

    local curNode = UpdFrame_GetNodeFromCurList(NodeIndex);
    curNode.state = ATOM_GROUP_EXEC_RET_INIT;
    local ID = g_NodeIdList[NodeIndex].id
    g_UpdNode[ID][NodeIndex].rt = ATOM_GROUP_EXEC_RET_INIT;
    g_UpdNode[ID][NodeIndex].ct = ATOM_GROUP_EXEC_RET_INIT;
    UpdFrame_RunAtomGroupEx(agType, NodeIp, curAG, timeout, tp, ltp);
    LogText(LL_NOTICE, "Node "..NodeIp.." UpdFrame_ResetAtomGroup" .. curAG);

    UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);
    UpdFrame_SaveFlowExecState();

    return 0;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_UpdateRbkState
-- Description     : ִлʱ½ڵ״̬
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
--                   AtomGroup ǰԭ
--                   Result ǰԭִн
-- Output          :
-- Return          :
---------------------------------------------------------------------------
function UpdFrame_UpdateRbkState(NodeIp, index, AtomGroup, Result)
    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    local ID = g_NodeIdList[index].id;
    local progress = UpdFrame_GetAgProgress(g_UpdState.Flow, AtomGroup, g_CurNodeList[subKey])
    LogText(LL_INFO, "Get progress, atom group: " .. AtomGroup .. " progress: " .. progress..", Result: "..Result);

    -- NodeList״̬, ûҵ˵
    g_UpdNode[ID][index].rt = Result

    --µǰڵбеĽڵ״̬
    g_CurNodeList[subKey][index].state = Result;
    g_UpdNode[ID][index].ct = Result
    --˳ɹʱ½
    if (Result == ATOM_GROUP_EXEC_RET_SUCC_RBK) then
        g_UpdNode[ID][index].pr = progress;
    end
    --UpdFrame_SaveState(g_UpdState); --ˢ½ڵ״̬ʱ ڵϱһαһ
    UpdFrame_SaveNodeListState(g_UpdNode[ID], ID);

end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetAtomGroupEx
-- Description     : ȡڵӦԭб
-- Caution         : OMMά, ޸
-- Input           : NodeIp ڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetAtomGroupEx(NodeIndex)
    local ID = g_NodeIdList[NodeIndex].id
    local Node = g_UpdNode[ID][NodeIndex]
    if (Node ~= nil ) then
        return Node.ag
    end
    return nil
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_ReportAgentExecing
-- Description     : updaķʱ ϱԭִ Ϊ20000ʾڵִԭ
-- Caution         : ܵãơֵģһ
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_ReportAgentExecing(NodeIp, NodeIndex, AtomGroup)
    -- дԭϱ
    local execResult = {};
    local isFrame = IsFrameVersion()
    if(NodeIp ~= nil or NodeIp ~= "" or AtomGroup ~= nil or AtomGroup ~= "")then
        if isFrame then
            execResult.node_ip = NodeIp
            execResult.node_index = NodeIndex
            execResult.atom_group = AtomGroup
            execResult.atom = "";
            execResult.start_time = os.time();
            execResult.progress = 100;
            execResult.error_code = 0;
            execResult.result = ATOM_RET_EXECING;
            execResult.end_time = os.time();
            LogText(LL_INFO, "Node (" .. NodeIp .. ") run atom group (" .. AtomGroup .. ") and report execing.");
            ReportAtomExecResultWithParam(execResult);
        else
            execResult.node_ip = NodeIp
            execResult.atom_group = AtomGroup
            execResult.atom = "";
            execResult.start_time = os.time();
            execResult.progress = 100;
            execResult.error_code = 0;
            execResult.result = ATOM_RET_EXECING;
            execResult.end_time = os.time();
            LogText(LL_INFO, "Node (" .. NodeIp .. ") run atom group (" .. AtomGroup .. ") and report execing.");
            ReportAtomExecResult(execResult);
        end
    else
        LogText(LL_INFO, "Node ip is nil or atom group is nil.");
    end
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsRepeatAGMsg
-- Description     : жǷظϢ
-- Caution         : OMMά, ޸
-- Input           : FlowId ̱ʶ
--                   AtomGroup ǰԭ
--                   NodeIp ڵip
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_IsRepeatAGMsg(FlowId, AtomGroup, NodeIp, NodeIndex)
    LogText(LL_NOTICE, "Enter UpdFrame_IsRepeatAGMsg, Flowid="..FlowId.." AtomGroup="..AtomGroup.." NodeIndex="..NodeIndex)
    local index = tonumber(NodeIndex)
    local subKey = UpdFrame_GetSubKeyFromCurList(index);
    if (-1 == subKey) then
        LogText(LL_NOTICE, "Can not find index, maybe a repeat message." .. "index is "..index)
        return TRUE
    end
    
    if (FLOW_STATE_FINISH == g_UpdState.FlowState) then
        LogText(LL_NOTICE, "Flow is finished, maybe a repeat message." .. "g_UpdState.FlowState is "..FLOW_STATE_FINISH)
        return TRUE
    end
    -- жˮǷͬ
    if (FlowId ~= g_UpdState.FlowId) then
        LogText(LL_NOTICE, "Flow id is different, maybe a repeat message.".."("..FlowId..")("..g_UpdState.FlowId..")")
        UpdFrame_ResumeAGWhenFlowIdDiff(g_CurNodeList[subKey], index);
        return TRUE
    end

    -- жϽڵϱԭǷǽڵ㵱ǰִеԭ(Node.agΪýڵ㵱ǰִеԭ)
    local current = UpdFrame_GetAtomGroupEx(index)
    if (AtomGroup ~= current) then
        LogText(LL_NOTICE, "Atom group name (" .. AtomGroup .. ") is not curAG(" .. current ..") or is nil, maybe a repeat message.")
        UpdFrame_ReportAgentExecing(NodeIp, index, current);
        UpdFrame_ResetAtomGroup(FlowId, g_CurNodeList[subKey], index, NodeIp);
        return TRUE
    end

    -- жnodelist rtֵǷΪֵϢѴ
    local state = UpdFrame_GetAtomGroupState(index)
    if (state ~= ATOM_GROUP_EXEC_RET_INIT) then
        LogText(LL_NOTICE, "rt is not initial state, maybe a repeat message."..state)
        return TRUE
    end

    return FALSE
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetProgress
-- Description     : װԭӦϢ
-- Caution         : OMMά, ޸
-- Input           : FlowName 
--                   LogicNodeType ߼ڵ
--                   UpgradeMode ģʽ
-- Output          :
-- Return          : ָ͵Ϣ
--------------------------------------------------------------------------------
function UpdFrame_GetAgProgress(FlowName, AtomGroup, SubCurList)
    local upgAgNum = 0
    local rbkAgNum = 0
    local tbl = SubCurList.agtbl
    
    upgAgNum = #tbl.upd
    --ֻ̲лԭ
    if tbl.rbk then
        rbkAgNum = #tbl.rbk
    end
    
    --װ̵ԭϢ
    if (0 ~= upgAgNum) then
        for i = 1, upgAgNum do
            local agName = tbl.upd[i].AtomGroupName
            local agProgress = tbl.upd[i].progress
            if (agName == AtomGroup) then
                return agProgress
            end
        end
    end
    
    if (0 ~= rbkAgNum) then
        for i = 1, rbkAgNum do
            local agName = tbl.rbk[i].AtomGroupName
            local agProgress = tbl.rbk[i].progress
            if (agName == AtomGroup) then
                return agProgress
            end
        end
    end
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_StopTimer
-- Description     : ֹͣʱ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_StopTimer()
    LogText(LL_INFO, "UpdFrame_StopTimer No need report get node list msg.")
    if (g_UpdState.GetNodeListFlag) then
        ResetGetListTimer{reset_timer=0}
        g_UpdState.GetNodeListFlag = false
    end
end

--------------------------------------------------------------------------------
-- Func Name       : StopTask_BatTsk
-- Description     : ܵãֹͣ״̬
-- Caution         : OMMά, ޸
-- Input           : TaskId id
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function StopTask_BatTsk(TaskId)
    LogText(LL_NOTICE, g_UpdState.TaskControl.." "..g_UpdState.FlowState)
    if (g_Const.TASK_CONTROL_PAUSE ~= g_UpdState.TaskControl) or (FLOW_STATE_PAUSE ~= g_UpdState.FlowState) then
        LogText(LL_NOTICE, "----Current status is not pause, fail to stop task.");
        return 1
    end

    g_UpdState.FlowState = FLOW_STATE_FINISH;
    for Index, WaitingNode in pairs(g_WaitingNodeList) do
        local ID = g_NodeIdList[Index].id
        g_UpdNode[ID][Index].st = NODE_STATE_CANCEL;
    end

    UpdFrame_SaveState()  ----ֹʱһ
    LogText(LL_NOTICE, "----Task Stoped.");
    return 0;
end

--------------------------------------------------------------------------------
-- Func Name       : ContinueTask_BatTsk
-- Description     : ܵã״̬£δʹã
-- Caution         : OMMά, ޸
-- Input           : TaskId id
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function ContinueTask_BatTsk(TaskId)
    if (g_Const.TASK_CONTROL_PAUSE ~= g_UpdState.TaskControl) or (FLOW_STATE_PAUSE ~= g_UpdState.FlowState) then
        LogText(LL_NOTICE, "----Current status is not pause, fail to continue task.");
        return 1
    end

    g_UpdState.FlowState = FLOW_STATE_FINISH;
    LogText(LL_NOTICE, "----Task continue.");
    UpdFrame_SaveCurNodeList(); ---GetNodeListֻҪˢCurNodeList
    UpdFrame_SaveCurExecState();

    return Resume();
end

--------------------------------------------------------------------------------
-- Func Name       : NextTask_BatTsk
-- Description     : ܵãִкʱ״̬
-- Caution         : OMMά, ޸
-- Input           : TaskId id
--                   TaskType 
--                   XmlPath xmlļ·
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function NextTask_BatTsk(TaskId, TaskType, XmlPath)
    if (FLOW_STATE_FINISH ~= g_UpdState.FlowState) then
        LogText(LL_NOTICE, "----Current status is not finish, fail to next task.");
        return 1
    end

    --xmlļ
    local file = io.open(XmlPath, "r");
    local fileData = file:read("*all");

    --ȡǰϢ
    local curtaskinfo = UpdFrame_GetTaskById(TaskId, fileData)
    if ("" == curtaskinfo) then
        LogText(LL_ERROR, "Fail to get current taskinfo, id " .. TaskId);
        return 1
    end

    --Ϣʼg_TaskInfo
    local ret = UpdFrame_SetCurrentTaskInfo(TaskId, TaskType, curtaskinfo)
    if (1 == ret) then
        LogText(LL_ERROR, "Fail to set current taskinfo, id " .. TaskId);
        return 1
    end

    --ڵϢʼg_UpdState.NodeList
    ret = UpdFrame_SetUpdStateNodeList(TaskId)
    if (1 == ret) then
        LogText(LL_ERROR, "Fail to set current nodelist, id " .. TaskId);
        return 1
    end
    UpdFrame_SaveState(g_UpdState); ----ִһtaskһ

    --GetNodeListFlow
    UpdFrame_SaveCurNodeList();  ---GetNodeListֻҪˢCurNodeList
    UpdFrame_SaveCurExecState();
    --ReportFlow{flow_name = g_UpdState.Flow}
    file:close();
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_IsCurListAllFinish
-- Description     : Ƿнڵ㶼ִ
-- Caution         : OMMά, ޸
-- Input           : ǰ̶Ӧԭб flowõԭб
--
--------------------------------------------------------------------------------
function UpdFrame_IsCurListAllFinish(SubCurList)
    local subList = UpdFrame_GetSubFromCurList(SubCurList)
    for index, Node in pairs(subList) do
        local ID = g_NodeIdList[index].id
        if (NODE_STATE_INIT == g_UpdNode[ID][index].st or NODE_STATE_RUNNING == g_UpdNode[ID][index].st) then
            LogText(LL_INFO, "Some node not finish the batch return false." );
            return false
        end
    end
    LogText(LL_INFO, "All node finish and return true.");
    return true
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetSubFromCurList
-- Description     : Ƿнڵ㶼ִ
-- Caution         : OMMά, ޸
-- Input           : ǰ̶Ӧԭб flowõԭб
--
--------------------------------------------------------------------------------
function UpdFrame_GetSubFromCurList(SubCurList)
    local subList = {}
    for index, node in pairs (SubCurList) do
        LogText(LL_NOTICE, "UpdFrame_GetSubFromCurList index = " .. index);
        if (index ~= g_UpdFrame_Const.CurListExecInfo and index ~= g_UpdFrame_Const.CurListAgTbl and index ~= g_UpdFrame_Const.CurListConfig) then
            subList[index] = node
        end
    end
    return subList
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_FinishFlowHandle
-- Description     : ̽ʱ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_FinishFlowHandle()
    g_UpdState.FlowState = FLOW_STATE_FINISH
    UpdFrame_UpdateNodeState(TERM_FLOW, {});
    UpdFrame_StopTimer()
    UpdFrame_SaveState()
    LogText(LL_NOTICE, "--The flow finished.");
end

--------------------------------------------------------------------------------
-- Func Name       : IsCurListNotBegin
-- Description     : жϵǰڵбнڵ״̬Ƿδִ
-- Caution         : OMMά, ޸
-- Input           : EventType ڵ״̬
--                   NodeList ڵб
--                   NodeType ڵ
--                   LogicNodeType ڵ߼
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_IsSubCurListBegin(SubCurList)
    local sublist = UpdFrame_GetSubFromCurList(SubCurList)
    if (nil == sublist or nil == next(sublist)) then
        LogText(LL_WARN, "SubCurList is empty, IsCurListNotBegin return true." )
        return true
    end
    
    for index, Node in pairs(sublist) do
        local ID = g_NodeIdList[index].id
        LogText(LL_INFO, "UpdFrame_IsSubCurListBegin index = "..index .." , ID = "..ID)
        LogText(LL_INFO, "UpdFrame_IsSubCurListBegin g_UpdNode = "..Table2String(g_UpdNode[ID][index]))
        if (NODE_STATE_INIT ~= g_UpdNode[ID][index].st) then
            LogText(LL_INFO, "UpdFrame_IsSubCurListBegin return true." )
            return true
        end
    end
    LogText(LL_INFO, "UpdFrame_IsSubCurListBegin return false." )
    return false
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_FinishFlowHandle
-- Description     : ̽ʱ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_IsInCurNodeList(CurNodeList, k)
    for _, SubCurList in pairs(CurNodeList) do
        if (SubCurList[k] ~= nil) then
            return true;
        end
    end
    return false;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_FinishFlowHandle
-- Description     : ̽ʱ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetAllCurListLenth(CurNodeList)
    local nodeCount = 0
    for _, SubCurList in pairs(CurNodeList) do
        for key, Node in pairs(SubCurList) do
            if (key ~= g_UpdFrame_Const.CurListExecInfo and key ~= g_UpdFrame_Const.CurListAgTbl and key ~= g_UpdFrame_Const.CurListConfig) then
                nodeCount = nodeCount + 1
            end
        end
    end
    LogText(LL_INFO, "num = "..nodeCount)
    return nodeCount
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetNodeFromCurList
-- Description     : ݽڵindexؽڵϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetNodeFromCurList(nodekey)
    for _, SubCurList in pairs(g_CurNodeList) do
        for index, Node in pairs(SubCurList) do
            if (nodekey == index) then
                return Node;
            end
        end
    end

    LogText(LL_ERROR, "UpdFrame_GetNodeFromCurList return {}." );
    return {};
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_GetSubKeyFromCurList
-- Description     : ݽڵindexҽڵڵб
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetSubKeyFromCurList(nodekey)
    for key, SubCurList in pairs(g_CurNodeList) do
        for index, Node in pairs(SubCurList) do
            if (nodekey == index) then
                LogText(LL_NOTICE, "UpdFrame_GetSubKeyFromCurList return key." .. key);
                return key;
            end
        end
    end
    LogText(LL_ERROR, "UpdFrame_GetSubKeyFromCurList return -1." .. nodekey);
    return -1;
end

-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------Դ--------------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------

g_InitFrameVersion = "uninit" -- Ƿȡܰ汾
g_IsFrameVersion = true       -- ܰ汾

function IsFrameVersion()
    local isFrame = true
    if (g_InitFrameVersion == "uninit") then
        if CheckDswareVersion then
            isFrame = CheckDswareVersion()
        end
        g_InitFrameVersion = "init"
        g_IsFrameVersion = isFrame
        LogText(LL_NOTICE, "Init g_IsFrameVersion")
    else
        LogText(LL_NOTICE, "Return g_IsFrameVersion")
        isFrame = g_IsFrameVersion
    end

    if (isFrame) then
        LogText(LL_NOTICE, "g_IsFrameVersion is 1")
    else
        LogText(LL_NOTICE, "g_IsFrameVersion is 0")
    end

    return isFrame
end

function GetCurNTPValue()
    for subkey, sublist in pairs(g_CurNodeList) do
        if (nil ~= sublist.curlist_config.NodeType) then
            LogText(LL_NOTICE, "GetCurNTPValue = " .. sublist.curlist_config.NodeType)
            return sublist.curlist_config.NodeType
        end
    end
    return nil
end

function GetCurLTPValue()
    for subkey, sublist in pairs(g_CurNodeList) do
        if (nil ~= sublist.curlist_config.LogicNodeType) then
            LogText(LL_NOTICE, "GetCurLTPValue = " .. sublist.curlist_config.LogicNodeType)
            return sublist.curlist_config.LogicNodeType
        end
    end
    return nil
end

function Run_BatTsk(FlowId, AtomGroup, NodeIp, Result)
    LogText(LL_NOTICE, "ip: "..NodeIp.." Run flow: " .. g_UpdState.Flow .. "AG:"..AtomGroup.." result: " .. Result);
    local tp = GetCurNTPValue()
    local ltp = GetCurLTPValue()
    local index = GetIndexValue(NodeIp, tp, ltp)
    
    return UpdFrame_Run(FlowId, AtomGroup, NodeIp, index, Result)
end

function IsRepeatAGMsg(FlowId, AtomGroup, NodeIp)
    LogText(LL_NOTICE, "Enter UpdFrame_IsRepeatAGMsg, Flowid="..FlowId.." AtomGroup="..AtomGroup.." NodeIp="..NodeIp)
    local tp = GetCurNTPValue()
    local ltp = GetCurLTPValue()
    local index = GetIndexValue(NodeIp, tp, ltp)
    return UpdFrame_IsRepeatAGMsg(FlowId, AtomGroup, NodeIp, index)
end

function IsAtomGroupFinished(NodeIp, AtomGroupName)
    local tp = GetCurNTPValue()
    local ltp = GetCurLTPValue()
    local index = GetIndexValue(NodeIp, tp, ltp)
    return UpdFrame_IsAGFinish(index, AtomGroupName)
end

function HandleAtomReportInfo(AtomName, ErrorCode, Progress, ExecResult, NodeIp, AtomgGroup, StartTime, EndTime)
    local tp = GetCurNTPValue()
    local ltp = GetCurLTPValue()
    local nodeIndex = GetIndexValue(NodeIp, tp, ltp)
    return UpdFrame_HandleAtomReportInfo(AtomName, ErrorCode, Progress, ExecResult, nodeIndex, AtomgGroup, StartTime, EndTime)
end

function IsRbkAtomGroup(flowName, atomGroupName)
    local rbkAtomGroups = nil
    local subKey = -1
    for SubKey, SubList in pairs(g_CurNodeList) do
        subKey = SubKey
        break
    end
    if (-1 == subKey) then
        return FALSE
    end
    local tbl = g_CurNodeList[subKey].agtbl
    if (tbl.isRbk) then
        return FALSE
    end
    rbkAtomGroups = tbl.rbk
    if (rbkAtomGroups == nil) then
        LogText(LL_ERROR, "Fail to find rollback atom group table(name:" .. flowName .. ").")
        return FALSE
    end
    for i = 1, #rbkAtomGroups do
        if (rbkAtomGroups[i].AtomGroupName == atomGroupName) then
            return TRUE
        end
    end
    
    return FALSE
end

function IsNodeFinished(NodeIp)
    local tp = GetCurNTPValue()
    local ltp = GetCurLTPValue()
    local Index = GetIndexValue(NodeIp, tp, ltp)
    return UpdFrame_IsNodeFinished(Index)
end
-----------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------Դ--------------------------------------------------------
--------------------------------------------------------START----------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------